/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sip.server;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.IConfService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.sip.CallHistory;
import com.zipow.videobox.sip.CallHistoryMgr;
import com.zipow.videobox.sip.SIPConfiguration;
import com.zipow.videobox.sip.SipCallItem;
import com.zipow.videobox.sip.server.AssistantAppMgr;
import com.zipow.videobox.sip.server.SIPProcessMgr;
import com.zipow.videobox.sip.server.SipAudioMgr;
import com.zipow.videobox.sip.server.ZoomAssistantIPCMessageUI;
import com.zipow.videobox.sip.server.ZoomAssistantIPCServer;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.view.sip.SipInCallActivity;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.NetworkStatusReceiver;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class SipCallManager
implements PTUI.IPTUIListener,
ZMActivity.GlobalActivityListener {
    private static SipCallManager mInstance;
    private SIPConfiguration mSIPConfiguration;
    private SipCallItem mActiveCallItem;
    private boolean mIsCallServiceReady;
    private boolean mIsMuted;
    private int mServiceStatus;
    private Handler mHandler = new Handler();
    private int mRegisteredType;
    private String mRegisteredIP;
    private NetworkStatusReceiver mNetworkRecevier;
    private static final String TAG;
    private WifiManager.WifiLock mWifiLock;
    private ListenerList mListenerList = new ListenerList();
    private NetworkStatusReceiver.SimpleNetworkStatusListener mNetworkListener = new NetworkStatusReceiver.SimpleNetworkStatusListener(){

        public void networkStatusChanged(boolean curConnection, boolean lastConnection, int lastType, String lastIp) {
            SipCallManager.this.onNetworkState(curConnection, lastConnection, lastType, lastIp);
        }
    };

    private SipCallManager() {
        WifiManager wifiMgr;
        this.mActiveCallItem = new SipCallItem();
        this.mSIPConfiguration = new SIPConfiguration();
        this.mSIPConfiguration.resetAll();
        SipAudioMgr audioMgr = SipAudioMgr.getInstance();
        audioMgr.init();
        this.addListener(audioMgr);
        this.startToListenNetworkStatus();
        this.mRegisteredType = 0;
        this.mRegisteredIP = "0.0.0.0";
        Context context = VideoBoxApplication.getGlobalContext();
        if (context != null && (wifiMgr = (WifiManager)context.getApplicationContext().getSystemService("wifi")) != null) {
            this.mWifiLock = wifiMgr.createWifiLock("zoom-sip");
        }
        PTUI.getInstance().addPTUIListener(this);
        ZMActivity.addGlobalActivityListener((ZMActivity.GlobalActivityListener)this);
    }

    public String getRegisterErrorString() {
        Context context = VideoBoxApplication.getGlobalContext();
        if (this.isSipAvailable() || context == null) {
            return null;
        }
        switch (this.mSIPConfiguration.respCode) {
            case 403: {
                return context.getString(R.string.zm_mm_msg_sip_unavailable_403_14480);
            }
            case 404: {
                return context.getString(R.string.zm_mm_msg_sip_unavailable_404_14480);
            }
            case 408: {
                return context.getString(R.string.zm_mm_msg_sip_unavailable_408_14480);
            }
            case 437: {
                return context.getString(R.string.zm_mm_msg_sip_unavailable_437_14480);
            }
            case 480: {
                return context.getString(R.string.zm_mm_msg_sip_unavailable_480_14480);
            }
            case 486: {
                return context.getString(R.string.zm_mm_msg_sip_unavailable_486_14480);
            }
            case 488: {
                return context.getString(R.string.zm_mm_msg_sip_unavailable_488_14480);
            }
        }
        return context.getString(R.string.zm_mm_msg_sip_unavailable_14480);
    }

    public static SipCallManager getInstance() {
        if (mInstance == null) {
            mInstance = new SipCallManager();
        }
        return mInstance;
    }

    public void addListener(OnSipCallEventListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((OnSipCallEventListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(OnSipCallEventListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public void cleanup() {
        this.uninitSIPCall();
    }

    public boolean isCallMuted() {
        return this.mIsMuted;
    }

    private void startToListenNetworkStatus() {
        if (this.mNetworkRecevier != null) {
            return;
        }
        Context context = VideoBoxApplication.getGlobalContext();
        this.mNetworkRecevier = new NetworkStatusReceiver(context);
        this.mNetworkRecevier.registerReceiver(context);
        this.mNetworkRecevier.addListener((NetworkStatusReceiver.NetworkStatusListener)this.mNetworkListener);
    }

    public void onNetworkState(boolean curConnection, boolean lastConnection, int lastType, String lastIp) {
        boolean networkChanged;
        if (!this.isSipCallEnabled()) {
            return;
        }
        Context context = VideoBoxApplication.getGlobalContext();
        int type = NetworkUtil.getDataNetworkType((Context)context);
        String ip = NetworkUtil.getNetworkIP((Context)context);
        boolean bl = networkChanged = type != this.mRegisteredType || ip.equals(this.mRegisteredIP);
        if (this.isSipAvailable()) {
            if (!curConnection || networkChanged) {
                this.unRegistrar();
            }
            if (curConnection && networkChanged) {
                this.registrar();
            }
        } else if (this.isSipRegistering()) {
            if (!curConnection || networkChanged) {
                this.unRegistrar();
            }
            if (curConnection && networkChanged) {
                this.registrar();
            }
        } else if (curConnection) {
            this.registrar();
        }
    }

    public void onSipCallStatusChange(int event, String callId) {
        IConfService confService;
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                OnSipCallEventListener l = (OnSipCallEventListener)lTmp;
                l.onSipCallEvent(event, callId);
            }
        }
        if ((confService = VideoBoxApplication.getInstance().getConfService()) != null) {
            try {
                confService.onSipCallEvent(event, callId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.updateCallHistory(event, callId);
    }

    private void updateCallHistory(int event, String callId) {
        CallHistory item = new CallHistory();
        item.setType(3);
        if (this.mActiveCallItem != null) {
            item.setNumber(this.mActiveCallItem.getPeerNumber());
            item.setId(callId);
            if (this.mActiveCallItem.isIncomingCall()) {
                item.setDirection(1);
                item.setCallerDisplayName(this.mActiveCallItem.getPeerDisplayName());
                item.setCallerJid(this.mActiveCallItem.getCallID());
                item.setCallerUri(this.mActiveCallItem.getPeerURI());
            } else {
                item.setDirection(2);
                item.setCalleeDisplayName(this.mActiveCallItem.getPeerDisplayName());
                item.setCalleeJid(this.mActiveCallItem.getCallID());
                item.setCalleeUri(this.mActiveCallItem.getPeerURI());
            }
        }
        if (4 == event || 8 == event) {
            item.setState(2);
            this.mActiveCallItem.setConnectTime(CmmTime.getMMNow());
            item.setTime(this.mActiveCallItem.getConnectTime());
        } else if (7 == event || 9 == event) {
            this.mActiveCallItem.setConnectTime(CmmTime.getMMNow());
            item.setTime(this.mActiveCallItem.getConnectTime());
            item.setState(3);
        } else if (11 == event) {
            if (this.mActiveCallItem == null || this.mActiveCallItem.isIncomingCall()) {
                return;
            }
            if (this.mActiveCallItem.getConnectTime() == 0L) {
                item.setState(3);
                item.setTime(CmmTime.getMMNow());
            } else {
                item.setState(2);
                item.setTimeLong(CmmTime.getMMNow() - this.mActiveCallItem.getConnectTime());
                item.setTime(this.mActiveCallItem.getConnectTime());
            }
        } else if (10 == event) {
            item.setTime(CmmTime.getMMNow());
            item.setState(3);
        } else if (3 == event) {
            item.setTime(CmmTime.getMMNow());
            item.setState(1);
        } else if (12 == event) {
            item.setTime(CmmTime.getMMNow());
            item.setState(3);
        }
        CallHistoryMgr mgr = PTApp.getInstance().getCallHistoryMgr();
        if (mgr != null) {
            mgr.addOrUpdateCallHistory(item);
        }
    }

    private void sendSipCallStatusToConf(boolean isAvailable) {
        IConfService confService = VideoBoxApplication.getInstance().getConfService();
        if (confService != null) {
            try {
                confService.onSipStatusEvent(isAvailable);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void onZoomLoginFinished() {
        this.updateWebSIPConfiguration();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                SipCallManager.this.initSIPCall();
            }
        }, 500L);
    }

    public void onZoomLogoutFinished() {
        this.hangupActiveCall();
        this.uninitSIPCall();
        if (this.mSIPConfiguration != null) {
            this.mSIPConfiguration.resetAll();
        }
        VideoBoxApplication.getInstance().stopSIPService();
    }

    public void onUserOptionUpdated() {
        boolean changed = this.updateWebSIPConfiguration();
        this.onSipConfigurationUpdated(changed);
    }

    public void onSipConfigurationUpdated(boolean bChanged) {
        if (bChanged) {
            this.reinitSIPCall();
            return;
        }
        if (this.isSipCallEnabled() && 5 == this.mServiceStatus) {
            this.reinitSIPCall();
            return;
        }
    }

    public void onSipCallServiceStarted() {
        SIPProcessMgr.getInstance().onSipCallServiceStarted();
        this.registrar();
        this.mIsCallServiceReady = true;
    }

    public void onSipCallServiceStoped() {
        this.mIsCallServiceReady = false;
        if (this.isCallingOrInCall()) {
            String strCallID = this.mActiveCallItem.getCallID();
            this.onSipCallStatusChange(11, strCallID);
        } else {
            this.sendSipCallStatusToConf(false);
        }
        this.rejoinConfAudioWhenSipCallEnded();
        this.resetAudioDevice();
        this.mIsMuted = false;
        this.mServiceStatus = 0;
        this.notifyWebSipStatus();
        this.notifySIPServiceStatus();
        if (this.mActiveCallItem != null) {
            this.mActiveCallItem.reset();
        }
        this.onSipCallStatusChange(2, null);
        NotificationMgr.removeSipNotification(VideoBoxApplication.getGlobalContext());
    }

    public void initSIPCall() {
        if (!this.isSipCallEnabled()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            VideoBoxApplication.getInstance().requestIgnoreBatteryOptimization();
        }
        this.initModule();
    }

    public void uninitSIPCall() {
        this.unRegistrar();
        AssistantAppMgr.getInstance().uninitModule();
    }

    public void initModule() {
        this.uninitModule();
        this.initSIPCallApi();
    }

    public void uninitModule() {
        this.uninitSIPCallApi();
    }

    public boolean initSIPCallApi() {
        return AssistantAppMgr.getInstance().initAssistantApp();
    }

    public boolean uninitSIPCallApi() {
        AssistantAppMgr.getInstance().uninitModule();
        return true;
    }

    public void reinitSIPCall() {
        if (this.mIsCallServiceReady) {
            this.unRegistrar();
            this.registrar();
        } else {
            this.uninitSIPCall();
            this.initSIPCall();
        }
    }

    public void registrar() {
        if (!this.isSipCallEnabled()) {
            return;
        }
        String address = NetworkUtil.getNetworkIP((Context)VideoBoxApplication.getGlobalContext());
        if (StringUtil.isEmptyOrNull((String)address)) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)this.mSIPConfiguration.userName)) {
            return;
        }
        String strSIPServerAddress = this.mSIPConfiguration.regServerAddress;
        String userName = this.mSIPConfiguration.userName;
        String userPassword = this.mSIPConfiguration.userPassword;
        String userDisplayName = this.mSIPConfiguration.userDisplayName;
        String domain = this.mSIPConfiguration.domain;
        String proxy = this.mSIPConfiguration.proxy;
        String authName = this.mSIPConfiguration.authName;
        int registrationExpiry = this.mSIPConfiguration.registrationExpiry;
        this.mRegisteredType = NetworkUtil.getDataNetworkType((Context)VideoBoxApplication.getGlobalContext());
        this.mRegisteredIP = address;
        ZoomAssistantIPCServer sipApi = ZoomAssistantIPCServer.getInstance();
        if (sipApi != null) {
            sipApi.sendSIPRegistrarRequestMessage(address, strSIPServerAddress, this.mSIPConfiguration.protocol, userName, userPassword, authName, userDisplayName, domain, proxy, registrationExpiry);
        }
    }

    public void unRegistrar() {
        ZoomAssistantIPCServer sipApi = ZoomAssistantIPCServer.getInstance();
        if (sipApi != null) {
            if (this.isCallingOrInCall()) {
                sipApi.sendSIPResposeCallRequestMessage(this.mActiveCallItem.getCallID(), 52, 1);
            }
            sipApi.sendSIPUnRegistrarRequestMessage();
            this.mRegisteredType = 0;
            this.mRegisteredIP = "0.0.0.0";
        }
    }

    public boolean hangupActiveCall() {
        if (!this.isCallingOrInCall()) {
            return false;
        }
        if (this.mActiveCallItem == null || StringUtil.isEmptyOrNull((String)this.mActiveCallItem.getCallID())) {
            return false;
        }
        return this.responseCall(this.mActiveCallItem.getCallID(), 52);
    }

    public boolean responseCall(String callID, int action) {
        if (action > 52 || action <= 0) {
            return false;
        }
        return this.responseCallWithReason(callID, action, 0);
    }

    public boolean responseCallWithReason(String callID, int action, int reason) {
        ZoomAssistantIPCServer sipApi;
        if (StringUtil.isEmptyOrNull((String)callID) && this.mActiveCallItem != null) {
            callID = this.mActiveCallItem.getCallID();
        }
        if ((sipApi = ZoomAssistantIPCServer.getInstance()) == null) {
            return false;
        }
        if (50 == action) {
            this.onSipCallStatusChange(4, callID);
        } else if (51 == action) {
            this.onSipCallStatusChange(5, callID);
        } else if (52 == action) {
            this.onSipCallStatusChange(11, callID);
        }
        return sipApi.sendSIPResposeCallRequestMessage(callID, action, reason);
    }

    public boolean callPeer(String peerUri) {
        if (!this.isSipAvailable() || PTApp.getInstance().getCallStatus() != 0) {
            return false;
        }
        ZoomAssistantIPCServer sipAPI = ZoomAssistantIPCServer.getInstance();
        if (sipAPI == null) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)peerUri)) {
            return false;
        }
        this.mActiveCallItem.setIsIncomingCall(false);
        this.mActiveCallItem.setPeerDisplayName(this.getDisplayNameBySipPhone(peerUri));
        this.mActiveCallItem.setConnectTime(0L);
        this.mActiveCallItem.setPeerNumber(peerUri);
        Context context = VideoBoxApplication.getGlobalContext();
        if (Build.VERSION.SDK_INT >= 23 && context != null && context.checkCallingOrSelfPermission("android.permission.RECORD_AUDIO") != 0) {
            SipInCallActivity.show(context, peerUri, true);
            return true;
        }
        boolean result = sipAPI.sendSIPCallPeerRequestMessage(peerUri);
        if (result) {
            SipInCallActivity.show(context, peerUri);
            NotificationMgr.showSipNotification(VideoBoxApplication.getGlobalContext());
        }
        return result;
    }

    public String getDisplayNameBySipPhone(String phone) {
        if (StringUtil.isEmptyOrNull((String)phone)) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return phone;
        }
        ZoomBuddy buddy = messenger.getBuddyWithSipPhone(phone);
        if (buddy == null) {
            return phone;
        }
        return buddy.getScreenName();
    }

    public void onCallPeer(int result) {
        if (0 == result) {
            return;
        }
        this.onSipCallStatusChange(11, this.mActiveCallItem.getCallID());
    }

    public boolean acceptCall() {
        return this.acceptCall(null);
    }

    public boolean acceptCall(String callID) {
        return this.responseCall(callID, 50);
    }

    public boolean declineCall() {
        return this.declineCall(null);
    }

    public boolean autoDeclineCall() {
        return this.declineCall(null, true);
    }

    public boolean declineCall(String callID) {
        return this.declineCall(callID, false);
    }

    private boolean declineCall(String callID, boolean autoDecline) {
        ZoomAssistantIPCServer sipAPI;
        if (StringUtil.isEmptyOrNull((String)callID)) {
            callID = this.mActiveCallItem.getCallID();
        }
        if ((sipAPI = ZoomAssistantIPCServer.getInstance()) == null) {
            return false;
        }
        if (!StringUtil.isEmptyOrNull((String)callID)) {
            boolean res = sipAPI.sendSIPResposeCallRequestMessage(callID, 51, 0);
            return res;
        }
        return false;
    }

    public long getActivityCallTimeLong() {
        if (this.mActiveCallItem == null || this.mActiveCallItem.getConnectTime() == 0L) {
            return 0L;
        }
        return CmmTime.getMMNow() - this.mActiveCallItem.getConnectTime();
    }

    public String getActiveCallId() {
        if (this.mActiveCallItem != null) {
            return this.mActiveCallItem.getCallID();
        }
        return null;
    }

    public boolean muteCall(String callID, boolean mute) {
        if (StringUtil.isEmptyOrNull((String)callID)) {
            callID = this.mActiveCallItem.getCallID();
        }
        if (StringUtil.isEmptyOrNull((String)callID)) {
            return false;
        }
        ZoomAssistantIPCServer sipAPI = ZoomAssistantIPCServer.getInstance();
        if (sipAPI == null) {
            return false;
        }
        return sipAPI.sendSIPMuteCallRequestMessage(callID, mute);
    }

    public void onMuteCall(boolean muted) {
        this.mIsMuted = muted;
    }

    public boolean sendDTMF(String callID, String key) {
        if (StringUtil.isEmptyOrNull((String)key) || StringUtil.isEmptyOrNull((String)callID)) {
            return false;
        }
        ZoomAssistantIPCServer sipAPI = ZoomAssistantIPCServer.getInstance();
        if (sipAPI == null) {
            return false;
        }
        return sipAPI.sendSIPDTMFRequestMessage(callID, key);
    }

    public void onRegistrar(int error, int respCode, String respDescription) {
        if (0 != error && 5 == this.mSIPConfiguration.status && respCode == this.mSIPConfiguration.respCode && !StringUtil.isEmptyOrNull((String)respDescription) && StringUtil.isSameString((String)this.mSIPConfiguration.respDescription, (String)respDescription)) {
            return;
        }
        boolean bRegistered = 0 == error;
        this.mSIPConfiguration.respCode = respCode;
        this.mSIPConfiguration.respDescription = respDescription;
        this.onSipCallStatusChange(bRegistered ? 1 : 2, null);
        if (0 != error) {
            this.mServiceStatus = 5;
            this.notifyWebSipStatus();
            this.notifySIPServiceStatus();
            this.mRegisteredType = 0;
            this.mRegisteredIP = "0.0.0.0";
            return;
        }
        this.mSIPConfiguration.status = 6;
        this.notifyWebSipStatus();
        this.notifySIPServiceStatus();
    }

    public void notifyWebSipStatus() {
        if (this.mSIPConfiguration == null) {
            return;
        }
        this.mSIPConfiguration.status = this.mServiceStatus;
        ZoomMessengerUI.getInstance().notifyWebSipStatus(this.mSIPConfiguration);
    }

    public void notifySIPServiceStatus() {
        if (this.mSIPConfiguration == null) {
            return;
        }
        this.mSIPConfiguration.status = this.mServiceStatus;
    }

    public boolean isInSIPCall() {
        if (this.mActiveCallItem == null || !this.isSipCallEnabled()) {
            return false;
        }
        int callStatus = this.mActiveCallItem.getCallStatus();
        return callStatus == 15 || callStatus == 20 || callStatus == 26 || callStatus == 28;
    }

    public boolean isCallingOrInCall() {
        return 50 == this.mServiceStatus || 20 == this.mServiceStatus || 10 == this.mServiceStatus;
    }

    public boolean isInCall() {
        return 50 == this.mServiceStatus || 20 == this.mServiceStatus;
    }

    public void onCallTerminated(String callid, String peerUri, String peerNumber, String peerDisplayName, int reason, boolean isIncomingCall) {
        this.mActiveCallItem.updateCallWithParas(29, callid, peerUri, peerNumber, peerDisplayName, isIncomingCall);
        this.onSipCallStatusChange(11, callid);
        if (50 == this.mServiceStatus) {
            this.mServiceStatus = 6;
        }
        this.rejoinConfAudioWhenSipCallEnded();
        this.resetAudioDevice();
        UIUtil.stopProximityScreenOffWakeLock();
        this.mActiveCallItem.reset();
        NotificationMgr.removeSipNotification(VideoBoxApplication.getGlobalContext());
        this.mIsMuted = false;
    }

    public void onCallIncoming(String callid, String peerUri, String peerNumber, String peerDisplayName, boolean needRing) {
        CallHistoryMgr mgr = PTApp.getInstance().getCallHistoryMgr();
        if (mgr != null) {
            CallHistory history = new CallHistory(3, callid, peerNumber, peerUri, callid, peerDisplayName, null, null, null, CmmTime.getMMNow(), 1, 0L, 1);
            mgr.addCallHistory(history);
        }
        if (!needRing) {
            return;
        }
        this.mActiveCallItem.updateCallWithParas(15, callid, peerUri, peerNumber, peerDisplayName, true);
        this.mActiveCallItem.setConnectTime(0L);
        if (PTApp.getInstance().getCallStatus() != 0) {
            this.autoDeclineCall();
            return;
        }
        NotificationMgr.showSipNotification(VideoBoxApplication.getGlobalContext());
        this.onSipCallStatusChange(3, callid);
        SipInCallActivity.show(VideoBoxApplication.getGlobalContext(), peerNumber);
    }

    private void showCallFailed() {
        Context context = VideoBoxApplication.getGlobalContext();
        if (context != null) {
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.zm_mm_msg_sip_call_failed_14480), (int)1).show();
        }
    }

    public void OnCallStatusUpdate(String callid, int status, String peerUri, String peerNumber, String peerDisplayName, boolean isIncomingCall) {
        this.mActiveCallItem.updateCallWithParas(status, callid, peerUri, peerNumber, peerDisplayName, isIncomingCall);
        switch (status) {
            case 24: {
                this.showCallFailed();
            }
            case 5: 
            case 21: 
            case 23: 
            case 25: {
                this.onSipCallStatusChange(9, callid);
                NotificationMgr.removeSipNotification(VideoBoxApplication.getGlobalContext());
                break;
            }
            case 22: {
                this.onSipCallStatusChange(10, callid);
                NotificationMgr.removeSipNotification(VideoBoxApplication.getGlobalContext());
                break;
            }
            case 26: 
            case 28: {
                this.onSipCallStatusChange(8, callid);
                break;
            }
            case 27: 
            case 29: {
                break;
            }
            case 20: {
                this.onSipCallStatusChange(12, callid);
                break;
            }
        }
    }

    public void OnSIPServiceStatusChanged(int status) {
        this.mServiceStatus = status;
        if (this.mWifiLock != null) {
            if (this.mServiceStatus == 50) {
                if (NetworkUtil.getDataNetworkType((Context)VideoBoxApplication.getGlobalContext()) == 1 && !this.mWifiLock.isHeld()) {
                    this.mWifiLock.acquire();
                }
            } else if (this.mWifiLock.isHeld()) {
                this.mWifiLock.release();
            }
        }
        if (5 == this.mServiceStatus) {
            return;
        }
        this.mSIPConfiguration.status = this.mServiceStatus;
        if (50 == this.mServiceStatus) {
            this.onCallEstablished();
        }
        this.notifySIPServiceStatus();
    }

    public void onCallEstablished() {
        this.sendSipCallStatusToConf(true);
        this.leaveConfAudioWhenSipCallReady();
        SipAudioMgr.getInstance().notifyHeadsetStatusChanged(HeadsetUtil.getInstance().isBluetoothHeadsetOn() || HeadsetUtil.getInstance().isWiredHeadsetOn());
    }

    public void leaveConfAudioWhenSipCallReady() {
        this.notifyConfToTurnOnOffAudioSession(false);
    }

    public void rejoinConfAudioWhenSipCallEnded() {
        this.notifyConfToTurnOnOffAudioSession(false);
    }

    private void notifyConfToTurnOnOffAudioSession(boolean on) {
    }

    public void resetAudioDevice() {
        SipAudioMgr.getInstance().resetAudioDevice();
    }

    public String getIPAddress() {
        return PTApp.getInstance().getMyLocalAddress();
    }

    public SipCallItem getActiveCallInfo() {
        return this.mActiveCallItem;
    }

    public SIPConfiguration getSipConfiguration() {
        return this.mSIPConfiguration;
    }

    public boolean updateWebSIPConfiguration() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return false;
        }
        PTAppProtos.SipPhoneIntegration integration = profile.getSipPhoneIntegration();
        if (integration == null) {
            return false;
        }
        if (this.mSIPConfiguration == null) {
            this.mSIPConfiguration = new SIPConfiguration();
        }
        this.mSIPConfiguration.userDisplayName = profile.getUserName();
        boolean isChange = !StringUtil.isSameString((String)this.mSIPConfiguration.userName, (String)integration.getUserName()) || !StringUtil.isSameString((String)this.mSIPConfiguration.domain, (String)integration.getDomain()) || !StringUtil.isSameString((String)this.mSIPConfiguration.userPassword, (String)integration.getPassword()) || !StringUtil.isSameString((String)this.mSIPConfiguration.authName, (String)integration.getAuthoriztionName()) || !StringUtil.isSameString((String)this.mSIPConfiguration.regServerAddress, (String)integration.getRegisterServer()) || !StringUtil.isSameString((String)this.mSIPConfiguration.proxy, (String)integration.getProxyServer()) || this.mSIPConfiguration.protocol != integration.getProtocol();
        this.mSIPConfiguration.userName = integration.getUserName();
        this.mSIPConfiguration.domain = integration.getDomain();
        this.mSIPConfiguration.userPassword = integration.getPassword();
        this.mSIPConfiguration.authName = integration.getAuthoriztionName();
        this.mSIPConfiguration.regServerAddress = integration.getRegisterServer();
        this.mSIPConfiguration.proxy = integration.getProxyServer();
        this.mSIPConfiguration.registrationExpiry = 60;
        this.mSIPConfiguration.protocol = integration.getProtocol();
        return isChange;
    }

    public boolean isSipCallEnabled() {
        return PTApp.getInstance().isSipPhoneEnabled();
    }

    public String getMyselfSipNo() {
        if (!this.isSipCallEnabled()) {
            return null;
        }
        return this.mSIPConfiguration.userName;
    }

    public boolean isSipAvailable() {
        if (!AssistantAppMgr.getInstance().isAssistantServiceAvailable()) {
            return false;
        }
        return this.mServiceStatus >= 6;
    }

    public boolean isSipRegistering() {
        if (!AssistantAppMgr.getInstance().isAssistantServiceAvailable()) {
            return false;
        }
        return this.mServiceStatus == 4;
    }

    public void onSIPRegistrarResponse(int result) {
        if (result != 0) {
            this.onRegistrar(result, result, "Register failed");
        }
    }

    public void onSIPOnRegistrarNotification(int result, int respCode, String respDescription) {
        this.onRegistrar(result, respCode, respDescription);
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 22: {
                if (PTApp.getInstance().getCallStatus() == 0 || !this.isInSIPCall()) break;
                this.hangupActiveCall();
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    public boolean needIputPassword() {
        if (this.mSIPConfiguration == null) {
            return false;
        }
        return this.mSIPConfiguration.respCode == 403 || this.mSIPConfiguration.respCode == 401 || this.mSIPConfiguration.respCode == 407;
    }

    public void onActivityMoveToFront(ZMActivity activity) {
    }

    public void onUIMoveToBackground() {
    }

    public void onUserActivityOnUI() {
    }

    static {
        TAG = SipCallManager.class.getSimpleName();
    }

    public static class PasswordInputDialog
    extends ZMDialogFragment {
        private EditText mEdtPassword;
        private Button mPositiveButton;
        private OnCancelClickListener mOnCancelClickListener;
        private ZoomAssistantIPCMessageUI.IZoomAssistantIPCMessageUIListener mListener = new ZoomAssistantIPCMessageUI.SimpleZoomAssistantIPCMessageUIListener(){

            @Override
            public void HandleSIPOnRegistrarNotification(int result, int respCode, String respDescription) {
                if (SipCallManager.getInstance().isSipAvailable()) {
                    PasswordInputDialog.this.dismiss();
                }
            }
        };

        public PasswordInputDialog() {
            ZoomAssistantIPCMessageUI.getInstance().addListener(this.mListener);
            this.setCancelable(false);
        }

        public static PasswordInputDialog getPasswordInputDialog(FragmentActivity activity) {
            if (activity == null) {
                return null;
            }
            return (PasswordInputDialog)activity.getSupportFragmentManager().findFragmentByTag(PasswordInputDialog.class.getName());
        }

        public static PasswordInputDialog show(ZMActivity zmActivity) {
            if (zmActivity == null || !SipCallManager.getInstance().needIputPassword()) {
                return null;
            }
            PasswordInputDialog dialog = new PasswordInputDialog();
            Bundle args = new Bundle();
            dialog.setArguments(args);
            dialog.show(zmActivity.getSupportFragmentManager(), PasswordInputDialog.class.getName());
            return dialog;
        }

        public void setOnCancelClick(OnCancelClickListener onCancelClickListener) {
            this.mOnCancelClickListener = onCancelClickListener;
        }

        public void onStart() {
            super.onStart();
            Dialog dlg = this.getDialog();
            if (dlg != null) {
                ZMAlertDialog alertDialog = (ZMAlertDialog)dlg;
                this.mPositiveButton = alertDialog.getButton(-1);
                if (this.mPositiveButton != null) {
                    this.mPositiveButton.setEnabled(this.mEdtPassword.length() > 0);
                }
            }
        }

        public void onDestroy() {
            ZoomAssistantIPCMessageUI.getInstance().removeListener(this.mListener);
            super.onDestroy();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            View view = View.inflate((Context)this.getContext(), (int)R.layout.zm_sip_input_passwd, null);
            this.mEdtPassword = (EditText)view.findViewById(R.id.edtPassword);
            this.mEdtPassword.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                }

                public void afterTextChanged(Editable s) {
                    if (PasswordInputDialog.this.mPositiveButton == null) {
                        return;
                    }
                    PasswordInputDialog.this.mPositiveButton.setEnabled(s.length() > 0);
                }
            });
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_lbl_sip_wrong_passwd_title_25326).setView(view).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (PasswordInputDialog.this.mOnCancelClickListener != null) {
                        PasswordInputDialog.this.mOnCancelClickListener.OnCancelClick();
                    }
                    UIUtil.closeSoftKeyboard((Context)PasswordInputDialog.this.getActivity(), (View)PasswordInputDialog.this.mEdtPassword);
                }
            }).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (PasswordInputDialog.this.mEdtPassword == null) {
                        return;
                    }
                    String password = PasswordInputDialog.this.mEdtPassword.getText().toString();
                    if (TextUtils.isEmpty((CharSequence)password)) {
                        return;
                    }
                    PasswordInputDialog.this.doSipRegister(password);
                    UIUtil.closeSoftKeyboard((Context)PasswordInputDialog.this.getActivity(), (View)PasswordInputDialog.this.mEdtPassword);
                }
            }).create();
        }

        public void onDismiss(DialogInterface dialog) {
            super.onDismiss(dialog);
        }

        private void doSipRegister(String password) {
            SipCallManager mgr = SipCallManager.getInstance();
            SIPConfiguration config = mgr.getSipConfiguration();
            config.userPassword = password;
            mgr.registrar();
        }

        public static interface OnCancelClickListener {
            public void OnCancelClick();
        }
    }

    public static interface OnSipCallEventListener
    extends IListener {
        public static final int Noti_SIP_Call_Registered = 1;
        public static final int Noti_SIP_Call_UnRegistered = 2;
        public static final int Noti_SIP_Call_In_Invitation = 3;
        public static final int Noti_SIP_Call_In_Accepting = 4;
        public static final int Noti_SIP_Call_In_Declining = 5;
        public static final int Noti_SIP_Call_In_Accepted = 6;
        public static final int Noti_SIP_Call_In_Declined = 7;
        public static final int Noti_SIP_Call_Out_Accepted = 8;
        public static final int Noti_SIP_Call_Out_Declined = 9;
        public static final int Noti_SIP_Call_Out_Busy = 10;
        public static final int Noti_SIP_Call_HangUp = 11;
        public static final int Noti_SIP_Call_Out_Ringing = 12;

        public void onSipCallEvent(int var1, String var2);
    }
}

