/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sip.server;

import android.content.Context;
import android.media.AudioManager;
import android.os.Handler;
import android.os.RemoteException;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.widget.Toast;
import com.zipow.videobox.ISIPService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.sip.server.SipCallManager;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class SipAudioMgr
implements SipCallManager.OnSipCallEventListener {
    private static SipAudioMgr mInstance;
    private static final String TAG;
    public static final int LOUDSPEAKER_NOT_SET = -1;
    public static final int LOUDSPEAKER_OFF = 0;
    public static final int LOUDSPEAKER_ON = 1;
    private Handler mHandler = new Handler();
    private boolean mIsCallOffHook;
    private PhoneStateListener mPhoneStateListener;
    private boolean mIsAudioStoppedByPauseAudio;
    private boolean mIsAudioMutedByCallOffHook;
    private boolean mIsAudioStoppedByCallOffHook;
    private int mPreferedLoudspeakerStatus = 0;

    public static SipAudioMgr getInstance() {
        if (mInstance == null) {
            mInstance = new SipAudioMgr();
        }
        return mInstance;
    }

    public void init() {
        this.startToListenPhoneState();
    }

    private SipAudioMgr() {
    }

    public boolean isSpeakerPhoneOn() {
        ISIPService service = VideoBoxApplication.getInstance().getSIPService();
        if (service == null) {
            return false;
        }
        try {
            return service.isSpeakerPhoneOn();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void resetAudioDevice() {
        this.setPreferedLoudSpeakerStatus(0);
        AudioManager audioManager = (AudioManager)VideoBoxApplication.getInstance().getSystemService("audio");
        if (audioManager != null) {
            if (HeadsetUtil.getInstance().isBluetoothHeadsetOn() || HeadsetUtil.getInstance().isWiredHeadsetOn()) {
                audioManager.setSpeakerphoneOn(false);
            } else {
                audioManager.setSpeakerphoneOn(true);
            }
        }
    }

    public void notifyHeadsetStatusChanged(boolean connected) {
        if (!this.isSpeakerPhoneOn() && !connected) {
            UIUtil.startProximityScreenOffWakeLock((Context)VideoBoxApplication.getInstance());
        } else {
            UIUtil.stopProximityScreenOffWakeLock();
        }
    }

    public boolean toggleSpeakerPhone(boolean on) {
        ISIPService service = VideoBoxApplication.getInstance().getSIPService();
        if (service == null) {
            return false;
        }
        if (!(on || HeadsetUtil.getInstance().isBluetoothHeadsetOn() || HeadsetUtil.getInstance().isWiredHeadsetOn())) {
            UIUtil.startProximityScreenOffWakeLock((Context)VideoBoxApplication.getInstance());
        } else {
            UIUtil.stopProximityScreenOffWakeLock();
        }
        try {
            return service.toggleSpeakerPhone(on);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void setPreferedLoudSpeakerStatus(int status) {
        this.mPreferedLoudspeakerStatus = status;
        if (-1 != status) {
            this.toggleSpeakerPhone(status == 1);
        }
    }

    public int getPreferedLoudSpeakerStatus() {
        return this.mPreferedLoudspeakerStatus;
    }

    public void checkOpenLoudSpeaker() {
        if (this.getPreferedLoudSpeakerStatus() == 1) {
            this.toggleSpeakerPhone(true);
        } else if (this.getPreferedLoudSpeakerStatus() == 0) {
            this.toggleSpeakerPhone(false);
        } else {
            this.toggleSpeakerPhone(!HeadsetUtil.getInstance().isBluetoothHeadsetOn() && !HeadsetUtil.getInstance().isWiredHeadsetOn());
        }
    }

    @Override
    public void onSipCallEvent(int event, String callId) {
        switch (event) {
            case 3: {
                if (!this.mIsCallOffHook) break;
                SipCallManager.getInstance().declineCall(callId);
                break;
            }
            case 8: {
                if (!SipCallManager.getInstance().getActiveCallInfo().isIncomingCall()) break;
                this.toggleSpeakerPhone(false);
                break;
            }
        }
        if (!SipCallManager.getInstance().isInCall()) {
            this.mIsAudioStoppedByCallOffHook = false;
            this.mIsAudioMutedByCallOffHook = false;
        }
    }

    private void startToListenPhoneState() {
        TelephonyManager tm = (TelephonyManager)VideoBoxApplication.getInstance().getSystemService("phone");
        if (tm != null) {
            this.mIsCallOffHook = tm.getCallState() == 2;
            this.mPhoneStateListener = new PhoneStateListener(){

                public void onCallStateChanged(int state, String incomingNumber) {
                    super.onCallStateChanged(state, incomingNumber);
                    switch (state) {
                        case 0: {
                            SipAudioMgr.this.onPhoneCallIdle();
                            break;
                        }
                        case 2: {
                            SipAudioMgr.this.onPhoneCallOffHook();
                        }
                    }
                }

                public void onDataConnectionStateChanged(int state, int networkType) {
                }
            };
            try {
                tm.listen(this.mPhoneStateListener, 96);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onPhoneCallOffHook() {
        this.mIsCallOffHook = true;
        if (this.mIsAudioStoppedByPauseAudio) {
            return;
        }
        SipCallManager mgr = SipCallManager.getInstance();
        if (!mgr.isInCall()) {
            return;
        }
        if (!mgr.isCallMuted()) {
            mgr.muteCall(mgr.getActiveCallId(), true);
            this.mIsAudioMutedByCallOffHook = true;
        }
        this.toggleSpeakerPhone(false);
        ISIPService sipService = VideoBoxApplication.getInstance().getSIPService();
        if (sipService != null) {
            try {
                sipService.stopPlayout();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        this.mIsAudioStoppedByCallOffHook = true;
        Toast.makeText((Context)VideoBoxApplication.getInstance(), (int)R.string.zm_mm_msg_sip_audio_stopped_by_call_offhook_14480, (int)1).show();
    }

    public void onPhoneCallIdle() {
        this.mIsCallOffHook = false;
        if (!this.mIsAudioStoppedByCallOffHook) {
            return;
        }
        SipCallManager mgr = SipCallManager.getInstance();
        if (!mgr.isInCall()) {
            return;
        }
        ISIPService sipService = VideoBoxApplication.getInstance().getSIPService();
        if (sipService != null) {
            try {
                sipService.startPlayout();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        if (this.mIsAudioMutedByCallOffHook && mgr.isCallMuted()) {
            mgr.muteCall(mgr.getActiveCallId(), false);
        }
        this.mIsAudioStoppedByCallOffHook = false;
        this.mIsAudioMutedByCallOffHook = false;
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                SipAudioMgr.this.checkOpenLoudSpeaker();
            }
        }, 2000L);
    }

    static {
        TAG = SipAudioMgr.class.getSimpleName();
    }
}

