/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sip.server;

import android.os.Handler;
import com.zipow.videobox.SIPService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.sip.server.SipCallManager;
import com.zipow.videobox.sip.server.ZoomAssistantIPCMessageUI;
import com.zipow.videobox.sip.server.ZoomAssistantIPCServer;

public class AssistantAppMgr {
    private static AssistantAppMgr mInstance;
    private int mAssistantPid;
    private Handler mHandler = new Handler();
    private boolean mbMessageLoopStopped = false;
    private static final String TAG;
    private Runnable mSipMessageLoopRunnable = new Runnable(){
        long lastDispatchIdleMessageTime = 0L;

        @Override
        public void run() {
            if (AssistantAppMgr.this.mbMessageLoopStopped) {
                return;
            }
            long timeStart = System.currentTimeMillis();
            if (timeStart - this.lastDispatchIdleMessageTime >= 300L || timeStart < this.lastDispatchIdleMessageTime) {
                this.lastDispatchIdleMessageTime = timeStart;
                AssistantAppMgr.this.dispatchIdleMessage();
                long timeUsed = System.currentTimeMillis() - timeStart;
                if (timeUsed > 300L) {
                    // empty if block
                }
            }
            AssistantAppMgr.this.startSipMessageLoop(50L);
        }
    };

    private AssistantAppMgr() {
    }

    private void startSipMessageLoop(long delayed) {
        this.mHandler.postDelayed(this.mSipMessageLoopRunnable, delayed);
    }

    private void stopMessageLoop() {
        this.mbMessageLoopStopped = true;
    }

    public static synchronized AssistantAppMgr getInstance() {
        if (mInstance == null) {
            mInstance = new AssistantAppMgr();
        }
        return mInstance;
    }

    public void dispatchIdleMessage() {
        ZoomAssistantIPCServer server = ZoomAssistantIPCServer.getInstance();
        if (server == null) {
            return;
        }
        server.heartBeat();
    }

    public int startAssistantService() {
        int pid;
        this.mAssistantPid = 0;
        VideoBoxApplication.getInstance().startSIPService(SIPService.ACTION_DEAMON);
        this.mAssistantPid = pid = VideoBoxApplication.getInstance().getSipProcessId();
        if (this.mAssistantPid != 0) {
            this.onAssistantServiceStartSuccess(this.mAssistantPid);
        }
        return this.mAssistantPid;
    }

    public void stopAssistantService() {
        if (this.mAssistantPid == 0) {
            return;
        }
        this.stopMessageLoop();
        VideoBoxApplication.getInstance().killSipProcess();
        this.mAssistantPid = 0;
    }

    public void uninitModule() {
        if (ZoomAssistantIPCServer.isInit()) {
            ZoomAssistantIPCServer.getInstance().removeMessageHandler(ZoomAssistantIPCMessageUI.getInstance());
            ZoomAssistantIPCServer.unInit();
        }
        SipCallManager.getInstance().onSIPRegistrarResponse(1);
    }

    public boolean isAssistantServiceAvailable() {
        return this.mAssistantPid != 0;
    }

    public int getAssistantServicePid() {
        return this.mAssistantPid;
    }

    public void onAssistantServiceStartSuccess(int pid) {
        boolean res;
        if (pid == 0) {
            return;
        }
        this.mAssistantPid = pid;
        if (ZoomAssistantIPCServer.isInit()) {
            ZoomAssistantIPCServer zoomAssistantIPCServer = ZoomAssistantIPCServer.getInstance();
            if (zoomAssistantIPCServer != null) {
                zoomAssistantIPCServer.removeMessageHandler(ZoomAssistantIPCMessageUI.getInstance());
            }
            ZoomAssistantIPCServer.unInit();
        }
        if (!(res = ZoomAssistantIPCServer.init(pid))) {
            return;
        }
        ZoomAssistantIPCServer.getInstance().addMessageHandler(ZoomAssistantIPCMessageUI.getInstance());
        this.startSipMessageLoop(50L);
    }

    public boolean initAssistantApp() {
        if (ZoomAssistantIPCServer.isInit()) {
            return true;
        }
        this.uninitAssistantApp();
        this.startAssistantService();
        return true;
    }

    public boolean uninitAssistantApp() {
        ZoomAssistantIPCServer.unInit();
        return true;
    }

    static {
        TAG = AssistantAppMgr.class.getSimpleName();
    }
}

