/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sip.client;

import android.os.Handler;
import com.zipow.videobox.mainboard.Mainboard;

public class AssistantAppClientMgr {
    private static AssistantAppClientMgr mInstance;
    private Handler mHandler = new Handler();
    private boolean mbMessageLoopStopped = false;
    private static final String TAG;
    private Runnable mSipMessageLoopRunnable = new Runnable(){
        long lastDispatchIdleMessageTime = 0L;

        @Override
        public void run() {
            if (AssistantAppClientMgr.this.mbMessageLoopStopped) {
                return;
            }
            long timeStart = System.currentTimeMillis();
            if (timeStart - this.lastDispatchIdleMessageTime >= 300L || timeStart < this.lastDispatchIdleMessageTime) {
                this.lastDispatchIdleMessageTime = timeStart;
                AssistantAppClientMgr.this.dispatchIdleMessage();
                long timeUsed = System.currentTimeMillis() - timeStart;
                if (timeUsed > 300L) {
                    // empty if block
                }
            }
            AssistantAppClientMgr.this.startSipMessageLoop(50L);
        }
    };

    private AssistantAppClientMgr() {
    }

    public void onAssistantClientStart() {
        this.startSipMessageLoop(50L);
    }

    public void onAssistantClientStop() {
        this.stopMessageLoop();
    }

    private void startSipMessageLoop(long delayed) {
        this.mHandler.postDelayed(this.mSipMessageLoopRunnable, delayed);
    }

    private void stopMessageLoop() {
        this.mbMessageLoopStopped = true;
    }

    public static synchronized AssistantAppClientMgr getInstance() {
        if (mInstance == null) {
            mInstance = new AssistantAppClientMgr();
        }
        return mInstance;
    }

    public void dispatchIdleMessage() {
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            return;
        }
        this.dispatchIdleMessageImpl();
    }

    public boolean toggleSpeakerPhone(boolean on) {
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            return false;
        }
        return this.toggleSpeakerPhoneImpl(on);
    }

    public boolean isSpeakerPhoneOn() {
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            return false;
        }
        return this.isSpeakerPhoneOnImpl();
    }

    public void startPlayout() {
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            return;
        }
        this.startPlayoutImpl();
    }

    public void stopPlayout() {
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            return;
        }
        this.stopPlayoutImpl();
    }

    private native void dispatchIdleMessageImpl();

    private native boolean toggleSpeakerPhoneImpl(boolean var1);

    private native boolean isSpeakerPhoneOnImpl();

    private native int startPlayoutImpl();

    private native int stopPlayoutImpl();

    static {
        TAG = AssistantAppClientMgr.class.getSimpleName();
    }
}

