/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.share;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.zipow.videobox.share.ShareBaseView;
import com.zipow.videobox.view.bookmark.BookmarkListViewFragment;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class ShareWebView
extends ShareBaseView {
    private Context mContext;
    private String mUrl;
    private WebView mWebView;
    private View mWebViewContainer;
    private View mHeader;
    private View mToolbar;
    private ProgressBar mLoadingProgress;
    private boolean mInWebLoading = false;
    private EditText mUrlEditText;
    private ImageView mWebRefresh;
    private ImageView mWebUrlDelete;
    private ImageView mWebLoadingStop;
    private ImageView mBackBtn;
    private ImageView mForwardBtn;
    private ImageView mBookmarkBtn;

    public ShareWebView(Context context) {
        super(context);
        this.init(context);
    }

    public ShareWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ShareWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    @SuppressLint(value={"NewApi"})
    private void init(Context context) {
        this.mContext = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.zm_share_webview, null, false);
        this.mToolbar = view.findViewById(R.id.shareWebToolbar);
        this.mWebView = (WebView)view.findViewById(R.id.webview);
        this.mWebViewContainer = view.findViewById(R.id.webviewContainer);
        if (!this.isInEditMode()) {
            if (Build.VERSION.SDK_INT > 10) {
                this.mWebView.getSettings().setAllowContentAccess(false);
            }
            this.mWebView.getSettings().setSupportZoom(true);
            this.mWebView.getSettings().setJavaScriptEnabled(true);
            this.mWebView.getSettings().setLoadsImagesAutomatically(true);
        }
        this.mWebView.setScrollBarStyle(0);
        this.mWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                ShareWebView.this.mWebView.requestFocus();
                return false;
            }
        });
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                ShareWebView.this.mUrlEditText.setText((CharSequence)url);
                ShareWebView.this.showWebUrlLoadingStatus();
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                ShareWebView.this.mUrlEditText.setText((CharSequence)url);
                ShareWebView.this.showWebUrlLoadedStatus();
                ShareWebView.this.updateWebNavigateBtn();
            }
        });
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int progress) {
                ShareWebView.this.displayWebLoadingProgress(view, progress);
            }
        });
        this.mHeader = view.findViewById(R.id.webheader);
        this.mLoadingProgress = (ProgressBar)view.findViewById(R.id.webLoadingProgress);
        this.mLoadingProgress.setVisibility(8);
        this.mUrlEditText = (EditText)view.findViewById(R.id.editurl);
        this.mUrlEditText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!ShareWebView.this.mUrlEditText.hasFocus()) {
                    ShareWebView.this.mUrlEditText.requestFocus();
                }
                ShareWebView.this.showWebUrlEditStatus();
            }
        });
        this.mUrlEditText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View arg0, int keyCode, KeyEvent arg2) {
                if (keyCode == 66) {
                    View focusView;
                    InputMethodManager inputMethodManager = (InputMethodManager)ShareWebView.this.mContext.getSystemService("input_method");
                    if (inputMethodManager != null && (focusView = ((Activity)ShareWebView.this.mContext).getCurrentFocus()) != null) {
                        inputMethodManager.hideSoftInputFromWindow(focusView.getWindowToken(), 2);
                    }
                    ShareWebView.this.setUrl(ShareWebView.this.mUrlEditText.getText().toString());
                }
                return false;
            }
        });
        this.mUrlEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (v != ShareWebView.this.mUrlEditText) {
                    return;
                }
                if (hasFocus) {
                    ShareWebView.this.showWebUrlEditStatus();
                } else {
                    UIUtil.closeSoftKeyboard((Context)ShareWebView.this.mContext, (View)v);
                    if (ShareWebView.this.mInWebLoading) {
                        ShareWebView.this.showWebUrlLoadingStatus();
                    } else {
                        ShareWebView.this.showWebUrlLoadedStatus();
                    }
                }
            }
        });
        this.mWebRefresh = (ImageView)view.findViewById(R.id.urlRefresh);
        this.mWebRefresh.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ShareWebView.this.mWebView.isShown()) {
                    ShareWebView.this.mWebView.reload();
                }
            }
        });
        this.mWebUrlDelete = (ImageView)view.findViewById(R.id.urlDelete);
        this.mWebUrlDelete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ShareWebView.this.mUrlEditText.setText((CharSequence)"");
                ShareWebView.this.mUrlEditText.requestFocus();
            }
        });
        this.mWebLoadingStop = (ImageView)view.findViewById(R.id.urlLoadingStop);
        this.mWebLoadingStop.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ShareWebView.this.mWebView.stopLoading();
            }
        });
        this.mBackBtn = (ImageView)view.findViewById(R.id.back);
        this.mBackBtn.setEnabled(false);
        this.mBackBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                if (ShareWebView.this.mWebView.canGoBack()) {
                    ShareWebView.this.mWebView.goBack();
                }
            }
        });
        this.mForwardBtn = (ImageView)view.findViewById(R.id.forward);
        this.mBackBtn.setEnabled(false);
        this.mForwardBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ShareWebView.this.mWebView.canGoForward()) {
                    ShareWebView.this.mWebView.goForward();
                }
            }
        });
        this.mBookmarkBtn = (ImageView)view.findViewById(R.id.bookmark);
        this.mBookmarkBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Bundle bundle = new Bundle();
                String title = ShareWebView.this.mWebView.getTitle();
                String url = ShareWebView.this.mWebView.getUrl();
                if (title != null && !title.isEmpty()) {
                    bundle.putString("bookmark_title", title);
                }
                if (url != null && !url.isEmpty()) {
                    bundle.putString("bookmark_url", url);
                }
                BookmarkListViewFragment.showAsActivity((ZMActivity)ShareWebView.this.mContext, bundle, 1006);
            }
        });
        this.addView(view);
    }

    private void showWebUrlEditStatus() {
        if (this.mHeader.getVisibility() == 0) {
            this.mWebUrlDelete.setVisibility(0);
            this.mWebRefresh.setVisibility(8);
            this.mWebLoadingStop.setVisibility(8);
        }
    }

    private void showWebUrlLoadingStatus() {
        if (this.mHeader.getVisibility() == 0) {
            this.mLoadingProgress.setVisibility(0);
            this.mLoadingProgress.setProgress(0);
            this.mInWebLoading = true;
            this.mWebLoadingStop.setVisibility(0);
            this.mWebUrlDelete.setVisibility(8);
            this.mWebRefresh.setVisibility(8);
        }
    }

    private void showWebUrlLoadedStatus() {
        if (this.mHeader.getVisibility() == 0) {
            this.mLoadingProgress.setVisibility(4);
            this.mInWebLoading = false;
            this.mWebUrlDelete.setVisibility(8);
            this.mWebRefresh.setVisibility(0);
            this.mWebLoadingStop.setVisibility(8);
        }
    }

    private void updateWebNavigateBtn() {
        if (this.mHeader.getVisibility() == 0) {
            this.mBackBtn.setEnabled(this.mWebView.canGoBack());
            this.mForwardBtn.setEnabled(this.mWebView.canGoForward());
        }
    }

    private void displayWebLoadingProgress(WebView view, int progress) {
        if (view != this.mWebView || progress < 0 || this.mHeader.getVisibility() != 0) {
            return;
        }
        if (progress < 100 && progress > 0) {
            this.mLoadingProgress.setProgress(progress);
        } else {
            this.mLoadingProgress.setProgress(0);
        }
    }

    private void setUrl(String url) {
        WebSettings webSettings;
        if ("".equals(url.trim())) {
            this.mUrl = null;
            return;
        }
        this.mUrl = url;
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = "http://" + url;
        }
        if ((webSettings = this.mWebView.getSettings()) != null) {
            webSettings.setJavaScriptEnabled(true);
            webSettings.setDomStorageEnabled(true);
        }
        this.mWebView.loadUrl(url);
        UIUtil.closeSoftKeyboard((Context)this.mContext, (View)this);
    }

    public boolean setWebUrl(String path) {
        if (StringUtil.isEmptyOrNull((String)path)) {
            return false;
        }
        this.setUrl(path);
        return true;
    }

    @Override
    public void drawShareContent(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        this.mWebViewContainer.draw(canvas);
    }

    @Override
    public int getShareContentWidth() {
        return this.mWebViewContainer.getWidth();
    }

    @Override
    public int getShareContentHeight() {
        return this.mWebViewContainer.getHeight();
    }

    @Override
    public boolean handleKeydown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            return true;
        }
        return false;
    }

    @Override
    public void setDrawingMode(boolean flag) {
        if (flag) {
            this.mHeader.setVisibility(8);
            this.mToolbar.setVisibility(0);
        } else {
            this.mHeader.setVisibility(0);
            this.mToolbar.setVisibility(8);
        }
    }

    @Override
    public void setDrawingModeForSDK(boolean flag) {
        if (flag) {
            this.mHeader.setVisibility(8);
        } else {
            this.mHeader.setVisibility(0);
        }
        this.mToolbar.setVisibility(8);
    }

    public void setBookmarkBtnVisibility(boolean isVisible) {
        if (this.mBookmarkBtn != null) {
            if (isVisible) {
                this.mBookmarkBtn.setVisibility(0);
            } else {
                this.mBookmarkBtn.setVisibility(8);
            }
        }
    }
}

