/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.share;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.zipow.videobox.share.IColorChangedListener;
import us.zoom.androidlib.util.UIUtil;

public class ColorTable
extends View {
    public static final int COLOR_ALPHA = 255;
    public static final int COLOR_RED = Color.argb((int)255, (int)238, (int)28, (int)37);
    public static final int COLOR_PINK = Color.argb((int)255, (int)236, (int)0, (int)140);
    public static final int COLOR_YELLOW = Color.argb((int)255, (int)255, (int)255, (int)0);
    public static final int COLOR_GREEN = Color.argb((int)255, (int)12, (int)255, (int)1);
    public static final int COLOR_LIGHTBLUE = Color.argb((int)255, (int)0, (int)186, (int)255);
    public static final int COLOR_DARKBLUE = Color.argb((int)255, (int)0, (int)0, (int)255);
    public static final int COLOR_DARK_RED = Color.argb((int)255, (int)189, (int)16, (int)225);
    public static final int COLOR_BLACK = Color.argb((int)255, (int)0, (int)0, (int)0);
    private int[] mColors;
    private static final int DFT_COLORS_CIRCLE_SIZE = 26;
    private static final int DFT_COLORS_CIRCLE_SPACE = 5;
    private Paint mPaint;
    private int circleSize;
    private int space;
    private Context mContext;
    private IColorChangedListener listner;

    public ColorTable(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    public ColorTable(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.mColors = new int[]{COLOR_RED, COLOR_PINK, COLOR_YELLOW, COLOR_GREEN, COLOR_LIGHTBLUE, COLOR_DARKBLUE, COLOR_DARK_RED, COLOR_BLACK};
        this.mPaint = new Paint(1);
        this.circleSize = UIUtil.dip2px((Context)this.mContext, (float)26.0f);
        this.space = UIUtil.dip2px((Context)this.mContext, (float)5.0f);
    }

    protected void onDraw(Canvas canvas) {
        this.mPaint.setStyle(Paint.Style.FILL);
        if (this.getWidth() == 0) {
            return;
        }
        int circleTotalSize = this.circleSize * this.mColors.length;
        if (circleTotalSize <= this.getWidth()) {
            this.space = (this.getWidth() - circleTotalSize) / (this.mColors.length + 1);
        } else {
            int spaceTotalW = this.space * (this.mColors.length + 1);
            if (spaceTotalW > this.getWidth()) {
                this.space = 0;
            }
            this.circleSize = (this.getWidth() - this.space * (this.mColors.length + 1)) / this.mColors.length;
        }
        int circleRadio = this.circleSize / 2;
        Log.e((String)"View", (String)("space is " + this.space));
        int cx = this.space + circleRadio;
        int height = this.getHeight();
        for (int i = 0; i < this.mColors.length; ++i) {
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(this.mColors[i]);
            canvas.drawCircle((float)cx, (float)(height / 2), (float)circleRadio, this.mPaint);
            Log.e((String)"View", (String)("draw x is " + cx + " draw y is " + height / 2));
            cx += this.circleSize + this.space;
        }
    }

    public int getColorByIndex(int index) {
        if (index < this.mColors.length) {
            return this.mColors[index];
        }
        return COLOR_RED;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 1: {
                float x = event.getX();
                int select = (int)(x * (float)this.mColors.length / (float)this.getWidth());
                if (select > this.mColors.length - 1) {
                    select = this.mColors.length - 1;
                }
                this.listner.onColorPicked(this, this.mColors[select]);
                break;
            }
            default: {
                return true;
            }
        }
        return true;
    }

    public void setOnColorChangedListener(IColorChangedListener listner) {
        this.listner = listner;
    }
}

