/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.share;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.ImageView;

public class ColorSelectedImage
extends ImageView {
    private int color = 0;
    private Paint mPaint;

    private void init() {
        this.setWillNotCacheDrawing(true);
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setAntiAlias(true);
    }

    public ColorSelectedImage(Context context) {
        super(context);
        this.init();
    }

    public ColorSelectedImage(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color2) {
        this.color = color2;
        this.mPaint.setColor(color2);
        this.invalidate();
    }

    public void onDraw(Canvas canvas) {
        if (this.color == 0) {
            super.onDraw(canvas);
        } else {
            this.mPaint.setColor(this.color);
            int height = this.getHeight();
            int width = this.getWidth();
            int radius = Math.min(height / 2, width / 2);
            canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)(radius - 2), this.mPaint);
        }
    }
}

