/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.share;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.zipow.videobox.share.IColorChangedListener;

public class ColorCircle
extends View {
    private float center_radius;
    private static final float CENTER_RADIUS_SCALE = 0.4f;
    private Paint mPaint;
    private Paint mCenterPaint;
    private int[] mColors;
    private IColorChangedListener mListener;
    private boolean mTrackingCenter;
    private boolean mHighlightCenter;

    public ColorCircle(Context context) {
        super(context);
        this.init();
    }

    public ColorCircle(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    void init() {
        this.mColors = new int[]{-65536, -65281, -16776961, -16711681, -16711936, -256, -65536};
        SweepGradient s = new SweepGradient(0.0f, 0.0f, this.mColors, null);
        this.mPaint = new Paint(1);
        this.mPaint.setShader((Shader)s);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mCenterPaint = new Paint(1);
        this.mCenterPaint.setStrokeWidth(5.0f);
    }

    protected void onDraw(Canvas canvas) {
        float outer_radius = Math.min(this.getWidth(), this.getHeight()) / 2;
        float touch_feedback_ring = this.center_radius + 2.0f * this.mCenterPaint.getStrokeWidth();
        float r = (outer_radius + touch_feedback_ring) / 2.0f;
        canvas.translate((float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        this.mPaint.setStrokeWidth(outer_radius - touch_feedback_ring);
        canvas.drawCircle(0.0f, 0.0f, r, this.mPaint);
        canvas.drawCircle(0.0f, 0.0f, this.center_radius, this.mCenterPaint);
        if (this.mTrackingCenter) {
            int c = this.mCenterPaint.getColor();
            this.mCenterPaint.setStyle(Paint.Style.STROKE);
            if (this.mHighlightCenter) {
                this.mCenterPaint.setAlpha(255);
            } else {
                this.mCenterPaint.setAlpha(128);
            }
            canvas.drawCircle(0.0f, 0.0f, this.center_radius + this.mCenterPaint.getStrokeWidth(), this.mCenterPaint);
            this.mCenterPaint.setStyle(Paint.Style.FILL);
            this.mCenterPaint.setColor(c);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int max_width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int max_height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int size = Math.min(max_width, max_height);
        this.center_radius = 0.4f * (float)size / 2.0f;
        this.setMeasuredDimension(size, size);
    }

    public void setColor(int color2) {
        this.mCenterPaint.setColor(color2);
        this.invalidate();
    }

    public int getColor() {
        return this.mCenterPaint.getColor();
    }

    public void setOnColorChangedListener(IColorChangedListener colorListener) {
        this.mListener = colorListener;
    }

    private int ave(int s, int d, float p) {
        return s + Math.round(p * (float)(d - s));
    }

    private int interpColor(int[] colors, float unit) {
        if (unit <= 0.0f) {
            return colors[0];
        }
        if (unit >= 1.0f) {
            return colors[colors.length - 1];
        }
        float p = unit * (float)(colors.length - 1);
        int i = (int)p;
        int c0 = colors[i];
        int c1 = colors[i + 1];
        int a = this.ave(Color.alpha((int)c0), Color.alpha((int)c1), p -= (float)i);
        int r = this.ave(Color.red((int)c0), Color.red((int)c1), p);
        int g = this.ave(Color.green((int)c0), Color.green((int)c1), p);
        int b = this.ave(Color.blue((int)c0), Color.blue((int)c1), p);
        return Color.argb((int)a, (int)r, (int)g, (int)b);
    }

    public boolean onTouchEvent(MotionEvent event) {
        float y;
        float x = event.getX() - (float)(this.getWidth() / 2);
        boolean inCenter = PointF.length((float)x, (float)(y = event.getY() - (float)(this.getHeight() / 2))) <= this.center_radius;
        switch (event.getAction()) {
            case 0: {
                this.mTrackingCenter = inCenter;
                if (inCenter) {
                    this.mHighlightCenter = true;
                    this.invalidate();
                    break;
                }
            }
            case 2: {
                if (this.mTrackingCenter) {
                    if (this.mHighlightCenter == inCenter) break;
                    this.mHighlightCenter = inCenter;
                    this.invalidate();
                    break;
                }
                float angle = (float)Math.atan2(y, x);
                float unit = angle / ((float)Math.PI * 2);
                if (unit < 0.0f) {
                    unit += 1.0f;
                }
                int newcolor = this.interpColor(this.mColors, unit);
                this.mCenterPaint.setColor(newcolor);
                if (this.mListener != null) {
                    this.mListener.onColorChanged(this, newcolor);
                }
                this.invalidate();
                break;
            }
            case 1: {
                if (!this.mTrackingCenter) break;
                if (inCenter && this.mListener != null) {
                    this.mListener.onColorPicked(this, this.mCenterPaint.getColor());
                }
                this.mTrackingCenter = false;
                this.invalidate();
            }
        }
        return true;
    }
}

