/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sdk;

import android.view.View;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.SdkConfUIBridge;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.view.video.VideoRenderer;
import com.zipow.videobox.view.video.ZPGLTextureView;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class SDKVideoRenderer
extends VideoRenderer {
    private static final String TAG = SDKVideoRenderer.class.getSimpleName();
    private int mWidth = 0;
    private int mHeight = 0;
    private ZPGLTextureView mGLTextureView;
    private int mGroupIndex = 0;
    private boolean mNeedStopAfterRun = false;

    public SDKVideoRenderer(ZPGLTextureView glView) {
        super((View)glView);
        this.mGLTextureView = glView;
    }

    public SDKVideoRenderer(ZPGLTextureView glView, int groupIndex) {
        super((View)glView, groupIndex);
        this.mGroupIndex = groupIndex;
        this.mGLTextureView = glView;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    public void stopRenderAfterRun() {
        if (!this.isRunning() || this.mNeedStopAfterRun) {
            return;
        }
        this.stopRenderer();
        this.requestRender();
        this.mNeedStopAfterRun = true;
        SdkConfUIBridge.incrementGLRunTaskCount();
    }

    private void resetRenderAfterRun() {
        if (this.mNeedStopAfterRun) {
            SdkConfUIBridge.decrementGLRunTaskCount();
            this.mNeedStopAfterRun = false;
        }
    }

    @Override
    public void beforeGLContextDestroyed() {
        if (this.isSDKConfAPPCreated() && !ConfUI.getInstance().isSDKCleanUpconfing()) {
            if (this.mNeedStopAfterRun) {
                super.beforeGLContextDestroyed();
            }
            this.resetRenderAfterRun();
        } else {
            this.onGLSurfaceDestoryed();
        }
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        if (!this.isSDKConfAPPCreated() || ConfUI.getInstance().isSDKCleanUpconfing()) {
            this.onDrawFrame(gl, this);
        } else {
            super.onDrawFrame(gl);
            this.resetRenderAfterRun();
        }
    }

    @Override
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        if (!this.isSDKConfAPPCreated() || ConfUI.getInstance().isSDKCleanUpconfing()) {
            this.onGLSurfaceChanged(width, height);
        } else {
            super.onSurfaceChanged(gl, width, height);
            this.resetRenderAfterRun();
        }
    }

    @Override
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.mGLTextureView.setRenderMode(0);
        if (!this.isSDKConfAPPCreated() || ConfUI.getInstance().isSDKCleanUpconfing()) {
            this.onGLSurfaceCreated();
        } else {
            super.onSurfaceCreated(gl, config);
            this.resetRenderAfterRun();
        }
    }

    @Override
    protected void onGLSurfaceCreated() {
    }

    @Override
    protected void onGLSurfaceChanged(int width, int height) {
    }

    @Override
    protected void onGLSurfaceDestoryed() {
    }

    @Override
    public void onDrawFrame(GL10 gl, VideoRenderer renderer) {
    }

    private boolean isSDKConfAPPCreated() {
        Mainboard mainboard = Mainboard.getMainboard();
        return mainboard != null && mainboard.isSDKConfAppCreated();
    }
}

