/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sdk;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.net.Uri;
import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.zipow.annotate.AnnoToolType;
import com.zipow.annotate.AnnotateView;
import com.zipow.annotate.ZoomShareData;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.ZoomShareUI;
import com.zipow.videobox.sdk.ISDKAnnotateToolDelegate;
import com.zipow.videobox.sdk.ISDKShareDataListener;
import com.zipow.videobox.sdk.SDKAnnotationMgr;
import com.zipow.videobox.sdk.SDKShareUnit;
import com.zipow.videobox.share.IDrawingViewListener;
import com.zipow.videobox.share.IShareServer;
import com.zipow.videobox.share.IShareView;
import com.zipow.videobox.share.ShareBaseView;
import com.zipow.videobox.share.ShareException;
import com.zipow.videobox.share.ShareImageView;
import com.zipow.videobox.share.SharePDFView;
import com.zipow.videobox.share.ShareServerImpl;
import com.zipow.videobox.share.ShareWebView;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class SDKShareView
extends FrameLayout
implements IShareView,
IDrawingViewListener,
ISDKAnnotateToolDelegate,
ISDKShareDataListener {
    private Context mContext;
    private Handler mHandler;
    private IShareServer mShareServer;
    private FrameLayout mShareContainer;
    private View mView;
    private ShareBaseView mContentView;
    private AnnotateView mAnnotateView;
    private Bitmap mCachedBitmap;
    private Canvas mCachedCanvas;
    private int mCacheW = 0;
    private int mCacheH = 0;
    private boolean mbAnnoationEnable = false;
    private boolean mAutoCapture = false;
    private boolean mStopped = false;
    private boolean mbSharing = true;
    private boolean mbEditStatus = false;
    private boolean mbAnnotateStart = false;
    private boolean mbPresenter = false;
    private int mTop = 0;
    private int mLeft = 0;
    private float mLocalShareHeight = 0.0f;
    private float mLocalShareWidth = 0.0f;
    private float mOffsetX = 0.0f;
    private float mOffsetY = 0.0f;
    private int mShareSourceHeight = 0;
    private float mScale = 1.0f;
    private long mShareUserId;
    private static final String TAG = SDKShareView.class.getSimpleName();
    private ZoomShareUI.IZoomShareUIListener mZoomShareUIListener = new ZoomShareUI.SimpleZoomShareUIListener(){

        @Override
        public void OnShareSourceAnnotationSupportPropertyChanged(long nShareSourceID, boolean bSupportAnnotation) {
            boolean isStartingShare;
            ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
            if (shareMgr == null) {
                return;
            }
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            if (confStatus == null) {
                return;
            }
            int shareStatus = shareMgr.getShareStatus();
            boolean isSameUser = confStatus.isSameUser(nShareSourceID, SDKShareView.this.mShareUserId);
            boolean bl = isStartingShare = shareStatus == 2 || shareStatus == 1;
            if (!isSameUser || isStartingShare && SDKShareView.this.mbPresenter) {
                return;
            }
            SDKShareView.this.setAnnotationEnable(bSupportAnnotation);
        }

        @Override
        public void OnShareSourceSendStatusChanged(long nShareSourceUserID, boolean bPaused) {
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            if (confStatus == null) {
                return;
            }
            if (confStatus.isSameUser(nShareSourceUserID, SDKShareView.this.mShareUserId)) {
                SDKShareView.this.setSharePauseStatuChanged(bPaused);
            }
        }
    };
    private ConfUI.IConfUIListener mConfUIListener = new ConfUI.SimpleConfUIListener(){

        @Override
        public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
            switch (cmd) {
                case 51: {
                    SDKShareView.this.onShareActiveUser(userId);
                }
            }
            return true;
        }
    };

    public SDKShareView(Context context) {
        super(context);
        this.init(context);
    }

    public SDKShareView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.mHandler = new Handler();
        if (!this.isInEditMode()) {
            this.mShareServer = new ShareServerImpl(this.mHandler);
        }
        this.mView = LayoutInflater.from((Context)context).inflate(R.layout.zm_sharinglayout_sdk, null, false);
        this.mShareContainer = (FrameLayout)this.mView.findViewById(R.id.shareContainer);
        this.addView(this.mView);
        if (!this.isInEditMode()) {
            this.mAnnotateView = new AnnotateView(this.mContext);
            this.mAnnotateView.setBackgroundColor(Color.parseColor((String)"#00FFFFFF"));
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            this.mAnnotateView.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        ZoomShareUI.getInstance().addListener(this.mZoomShareUIListener);
        ConfUI.getInstance().addListener(this.mConfUIListener);
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.onRepaint();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mAnnotateView != null) {
            this.mAnnotateView.registerUpdateListener(this);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAnnotateView != null) {
            this.mAnnotateView.unRegisterUpdateListener(this);
        }
    }

    public void start(boolean isPresenter) {
        SDKAnnotationMgr.getInstance().setAnnotateToolDelegate(this);
        this.setPresenter(isPresenter);
        this.mShareServer.setCacheView(this);
        try {
            this.mShareServer.startShare(this.mAutoCapture);
        }
        catch (ShareException shareException) {
            // empty catch block
        }
    }

    private void setPresenter(boolean isPresenter) {
        this.mbPresenter = isPresenter;
        if (this.mAnnotateView != null) {
            this.mAnnotateView.setToolWidth(2, false);
            this.mAnnotateView.setHighlightToolWidth(12);
            this.mAnnotateView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_PEN);
            this.mAnnotateView.setIsPresenter(isPresenter);
        }
        this.mTop = 0;
        this.mLeft = 0;
        this.mScale = 1.0f;
    }

    public void stop() {
        this.mAutoCapture = false;
        this.mShareContainer.removeView((View)this.mAnnotateView);
        this.mShareServer.endShare();
        if (this.mbAnnotateStart) {
            if (this.mAnnotateView != null) {
                this.mAnnotateView.setToolWidth(2, false);
                this.mAnnotateView.setHighlightToolWidth(12);
                this.mAnnotateView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_PEN);
                this.mAnnotateView.setIsPresenter(false);
                this.mAnnotateView.stopAnnotation();
            }
            this.mbAnnotateStart = false;
        }
        this.release();
    }

    private void release() {
        if (this.mContentView != null) {
            this.mContentView.stop();
        }
        this.mContentView = null;
        this.mCacheW = 0;
        this.mCacheH = 0;
        this.setEidtModel(false);
        this.mShareContainer.removeAllViews();
    }

    public void setAnnotationEnable(boolean enable) {
        this.mbAnnoationEnable = enable;
        this.setShareViewVisible();
    }

    public void setSharePauseStatuChanged(boolean bPaused) {
        this.mbSharing = !bPaused;
        this.setShareViewVisible();
    }

    private void setShareViewVisible() {
        boolean canAnnotate = this.mbSharing && this.mbAnnoationEnable && !ConfMgr.getInstance().isViewOnlyMeeting();
        this.setVisibility(canAnnotate ? 0 : 8);
    }

    private void onShareActiveUser(long userId) {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        int status = shareMgr.getShareStatus();
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (status == 0) {
            SDKAnnotationMgr.clearInstance();
        }
        boolean isMySelf = confStatus.isMyself(userId);
        if (status == 2 && isMySelf) {
            this.showAnnotateOnMyShareStart();
        }
    }

    private void showAnnotateOnMyShareStart() {
        if (this.mShareContainer == null || this.mAnnotateView == null || !this.mbPresenter) {
            return;
        }
        SDKAnnotationMgr.getInstance().setAnnotateToolDelegate(this);
        this.mShareContainer.removeView((View)this.mAnnotateView);
        this.showAnnotateView();
        this.mAnnotateView.setVisibility(0);
        this.mAnnotateView.setIsPresenter(true);
        int max = Math.max(UIUtil.getDisplayWidth((Context)this.getContext()), UIUtil.getDisplayHeight((Context)this.getContext()));
        this.mAnnotateView.startAnnotation(false);
        this.mAnnotateView.initBackgroundCanvasSize(max, max);
        this.mbAnnotateStart = true;
    }

    @Override
    public void onRepaint() {
        this.mShareServer.onRepaint();
    }

    @Override
    public void onBitmapChanged(Canvas canvas) {
        this.mShareServer.onRepaint();
    }

    @Override
    public void onLongPressed(boolean bLongClicked) {
    }

    @Override
    public void onBeginEditing(int x, int y) {
    }

    @Override
    public void onEndEditing() {
    }

    @Override
    public void onAnnotateViewSizeChanged() {
    }

    public boolean setImageUri(Uri uri) {
        ShareImageView shareview = new ShareImageView(this.mContext);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        shareview.setLayoutParams((ViewGroup.LayoutParams)lp);
        boolean ret = shareview.setImageUri(uri);
        if (!ret) {
            return false;
        }
        this.mContentView = shareview;
        this.mShareContainer.addView((View)shareview);
        this.mAutoCapture = false;
        return true;
    }

    public boolean setImageBitmap(Bitmap bmp) {
        ShareImageView shareview = new ShareImageView(this.mContext);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        shareview.setLayoutParams((ViewGroup.LayoutParams)lp);
        boolean ret = shareview.setImageBitmap(bmp);
        if (!ret) {
            return false;
        }
        this.mContentView = shareview;
        this.mShareContainer.addView((View)shareview);
        this.mAutoCapture = false;
        return true;
    }

    public boolean setWhiteboardBackground() {
        ShareImageView shareview = new ShareImageView(this.mContext);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        shareview.setLayoutParams((ViewGroup.LayoutParams)lp);
        shareview.showWhiteboard();
        this.mContentView = shareview;
        this.mShareContainer.addView((View)shareview);
        this.mAutoCapture = false;
        return true;
    }

    public boolean setUrl(String url) {
        return this.setUrl(url, true);
    }

    public boolean setUrl(String url, boolean isBookmarkBtnVisible) {
        ShareWebView shareview = new ShareWebView(this.mContext);
        shareview.setBookmarkBtnVisibility(isBookmarkBtnVisible);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        shareview.setLayoutParams((ViewGroup.LayoutParams)lp);
        boolean success = shareview.setWebUrl(url);
        if (!success) {
            return false;
        }
        this.mContentView = shareview;
        this.mShareContainer.addView((View)shareview);
        this.mAutoCapture = true;
        return true;
    }

    public boolean setPdf(String filePath, String password) {
        if (this.mContext instanceof FragmentActivity) {
            SharePDFView shareview = new SharePDFView(this.mContext);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            shareview.setLayoutParams((ViewGroup.LayoutParams)lp);
            boolean success = shareview.setPdfFile(filePath, password);
            if (!success) {
                return false;
            }
            this.mContentView = shareview;
            this.mShareContainer.addView((View)shareview);
            this.mAutoCapture = false;
            return true;
        }
        return false;
    }

    private void setEidtModel(boolean bEidt) {
        this.mbEditStatus = bEidt;
        if (this.mAnnotateView != null) {
            this.mAnnotateView.setEditModel(bEidt);
        }
    }

    private void showAnnotateView() {
        if (!this.isAnnotateViewVisible()) {
            this.mShareContainer.addView((View)this.mAnnotateView);
        }
    }

    private boolean isAnnotateViewVisible() {
        int count = this.mShareContainer.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.mShareContainer.getChildAt(i);
            if (view != this.mAnnotateView) continue;
            return true;
        }
        return false;
    }

    private boolean isContentViewVisible() {
        if (this.mContentView == null) {
            return false;
        }
        int count = this.mShareContainer.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.mShareContainer.getChildAt(i);
            if (view != this.mContentView) continue;
            return true;
        }
        return false;
    }

    private void checkCachedSize() {
        if (this.mShareContainer == null || this.mContentView == null) {
            return;
        }
        int count = this.mShareContainer.getChildCount();
        if (count <= 0) {
            return;
        }
        this.mCacheW = this.mContentView.getShareContentWidth();
        this.mCacheH = this.mContentView.getShareContentHeight();
    }

    private void destroyCachedBitmap() {
        if (this.mCachedBitmap != null) {
            this.mCachedBitmap.recycle();
            this.mCachedBitmap = null;
        }
        this.mCachedCanvas = null;
    }

    private boolean checkCacheBitmap() {
        this.checkCachedSize();
        if (this.mCacheW <= 0 || this.mCacheH <= 0) {
            return false;
        }
        if (this.mCachedBitmap != null && (this.mCachedBitmap.getWidth() != this.mCacheW || this.mCachedBitmap.getHeight() != this.mCacheH)) {
            this.destroyCachedBitmap();
        }
        if (this.mCachedBitmap == null) {
            try {
                this.mCachedBitmap = Bitmap.createBitmap((int)this.mCacheW, (int)this.mCacheH, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError e) {
                return false;
            }
            if (this.mCachedBitmap == null) {
                return false;
            }
            this.mCachedCanvas = new Canvas(this.mCachedBitmap);
        }
        return true;
    }

    @Override
    public Bitmap getCacheDrawingView() {
        if (this.mStopped) {
            return null;
        }
        boolean success = this.checkCacheBitmap();
        if (!success) {
            return null;
        }
        if (this.isContentViewVisible()) {
            this.mContentView.drawShareContent(this.mCachedCanvas);
        }
        if (this.isAnnotateViewVisible()) {
            this.mAnnotateView.drawShareContent(this.mCachedCanvas);
        }
        return this.mCachedBitmap;
    }

    @Override
    public void startAnnotation() {
        if (!this.mbAnnotateStart && this.mAnnotateView != null) {
            this.showAnnotateView();
            int max = Math.max(UIUtil.getDisplayWidth((Context)this.getContext()), UIUtil.getDisplayHeight((Context)this.getContext()));
            this.mAnnotateView.startAnnotation(false);
            this.mAnnotateView.initBackgroundCanvasSize(max, max);
            this.mbAnnotateStart = true;
        }
        this.setEidtModel(true);
        if (this.mContentView != null) {
            this.mContentView.setDrawingModeForSDK(true);
        }
    }

    @Override
    public void stopAnnotation() {
        this.setEidtModel(false);
        if (this.mContentView != null) {
            this.mContentView.setDrawingModeForSDK(false);
        }
    }

    @Override
    public void setToolWidth(int width, boolean updateAllWidth) {
        if (this.mAnnotateView != null) {
            this.mAnnotateView.setToolWidth(width, updateAllWidth);
        }
    }

    @Override
    public void setCurAnnoTool(AnnoToolType type) {
        if (this.mAnnotateView != null) {
            this.mAnnotateView.setCurAnnoTool(type);
        }
        this.onRepaint();
    }

    @Override
    public void setToolColor(int color2) {
        if (this.mAnnotateView != null) {
            this.mAnnotateView.setToolColor(color2);
        }
    }

    @Override
    public void redo() {
        if (this.mAnnotateView != null) {
            this.mAnnotateView.redo();
        }
        this.onRepaint();
    }

    @Override
    public void undo() {
        if (this.mAnnotateView != null) {
            this.mAnnotateView.undo();
        }
        this.onRepaint();
    }

    @Override
    public void eraseAll() {
        if (this.mAnnotateView != null) {
            this.mAnnotateView.eraserAll();
        }
        this.onRepaint();
    }

    @Override
    public boolean isPresenter() {
        return this.mbPresenter;
    }

    @Override
    public void onShareUnitCreated(long userId) {
        if (this.mbPresenter) {
            return;
        }
        SDKAnnotationMgr.getInstance().setAnnotateToolDelegate(this);
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        this.mShareUserId = userId;
        this.setPresenter(false);
        this.mbAnnoationEnable = shareMgr.senderSupportAnnotation(userId);
        this.setShareViewVisible();
    }

    @Override
    public void onShareUnitDestoryed() {
        if (this.mbPresenter) {
            return;
        }
        this.stopAnnotation();
        this.mShareUserId = -1L;
        this.setVisibility(8);
    }

    @Override
    public void onShareUserReceivingStatus(long userId) {
        this.setSharePauseStatuChanged(false);
    }

    @Override
    public void onShareSourceDataSizeChanged(int width, int height) {
        if (this.mbPresenter) {
            return;
        }
        if (this.mShareSourceHeight != height) {
            this.mShareSourceHeight = height;
            this.refreshAnnotateWndSize();
        }
    }

    @Override
    public void onDestAreaChangedChanged(float x, float y, float width, float height) {
        if (this.mbPresenter) {
            return;
        }
        if (this.mOffsetX != x || this.mOffsetY != y || this.mLocalShareWidth != width || this.mLocalShareHeight != height) {
            this.mOffsetX = Math.abs(x);
            this.mOffsetY = Math.abs(y);
            this.mLocalShareHeight = height;
            this.mLocalShareWidth = width;
            this.refreshAnnotateWndSize();
        }
    }

    @Override
    public void onUpdateUnitShare(SDKShareUnit unit) {
        if (this.mbPresenter) {
            return;
        }
        ZoomShareData.getInstance().onUpdateSDKUnitShare(unit);
        if ((float)unit.getHeight() != this.mLocalShareHeight || (float)unit.getWidth() != this.mLocalShareWidth || unit.getLeft() != this.mLeft || unit.getTop() != this.mTop) {
            this.mLeft = unit.getLeft();
            this.mTop = unit.getTop();
            this.mLocalShareHeight = unit.getHeight();
            this.mLocalShareWidth = unit.getWidth();
            this.refreshAnnotateWndSize();
        }
    }

    private void refreshAnnotateWndSize() {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.getLayoutParams();
        params.height = (int)this.mLocalShareHeight;
        params.width = (int)this.mLocalShareWidth;
        params.setMargins(this.mLeft, this.mTop, 0, 0);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mScale = (float)this.mShareSourceHeight / this.mLocalShareHeight;
        if (this.mAnnotateView != null) {
            this.mAnnotateView.setScaleAndOffsetValue(this.mScale, this.mOffsetX, this.mOffsetY);
        }
    }
}

