/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sdk;

import android.content.Context;
import android.os.Handler;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.util.PreferenceUtil;
import us.zoom.androidlib.util.StringUtil;

public class SDKCustomizedMeetingUIHelper {
    private static final String TAG = SDKCustomizedMeetingUIHelper.class.getSimpleName();
    private static Handler g_handler = new Handler();

    public static boolean isSdkUsingCustomizedMeetingUI() {
        if (VideoBoxApplication.getInstance() == null) {
            return false;
        }
        return VideoBoxApplication.getInstance().isSDKMode() && PTApp.getInstance().isSdkEnableCustomizedUI() && PreferenceUtil.readBooleanValue("sdk_use_customized_meeting_ui", false);
    }

    public static boolean handleSdkStartOrJoin(Context context, String urlAction) {
        if (context == null || StringUtil.isEmptyOrNull((String)urlAction)) {
            return true;
        }
        VideoBoxApplication.getInstance().setConfUIPreloaded(true);
        Mainboard.getMainboard().notifyUrlAction(urlAction);
        SDKCustomizedMeetingUIHelper.runOnConfProcessReady(new Runnable(){

            @Override
            public void run() {
            }
        }, 2000L);
        return true;
    }

    public static void handleSdkReconnect() {
        SDKCustomizedMeetingUIHelper.runOnConfProcessReady(new Runnable(){

            @Override
            public void run() {
            }
        }, 2000L);
    }

    private static void runOnConfProcessReady(final Runnable runnable, final long timeout) {
        if (VideoBoxApplication.getInstance().isConfProcessReady()) {
            runnable.run();
        } else if (timeout > 0L) {
            g_handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SDKCustomizedMeetingUIHelper.runOnConfProcessReady(runnable, timeout - 20L);
                }
            }, 20L);
        } else {
            VideoBoxApplication.getInstance().setConfUIPreloaded(false);
        }
    }
}

