/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.sdk.SDKHost;

public class QueryRequestReceiver
extends BroadcastReceiver {
    private static final String ACTION_QUERY_MEETING_STATUS = "us.zoom.videomeetings.intent.action.QUERY_MEETING_STATUS";
    private Handler mHandler = new Handler();

    public void onReceive(final Context context, Intent intent) {
        String action = intent.getAction();
        if (ACTION_QUERY_MEETING_STATUS.equalsIgnoreCase(action)) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    QueryRequestReceiver.this.broadcastMeetingStatus(context);
                }
            });
        }
    }

    private void broadcastMeetingStatus(Context context) {
        Mainboard mainboard = Mainboard.getMainboard();
        if (!mainboard.isInitialized()) {
            SDKHost.broadcastMeetingStatus(context, 0);
            return;
        }
        int callStatus = PTApp.getInstance().getCallStatus();
        switch (callStatus) {
            case 2: {
                SDKHost.broadcastMeetingStatus(context, 2);
                break;
            }
            case 1: {
                SDKHost.broadcastMeetingStatus(context, 1);
                break;
            }
            default: {
                SDKHost.broadcastMeetingStatus(context, 0);
            }
        }
    }
}

