/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sdk;

import com.zipow.videobox.sdk.PromptProxyServerTask;
import java.util.ArrayList;

public class PromptProxyServerTaskManager {
    private static PromptProxyServerTaskManager instance = null;
    private ArrayList<PromptProxyServerTask> mTaskQueue = new ArrayList();
    private boolean mRunImmediately = true;

    public static synchronized PromptProxyServerTaskManager getInstance() {
        if (instance == null) {
            instance = new PromptProxyServerTaskManager();
        }
        return instance;
    }

    private PromptProxyServerTaskManager() {
    }

    public void run(PromptProxyServerTask task) {
        if (!this.mRunImmediately) {
            this.updateTask(task);
        } else {
            task.run();
        }
    }

    private void runQueuedTasks() {
        while (!this.mTaskQueue.isEmpty()) {
            PromptProxyServerTask task = this.mTaskQueue.remove(0);
            task.run();
        }
    }

    public void setRunImmediatelyEnabled(boolean enabled) {
        this.mRunImmediately = enabled;
        if (this.mRunImmediately) {
            this.runQueuedTasks();
        }
    }

    private void updateTask(PromptProxyServerTask task) {
        if (task == null) {
            return;
        }
        for (PromptProxyServerTask tk : this.mTaskQueue) {
            if (tk == null || tk.getName() == null || !tk.getName().equals(task.getName())) continue;
            this.mTaskQueue.remove(tk);
            break;
        }
        this.mTaskQueue.add(task);
    }
}

