/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import android.text.TextUtils;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomBuddyGroup;
import com.zipow.videobox.ptapp.mm.ZoomBuddySearchData;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomPublicRoomSearchData;
import com.zipow.videobox.ptapp.mm.ZoomSubscribeRequest;
import com.zipow.videobox.util.EmojiHelper;
import com.zipow.videobox.util.ImageUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;

public class ZoomMessenger {
    private long mNativeHandle = 0L;
    private static final String TAG = ZoomMessenger.class.getSimpleName();

    public ZoomMessenger(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public void setMsgUI(ZoomMessengerUI ui) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        if (ui == null) {
            return;
        }
        this.setMsgUIImpl(this.mNativeHandle, ui.getNativeHandle());
    }

    public boolean isConnectionGood() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isConnectionGoodImpl(this.mNativeHandle);
    }

    public String getSessionDataFolder(String sessionID) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getSessionDataFolderImpl(this.mNativeHandle, sessionID);
    }

    public ZoomBuddy getMyself() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long hdlMyself = this.getMyselfImpl(this.mNativeHandle);
        if (hdlMyself == 0L) {
            return null;
        }
        return new ZoomBuddy(hdlMyself);
    }

    public int getBuddyCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getBuddyCountImpl(this.mNativeHandle);
    }

    public ZoomBuddy getBuddyAt(int idx) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (idx < 0) {
            return null;
        }
        long hdlBuddy = this.getBuddyAtImpl(this.mNativeHandle, idx);
        if (hdlBuddy == 0L) {
            return null;
        }
        return new ZoomBuddy(hdlBuddy);
    }

    public ZoomBuddy getBuddyWithJID(String jid) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return null;
        }
        long hdlBuddy = this.getBuddyWithJIDImpl(this.mNativeHandle, jid);
        if (hdlBuddy == 0L) {
            return null;
        }
        return new ZoomBuddy(hdlBuddy);
    }

    public ZoomBuddy getBuddyWithPhoneNumber(String phoneNumber) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (StringUtil.isEmptyOrNull((String)phoneNumber)) {
            return null;
        }
        long hdlBuddy = this.getBuddyWithPhoneNumberImpl(this.mNativeHandle, phoneNumber);
        if (hdlBuddy == 0L) {
            return null;
        }
        return new ZoomBuddy(hdlBuddy);
    }

    public int getGroupCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getGroupCountImpl(this.mNativeHandle);
    }

    public ZoomGroup getGroupAt(int idx) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (idx < 0) {
            return null;
        }
        long hdlGroup = this.getGroupAtImpl(this.mNativeHandle, idx);
        if (hdlGroup == 0L) {
            return null;
        }
        return new ZoomGroup(hdlGroup);
    }

    public ZoomGroup getGroupById(String groupId) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (StringUtil.isEmptyOrNull((String)groupId)) {
            return null;
        }
        long hdlGroup = this.getGroupByIdImpl(this.mNativeHandle, groupId);
        if (hdlGroup == 0L) {
            return null;
        }
        return new ZoomGroup(hdlGroup);
    }

    public PTAppProtos.MakeGroupResult makeGroup(List<String> buddies, String groupName, long mucType) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (mucType == 14L) {
            if (buddies == null) {
                buddies = new ArrayList<String>();
            }
        } else {
            if (buddies == null || buddies.size() == 0) {
                return null;
            }
            if (mucType == 80L && StringUtil.isEmptyOrNull((String)groupName)) {
                groupName = ZoomGroup.createDefaultMUCName(buddies);
            }
        }
        if (groupName == null) {
            groupName = "";
        }
        String[] arrBuddies = new String[buddies.size()];
        byte[] data = this.makeGroupImpl(this.mNativeHandle, arrBuddies = buddies.toArray(arrBuddies), groupName, mucType, ZoomMessengerUI.getInstance().getNativeHandle());
        if (data == null) {
            return null;
        }
        PTAppProtos.MakeGroupResult makeGroupResult = null;
        try {
            makeGroupResult = PTAppProtos.MakeGroupResult.parseFrom(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return makeGroupResult;
    }

    public boolean modifyGroupName(String groupId, String groupName) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)groupId) || StringUtil.isEmptyOrNull((String)groupName)) {
            return false;
        }
        return this.modifyGroupNameImpl(this.mNativeHandle, groupId, groupName);
    }

    public boolean deleteGroup(String groupId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)groupId)) {
            return false;
        }
        return this.deleteGroupImpl(this.mNativeHandle, groupId);
    }

    public boolean assignGroupAdminsV2(String groupId, List<String> buddies) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)groupId) || buddies == null || buddies.size() <= 0) {
            return false;
        }
        return this.assignGroupAdminsV2Impl(this.mNativeHandle, groupId, buddies);
    }

    public boolean addBuddyToGroup(String groupId, List<String> buddies) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)groupId) || buddies == null) {
            return false;
        }
        return this.addBuddyToGroupImpl(this.mNativeHandle, groupId, buddies);
    }

    public boolean removeBuddyFromGroup(String groupId, String buddyJid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)groupId) || StringUtil.isEmptyOrNull((String)buddyJid)) {
            return false;
        }
        return this.removeBuddyFromGroupImpl(this.mNativeHandle, groupId, buddyJid);
    }

    public int editGroupChat(String groupId, String groupName, List<String> buddies, int mucFlag) {
        if (this.mNativeHandle == 0L) {
            return 1;
        }
        if (StringUtil.isEmptyOrNull((String)groupId) || StringUtil.isEmptyOrNull((String)groupName)) {
            return 1;
        }
        return this.editGroupChatImpl(this.mNativeHandle, groupId, groupName, buddies, mucFlag);
    }

    public ZoomChatSession getSessionAt(int index) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        long handle = this.getSessionAtImpl(this.mNativeHandle, index);
        if (handle == 0L) {
            return null;
        }
        return new ZoomChatSession(handle);
    }

    public ZoomChatSession getSessionById(String sessionId) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            return null;
        }
        long handle = this.getSessionByIdImpl(this.mNativeHandle, sessionId);
        if (handle == 0L) {
            return null;
        }
        return new ZoomChatSession(handle);
    }

    public int getChatSessionCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getChatSessionCountImpl(this.mNativeHandle);
    }

    public int getTotalUnreadMessageCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getTotalUnreadMessageCountImpl(this.mNativeHandle);
    }

    public int getTotalMarkedUnreadMsgCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getTotalMarkedUnreadMsgCountImpl(this.mNativeHandle);
    }

    public int sendE2EFTEInvite(String receiverJid, String hintForNewClient, String hintForOldClient) {
        if (TextUtils.isEmpty((CharSequence)receiverJid)) {
            return 3;
        }
        return this.sendMessage(-1, null, receiverJid, hintForOldClient, null, null, null, 0, false, null, hintForNewClient, true, false);
    }

    private int sendMessage(int messageType, String groupId, String receiverJid, String body, List<String> atList, PTAppProtos.EmojiList emojiList, String file, int lenInSeconds, boolean isE2E, String[] msgId, String e2eFakeMsg, boolean isE2EInvitation, boolean hasAtAll) {
        if (this.mNativeHandle == 0L) {
            return 3;
        }
        if (StringUtil.isEmptyOrNull((String)groupId) && StringUtil.isEmptyOrNull((String)receiverJid)) {
            return 3;
        }
        if (groupId == null) {
            groupId = "";
        }
        if (receiverJid == null) {
            receiverJid = "";
        }
        PTAppProtos.MessageInput.Builder inputBuilder = PTAppProtos.MessageInput.newBuilder();
        if (!TextUtils.isEmpty((CharSequence)body)) {
            inputBuilder.setBody(body);
        }
        if (emojiList != null) {
            inputBuilder.setEmojiList(emojiList);
        }
        inputBuilder.setLenInSeconds(lenInSeconds);
        if (!TextUtils.isEmpty((CharSequence)file)) {
            inputBuilder.setLocalFilePath(file);
        }
        inputBuilder.setMsgType(messageType);
        inputBuilder.setSessionID(TextUtils.isEmpty((CharSequence)groupId) ? receiverJid : groupId);
        inputBuilder.setIsE2EMessage(isE2E);
        inputBuilder.setIsAtAllGroupMembers(hasAtAll);
        if (!TextUtils.isEmpty((CharSequence)e2eFakeMsg)) {
            inputBuilder.setE2EMessageFakeBody(e2eFakeMsg);
        }
        inputBuilder.setIsE2EInvitation(isE2EInvitation);
        if (atList != null) {
            inputBuilder.addAllVecMessageAtList(atList);
        }
        byte[] previewData = null;
        if (!StringUtil.isEmptyOrNull((String)file) && isE2E && (messageType == 1 || messageType == 5 || messageType == 1)) {
            previewData = ImageUtil.getPreviewImgData(file, 15000);
        }
        if (msgId == null || msgId.length < 1) {
            msgId = new String[1];
        }
        return this.sendMessageImpl(this.mNativeHandle, inputBuilder.build().toByteArray(), msgId, previewData);
    }

    public String sendText(String groupId, String receiverJid, String body) {
        return this.sendText(groupId, receiverJid, body, false, null, null, false);
    }

    public String sendText(String groupId, String receiverJid, String body, boolean isE2E, List<String> atList, String e2eFakeMsg, boolean hasAtAll) {
        body = EmojiHelper.getInstance().getRealMsg(body);
        return this.sendText(groupId, receiverJid, body, isE2E, atList, EmojiHelper.getInstance().getEmojiList(body), e2eFakeMsg, hasAtAll);
    }

    private String sendText(String groupId, String receiverJid, String body, boolean isE2E, List<String> atList, PTAppProtos.EmojiList emojiList, String e2eFakeMsg, boolean hasAtAll) {
        if (StringUtil.isEmptyOrNull((String)body)) {
            return null;
        }
        String[] msgId = new String[1];
        int code = this.sendMessage(0, groupId, receiverJid, body, atList, emojiList, null, 0, isE2E, msgId, e2eFakeMsg, false, hasAtAll);
        if (code == 0 && !TextUtils.isEmpty((CharSequence)msgId[0])) {
            return msgId[0];
        }
        return "";
    }

    public String sendAudio(String groupId, String receiverJid, String file, int lenInSeconds, boolean isE2E, String e2eFakeMsg) {
        if (StringUtil.isEmptyOrNull((String)file)) {
            return null;
        }
        File oFile = new File(file);
        if (!oFile.exists() || !oFile.isFile()) {
            return null;
        }
        String[] msgId = new String[1];
        int code = this.sendMessage(2, groupId, receiverJid, null, null, null, file, lenInSeconds, isE2E, msgId, e2eFakeMsg, false, false);
        if (code == 0 && !TextUtils.isEmpty((CharSequence)msgId[0])) {
            return msgId[0];
        }
        return "";
    }

    public String sendVideo(String groupId, String receiverJid, String file, int lenInSeconds) {
        if (StringUtil.isEmptyOrNull((String)file)) {
            return null;
        }
        File oFile = new File(file);
        if (!oFile.exists() || !oFile.isFile()) {
            return null;
        }
        String[] msgId = new String[1];
        int code = this.sendMessage(3, groupId, receiverJid, null, null, null, file, lenInSeconds, false, msgId, null, false, false);
        if (code == 0 && !TextUtils.isEmpty((CharSequence)msgId[0])) {
            return msgId[0];
        }
        return "";
    }

    public String sendGif(String groupId, String receiverJid, String file, boolean isE2E, String e2eFakeMsg) {
        return this.sendPicture(groupId, receiverJid, file, 6, isE2E, e2eFakeMsg);
    }

    public String sendPng(String groupId, String receiverJid, String file, boolean isE2E, String e2eFakeMsg) {
        return this.sendPicture(groupId, receiverJid, file, 5, isE2E, e2eFakeMsg);
    }

    public String sendPicture(String groupId, String receiverJid, String file, boolean isE2E, String e2eFakeMsg) {
        return this.sendPicture(groupId, receiverJid, file, 1, isE2E, e2eFakeMsg);
    }

    private String sendPicture(String groupId, String receiverJid, String file, int msgType, boolean isE2E, String e2eFakeMsg) {
        if (StringUtil.isEmptyOrNull((String)file)) {
            return null;
        }
        File oFile = new File(file);
        if (!oFile.exists() || !oFile.isFile()) {
            return null;
        }
        String[] msgId = new String[1];
        int code = this.sendMessage(msgType, groupId, receiverJid, null, null, null, file, 0, isE2E, msgId, e2eFakeMsg, false, false);
        if (code == 0 && !TextUtils.isEmpty((CharSequence)msgId[0])) {
            return msgId[0];
        }
        return "";
    }

    public int sendFile(String groupId, String receiverJid, String file, String[] msgId, String fakeE2EMsg, boolean isE2E) {
        if (StringUtil.isEmptyOrNull((String)file)) {
            return 3;
        }
        File oFile = new File(file);
        if (!oFile.exists() || !oFile.isFile()) {
            return 20;
        }
        if (msgId == null || msgId.length < 1) {
            msgId = new String[1];
        }
        int code = this.sendMessage(10, groupId, receiverJid, null, null, null, file, 0, isE2E, msgId, fakeE2EMsg, false, false);
        return code;
    }

    public String insertSystemMessage(String groupId, String buddyId, String body, long time, boolean isMsgRead, int msgType) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (StringUtil.isEmptyOrNull((String)groupId) && StringUtil.isEmptyOrNull((String)buddyId) || StringUtil.isEmptyOrNull((String)body)) {
            return null;
        }
        return this.insertSystemMessage(groupId, buddyId, body, time, isMsgRead, msgType, null, CmmTime.getMMNow(), 0L);
    }

    public String insertSystemMessage(String groupId, String buddyId, String body, long time, boolean isMsgRead, int msgType, String id2) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (StringUtil.isEmptyOrNull((String)groupId) && StringUtil.isEmptyOrNull((String)buddyId) || StringUtil.isEmptyOrNull((String)body)) {
            return null;
        }
        return this.insertSystemMessage(groupId, buddyId, body, time, isMsgRead, msgType, id2, CmmTime.getMMNow(), 0L);
    }

    public String insertSystemMessage(String groupId, String buddyId, String body, long time, int msgType, String msgId, long tmServerside, long prevMsgtime) {
        return this.insertSystemMessage(groupId, buddyId, body, time, true, msgType, msgId, tmServerside, prevMsgtime);
    }

    public String insertSystemMessage(String groupId, String buddyId, String body, long time, boolean isMsgRead, int msgType, String msgId, long tmServerside, long prevMsgtime) {
        boolean res;
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (StringUtil.isEmptyOrNull((String)groupId) && StringUtil.isEmptyOrNull((String)buddyId) || StringUtil.isEmptyOrNull((String)body)) {
            return null;
        }
        String[] contain = new String[1];
        if (msgId != null) {
            contain[0] = msgId;
        }
        if (res = this.insertSystemMessageImpl(this.mNativeHandle, groupId, buddyId, body, time, msgType, isMsgRead, contain, tmServerside, prevMsgtime)) {
            return contain[0];
        }
        return null;
    }

    public int startMeeting(String groupId, String buddyId, long meetingNum, int confType) {
        if (this.mNativeHandle == 0L) {
            return 1;
        }
        if (StringUtil.isEmptyOrNull((String)groupId) && StringUtil.isEmptyOrNull((String)buddyId)) {
            return 6;
        }
        if (groupId == null) {
            groupId = "";
        }
        if (buddyId == null) {
            buddyId = "";
        }
        return this.startMeetingImpl(this.mNativeHandle, groupId, buddyId, meetingNum, confType);
    }

    public int inviteToMeeting(String sessionId, String meetingId, long meetingNum) {
        if (this.mNativeHandle == 0L) {
            return 1;
        }
        if (StringUtil.isEmptyOrNull((String)sessionId) || StringUtil.isEmptyOrNull((String)meetingId) || meetingNum <= 0L) {
            return 6;
        }
        return this.inviteToMeetingImpl(this.mNativeHandle, sessionId, meetingId, meetingNum);
    }

    public boolean deleteSession(String sessionId, boolean wipe_all_if_group_session) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            return false;
        }
        return this.deleteSessionImpl(this.mNativeHandle, sessionId, wipe_all_if_group_session);
    }

    public boolean deleteSession(String sessionId) {
        return this.deleteSession(sessionId, true);
    }

    public boolean blackList_IsBlocked(String sessionId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            return false;
        }
        return this.blackListIsBlockedImpl(this.mNativeHandle, sessionId);
    }

    public boolean blackList_Set(String sessionId, boolean asBlocked) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            return false;
        }
        return this.blackListSetImpl(this.mNativeHandle, sessionId, asBlocked);
    }

    public boolean blockAll_Set(int type) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.blockAllSetImpl(this.mNativeHandle, type);
    }

    public int blockAll_Get() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.blockAllGetImpl(this.mNativeHandle);
    }

    public boolean setPresence(int presence) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.setPresenceImpl(this.mNativeHandle, presence);
    }

    public boolean addBuddyByJID(String jid, String myName, String group, String buddyName, String buddyEmail) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        if (myName == null) {
            myName = "";
        }
        if (group == null) {
            group = "";
        }
        if (buddyName == null) {
            buddyName = "";
        }
        if (buddyEmail == null) {
            buddyEmail = "";
        }
        return this.addBuddyByJIDImpl(this.mNativeHandle, jid, myName, group, buddyName, buddyEmail);
    }

    public boolean addBuddyByEmail(String email) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)email)) {
            return false;
        }
        return this.addBuddyByEmailImpl(this.mNativeHandle, email);
    }

    public boolean searchBuddy(String email) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)email)) {
            return false;
        }
        return this.searchBuddyImpl(this.mNativeHandle, email);
    }

    public boolean searchBuddyByKey(String key) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)key)) {
            return false;
        }
        return this.searchBuddyByKeyImpl(this.mNativeHandle, key);
    }

    public boolean removeBuddy(String jid, String reason) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        if (reason == null) {
            reason = "";
        }
        return this.removeBuddyImpl(this.mNativeHandle, jid, reason);
    }

    public boolean canRemoveBuddy(String jid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        return this.canRemoveBuddyImpl(this.mNativeHandle, jid);
    }

    public ZoomBuddySearchData getBuddySearchData() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getBuddySearchDataImpl(this.mNativeHandle);
        if (handle == 0L) {
            return null;
        }
        return new ZoomBuddySearchData(handle);
    }

    public String getAddBuddyUrl() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getAddBuddyUrlImpl(this.mNativeHandle);
    }

    public String getAddBuddyEmail() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getAddBuddyEmailImpl(this.mNativeHandle);
    }

    public String getAddBuddySubject() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getAddBuddySubjectImpl(this.mNativeHandle);
    }

    public boolean refreshBuddyVCard(String jid) {
        return this.refreshBuddyVCard(jid, false);
    }

    public boolean refreshBuddyVCard(String jid, boolean rightNow) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        return this.refreshBuddyVCardImpl(this.mNativeHandle, jid, rightNow);
    }

    public boolean forceSignon() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.forceSignonImpl(this.mNativeHandle);
    }

    public boolean trySignon() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.trySignonImpl(this.mNativeHandle);
    }

    public boolean isStreamConflict() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isStreamConflictImpl(this.mNativeHandle);
    }

    public int getCoWorkersCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getCoWorkersCountImpl(this.mNativeHandle);
    }

    public boolean canSubscribeBuddy(String jid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        return this.canSubscribeBuddyImpl(this.mNativeHandle, jid);
    }

    public boolean refreshGroupInfo(String groupId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)groupId)) {
            return false;
        }
        return this.refreshGroupInfoImpl(this.mNativeHandle, groupId);
    }

    public boolean refreshBuddyBigPicture(String jid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        return this.refreshBuddyBigPictureImpl(this.mNativeHandle, jid);
    }

    public boolean isMyFriend(String jid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        return this.isMyFriendImpl(this.mNativeHandle, jid);
    }

    public boolean ackBuddySubscribe(String jid, boolean accept) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        return this.ackBuddySubscribeImpl(this.mNativeHandle, jid, accept);
    }

    public boolean isMyContact(String jid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        return this.isMyContactImpl(this.mNativeHandle, jid);
    }

    public boolean isMyContactOrPending(String jid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        return this.isMyContactOrPendingImpl(this.mNativeHandle, jid);
    }

    public boolean FT_Download(String sessionID, String msgID, String localPath) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)sessionID) || StringUtil.isEmptyOrNull((String)msgID)) {
            return false;
        }
        if (localPath == null) {
            localPath = "";
        }
        return this.FTDownloadImpl(this.mNativeHandle, sessionID, msgID, localPath);
    }

    public boolean FT_Resume(String sessionID, String msgID) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)sessionID) || StringUtil.isEmptyOrNull((String)msgID)) {
            return false;
        }
        return this.FTResumeImpl(this.mNativeHandle, sessionID, msgID);
    }

    public boolean FT_Cancel(String sessionID, String msgID) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)sessionID) || StringUtil.isEmptyOrNull((String)msgID)) {
            return false;
        }
        return this.FTCancelImpl(this.mNativeHandle, sessionID, msgID);
    }

    public String searchMessageContent(PTAppProtos.MessageContentSearchFilter filter) {
        if (this.mNativeHandle == 0L || filter == null) {
            return null;
        }
        byte[] filterByte = filter.toByteArray();
        return this.searchMessageContentImpl(this.mNativeHandle, filterByte);
    }

    public int getPendingRequestCount(int reqType) {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        if (reqType != 0 || reqType != 1) {
            return 0;
        }
        return this.getPendingRequestCountImpl(this.mNativeHandle, reqType);
    }

    public int getSubscribeRequestCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getSubscribeRequestCountImpl(this.mNativeHandle);
    }

    public ZoomSubscribeRequest getSubscribeRequestAt(int index) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        long nativeHandle = this.getSubscribeRequestAtImpl(this.mNativeHandle, index);
        if (nativeHandle == 0L) {
            return null;
        }
        return new ZoomSubscribeRequest(nativeHandle);
    }

    public boolean deleteSubscribeRequest(int requestIndex) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.deleteSubscribeRequestImpl(this.mNativeHandle, requestIndex);
    }

    public boolean setAllRequestAsReaded() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.setAllRequestAsReadedImpl(this.mNativeHandle);
    }

    public int getUnreadRequestCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getUnreadRequestCountImpl(this.mNativeHandle);
    }

    public long getLatestRequestTimeStamp() {
        if (this.mNativeHandle == 0L) {
            return 0L;
        }
        return this.getLatestRequestTimeStampImpl(this.mNativeHandle);
    }

    public boolean isAutoAcceptBuddy(String jid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isAutoAcceptBuddyImpl(this.mNativeHandle, jid);
    }

    public boolean updateAutoAnswerGroupBuddy(String jid, boolean isAdd) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.updateAutoAnswerGroupBuddyImpl(this.mNativeHandle, jid, isAdd);
    }

    public boolean isBuddyWithJIDInGroup(String jid, String groupId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isBuddyWithJIDInGroupImpl(this.mNativeHandle, jid, groupId);
    }

    public int e2eGetMyOption() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.e2eGetMyOptionImpl(this.mNativeHandle);
    }

    public int e2eGetMyState() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.e2eGetMyStateImpl(this.mNativeHandle);
    }

    public boolean e2eIsFTEWithBuddy(String jid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.e2eIsFTEWithBuddyImpl(this.mNativeHandle, jid);
    }

    public int e2eQuerySessionState(String sessionId) {
        if (this.mNativeHandle == 0L) {
            return 4;
        }
        return this.e2eQuerySessionStateImpl(this.mNativeHandle, sessionId);
    }

    public int e2eGetAutologoffMinutes() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.e2eGetAutologoffMinutesImpl(this.mNativeHandle);
    }

    public int e2eTryDecodeMessage(String sessionId, String msgId) {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.e2eTryDecodeMessageImpl(this.mNativeHandle, sessionId, msgId);
    }

    public int subBuddyTempPresence(List<String> buddies) {
        if (this.mNativeHandle == 0L) {
            return 3;
        }
        return this.subBuddyTempPresenceImpl(this.mNativeHandle, buddies);
    }

    public int getBuddiesPresence(List<String> buddies, boolean needSubscribe) {
        if (this.mNativeHandle == 0L) {
            return 3;
        }
        return this.getBuddiesPresenceImpl(this.mNativeHandle, buddies, needSubscribe);
    }

    public int getBuddiesPresenceForMUC(String groupId, boolean needSubcribe) {
        if (this.mNativeHandle == 0L) {
            return 3;
        }
        return this.getBuddiesPresenceForMUCImpl(this.mNativeHandle, groupId, needSubcribe);
    }

    public List<String> sortBuddies2(List<String> buddies, int sortRule, String key) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (buddies == null || buddies.size() == 0) {
            return null;
        }
        if (key == null) {
            key = "";
        }
        return this.sortBuddies2Impl(this.mNativeHandle, buddies, sortRule, key);
    }

    public List<String> localSearchGroupSessionsByName(String key) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.localSearchGroupSessionsByNameImpl(this.mNativeHandle, key);
    }

    public List<String> localStrictSearchBuddies(String key, String groupId) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.localStrictSearchBuddiesImpl(this.mNativeHandle, key, groupId);
    }

    public boolean isZoomRoomContact(String jid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isZoomRoomContactImpl(this.mNativeHandle, jid);
    }

    public boolean addSameOrgBuddyByJID(String jid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.addSameOrgBuddyByJIDImpl(this.mNativeHandle, jid);
    }

    public int syncAllSubScribeReqAsReaded() {
        if (this.mNativeHandle == 0L) {
            return 3;
        }
        return this.syncAllSubScribeReqAsReadedImpl(this.mNativeHandle);
    }

    public List<String> savedSessionGetAll() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.savedSessionGetAllImpl(this.mNativeHandle);
    }

    public boolean savedSessionClearAll() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.savedSessionClearAllImpl(this.mNativeHandle);
    }

    public boolean savedSessionIsSaved(String sessionId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.savedSessionIsSavedImpl(this.mNativeHandle, sessionId);
    }

    public boolean savedSessionSet(String sessionId, boolean isSaved) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.savedSessionSetImpl(this.mNativeHandle, sessionId, isSaved);
    }

    public String syncSessionHistory(String sessionID, long end, int maxSize) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.syncSessionHistoryImpl(this.mNativeHandle, sessionID, end, maxSize);
    }

    public ZoomPublicRoomSearchData getPublicRoomSearchData() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getPublicRoomSearchDataImpl(this.mNativeHandle);
        if (handle == 0L) {
            return null;
        }
        return new ZoomPublicRoomSearchData(handle);
    }

    public boolean isForceSignout() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isForceSignoutImpl(this.mNativeHandle);
    }

    public boolean isCompanyContact(String buddyId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isCompanyContactImpl(this.mNativeHandle, buddyId);
    }

    public ZoomBuddyGroup getBuddyGroupByType(int buddyGroupType) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getBuddyGroupByTypeImpl(this.mNativeHandle, buddyGroupType);
        if (handle == 0L) {
            return null;
        }
        return new ZoomBuddyGroup(handle);
    }

    public ZoomBuddyGroup getBuddyGroupByJid(String jid) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getBuddyGroupByJidImpl(this.mNativeHandle, jid);
        if (handle == 0L) {
            return null;
        }
        return new ZoomBuddyGroup(handle);
    }

    public int TPV2_GetContactsPresence(List<String> contacts) {
        if (this.mNativeHandle == 0L) {
            return 3;
        }
        return this.TPV2GetContactsPresenceImpl(this.mNativeHandle, contacts);
    }

    public int TPV2_SubscribePresence(List<String> buddies, int type) {
        if (this.mNativeHandle == 0L) {
            return 3;
        }
        return this.TPV2SubscribePresenceImpl(this.mNativeHandle, buddies, type);
    }

    public int TPV2_UnsubscribePresence(List<String> contacts) {
        if (this.mNativeHandle == 0L) {
            return 3;
        }
        return this.TPV2UnsubscribePresenceImpl(this.mNativeHandle, contacts);
    }

    public PTAppProtos.AllBuddyInfo getAllBuddies(boolean showOfflineBuddies, boolean isPhoneNumberRegistered, String[] phoneNumbers, String myNumber) {
        byte[] data;
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (phoneNumbers == null) {
            phoneNumbers = new String[]{};
        }
        if (myNumber == null) {
            myNumber = "";
        }
        if ((data = this.getAllBuddiesImpl(this.mNativeHandle, showOfflineBuddies, isPhoneNumberRegistered, phoneNumbers, myNumber)) == null) {
            return null;
        }
        try {
            return PTAppProtos.AllBuddyInfo.parseFrom(data);
        }
        catch (IOException e) {
            return null;
        }
    }

    public PTAppProtos.AllBuddyInfo getAllRooms() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] data = this.getAllRoomsImpl(this.mNativeHandle);
        try {
            return PTAppProtos.AllBuddyInfo.parseFrom(data);
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isAnyBuddyGroupLarge() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isAnyBuddyGroupLargeImpl(this.mNativeHandle);
    }

    public String microServiceSearchHistoryMessage(String sessionID, long middleTime, int maxSize, int searchMessageContextType) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (StringUtil.isEmptyOrNull((String)sessionID)) {
            return null;
        }
        if (middleTime == 0L) {
            return null;
        }
        if (maxSize <= 0) {
            maxSize = 50;
        }
        return this.microServiceSearchHistoryMessageImpl(this.mNativeHandle, sessionID, middleTime, maxSize, searchMessageContextType);
    }

    public int imChatGetOption() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.imChatGetOptionImpl(this.mNativeHandle);
    }

    public List<String> blockUserGetAll() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.blockUserGetAllImpl(this.mNativeHandle);
    }

    public boolean blockUserIsBlocked(String jid) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        return this.blockUserIsBlockedImpl(this.mNativeHandle, jid);
    }

    public boolean blockUserBlockUsers(List<String> users) {
        if (this.mNativeHandle == 0L || users == null) {
            return false;
        }
        return this.blockUserBlockUsersImpl(this.mNativeHandle, users);
    }

    public boolean blockUserUnBlockUsers(List<String> users) {
        if (this.mNativeHandle == 0L || users == null) {
            return false;
        }
        return this.blockUserUnBlockUsersImpl(this.mNativeHandle, users);
    }

    public boolean blockUserEditBlockedUsersList(List<String> users) {
        if (this.mNativeHandle == 0L || users == null) {
            return false;
        }
        return this.blockUserEditBlockedUsersListImpl(this.mNativeHandle, users);
    }

    public boolean assignGroupAdmins(String sessionID, List<String> buddies) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)sessionID) || CollectionsUtil.isListEmpty(buddies)) {
            return false;
        }
        return this.assignGroupAdminsImpl(this.mNativeHandle, sessionID, buddies);
    }

    public boolean destroyGroup(String groupID) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)groupID)) {
            return false;
        }
        return this.destroyGroupImpl(this.mNativeHandle, groupID);
    }

    public String setUserSignature(String text) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.setUserSignatureImpl(this.mNativeHandle, text);
    }

    public String fetchUserProfileByJid(String peer_jid) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)peer_jid)) {
            return null;
        }
        return this.fetchUserProfileByJidImpl(this.mNativeHandle, peer_jid);
    }

    public int getMyPresence() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getMyPresenceImpl(this.mNativeHandle);
    }

    public ZoomBuddy getBuddyWithSipPhone(String sipPhone) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)sipPhone)) {
            return null;
        }
        long handle = this.getBuddyWithSipPhoneImpl(this.mNativeHandle, sipPhone);
        if (handle == 0L) {
            return null;
        }
        return new ZoomBuddy(handle);
    }

    public String sendGetHttp(String url) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.sendGetHttpMessageImpl(this.mNativeHandle, url);
    }

    public String sendPostHttp(String url, Map<String, String> params) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        String[] keys = null;
        String[] values = null;
        if (params != null && params.size() > 0) {
            keys = params.keySet().toArray(new String[params.size()]);
            values = params.values().toArray(new String[params.size()]);
        }
        return this.sendPostHttpMessageImpl(this.mNativeHandle, url, keys, values);
    }

    public String downloadFileByUrl(String url, String filePath, boolean isZoomService) {
        return this.downloadFileByUrl(url, filePath, false, isZoomService);
    }

    public String downloadFileByUrl(String url, String filePath, boolean useCache, boolean isZoomService) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.downloadFileByUrlImpl(this.mNativeHandle, url, filePath, useCache, isZoomService);
    }

    public String downloadFileForEditCodeSnippet(String webFileId, String filePath, long size) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.downloadFileForEditCodeSnippetImpl(this.mNativeHandle, webFileId, filePath, size);
    }

    public String getGiphyInfoByStr(String giphyStr, String sessionID, int giphyNumber) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getGiphyInfoByStrImpl(this.mNativeHandle, giphyStr, sessionID, giphyNumber, "pg-13");
    }

    public String getHotGiphyInfo(String sessionID, int giphyNumber) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getHotGiphyInfoImpl(this.mNativeHandle, sessionID, giphyNumber, "pg-13");
    }

    public int getGiphyOption() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getGiphyOptionImpl(this.mNativeHandle);
    }

    public String downloadGIFFromGiphyByUrl(String giphyID, String giphyStr, String sessionID, String url) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.downloadGIFFromGiphyByUrlImpl(this.mNativeHandle, giphyID, giphyStr, sessionID, url);
    }

    public PTAppProtos.GiphyMsgInfo getGiphyInfo(String giphyID) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] data = this.getGiphyInfoImpl(this.mNativeHandle, giphyID);
        if (data == null || data.length == 0) {
            return null;
        }
        try {
            return PTAppProtos.GiphyMsgInfo.parseFrom(data);
        }
        catch (IOException e) {
            return null;
        }
    }

    public int sendMessageForGiphy(int messageType, String groupId, String receiverJid, String body, String giphyID, String[] msgId) {
        if (this.mNativeHandle == 0L) {
            return 3;
        }
        if (groupId == null) {
            groupId = "";
        }
        if (receiverJid == null) {
            receiverJid = "";
        }
        if (StringUtil.isEmptyOrNull((String)groupId) && StringUtil.isEmptyOrNull((String)receiverJid)) {
            return 3;
        }
        PTAppProtos.MessageInput.Builder inputBuilder = PTAppProtos.MessageInput.newBuilder();
        if (!TextUtils.isEmpty((CharSequence)body)) {
            inputBuilder.setBody(body);
        }
        inputBuilder.setMsgType(messageType);
        inputBuilder.setSessionID(TextUtils.isEmpty((CharSequence)groupId) ? receiverJid : groupId);
        inputBuilder.setGiphyID(giphyID);
        if (msgId == null || msgId.length < 1) {
            msgId = new String[1];
        }
        return this.sendMessageForGiphyImpl(this.mNativeHandle, msgId, inputBuilder.build().toByteArray());
    }

    public boolean checkGiphyFileIsExist(String giphyID) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.checkGiphyFileIsExistImpl(this.mNativeHandle, giphyID);
    }

    public boolean checkGroupNameIsExist(String groupName) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.checkGroupNameIsExistImpl(this.mNativeHandle, groupName);
    }

    public List<String> checkIfNeedUpdateHotGiphyInfo() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.checkIfNeedUpdateHotGiphyInfoImpl(this.mNativeHandle);
    }

    public List<String> sortSessions(List<String> sessions) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (sessions == null || sessions.isEmpty()) {
            return null;
        }
        return this.sortSessionsImpl(this.mNativeHandle, sessions);
    }

    public String emojiVersionGetJsonStr() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.emojiVersionGetJsonStrImpl(this.mNativeHandle);
    }

    public ZoomChatSession findSessionById(String sessionId) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            return null;
        }
        long handle = this.findSessionByIdImpl(this.mNativeHandle, sessionId);
        if (handle == 0L) {
            return null;
        }
        return new ZoomChatSession(handle);
    }

    public ZoomBuddyGroup getAddressbookContactBuddyGroup() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getAddressbookContactBuddyGroupImpl(this.mNativeHandle);
        if (handle == 0L) {
            return null;
        }
        return new ZoomBuddyGroup(handle);
    }

    public boolean searchSessionLastMessageCtx(List<String> sessions) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.searchSessionLastMessageCtxImpl(this.mNativeHandle, sessions);
    }

    public int editIMSettingGetOption() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.editIMSettingGetOptionImpl(this.mNativeHandle);
    }

    public PTAppProtos.LocalStorageTimeInterval getLocalStorageTimeInterval() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] data = this.getLocalStorageTimeIntervalImpl(this.mNativeHandle);
        if (data == null) {
            return null;
        }
        PTAppProtos.LocalStorageTimeInterval interval = null;
        try {
            interval = PTAppProtos.LocalStorageTimeInterval.parseFrom(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return interval;
    }

    public void notifyMissedCall(long meetingNO) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        this.notifyMissedCallImpl(this.mNativeHandle, meetingNO);
    }

    public List<String> getAllRobotBuddies(String sessionID) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getAllRobotBuddiesImpl(this.mNativeHandle, sessionID);
    }

    private native void setMsgUIImpl(long var1, long var3);

    private native boolean isConnectionGoodImpl(long var1);

    private native String getSessionDataFolderImpl(long var1, String var3);

    private native long getMyselfImpl(long var1);

    private native int getBuddyCountImpl(long var1);

    private native long getBuddyAtImpl(long var1, int var3);

    private native long getBuddyWithJIDImpl(long var1, String var3);

    private native long getBuddyWithPhoneNumberImpl(long var1, String var3);

    private native int getGroupCountImpl(long var1);

    private native long getGroupAtImpl(long var1, int var3);

    private native long getGroupByIdImpl(long var1, String var3);

    private native byte[] makeGroupImpl(long var1, String[] var3, String var4, long var5, long var7);

    private native boolean modifyGroupNameImpl(long var1, String var3, String var4);

    private native boolean deleteGroupImpl(long var1, String var3);

    private native boolean addBuddyToGroupImpl(long var1, String var3, List<String> var4);

    private native boolean removeBuddyFromGroupImpl(long var1, String var3, String var4);

    private native int editGroupChatImpl(long var1, String var3, String var4, List<String> var5, int var6);

    private native int getChatSessionCountImpl(long var1);

    private native long getSessionAtImpl(long var1, int var3);

    private native long getSessionByIdImpl(long var1, String var3);

    private native int getTotalUnreadMessageCountImpl(long var1);

    private native int getTotalMarkedUnreadMsgCountImpl(long var1);

    private native String sendTextImpl(long var1, String var3, String var4, String var5, List<String> var6, byte[] var7);

    private native String sendAudioImpl(long var1, String var3, String var4, String var5, int var6);

    private native String sendVideoImpl(long var1, String var3, String var4, String var5, int var6);

    private native String sendPictureImpl(long var1, String var3, String var4, String var5);

    private native int sendFileImpl(long var1, String var3, String var4, String var5, String[] var6);

    private native boolean insertSystemMessageImpl(long var1, String var3, String var4, String var5, long var6, int var8, boolean var9, String[] var10, long var11, long var13);

    private native int startMeetingImpl(long var1, String var3, String var4, long var5, int var7);

    private native int inviteToMeetingImpl(long var1, String var3, String var4, long var5);

    private native boolean deleteSessionImpl(long var1, String var3, boolean var4);

    private native boolean blackListIsBlockedImpl(long var1, String var3);

    private native boolean blackListSetImpl(long var1, String var3, boolean var4);

    private native boolean blockAllSetImpl(long var1, int var3);

    private native int blockAllGetImpl(long var1);

    private native boolean setPresenceImpl(long var1, int var3);

    private native boolean addBuddyByJIDImpl(long var1, String var3, String var4, String var5, String var6, String var7);

    private native boolean addBuddyByEmailImpl(long var1, String var3);

    private native boolean searchBuddyImpl(long var1, String var3);

    private native boolean searchBuddyByKeyImpl(long var1, String var3);

    private native boolean removeBuddyImpl(long var1, String var3, String var4);

    private native boolean canRemoveBuddyImpl(long var1, String var3);

    private native long getBuddySearchDataImpl(long var1);

    private native String getAddBuddyUrlImpl(long var1);

    private native String getAddBuddyEmailImpl(long var1);

    private native String getAddBuddySubjectImpl(long var1);

    private native boolean refreshBuddyVCardImpl(long var1, String var3, boolean var4);

    private native boolean forceSignonImpl(long var1);

    private native boolean trySignonImpl(long var1);

    private native boolean isStreamConflictImpl(long var1);

    private native int getCoWorkersCountImpl(long var1);

    private native boolean canSubscribeBuddyImpl(long var1, String var3);

    private native boolean refreshGroupInfoImpl(long var1, String var3);

    private native boolean refreshBuddyBigPictureImpl(long var1, String var3);

    private native boolean isMyFriendImpl(long var1, String var3);

    private native long getNewFriendDataImpl(long var1);

    private native boolean ackBuddySubscribeImpl(long var1, String var3, boolean var4);

    private native boolean isMyContactImpl(long var1, String var3);

    private native boolean isMyContactOrPendingImpl(long var1, String var3);

    private native boolean FTDownloadImpl(long var1, String var3, String var4, String var5);

    private native boolean FTResumeImpl(long var1, String var3, String var4);

    private native boolean FTCancelImpl(long var1, String var3, String var4);

    private native String searchMessageContentImpl(long var1, byte[] var3);

    private native int getPendingRequestCountImpl(long var1, int var3);

    private native int getSubscribeRequestCountImpl(long var1);

    private native long getSubscribeRequestAtImpl(long var1, int var3);

    private native boolean deleteSubscribeRequestImpl(long var1, int var3);

    private native boolean setAllRequestAsReadedImpl(long var1);

    private native int getUnreadRequestCountImpl(long var1);

    private native long getLatestRequestTimeStampImpl(long var1);

    private native boolean isAutoAcceptBuddyImpl(long var1, String var3);

    private native boolean updateAutoAnswerGroupBuddyImpl(long var1, String var3, boolean var4);

    private native boolean isBuddyWithJIDInGroupImpl(long var1, String var3, String var4);

    private native int e2eGetMyOptionImpl(long var1);

    private native int e2eGetMyStateImpl(long var1);

    private native int sendMessageImpl(long var1, byte[] var3, String[] var4, byte[] var5);

    private native boolean e2eIsFTEWithBuddyImpl(long var1, String var3);

    private native int e2eQuerySessionStateImpl(long var1, String var3);

    private native int e2eGetAutologoffMinutesImpl(long var1);

    private native int e2eTryDecodeMessageImpl(long var1, String var3, String var4);

    private native int subBuddyTempPresenceImpl(long var1, List<String> var3);

    private native int getBuddiesPresenceImpl(long var1, List<String> var3, boolean var4);

    private native int getBuddiesPresenceForMUCImpl(long var1, String var3, boolean var4);

    private native List<String> sortBuddies2Impl(long var1, List<String> var3, int var4, String var5);

    private native List<String> localSearchGroupSessionsByNameImpl(long var1, String var3);

    private native List<String> localStrictSearchBuddiesImpl(long var1, String var3, String var4);

    private native boolean isZoomRoomContactImpl(long var1, String var3);

    private native boolean addSameOrgBuddyByJIDImpl(long var1, String var3);

    private native int syncAllSubScribeReqAsReadedImpl(long var1);

    private native List<String> savedSessionGetAllImpl(long var1);

    private native boolean savedSessionClearAllImpl(long var1);

    private native boolean savedSessionIsSavedImpl(long var1, String var3);

    private native boolean savedSessionSetImpl(long var1, String var3, boolean var4);

    private native long getPublicRoomSearchDataImpl(long var1);

    private native boolean isCompanyContactImpl(long var1, String var3);

    private native long getBuddyGroupByTypeImpl(long var1, int var3);

    private native long getBuddyGroupByJidImpl(long var1, String var3);

    private native String syncSessionHistoryImpl(long var1, String var3, long var4, int var6);

    private native boolean isForceSignoutImpl(long var1);

    private native byte[] getAllBuddiesImpl(long var1, boolean var3, boolean var4, String[] var5, String var6);

    private native boolean isAnyBuddyGroupLargeImpl(long var1);

    private native byte[] getAllRoomsImpl(long var1);

    private native int imChatGetOptionImpl(long var1);

    private native String microServiceSearchHistoryMessageImpl(long var1, String var3, long var4, int var6, int var7);

    private native List<String> blockUserGetAllImpl(long var1);

    private native boolean blockUserIsBlockedImpl(long var1, String var3);

    private native boolean blockUserBlockUsersImpl(long var1, List<String> var3);

    private native boolean blockUserUnBlockUsersImpl(long var1, List<String> var3);

    private native boolean blockUserEditBlockedUsersListImpl(long var1, List<String> var3);

    private native boolean assignGroupAdminsImpl(long var1, String var3, List<String> var4);

    private native boolean destroyGroupImpl(long var1, String var3);

    private native String fetchUserProfileByJidImpl(long var1, String var3);

    private native String setUserSignatureImpl(long var1, String var3);

    private native int getMyPresenceImpl(long var1);

    private native String sendGetHttpMessageImpl(long var1, String var3);

    private native String sendPostHttpMessageImpl(long var1, String var3, String[] var4, String[] var5);

    private native String downloadFileByUrlImpl(long var1, String var3, String var4, boolean var5, boolean var6);

    private native String downloadFileForEditCodeSnippetImpl(long var1, String var3, String var4, long var5);

    private native long getBuddyWithSipPhoneImpl(long var1, String var3);

    private native int TPV2GetContactsPresenceImpl(long var1, List<String> var3);

    private native int TPV2SubscribePresenceImpl(long var1, List<String> var3, int var4);

    private native int TPV2UnsubscribePresenceImpl(long var1, List<String> var3);

    private native String getGiphyInfoByStrImpl(long var1, String var3, String var4, int var5, String var6);

    private native String getHotGiphyInfoImpl(long var1, String var3, int var4, String var5);

    private native String downloadGIFFromGiphyByUrlImpl(long var1, String var3, String var4, String var5, String var6);

    private native byte[] getGiphyInfoImpl(long var1, String var3);

    private native int sendMessageForGiphyImpl(long var1, String[] var3, byte[] var4);

    private native boolean checkGiphyFileIsExistImpl(long var1, String var3);

    private native boolean checkGroupNameIsExistImpl(long var1, String var3);

    private native List<String> checkIfNeedUpdateHotGiphyInfoImpl(long var1);

    private native List<String> sortSessionsImpl(long var1, List<String> var3);

    private native String emojiVersionGetJsonStrImpl(long var1);

    private native int getGiphyOptionImpl(long var1);

    private native long findSessionByIdImpl(long var1, String var3);

    private native long getAddressbookContactBuddyGroupImpl(long var1);

    private native int editIMSettingGetOptionImpl(long var1);

    private native boolean searchSessionLastMessageCtxImpl(long var1, List<String> var3);

    private native byte[] getLocalStorageTimeIntervalImpl(long var1);

    private native void notifyMissedCallImpl(long var1, long var3);

    private native List<String> getAllRobotBuddiesImpl(long var1, String var3);

    private native boolean assignGroupAdminsV2Impl(long var1, String var3, List<String> var4);
}

