/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import android.text.TextUtils;
import com.google.protobuf.InvalidProtocolBufferException;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.ZoomMessageTemplateUI;

public class ZoomMessageTemplate {
    private static final String TAG = ZoomMessageTemplate.class.getSimpleName();
    private long mNativeHandle;

    public ZoomMessageTemplate(long mNativeHandle) {
        this.mNativeHandle = mNativeHandle;
    }

    public PTAppProtos.RobotMsg robotDecode(String sessionID, String messageID) {
        if (this.mNativeHandle == 0L || TextUtils.isEmpty((CharSequence)sessionID) || TextUtils.isEmpty((CharSequence)messageID)) {
            return null;
        }
        byte[] robotDecode = this.robotDecodeImpl(this.mNativeHandle, sessionID, messageID);
        try {
            return robotDecode == null ? null : PTAppProtos.RobotMsg.parseFrom(robotDecode);
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
    }

    public boolean updateMessageBodyByJson(String sessionID, String messageID, String newJson) {
        if (this.mNativeHandle == 0L || TextUtils.isEmpty((CharSequence)sessionID) || TextUtils.isEmpty((CharSequence)messageID)) {
            return false;
        }
        return this.updateMessageBodyByJsonImpl(this.mNativeHandle, sessionID, messageID, newJson);
    }

    public void registerCommonAppUICallback(ZoomMessageTemplateUI zoomMessageTemplateUI) {
        if (this.mNativeHandle == 0L || zoomMessageTemplateUI == null) {
            return;
        }
        this.registerCommonAppUICallbackImpl(this.mNativeHandle, zoomMessageTemplateUI.getNativeHandle());
    }

    private native byte[] robotDecodeImpl(long var1, String var3, String var4);

    private native boolean updateMessageBodyByJsonImpl(long var1, String var3, String var4, String var5);

    private native void registerCommonAppUICallbackImpl(long var1, long var3);
}

