/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.util.EmojiHelper;
import com.zipow.videobox.util.ImageUtil;
import java.io.IOException;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;

public class ZoomChatSession {
    private static final String TAG = ZoomChatSession.class.getSimpleName();
    public static final int DEFAULT_QUERY_MESSAGE_COUNT = 30;
    private long mNativeHandle = 0L;

    public ZoomChatSession(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public String getSessionId() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getSessionIdImpl(this.mNativeHandle);
    }

    public boolean isGroup() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isGroupImpl(this.mNativeHandle);
    }

    public ZoomBuddy getSessionBuddy() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getSessionBuddyImpl(this.mNativeHandle);
        if (handle == 0L) {
            return null;
        }
        return new ZoomBuddy(handle);
    }

    public ZoomGroup getSessionGroup() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getSessionGroupImpl(this.mNativeHandle);
        if (handle == 0L) {
            return null;
        }
        return new ZoomGroup(handle);
    }

    public ZoomMessage getLastMessage() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getLastMessageImpl(this.mNativeHandle);
        if (handle == 0L) {
            return null;
        }
        return new ZoomMessage(handle);
    }

    public int getUnreadMessageCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getUnreadMessageCountImpl(this.mNativeHandle);
    }

    public int getMarkUnreadMessageCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getMarkUnreadMessageCountImpl(this.mNativeHandle);
    }

    public int getMarkUnreadMessageContext(int from, long serverTime) {
        if (serverTime <= 0L) {
            return -1;
        }
        List<String> messages = this.fetchLocaldbLinkedMessages(200);
        if (messages != null && !messages.isEmpty()) {
            for (int i = 0; i < messages.size(); ++i) {
                ZoomMessage item = this.getMessageById(messages.get(i));
                if (item == null || item.getServerSideTime() != serverTime) continue;
                return messages.size() - i - from;
            }
        }
        return -1;
    }

    public int getMessages(List<ZoomMessage> messages, int from, int count) {
        return this.getMessages(messages, from, count, null);
    }

    public int getMessages(List<ZoomMessage> messages, int from, int count, long[] dirtyTime) {
        int size;
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        if (from < 0 || messages == null || count <= 0) {
            return -1;
        }
        long[] handles = new long[count];
        if (dirtyTime == null || dirtyTime.length == 0) {
            dirtyTime = new long[1];
        }
        if ((size = this.getMessagesImpl(this.mNativeHandle, handles, from, count, dirtyTime)) < 0) {
            return size;
        }
        for (int i = 0; i < size; ++i) {
            messages.add(new ZoomMessage(handles[i]));
        }
        return size;
    }

    public ZoomMessage getMessageById(String msgId) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (StringUtil.isEmptyOrNull((String)msgId)) {
            return null;
        }
        long hdlMsg = this.getMessageByIdImpl(this.mNativeHandle, msgId);
        if (hdlMsg == 0L) {
            return null;
        }
        return new ZoomMessage(hdlMsg);
    }

    public ZoomMessage getMessageByIndex(int index) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (index < 0 || index >= this.getMessageCount()) {
            return null;
        }
        long hdlMsg = this.getMessageByIndexImpl(this.mNativeHandle, index);
        if (hdlMsg == 0L) {
            return null;
        }
        return new ZoomMessage(hdlMsg);
    }

    public int getMessageCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getMessageCountImpl(this.mNativeHandle);
    }

    public boolean downloadFileForMessage(String msgId) {
        return this.downloadFileForMessage(msgId, null);
    }

    public boolean downloadFileForMessage(String msgId, String path) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (msgId == null) {
            return false;
        }
        if (path == null) {
            path = "";
        }
        return this.downloadFileForMessageImpl(this.mNativeHandle, msgId, path);
    }

    public boolean resendPendingMessage(String msgId, String fakeE2EMsg) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)msgId)) {
            return false;
        }
        return this.resendPendingMessageImpl(this.mNativeHandle, msgId, fakeE2EMsg);
    }

    public boolean deleteLocalMessage(String msgId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)msgId)) {
            return false;
        }
        return this.deleteLocalMessageImpl(this.mNativeHandle, msgId);
    }

    private boolean deleteMessageInternal(String msgId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (msgId == null) {
            msgId = "";
        }
        return this.deleteMessageImpl(this.mNativeHandle, msgId);
    }

    public boolean deleteMessage(String msgId) {
        if (StringUtil.isEmptyOrNull((String)msgId)) {
            return false;
        }
        return this.deleteMessageInternal(msgId);
    }

    public boolean clearAllMessages() {
        return this.deleteMessageInternal("");
    }

    public void cleanUnreadMessageCount() {
        if (this.mNativeHandle == 0L) {
            return;
        }
        this.cleanUnreadMessageCountImpl(this.mNativeHandle);
    }

    public boolean hasUnreadMessageAtMe() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.hasUnreadMessageAtMeImpl(this.mNativeHandle);
    }

    public void checkAutoDownloadForMessage(String msgId) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)msgId)) {
            return;
        }
        this.checkAudioDownloadForMessageImpl(this.mNativeHandle, msgId);
    }

    public boolean hasUnreadedMessageAtAllMembers() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.hasUnreadedMessageAtAllMembersImpl(this.mNativeHandle);
    }

    public boolean isLastMessageUnreadedAtAllMembers() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isLastMessageUnreadedAtAllMembersImpl(this.mNativeHandle);
    }

    public long hasMoreMessagesAtServerSide() {
        if (this.mNativeHandle == 0L) {
            return 0L;
        }
        return this.hasMoreMessagesAtServerSideImpl(this.mNativeHandle);
    }

    public ZoomMessage getMessageByXMPPGuid(String xmppGuid) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)xmppGuid)) {
            return null;
        }
        long handle = this.getMessageByXMPPGuidImpl(this.mNativeHandle, xmppGuid);
        if (handle == 0L) {
            return null;
        }
        return new ZoomMessage(handle);
    }

    public boolean revokeMessageByXMPPGuid(String guid) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)guid)) {
            return false;
        }
        return this.revokeMessageByXMPPGuidImpl(this.mNativeHandle, guid, false);
    }

    public boolean storeMessageDraft(String draft) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.storeMessageDraftImpl(this.mNativeHandle, draft == null ? "" : draft);
    }

    public String getMessageDraft() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getMessageDraftImpl(this.mNativeHandle);
    }

    public String sendAddonCommand(String msg) {
        if (this.mNativeHandle == 0L || TextUtils.isEmpty((CharSequence)msg)) {
            return null;
        }
        return this.sendAddonCommandImpl(this.mNativeHandle, msg, "");
    }

    public String sendAddonCommand(String msg, String robotJid) {
        if (this.mNativeHandle == 0L || TextUtils.isEmpty((CharSequence)msg)) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)robotJid)) {
            return this.sendAddonCommand(msg);
        }
        return this.sendAddonCommandImpl(this.mNativeHandle, msg, robotJid);
    }

    public boolean resendPendingE2EImageMessage(String msgId, String fakeE2EMsg, String localPath) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)localPath) || !ImageUtil.isValidImageFile(localPath)) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)msgId)) {
            return false;
        }
        byte[] previewData = ImageUtil.getPreviewImgData(localPath, 60000);
        if (previewData == null) {
            return false;
        }
        return this.resendPendingE2EImageMessageImpl(this.mNativeHandle, msgId, fakeE2EMsg, previewData);
    }

    public boolean editMessageByXMPPGuid(String msg, String guid, String sessionID, List<String> atList, boolean hasAtAll) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)msg) || TextUtils.isEmpty((CharSequence)guid) || TextUtils.isEmpty((CharSequence)sessionID)) {
            return false;
        }
        String body = EmojiHelper.getInstance().getRealMsg(msg);
        PTAppProtos.EmojiList emojiList = EmojiHelper.getInstance().getEmojiList(body);
        PTAppProtos.MessageInput.Builder inputBuilder = PTAppProtos.MessageInput.newBuilder();
        if (!TextUtils.isEmpty((CharSequence)body)) {
            inputBuilder.setBody(body);
        }
        if (emojiList != null) {
            inputBuilder.setEmojiList(emojiList);
        }
        inputBuilder.setMsgType(0);
        inputBuilder.setSessionID(sessionID);
        inputBuilder.setIsAtAllGroupMembers(hasAtAll);
        if (atList != null) {
            inputBuilder.addAllVecMessageAtList(atList);
        }
        return this.editMessageByXMPPGuidImpl(this.mNativeHandle, guid, inputBuilder.build().toByteArray());
    }

    public boolean markMessageAsUnread(String guid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)guid)) {
            return false;
        }
        return this.markMessageAsUnreadImpl(this.mNativeHandle, guid);
    }

    public boolean unmarkMessageAsUnread(String guid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)guid)) {
            return false;
        }
        return this.unmarkMessageAsUnreadImpl(this.mNativeHandle, guid);
    }

    public boolean unmarkUnreadMessageBySvrTime(long serverTime) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.unmarkUnreadMessageBySvrTimeImpl(this.mNativeHandle, serverTime);
    }

    public boolean markMessageAsUnreadBySvrTime(long serverTime) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.markMessageAsUnreadBySvrTimeImpl(this.mNativeHandle, serverTime);
    }

    public boolean clearAllMarkedUnreadMessage() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.clearAllMarkedUnreadMessageImpl(this.mNativeHandle);
    }

    public boolean isMessageMarkUnread(String guid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isMessageMarkUnreadImpl(this.mNativeHandle, guid);
    }

    public long[] getMarkUnreadMessages() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getMarkUnreadMessagesImpl(this.mNativeHandle);
    }

    public String searchMarkUnreadMessageCtx(long serverTime, int type, int count) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.searchMarkUnreadMessageCtxImpl(this.mNativeHandle, serverTime, type, count);
    }

    public String searchLatestReadMsg() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.searchLatestReadMsgImpl(this.mNativeHandle);
    }

    public int getMessageInCacheIndex(String guid) {
        if (this.mNativeHandle == 0L) {
            return -1;
        }
        return this.getMessageInCacheIndexImpl(this.mNativeHandle, guid);
    }

    @Nullable
    public PTAppProtos.SyncHistoryMsgInfo getNewestPageRequest(int count) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] content = this.getNewestPageRequestImpl(this.mNativeHandle, count);
        if (content == null) {
            return null;
        }
        try {
            PTAppProtos.SyncHistoryMsgInfo info = PTAppProtos.SyncHistoryMsgInfo.parseFrom(content);
            return info;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    public PTAppProtos.SyncHistoryMsgInfo getPrevPageRequest(String msgStartId, int count) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)msgStartId)) {
            return null;
        }
        byte[] content = this.getPrevPageRequestImpl(this.mNativeHandle, msgStartId, count);
        try {
            PTAppProtos.SyncHistoryMsgInfo info = PTAppProtos.SyncHistoryMsgInfo.parseFrom(content);
            return info;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean containMoreMessages() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.containMoreMessagesImpl(this.mNativeHandle);
    }

    @Nullable
    public List<String> getLocalNewestPage(int count) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getLocalNewestPageImpl(this.mNativeHandle, count);
    }

    @Nullable
    public List<String> getLocalPrevPage(String msgId, int count) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getLocalPrevPageImpl(this.mNativeHandle, msgId, count);
    }

    public void clearSyncedFlag() {
        if (this.mNativeHandle == 0L) {
            return;
        }
        this.clearSyncedFlagImpl(this.mNativeHandle);
    }

    public void cancelSearchHistoryMessageRequest(String reqId) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)reqId)) {
            return;
        }
        this.cancelSearchHistoryMessageRequestImpl(this.mNativeHandle, reqId);
    }

    public boolean isAnyNewMessagesForreload() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isAnyNewMessagesForreloadImpl(this.mNativeHandle);
    }

    @Nullable
    public List<String> getUnreadAtMeMessages() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getUnreadAtMeMessagesImpl(this.mNativeHandle);
    }

    @Nullable
    public List<String> getUnreadAtAllMessages() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getUnreadAtAllMessagesImpl(this.mNativeHandle);
    }

    @Nullable
    public List<String> fetchLocaldbLinkedMessages(int count) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.fetchLocaldbLinkedMessagesImpl(this.mNativeHandle, count);
    }

    private native String getSessionIdImpl(long var1);

    private native boolean isGroupImpl(long var1);

    private native long getSessionBuddyImpl(long var1);

    private native long getSessionGroupImpl(long var1);

    private native long getLastMessageImpl(long var1);

    private native int getUnreadMessageCountImpl(long var1);

    private native int getMarkUnreadMessageCountImpl(long var1);

    private native int getMessagesImpl(long var1, long[] var3, int var4, int var5, long[] var6);

    private native long getMessageByIdImpl(long var1, String var3);

    private native boolean resendPendingMessageImpl(long var1, String var3, String var4);

    private native boolean downloadFileForMessageImpl(long var1, String var3, String var4);

    private native boolean deleteMessageImpl(long var1, String var3);

    private native boolean deleteLocalMessageImpl(long var1, String var3);

    private native void cleanUnreadMessageCountImpl(long var1);

    private native void checkAudioDownloadForMessageImpl(long var1, String var3);

    private native int getMessageCountImpl(long var1);

    private native long getMessageByIndexImpl(long var1, int var3);

    private native boolean hasUnreadMessageAtMeImpl(long var1);

    private native boolean hasUnreadedMessageAtAllMembersImpl(long var1);

    private native boolean isLastMessageUnreadedAtAllMembersImpl(long var1);

    private native long hasMoreMessagesAtServerSideImpl(long var1);

    private native long getMessageByXMPPGuidImpl(long var1, String var3);

    private native boolean revokeMessageByXMPPGuidImpl(long var1, String var3, boolean var4);

    private native boolean storeMessageDraftImpl(long var1, String var3);

    private native String getMessageDraftImpl(long var1);

    private native String sendAddonCommandImpl(long var1, String var3, String var4);

    private native boolean resendPendingE2EImageMessageImpl(long var1, String var3, String var4, byte[] var5);

    private native boolean editMessageByXMPPGuidImpl(long var1, String var3, byte[] var4);

    private native boolean markMessageAsUnreadImpl(long var1, String var3);

    private native boolean unmarkMessageAsUnreadImpl(long var1, String var3);

    private native boolean unmarkUnreadMessageBySvrTimeImpl(long var1, long var3);

    private native boolean markMessageAsUnreadBySvrTimeImpl(long var1, long var3);

    private native boolean clearAllMarkedUnreadMessageImpl(long var1);

    private native boolean isMessageMarkUnreadImpl(long var1, String var3);

    private native long[] getMarkUnreadMessagesImpl(long var1);

    private native String searchMarkUnreadMessageCtxImpl(long var1, long var3, int var5, int var6);

    private native String searchLatestReadMsgImpl(long var1);

    private native int getMessageInCacheIndexImpl(long var1, String var3);

    private native byte[] getNewestPageRequestImpl(long var1, int var3);

    private native byte[] getPrevPageRequestImpl(long var1, String var3, int var4);

    private native boolean containMoreMessagesImpl(long var1);

    private native List<String> getLocalNewestPageImpl(long var1, int var3);

    private native List<String> getLocalPrevPageImpl(long var1, String var3, int var4);

    private native void clearSyncedFlagImpl(long var1);

    private native void cancelSearchHistoryMessageRequestImpl(long var1, String var3);

    private native boolean isAnyNewMessagesForreloadImpl(long var1);

    private native List<String> getUnreadAtMeMessagesImpl(long var1);

    private native List<String> getUnreadAtAllMessagesImpl(long var1);

    private native List<String> fetchLocaldbLinkedMessagesImpl(long var1, int var3);
}

