/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import android.text.TextUtils;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.mm.MMChatsListItem;
import com.zipow.videobox.view.mm.MMZoomGroup;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.SortUtil;
import us.zoom.androidlib.util.StringUtil;

public class ZMSortUtil {
    public static List<MMChatsListItem> sortSessions(List<MMChatsListItem> sessions) {
        if (CollectionsUtil.isCollectionEmpty(sessions)) {
            return sessions;
        }
        ArrayList<MMChatsListItem> temp = new ArrayList<MMChatsListItem>(sessions);
        Collections.sort(temp, new SessionComparator(CompatUtils.getLocalDefault()));
        return temp;
    }

    public static List<MMZoomGroup> sortGroups(List<MMZoomGroup> groups) {
        if (CollectionsUtil.isCollectionEmpty(groups)) {
            return groups;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return groups;
        }
        HashMap<MMZoomGroup, Long> recentGroups = new HashMap<MMZoomGroup, Long>();
        for (MMZoomGroup group : groups) {
            ZoomMessage message;
            ZoomChatSession session;
            if (group == null || StringUtil.isEmptyOrNull((String)group.getGroupId()) || (session = messenger.findSessionById(group.getGroupId())) == null || (message = session.getLastMessage()) == null) continue;
            recentGroups.put(group, message.getStamp());
        }
        ArrayList<MMZoomGroup> temp = new ArrayList<MMZoomGroup>(groups);
        Collections.sort(temp, new GroupComparator(recentGroups, CompatUtils.getLocalDefault()));
        return temp;
    }

    public static List<String> sortBuddies(List<String> buddies) {
        return ZMSortUtil.sortBuddies(buddies, 0, null);
    }

    public static List<String> sortBuddies(List<String> buddies, int sortRule, String key) {
        if (CollectionsUtil.isCollectionEmpty(buddies)) {
            return buddies;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return buddies;
        }
        List<String> buddiesSortedByNative = messenger.sortBuddies2(buddies, sortRule, key);
        if (buddiesSortedByNative == null) {
            return buddies;
        }
        HashMap<String, Long> recentBuddies = new HashMap<String, Long>();
        for (int i = 0; i < buddiesSortedByNative.size(); ++i) {
            ZoomMessage message;
            ZoomChatSession session;
            String jid = buddiesSortedByNative.get(i);
            if (TextUtils.isEmpty((CharSequence)jid) || (session = messenger.findSessionById(jid)) == null || (message = session.getLastMessage()) == null) continue;
            buddiesSortedByNative.remove(i);
            recentBuddies.put(jid, message.getStamp());
            --i;
        }
        if (recentBuddies.size() == 0) {
            return buddiesSortedByNative;
        }
        ArrayList<String> temp = new ArrayList<String>(recentBuddies.keySet());
        Collections.sort(temp, new BuddyComparator(recentBuddies));
        temp.addAll(buddiesSortedByNative);
        return temp;
    }

    private static class SessionComparator
    implements Comparator<MMChatsListItem> {
        private Collator mCollator;

        SessionComparator(Locale locale) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
        }

        private String getItemSortKey(MMChatsListItem item) {
            return SortUtil.getSortKey((String)item.getTitle(), (Locale)CompatUtils.getLocalDefault());
        }

        @Override
        public int compare(MMChatsListItem lhs, MMChatsListItem rhs) {
            if (lhs == rhs) {
                return 0;
            }
            if (lhs.getTimeStamp() > rhs.getTimeStamp()) {
                return -1;
            }
            if (lhs.getTimeStamp() < rhs.getTimeStamp()) {
                return 1;
            }
            String str1 = this.getItemSortKey(lhs);
            String str2 = this.getItemSortKey(rhs);
            return this.mCollator.compare(str1, str2);
        }
    }

    private static class GroupComparator
    implements Comparator<MMZoomGroup> {
        private Map<MMZoomGroup, Long> mGroupsWithStamp;
        private Collator mCollator;

        GroupComparator(Map<MMZoomGroup, Long> buddiesWithStamp, Locale locale) {
            this.mGroupsWithStamp = buddiesWithStamp;
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
        }

        private String getItemSortKey(MMZoomGroup item) {
            return SortUtil.getSortKey((String)item.getGroupName(), (Locale)CompatUtils.getLocalDefault());
        }

        @Override
        public int compare(MMZoomGroup o1, MMZoomGroup o2) {
            if (this.mGroupsWithStamp == null || o1 == o2) {
                return 0;
            }
            Long stamp1 = this.mGroupsWithStamp.get(o1);
            Long stamp2 = this.mGroupsWithStamp.get(o2);
            if (stamp1 != null && stamp2 != null) {
                long t = stamp1 - stamp2;
                if (t == 0L) {
                    return 0;
                }
                if (t > 0L) {
                    return -1;
                }
                return 1;
            }
            if (stamp1 != null) {
                return -1;
            }
            if (stamp2 != null) {
                return 1;
            }
            String str1 = this.getItemSortKey(o1);
            String str2 = this.getItemSortKey(o2);
            return this.mCollator.compare(str1, str2);
        }
    }

    private static class BuddyComparator
    implements Comparator<String> {
        private Map<String, Long> mBuddiesWithStamp;

        BuddyComparator(Map<String, Long> buddiesWithStamp) {
            this.mBuddiesWithStamp = buddiesWithStamp;
        }

        @Override
        public int compare(String o1, String o2) {
            if (this.mBuddiesWithStamp == null) {
                return 0;
            }
            Long stamp1 = this.mBuddiesWithStamp.get(o1);
            Long stamp2 = this.mBuddiesWithStamp.get(o2);
            if (stamp1 == null && stamp2 == null) {
                return 0;
            }
            if (stamp1 == null) {
                return 1;
            }
            if (stamp2 == null) {
                return -1;
            }
            long t = stamp1 - stamp2;
            if (t == 0L) {
                return 0;
            }
            if (t > 0L) {
                return -1;
            }
            return 1;
        }
    }
}

