/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import android.content.Context;
import android.util.Base64;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class GroupAction
implements Serializable {
    private static final String TAG = GroupAction.class.getSimpleName();
    private static final long serialVersionUID = 1L;
    public static final int ACTION_MAKE_GROUP = 0;
    public static final int ACTION_MODIFY_NAME = 1;
    public static final int ACTION_DELETE_GROUP = 2;
    public static final int ACTION_ADD_BUDDIES = 3;
    public static final int ACTION_REMOVE_BUDDY = 4;
    public static final int ACTION_QUIT_GROUP = 5;
    public static final int ACTION_MODIFY_OPTION = 6;
    public static final int ACTION_NEW_ADMIN = 7;
    private int actionType;
    private String actionOwner;
    private String[] buddies;
    private boolean isActionOwnerMe = false;
    private boolean isMeInBuddies = false;
    private String newGroupName;
    private String actionOwnerId;
    private String groupId;
    private long time;
    private List<String> notAllowBuddies;
    private int mucFlag;
    private String reqId;

    public GroupAction(int type, String owner, String[] buddies, boolean isActionOwnerMe, boolean isMeInBuddies, String newGroupName) {
        this.actionType = type;
        this.actionOwner = owner;
        this.buddies = buddies;
        this.isActionOwnerMe = isActionOwnerMe;
        this.isMeInBuddies = isMeInBuddies;
        this.newGroupName = newGroupName;
    }

    public int getActionType() {
        return this.actionType;
    }

    public void setActionType(int actionType) {
        this.actionType = actionType;
    }

    public String getActionOwner() {
        return this.actionOwner;
    }

    public void setActionOwner(String actionOwner) {
        this.actionOwner = actionOwner;
    }

    public String[] getBuddies() {
        return this.buddies;
    }

    public void setBuddies(String[] buddies) {
        this.buddies = buddies;
    }

    public boolean isActionOwnerMe() {
        return this.isActionOwnerMe;
    }

    public void setIsActionOwnerMe(boolean isActionOwnerMe) {
        this.isActionOwnerMe = isActionOwnerMe;
    }

    public boolean isMeInBuddies() {
        return this.isMeInBuddies;
    }

    public void setIsMeInBuddies(boolean isMeInBuddies) {
        this.isMeInBuddies = isMeInBuddies;
    }

    public String getNewGroupName() {
        return this.newGroupName;
    }

    public void setNewGroupName(String newGroupName) {
        this.newGroupName = newGroupName;
    }

    public String getActionOwnerId() {
        return this.actionOwnerId;
    }

    public void setActionOwnerId(String actionOwnerId) {
        this.actionOwnerId = actionOwnerId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String toMessage(Context context) {
        if (context == null) {
            return null;
        }
        String message = null;
        if (StringUtil.isEmptyOrNull((String)this.actionOwner) && !StringUtil.isEmptyOrNull((String)this.actionOwnerId)) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return null;
            }
            ZoomBuddy buddy = messenger.getBuddyWithJID(this.actionOwnerId);
            if (buddy != null) {
                this.actionOwner = BuddyNameUtil.getBuddyDisplayName(buddy, null, false);
            }
        }
        switch (this.actionType) {
            case 0: {
                message = this.buildMakeGroupMessage(context);
                break;
            }
            case 1: {
                message = this.buildModifyNameMessage(context);
                break;
            }
            case 2: 
            case 5: {
                message = this.buildQuitGroupMessage(context);
                break;
            }
            case 3: {
                message = this.buildAddBuddiesMessage(context);
                break;
            }
            case 4: {
                message = this.buildRemoveBuddyMessage(context);
                break;
            }
            case 6: {
                message = this.buildModifyOptionMessage(context);
                break;
            }
            case 7: {
                message = this.buildNewAdminMessage(context);
                break;
            }
        }
        return message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String buildMakeGroupMessage(Context context) {
        String message = null;
        if (this.isActionOwnerMe) {
            if (this.buddies != null && this.buddies.length > 0) {
                if (this.buddies.length == 1) {
                    if (this.buddies[0] == null) return message;
                    return context.getString(R.string.zm_mm_group_action_make_group_owner_is_me, new Object[]{this.buddies[0]});
                }
                if (this.buddies.length <= 1) return message;
                String comma = context.getString(R.string.zm_mm_group_names_list_comma);
                String namesList = "";
                String nameAfterAnd = null;
                for (int i = 0; i < this.buddies.length - 1; ++i) {
                    String buddy = this.buddies[i];
                    if (buddy == null) {
                        return null;
                    }
                    namesList = namesList + buddy;
                    if (this.buddies.length <= 2 || i >= this.buddies.length - 2) continue;
                    namesList = namesList + comma + " ";
                }
                nameAfterAnd = this.buddies[this.buddies.length - 1];
                if (nameAfterAnd == null) {
                    return null;
                }
                namesList = context.getString(R.string.zm_mm_group_names_list_and, new Object[]{namesList, nameAfterAnd});
                return context.getString(R.string.zm_mm_group_action_make_group_owner_is_me, new Object[]{namesList});
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return null;
            }
            ZoomGroup group = messenger.getGroupById(this.getGroupId());
            if (group == null) {
                return null;
            }
            String groupName = group.getGroupDisplayName(context);
            return context.getString(R.string.zm_mm_group_action_make_group_exception, new Object[]{groupName});
        }
        if (this.buddies != null && this.buddies.length > 0) {
            if (this.buddies.length == 1) {
                if (this.isMeInBuddies) {
                    if (this.actionOwner == null) return message;
                    if (this.buddies[0] == null) return message;
                    String namesList = context.getString(R.string.zm_mm_group_names_list_you_and_xxx, new Object[]{this.buddies[0]});
                    return context.getString(R.string.zm_mm_group_action_make_group, new Object[]{this.actionOwner, namesList});
                }
                if (this.actionOwner == null) return message;
                if (this.buddies[0] == null) return message;
                return context.getString(R.string.zm_mm_group_action_make_group, new Object[]{this.actionOwner, this.buddies[0]});
            }
            if (this.buddies.length <= 1) return message;
            if (!this.isMeInBuddies) {
                String comma = context.getString(R.string.zm_mm_group_names_list_comma);
                String namesList = "";
                String nameAfterAnd = null;
                for (int i = 0; i < this.buddies.length - 1; ++i) {
                    String buddy = this.buddies[i];
                    if (buddy == null) {
                        return null;
                    }
                    namesList = namesList + buddy;
                    if (this.buddies.length <= 2 || i >= this.buddies.length - 2) continue;
                    namesList = namesList + comma + " ";
                }
                nameAfterAnd = this.buddies[this.buddies.length - 1];
                if (nameAfterAnd == null) {
                    return null;
                }
                namesList = context.getString(R.string.zm_mm_group_names_list_and, new Object[]{namesList, nameAfterAnd});
                return context.getString(R.string.zm_mm_group_action_make_group, new Object[]{this.actionOwner, namesList});
            }
            String comma = context.getString(R.string.zm_mm_group_names_list_comma);
            String namesList = "";
            String nameAfterAnd = null;
            for (int i = 0; i < this.buddies.length - 1; ++i) {
                String buddy = this.buddies[i];
                if (buddy == null) {
                    return null;
                }
                namesList = namesList + buddy;
                if (this.buddies.length <= 2 || i >= this.buddies.length - 2) continue;
                namesList = namesList + comma + " ";
            }
            nameAfterAnd = this.buddies[this.buddies.length - 1];
            if (nameAfterAnd == null) {
                return null;
            }
            namesList = context.getString(R.string.zm_mm_group_names_list_you_xxx_and_xxx, new Object[]{namesList, nameAfterAnd});
            return context.getString(R.string.zm_mm_group_action_make_group, new Object[]{this.actionOwner, namesList});
        }
        if (!this.isMeInBuddies) return context.getString(R.string.zm_mm_group_action_make_group, new Object[]{this.actionOwner, ""});
        if (this.actionOwner == null) return message;
        return context.getString(R.string.zm_mm_group_action_make_group_buddies_is_me, new Object[]{this.actionOwner});
    }

    private String buildModifyNameMessage(Context context) {
        String message = null;
        if (this.isActionOwnerMe) {
            if (this.newGroupName != null) {
                message = context.getString(R.string.zm_mm_group_action_modify_group_name_you, new Object[]{this.newGroupName});
            }
        } else if (this.newGroupName != null && this.actionOwner != null) {
            message = context.getString(R.string.zm_mm_group_action_modify_group_name_other, new Object[]{this.actionOwner, this.newGroupName});
        }
        return message;
    }

    private String buildQuitGroupMessage(Context context) {
        String message = null;
        if (this.isActionOwnerMe) {
            message = context.getString(R.string.zm_mm_group_action_quit_group_you);
        } else if (this.actionOwner != null) {
            message = context.getString(R.string.zm_mm_group_action_quit_group_other, new Object[]{this.actionOwner});
        }
        return message;
    }

    private String buildNewAdminMessage(Context context) {
        if (this.buddies == null) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        if (this.buddies == null || this.buddies.length == 0) {
            return null;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return null;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(this.buddies[0]);
        if (buddy == null) {
            return null;
        }
        if (this.isActionOwnerMe) {
            return context.getString(R.string.zm_mm_lbl_transfer_admin_from_42597, new Object[]{BuddyNameUtil.getBuddyDisplayName(buddy, null)});
        }
        if (this.isMeInBuddies) {
            return context.getString(R.string.zm_mm_lbl_transfer_admin_to_42597, new Object[]{this.actionOwner});
        }
        return context.getString(R.string.zm_mm_lbl_transfer_admin_other_42597, new Object[]{this.actionOwner, BuddyNameUtil.getBuddyDisplayName(buddy, null)});
    }

    private String buildModifyOptionMessage(Context context) {
        String message = null;
        if (this.isActionOwnerMe) {
            message = context.getString(R.string.zm_mm_group_action_modify_group_option_you);
        } else if (this.actionOwner != null) {
            message = context.getString(R.string.zm_mm_group_action_modify_group_option_other, new Object[]{this.actionOwner});
        }
        return message;
    }

    private String buildAddBuddiesMessage(Context context) {
        String message = null;
        if (this.isActionOwnerMe) {
            if (this.buddies != null && this.buddies.length > 0) {
                if (this.buddies.length == 1) {
                    if (this.buddies[0] != null) {
                        message = context.getString(R.string.zm_mm_group_action_add_buddies_owner_is_me, new Object[]{this.buddies[0]});
                    }
                } else if (this.buddies.length > 1) {
                    String comma = context.getString(R.string.zm_mm_group_names_list_comma);
                    String namesList = "";
                    String nameAfterAnd = null;
                    for (int i = 0; i < this.buddies.length - 1; ++i) {
                        String buddy = this.buddies[i];
                        if (buddy == null) {
                            return null;
                        }
                        namesList = namesList + buddy;
                        if (this.buddies.length <= 2 || i >= this.buddies.length - 2) continue;
                        namesList = namesList + comma + " ";
                    }
                    nameAfterAnd = this.buddies[this.buddies.length - 1];
                    if (nameAfterAnd == null) {
                        return null;
                    }
                    namesList = context.getString(R.string.zm_mm_group_names_list_and, new Object[]{namesList, nameAfterAnd});
                    message = context.getString(R.string.zm_mm_group_action_add_buddies_owner_is_me, new Object[]{namesList});
                }
            }
        } else if (this.buddies != null && this.buddies.length > 0) {
            if (this.buddies.length == 1) {
                if (this.isMeInBuddies) {
                    if (this.actionOwner != null && this.buddies[0] != null) {
                        String namesList = context.getString(R.string.zm_mm_group_names_list_you_and_xxx, new Object[]{this.buddies[0]});
                        message = context.getString(R.string.zm_mm_group_action_add_buddies, new Object[]{this.actionOwner, namesList});
                    }
                } else if (this.actionOwner != null && this.buddies[0] != null) {
                    message = this.actionOwner.equals(this.buddies[0]) ? context.getString(R.string.zm_mm_group_action_self_add_self_34394, new Object[]{this.actionOwner}) : context.getString(R.string.zm_mm_group_action_add_buddies, new Object[]{this.actionOwner, this.buddies[0]});
                }
            } else if (this.buddies.length > 1) {
                if (!this.isMeInBuddies) {
                    String comma = context.getString(R.string.zm_mm_group_names_list_comma);
                    String namesList = "";
                    String nameAfterAnd = null;
                    for (int i = 0; i < this.buddies.length - 1; ++i) {
                        String buddy = this.buddies[i];
                        if (buddy == null) {
                            return null;
                        }
                        namesList = namesList + buddy;
                        if (this.buddies.length <= 2 || i >= this.buddies.length - 2) continue;
                        namesList = namesList + comma + " ";
                    }
                    nameAfterAnd = this.buddies[this.buddies.length - 1];
                    if (nameAfterAnd == null) {
                        return null;
                    }
                    namesList = context.getString(R.string.zm_mm_group_names_list_and, new Object[]{namesList, nameAfterAnd});
                    message = context.getString(R.string.zm_mm_group_action_add_buddies, new Object[]{this.actionOwner, namesList});
                } else {
                    String comma = context.getString(R.string.zm_mm_group_names_list_comma);
                    String namesList = "";
                    String nameAfterAnd = null;
                    for (int i = 0; i < this.buddies.length - 1; ++i) {
                        String buddy = this.buddies[i];
                        if (buddy == null) {
                            return null;
                        }
                        namesList = namesList + buddy;
                        if (this.buddies.length <= 2 || i >= this.buddies.length - 2) continue;
                        namesList = namesList + comma + " ";
                    }
                    nameAfterAnd = this.buddies[this.buddies.length - 1];
                    if (nameAfterAnd == null) {
                        return null;
                    }
                    namesList = context.getString(R.string.zm_mm_group_names_list_you_xxx_and_xxx, new Object[]{namesList, nameAfterAnd});
                    message = context.getString(R.string.zm_mm_group_action_add_buddies, new Object[]{this.actionOwner, namesList});
                }
            }
        } else if (this.isMeInBuddies) {
            if (this.actionOwner != null) {
                message = context.getString(R.string.zm_mm_group_action_add_buddies_buddies_is_me, new Object[]{this.actionOwner});
            }
        } else {
            message = context.getString(R.string.zm_mm_group_action_add_buddies, new Object[]{this.actionOwner, ""});
        }
        return message;
    }

    private String buildRemoveBuddyMessage(Context context) {
        String message = null;
        if (this.isActionOwnerMe) {
            if (this.buddies != null && this.buddies.length > 0) {
                if (this.buddies.length == 1) {
                    if (this.buddies[0] != null) {
                        message = context.getString(R.string.zm_mm_group_action_remove_buddy_by_you, new Object[]{this.buddies[0]});
                    }
                } else if (this.buddies.length > 1) {
                    String comma = context.getString(R.string.zm_mm_group_names_list_comma);
                    String namesList = "";
                    String nameAfterAnd = null;
                    for (int i = 0; i < this.buddies.length - 1; ++i) {
                        String buddy = this.buddies[i];
                        if (buddy == null) {
                            return null;
                        }
                        namesList = namesList + buddy;
                        if (this.buddies.length <= 2 || i >= this.buddies.length - 2) continue;
                        namesList = namesList + comma + " ";
                    }
                    nameAfterAnd = this.buddies[this.buddies.length - 1];
                    if (nameAfterAnd == null) {
                        return null;
                    }
                    namesList = context.getString(R.string.zm_mm_group_names_list_and, new Object[]{namesList, nameAfterAnd});
                    message = context.getString(R.string.zm_mm_group_action_remove_buddy_by_you, new Object[]{namesList});
                }
            }
        } else if (this.buddies != null && this.buddies.length > 0) {
            if (this.buddies.length == 1) {
                if (this.isMeInBuddies) {
                    if (this.actionOwner != null && this.buddies[0] != null) {
                        String namesList = context.getString(R.string.zm_mm_group_names_list_you_and_xxx, new Object[]{this.buddies[0]});
                        message = context.getString(R.string.zm_mm_group_action_remove_buddy, new Object[]{this.actionOwner, namesList});
                    }
                } else if (this.actionOwner != null && this.buddies[0] != null) {
                    message = context.getString(R.string.zm_mm_group_action_remove_buddy, new Object[]{this.actionOwner, this.buddies[0]});
                }
            } else if (this.buddies.length > 1) {
                if (!this.isMeInBuddies) {
                    String comma = context.getString(R.string.zm_mm_group_names_list_comma);
                    String namesList = "";
                    String nameAfterAnd = null;
                    for (int i = 0; i < this.buddies.length - 1; ++i) {
                        String buddy = this.buddies[i];
                        if (buddy == null) {
                            return null;
                        }
                        namesList = namesList + buddy;
                        if (this.buddies.length <= 2 || i >= this.buddies.length - 2) continue;
                        namesList = namesList + comma + " ";
                    }
                    nameAfterAnd = this.buddies[this.buddies.length - 1];
                    if (nameAfterAnd == null) {
                        return null;
                    }
                    namesList = context.getString(R.string.zm_mm_group_names_list_and, new Object[]{namesList, nameAfterAnd});
                    message = context.getString(R.string.zm_mm_group_action_remove_buddy, new Object[]{this.actionOwner, namesList});
                } else {
                    String comma = context.getString(R.string.zm_mm_group_names_list_comma);
                    String namesList = "";
                    String nameAfterAnd = null;
                    for (int i = 0; i < this.buddies.length - 1; ++i) {
                        String buddy = this.buddies[i];
                        if (buddy == null) {
                            return null;
                        }
                        namesList = namesList + buddy;
                        if (this.buddies.length <= 2 || i >= this.buddies.length - 2) continue;
                        namesList = namesList + comma + " ";
                    }
                    nameAfterAnd = this.buddies[this.buddies.length - 1];
                    if (nameAfterAnd == null) {
                        return null;
                    }
                    namesList = context.getString(R.string.zm_mm_group_names_list_you_xxx_and_xxx, new Object[]{namesList, nameAfterAnd});
                    message = context.getString(R.string.zm_mm_group_action_remove_buddy, new Object[]{this.actionOwner, namesList});
                }
            }
        } else if (this.isMeInBuddies) {
            if (this.actionOwner != null) {
                message = context.getString(R.string.zm_mm_group_action_remove_buddy_remove_you, new Object[]{this.actionOwner});
            }
        } else {
            message = context.getString(R.string.zm_mm_group_action_remove_buddy, new Object[]{this.actionOwner, ""});
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serializeToString(GroupAction action) {
        block15: {
            String string2;
            if (action == null) {
                return null;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                String str;
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(action);
                oos.close();
                byte[] bytes = bos.toByteArray();
                if (bytes == null) {
                    String string3 = null;
                    return string3;
                }
                string2 = str = Base64.encodeToString((byte[])bytes, (int)0);
            }
            catch (IOException iOException) {
                break block15;
            }
            finally {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
            return string2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GroupAction loadFromString(String str) {
        if (str == null) {
            return null;
        }
        ByteArrayInputStream bis = null;
        try {
            byte[] bytes = Base64.decode((String)str, (int)0);
            bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object obj = ois.readObject();
            if (obj instanceof GroupAction) {
                GroupAction groupAction = (GroupAction)obj;
                return groupAction;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public List<String> getNotAllowBuddies() {
        return this.notAllowBuddies;
    }

    public void setNotAllowBuddies(List<String> notAllowBuddies) {
        this.notAllowBuddies = notAllowBuddies;
    }

    public int getMucFlag() {
        return this.mucFlag;
    }

    public void setMucFlag(int mucFlag) {
        this.mucFlag = mucFlag;
    }

    public String getReqId() {
        return this.reqId;
    }

    public void setReqId(String reqId) {
        this.reqId = reqId;
    }
}

