/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.delegate;

import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.delegate.IMHelperDelegation;
import com.zipow.videobox.ptapp.delegate.PTAppDelegation;
import java.io.IOException;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class PTUIDelegation {
    private static final String TAG = PTUIDelegation.class.getSimpleName();
    private static PTUIDelegation instance = null;
    private ListenerList mPTListenerList = new ListenerList();
    private ListenerList mIMListenerList = new ListenerList();

    private PTUIDelegation() {
    }

    public static synchronized PTUIDelegation getInstance() {
        if (instance == null) {
            instance = new PTUIDelegation();
        }
        return instance;
    }

    public void addPTUIListener(PTUI.IPTUIListener l) {
        if (VideoBoxApplication.getInstance().isPTApp()) {
            PTUI.getInstance().addPTUIListener(l);
        } else {
            if (l == null) {
                return;
            }
            IListener[] listeners = this.mPTListenerList.getAll();
            for (int i = 0; i < listeners.length; ++i) {
                if (listeners[i].getClass() != l.getClass()) continue;
                this.removePTUIListener((PTUI.IPTUIListener)listeners[i]);
            }
            this.mPTListenerList.add((IListener)l);
        }
    }

    public void removePTUIListener(PTUI.IPTUIListener l) {
        if (VideoBoxApplication.getInstance().isPTApp()) {
            PTUI.getInstance().removePTUIListener(l);
        } else {
            this.mPTListenerList.remove((IListener)l);
        }
    }

    public void addIMListener(PTUI.IIMListener l) {
        if (VideoBoxApplication.getInstance().isPTApp()) {
            PTUI.getInstance().addIMListener(l);
        } else {
            if (l == null) {
                return;
            }
            IListener[] listeners = this.mIMListenerList.getAll();
            for (int i = 0; i < listeners.length; ++i) {
                if (listeners[i].getClass() != l.getClass()) continue;
                this.removeIMListener((PTUI.IIMListener)listeners[i]);
            }
            this.mIMListenerList.add((IListener)l);
        }
    }

    public void removeIMListener(PTUI.IIMListener l) {
        if (VideoBoxApplication.getInstance().isPTApp()) {
            PTUI.getInstance().removeIMListener(l);
        } else {
            this.mIMListenerList.remove((IListener)l);
        }
    }

    public void dispatchPTAppEvent(int ptEvent, long result) {
        switch (ptEvent) {
            case 0: {
                this.onWebLogin(result);
                break;
            }
            case 8: {
                this.onIMLogin(result);
                break;
            }
            case 1: {
                this.onWebLogout(result);
            }
        }
        IListener[] listeners = this.mPTListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                PTUI.IPTUIListener l = (PTUI.IPTUIListener)lTmp;
                l.onPTAppEvent(ptEvent, result);
            }
        }
    }

    private void onWebLogin(long result) {
        PTAppDelegation.getInstance().setWebSignedOn(result == 0L);
        PTAppDelegation.getInstance().resetPTLoginType();
    }

    private void onIMLogin(long result) {
        IMHelperDelegation imHelper = PTAppDelegation.getInstance().getIMHelper();
        if (imHelper != null) {
            imHelper.setIMSignedOn(result == 0L);
        }
        PTAppDelegation.getInstance().resetPTLoginType();
    }

    private void onWebLogout(long result) {
        PTAppDelegation.getInstance().setWebSignedOn(false);
        PTAppDelegation.getInstance().resetPTLoginType();
    }

    public void sinkIMLocalStatusChanged(int status) {
        IMHelperDelegation imHelper = PTAppDelegation.getInstance().getIMHelper();
        switch (status) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                if (imHelper == null) break;
                imHelper.setIMSignedOn(false);
                break;
            }
            case 4: {
                if (imHelper != null) {
                    imHelper.setIMSignedOn(true);
                }
                PTAppDelegation.getInstance().resetPTLoginType();
            }
        }
        IListener[] listeners = this.mIMListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                PTUI.IIMListener l = (PTUI.IIMListener)lTmp;
                l.onIMLocalStatusChanged(status);
            }
        }
    }

    public void sinkIMReceived(byte[] content) {
        PTAppProtos.IMMessage message = null;
        try {
            message = PTAppProtos.IMMessage.parseFrom(content);
        }
        catch (IOException e) {
            return;
        }
        IListener[] listeners = this.mIMListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                PTUI.IIMListener l = (PTUI.IIMListener)lTmp;
                l.onIMReceived(message);
            }
        }
    }

    public void sinkIMBuddyPresence(byte[] content) {
        PTAppProtos.BuddyItem item = null;
        try {
            item = PTAppProtos.BuddyItem.parseFrom(content);
        }
        catch (IOException e) {
            return;
        }
        IListener[] listeners = this.mIMListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                PTUI.IIMListener l = (PTUI.IIMListener)lTmp;
                l.onIMBuddyPresence(item);
            }
        }
    }

    public void sinkIMBuddyPic(byte[] content) {
        PTAppProtos.BuddyItem item = null;
        try {
            item = PTAppProtos.BuddyItem.parseFrom(content);
        }
        catch (IOException e) {
            return;
        }
        IListener[] listeners = this.mIMListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                PTUI.IIMListener l = (PTUI.IIMListener)lTmp;
                l.onIMBuddyPic(item);
            }
        }
    }

    public void sinkIMBuddySort() {
        IListener[] listeners = this.mIMListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                PTUI.IIMListener l = (PTUI.IIMListener)lTmp;
                l.onIMBuddySort();
            }
        }
    }

    public void sinkNetworkState(boolean hasDataNetwork) {
        IListener[] listeners = this.mPTListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                PTUI.IPTUIListener l = (PTUI.IPTUIListener)lTmp;
                l.onDataNetworkStatusChanged(hasDataNetwork);
            }
        }
    }
}

