/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.delegate;

import android.os.RemoteException;
import com.zipow.videobox.IPTService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PT_LOGIN_TYPE;
import com.zipow.videobox.ptapp.delegate.ABContactsHelperDelegation;
import com.zipow.videobox.ptapp.delegate.FavoriteMgrDelegation;
import com.zipow.videobox.ptapp.delegate.IMHelperDelegation;
import com.zipow.videobox.ptapp.delegate.PTBuddyHelperDelegation;

public class PTAppDelegation {
    private static final String TAG = PTAppDelegation.class.getSimpleName();
    private static PTAppDelegation instance = null;
    private PTBuddyHelperDelegation buddyHelperDelegation;
    private FavoriteMgrDelegation favMgrDelegation;
    private IMHelperDelegation imHelperDelegation;
    private ABContactsHelperDelegation contactsHelperDelegation;
    private boolean mWebSignedOn;
    private boolean mWebSignedOnAssigned = false;
    private int mPTLoginType = 102;
    private boolean mPTLoginTypeAssigned = false;

    public static synchronized PTAppDelegation getInstance() {
        if (instance == null) {
            instance = new PTAppDelegation();
        }
        return instance;
    }

    private PTAppDelegation() {
        if (!VideoBoxApplication.getInstance().isPTApp()) {
            this.buddyHelperDelegation = this.getBuddyHelper();
        }
    }

    public void initDelegations() {
        this.initPTLoginType();
        final IMHelperDelegation imHelper = this.getIMHelper();
        Thread initDelegationsThread = new Thread("InitDelegationsThread"){

            @Override
            public void run() {
                PTAppDelegation.this.initWebSignedOn();
                imHelper.initIMSignedOn();
            }
        };
        initDelegationsThread.start();
    }

    public IMHelperDelegation getIMHelper() {
        if (VideoBoxApplication.getInstance().isPTApp()) {
            return new IMHelperDelegation(PTApp.getInstance().getIMHelper());
        }
        if (this.imHelperDelegation == null) {
            this.imHelperDelegation = new IMHelperDelegation();
        }
        return this.imHelperDelegation;
    }

    public PTBuddyHelperDelegation getBuddyHelper() {
        if (VideoBoxApplication.getInstance().isPTApp()) {
            return new PTBuddyHelperDelegation(PTApp.getInstance().getBuddyHelper());
        }
        if (this.buddyHelperDelegation == null) {
            this.buddyHelperDelegation = new PTBuddyHelperDelegation();
        }
        return this.buddyHelperDelegation;
    }

    public FavoriteMgrDelegation getFavoriteMgr() {
        if (VideoBoxApplication.getInstance().isPTApp()) {
            return new FavoriteMgrDelegation(PTApp.getInstance().getFavoriteMgr());
        }
        if (this.favMgrDelegation == null) {
            this.favMgrDelegation = new FavoriteMgrDelegation();
        }
        return this.favMgrDelegation;
    }

    public ABContactsHelperDelegation getABContactsHelper() {
        if (VideoBoxApplication.getInstance().isPTApp()) {
            return new ABContactsHelperDelegation(PTApp.getInstance().getABContactsHelper());
        }
        if (this.contactsHelperDelegation == null) {
            this.contactsHelperDelegation = new ABContactsHelperDelegation();
        }
        return this.contactsHelperDelegation;
    }

    public boolean hasActiveCall() {
        if (VideoBoxApplication.getInstance().isPTApp()) {
            return PTApp.getInstance().hasActiveCall();
        }
        return true;
    }

    public int getCallStatus() {
        if (VideoBoxApplication.getInstance().isPTApp()) {
            return PTApp.getInstance().getCallStatus();
        }
        return 2;
    }

    public int inviteBuddiesToConf(String[] buddyJids, String[] emails, String meetingId, long meetingNum, String invitationMsgTemplate) {
        if (VideoBoxApplication.getInstance().isPTApp()) {
            return PTApp.getInstance().inviteBuddiesToConf(buddyJids, emails, meetingId, meetingNum, invitationMsgTemplate);
        }
        IPTService ptService = VideoBoxApplication.getInstance().getPTService();
        if (ptService != null) {
            try {
                return ptService.inviteBuddiesToConf(buddyJids, emails, meetingId, meetingNum, invitationMsgTemplate);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return -1;
    }

    public synchronized int getPTLoginType() {
        if (VideoBoxApplication.getInstance().isPTApp()) {
            return PTApp.getInstance().getPTLoginType();
        }
        if (!this.mPTLoginTypeAssigned) {
            this.initPTLoginType();
        }
        return this.mPTLoginType;
    }

    private synchronized void initPTLoginType() {
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard != null && mainboard.isInitialized()) {
            if (VideoBoxApplication.getInstance().isConfApp()) {
                this.mPTLoginType = ConfMgr.getInstance().getPTLoginType();
                this.mPTLoginTypeAssigned = true;
            } else if (VideoBoxApplication.getInstance().isSipApp()) {
                this.mPTLoginType = 100;
                this.mPTLoginTypeAssigned = true;
            } else {
                this.mPTLoginType = PTApp.getInstance().getPTLoginType();
                this.mPTLoginTypeAssigned = true;
            }
        } else {
            IPTService ptService = VideoBoxApplication.getInstance().getPTService();
            if (ptService != null) {
                try {
                    this.mPTLoginType = ptService.getPTLoginType();
                    this.mPTLoginTypeAssigned = true;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized boolean isWebSignedOn() {
        if (VideoBoxApplication.getInstance().isPTApp()) {
            return PTApp.getInstance().isWebSignedOn();
        }
        if (!this.mWebSignedOnAssigned) {
            this.initWebSignedOn();
        }
        return this.mWebSignedOn;
    }

    private synchronized void initWebSignedOn() {
        if (!VideoBoxApplication.getInstance().isSDKMode()) {
            IPTService ptService = VideoBoxApplication.getInstance().getPTService();
            if (ptService != null) {
                try {
                    this.mWebSignedOn = ptService.isSignedIn();
                    this.mWebSignedOnAssigned = true;
                }
                catch (RemoteException remoteException) {}
            }
        } else {
            this.mWebSignedOn = PTApp.getInstance().isWebSignedOn();
            this.mWebSignedOnAssigned = true;
        }
    }

    public boolean isCurrentLoginTypeSupportIM() {
        return PT_LOGIN_TYPE.isTypeSupportIM(this.getPTLoginType());
    }

    public boolean isCurrentLoginTypeSupportFavoriteContacts() {
        int loginType = this.getPTLoginType();
        if (loginType == 100) {
            if (VideoBoxApplication.getInstance().isPTApp()) {
                return PTApp.getInstance().isCurrentLoginTypeSupportFavoriteContacts();
            }
            if (VideoBoxApplication.getInstance().isConfApp() && 1 == ConfMgr.getInstance().getCurrentVendor()) {
                return false;
            }
        }
        return PT_LOGIN_TYPE.isTypeSupportFavoriteContacts(loginType);
    }

    protected synchronized void setWebSignedOn(boolean webSignedOn) {
        this.mWebSignedOn = webSignedOn;
        this.mWebSignedOnAssigned = true;
    }

    protected void resetPTLoginType() {
        this.initPTLoginType();
    }
}

