/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.delegate;

import android.os.RemoteException;
import com.zipow.videobox.IPTService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.IMHelper;

public class IMHelperDelegation {
    private static final String TAG = IMHelperDelegation.class.getSimpleName();
    private IMHelper mImHelper;
    private boolean mIMSignedOn;
    private boolean mIMSignedOnAssigned = false;

    protected IMHelperDelegation() {
    }

    protected IMHelperDelegation(IMHelper imHelper) {
        this.mImHelper = imHelper;
    }

    public synchronized boolean isIMSignedOn() {
        if (this.mImHelper != null) {
            return this.mImHelper.isIMSignedOn();
        }
        if (!this.mIMSignedOnAssigned) {
            this.initIMSignedOn();
        }
        return this.mIMSignedOn;
    }

    protected synchronized void initIMSignedOn() {
        IPTService ptService = VideoBoxApplication.getInstance().getPTService();
        if (ptService != null) {
            try {
                this.mIMSignedOn = ptService.isIMSignedIn();
                this.mIMSignedOnAssigned = true;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    protected synchronized void setIMSignedOn(boolean signedOn) {
        this.mIMSignedOn = signedOn;
        this.mIMSignedOnAssigned = true;
    }
}

