/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class ZoomPublicRoomSearchUI {
    private static final String TAG = ZoomPublicRoomSearchUI.class.getSimpleName();
    private static ZoomPublicRoomSearchUI instance = null;
    private ListenerList mListenerList = new ListenerList();
    private long mNativeHandle = 0L;

    public void addListener(IZoomPublicRoomSearchUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((IZoomPublicRoomSearchUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(IZoomPublicRoomSearchUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public static synchronized ZoomPublicRoomSearchUI getInstance() {
        if (instance == null) {
            instance = new ZoomPublicRoomSearchUI();
        }
        if (!instance.initialized()) {
            instance.init();
        }
        return instance;
    }

    private ZoomPublicRoomSearchUI() {
        this.init();
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    private void init() {
        try {
            this.mNativeHandle = this.nativeInit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void onSearchResponse(int errCode, int fromIdx, int count) {
        try {
            this.onSearchResponseImpl(errCode, fromIdx, count);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onSearchResponseImpl(int errCode, int fromIdx, int count) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomPublicRoomSearchUIListener l = (IZoomPublicRoomSearchUIListener)lTmp;
                l.onSearchResponse(errCode, fromIdx, count);
            }
        }
    }

    protected void onJoinRoom(String roomId, int errCode) {
        try {
            this.onJoinRoomImpl(roomId, errCode);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onJoinRoomImpl(String roomId, int errCode) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomPublicRoomSearchUIListener l = (IZoomPublicRoomSearchUIListener)lTmp;
                l.onJoinRoom(roomId, errCode);
            }
        }
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    protected void finalize() throws Throwable {
        if (this.mNativeHandle != 0L) {
            this.nativeUninit(this.mNativeHandle);
        }
        super.finalize();
    }

    private native long nativeInit();

    private native void nativeUninit(long var1);

    public static abstract class SimpleZoomPublicRoomSearchUIListener
    implements IZoomPublicRoomSearchUIListener {
        @Override
        public void onSearchResponse(int errCode, int fromIdx, int count) {
        }

        @Override
        public void onJoinRoom(String roomId, int errCode) {
        }
    }

    public static interface IZoomPublicRoomSearchUIListener
    extends IListener {
        public void onSearchResponse(int var1, int var2, int var3);

        public void onJoinRoom(String var1, int var2);
    }
}

