/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import com.zipow.videobox.ConfActivityNormal;
import com.zipow.videobox.IConfService;
import com.zipow.videobox.LoginActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class RevokeTokenAutoLogoffChecker {
    private static final String TAG = RevokeTokenAutoLogoffChecker.class.getSimpleName();
    private static final int MSG_REVOKE_TOKEN = 1;
    private static final int MSG_ZAK_ERROR = 2;
    private static RevokeTokenAutoLogoffChecker instance;
    private boolean mIsSignout;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                    if (messenger == null) {
                        return;
                    }
                    if (messenger.isConnectionGood() || !messenger.isForceSignout()) break;
                    RevokeTokenAutoLogoffChecker.this.mIsSignout = true;
                    PTApp.getInstance().logout(0);
                    ZMActivity front = ZMActivity.getFrontActivity();
                    if (front == null || !front.isActive()) break;
                    RevokeTokenAutoLogoffChecker.this.checkSignout();
                    break;
                }
                case 2: {
                    RevokeTokenAutoLogoffChecker.this.mIsSignout = true;
                    PTApp.getInstance().logout(0);
                    ZMActivity front = ZMActivity.getFrontActivity();
                    if (front == null || !front.isActive()) break;
                    RevokeTokenAutoLogoffChecker.this.checkSignout();
                }
            }
        }
    };
    private ZMActivity.GlobalActivityListener mGlobalActivityListener = new ZMActivity.GlobalActivityListener(){

        public void onActivityMoveToFront(ZMActivity activity) {
            RevokeTokenAutoLogoffChecker.this.checkSignout();
        }

        public void onUIMoveToBackground() {
        }

        public void onUserActivityOnUI() {
        }
    };
    private ZoomMessengerUI.IZoomMessengerUIListener mListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onConnectReturn(int errorCode) {
            RevokeTokenAutoLogoffChecker.this.checkRevokeToken();
        }
    };
    private PTUI.INotifyZAKListener mNotifyZAKLListener = new PTUI.INotifyZAKListener(){

        @Override
        public void notifyZAKRefreshFailed(int errCode) {
            if (errCode == 1001 || errCode == 1134) {
                RevokeTokenAutoLogoffChecker.this.zakExpired();
            }
        }
    };

    public static RevokeTokenAutoLogoffChecker getInstance() {
        if (instance == null) {
            instance = new RevokeTokenAutoLogoffChecker();
        }
        return instance;
    }

    private void stopConference() {
        IConfService confService;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood() && messenger.isForceSignout() && (confService = VideoBoxApplication.getInstance().getConfService()) != null) {
            try {
                confService.leaveCurrentMeeting(false);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private RevokeTokenAutoLogoffChecker() {
    }

    private void checkRevokeToken() {
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessage(1);
    }

    private void zakExpired() {
        this.mHandler.removeMessages(2);
        this.mHandler.sendEmptyMessage(2);
    }

    private void checkSignout() {
        if (this.mIsSignout) {
            this.mIsSignout = false;
            if (!PTApp.getInstance().isWebSignedOn()) {
                int activityCount = ZMActivity.getInProcessActivityCountInStack();
                if (activityCount > 0) {
                    for (int i = activityCount - 1; i >= 0; --i) {
                        ZMActivity activity = ZMActivity.getInProcessActivityInStackAt((int)i);
                        if (activity instanceof ConfActivityNormal || activity == null) continue;
                        activity.finish();
                    }
                }
                LoginActivity.show(VideoBoxApplication.getGlobalContext(), false, true);
            }
        }
    }

    public void startChecker() {
        ZMActivity.addGlobalActivityListener((ZMActivity.GlobalActivityListener)this.mGlobalActivityListener);
        ZoomMessengerUI.getInstance().addListener(this.mListener);
        PTUI.getInstance().addINotifyZAKListener(this.mNotifyZAKLListener);
    }

    public void stopChecker() {
        ZMActivity.removeGlobalActivityListener((ZMActivity.GlobalActivityListener)this.mGlobalActivityListener);
        ZoomMessengerUI.getInstance().removeListener(this.mListener);
    }

    public static class RovokeTokenDialog
    extends ZMDialogFragment {
        public static void show(ZMActivity zmActivity) {
            if (zmActivity == null) {
                return;
            }
            RovokeTokenDialog dialog = new RovokeTokenDialog();
            Bundle args = new Bundle();
            dialog.setArguments(args);
            dialog.show(zmActivity.getSupportFragmentManager(), RovokeTokenDialog.class.getName());
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_lbl_revoke_token_25029).setPositiveButton(R.string.zm_btn_ok, null).create();
        }
    }
}

