/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import com.zipow.videobox.view.mm.sticker.StickerManager;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class PrivateStickerUICallBack {
    private static final String TAG = PrivateStickerUICallBack.class.getSimpleName();
    private static PrivateStickerUICallBack instance = null;
    private ListenerList mListenerList = new ListenerList();
    private long mNativeHandle;

    public void addListener(IZoomPrivateStickerUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((IZoomPrivateStickerUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(IZoomPrivateStickerUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public static synchronized PrivateStickerUICallBack getInstance() {
        if (instance == null) {
            instance = new PrivateStickerUICallBack();
        }
        if (!instance.initialized()) {
            instance.init();
        }
        return instance;
    }

    private PrivateStickerUICallBack() {
        this.init();
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    private void init() {
        try {
            this.mNativeHandle = this.nativeInit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void OnNewStickerUploaded(String req_id, int result, String stickerId) {
        try {
            this.OnNewStickerUploadedImpl(req_id, result, stickerId);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnNewStickerUploadedImpl(String req_id, int result, String stickerId) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomPrivateStickerUIListener l = (IZoomPrivateStickerUIListener)lTmp;
                l.OnNewStickerUploaded(req_id, result, stickerId);
            }
        }
    }

    protected void OnMakePrivateSticker(int result, String src_file_id, String stickerId) {
        try {
            this.OnMakePrivateStickerImpl(result, src_file_id, stickerId);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnMakePrivateStickerImpl(int result, String src_file_id, String stickerId) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomPrivateStickerUIListener l = (IZoomPrivateStickerUIListener)lTmp;
                l.OnMakePrivateSticker(result, src_file_id, stickerId);
            }
        }
    }

    protected void OnDiscardPrivateSticker(int result, String stickerId) {
        try {
            this.OnDiscardPrivateStickerImpl(result, stickerId);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnDiscardPrivateStickerImpl(int result, String stickerId) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomPrivateStickerUIListener l = (IZoomPrivateStickerUIListener)lTmp;
                l.OnDiscardPrivateSticker(result, stickerId);
            }
        }
    }

    protected void OnSendPrivateSticker(String req_id, int result, String session, String guid) {
        try {
            this.OnSendPrivateStickerImpl(req_id, result, session, guid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnSendPrivateStickerImpl(String req_id, int result, String session, String guid) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomPrivateStickerUIListener l = (IZoomPrivateStickerUIListener)lTmp;
                l.OnSendPrivateSticker(req_id, result, session, guid);
            }
        }
    }

    protected void OnPrivateStickersUpdated() {
        try {
            this.OnPrivateStickersUpdatedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnPrivateStickersUpdatedImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomPrivateStickerUIListener l = (IZoomPrivateStickerUIListener)lTmp;
                l.OnPrivateStickersUpdated();
            }
        }
    }

    protected void OnStickerDownloaded(String req_id, int result) {
        try {
            this.OnStickerDownloadedImpl(req_id, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnStickerDownloadedImpl(String req_id, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomPrivateStickerUIListener l = (IZoomPrivateStickerUIListener)lTmp;
                l.OnStickerDownloaded(req_id, result);
            }
        }
        StickerManager.removeStickerPendingDownloadByReqId(req_id);
    }

    protected void OnSendStickerMsgAppended(String session, String msgId) {
        try {
            this.OnSendStickerMsgAppendedImpl(session, msgId);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnSendStickerMsgAppendedImpl(String session, String msgId) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomPrivateStickerUIListener l = (IZoomPrivateStickerUIListener)lTmp;
                l.OnSendStickerMsgAppended(session, msgId);
            }
        }
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    protected void finalize() throws Throwable {
        if (this.mNativeHandle != 0L) {
            this.nativeUninit(this.mNativeHandle);
        }
        super.finalize();
    }

    private native long nativeInit();

    private native void nativeUninit(long var1);

    public static abstract class SimpleZoomPrivateStickerUIListener
    implements IZoomPrivateStickerUIListener {
        @Override
        public void OnNewStickerUploaded(String req_id, int result, String stickerId) {
        }

        @Override
        public void OnMakePrivateSticker(int result, String src_file_id, String stickerId) {
        }

        @Override
        public void OnDiscardPrivateSticker(int result, String stickerId) {
        }

        @Override
        public void OnSendPrivateSticker(String req_id, int result, String session, String guid) {
        }

        @Override
        public void OnPrivateStickersUpdated() {
        }

        @Override
        public void OnStickerDownloaded(String req_id, int result) {
        }

        @Override
        public void OnSendStickerMsgAppended(String session, String msgId) {
        }
    }

    public static interface IZoomPrivateStickerUIListener
    extends IListener {
        public void OnNewStickerUploaded(String var1, int var2, String var3);

        public void OnMakePrivateSticker(int var1, String var2, String var3);

        public void OnDiscardPrivateSticker(int var1, String var2);

        public void OnSendPrivateSticker(String var1, int var2, String var3, String var4);

        public void OnPrivateStickersUpdated();

        public void OnStickerDownloaded(String var1, int var2);

        public void OnSendStickerMsgAppended(String var1, String var2);
    }
}

