/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.IConfService;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.IntegrationActivity;
import com.zipow.videobox.JoinConfActivity;
import com.zipow.videobox.LauncherActivity;
import com.zipow.videobox.LoginActivity;
import com.zipow.videobox.PTService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.box.BoxMgr;
import com.zipow.videobox.confapp.bo.BOStatusChangeMgrOnPT;
import com.zipow.videobox.dropbox.ZMDropbox;
import com.zipow.videobox.fragment.ForceUpdateDialogFragment;
import com.zipow.videobox.fragment.JoinConfFragment;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.googledrive.GoogleDriveMgr;
import com.zipow.videobox.kubi.KubiServiceManager;
import com.zipow.videobox.nos.NOSMgr;
import com.zipow.videobox.onedrive.OneDriveManager;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.CrawlerLinkPreviewUI;
import com.zipow.videobox.ptapp.IMCallbackUI;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.IncomingCallManager;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.NotificationSettingUI;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.ptapp.PrivateStickerUICallBack;
import com.zipow.videobox.ptapp.VerifyCertEvent;
import com.zipow.videobox.ptapp.ZoomContact;
import com.zipow.videobox.ptapp.ZoomMessageTemplateUI;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.ZoomProductHelper;
import com.zipow.videobox.ptapp.ZoomPublicRoomSearchUI;
import com.zipow.videobox.ptapp.mm.CrawlerLinkPreview;
import com.zipow.videobox.ptapp.mm.MMPrivateStickerMgr;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.ptapp.mm.ZMBuddySyncInstance;
import com.zipow.videobox.ptapp.mm.ZoomMessageTemplate;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.ptapp.mm.ZoomPublicRoomSearchData;
import com.zipow.videobox.sdk.PromptProxyServerTask;
import com.zipow.videobox.sdk.PromptProxyServerTaskManager;
import com.zipow.videobox.sdk.SDKHost;
import com.zipow.videobox.sip.server.SipCallManager;
import com.zipow.videobox.util.IPCHelper;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.util.ZMServiceHelper;
import com.zipow.videobox.view.IMAddrBookListView;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import us.zoom.androidlib.app.ForegroundTask;
import us.zoom.androidlib.app.ForegroundTaskManager;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.thirdparty.login.LoginType;
import us.zoom.thirdparty.login.ThirdPartyLoginFactory;
import us.zoom.videomeetings.R;

public final class PTUI {
    private static final String TAG = PTUI.class.getSimpleName();
    private static PTUI instance = null;
    private ListenerList mPTListenerList = new ListenerList();
    private ListenerList mIMListenerList = new ListenerList();
    private ListenerList mConfInvitationListenerList = new ListenerList();
    private ListenerList mMeetingMgrListenerList = new ListenerList();
    private ListenerList mFavoriteListenerList = new ListenerList();
    private ListenerList mPhoneABListenerList = new ListenerList();
    private ListenerList mConfFailLisenerList = new ListenerList();
    private ListenerList mInviteByCallOutListenerList = new ListenerList();
    private ListenerList mCallMeListenerList = new ListenerList();
    private ListenerList mSDKAuthListenerList = new ListenerList();
    private ListenerList mRoomCallListenerList = new ListenerList();
    private ListenerList mJoinConfMeetingStatusListener = new ListenerList();
    private ListenerList mProfileListenerList = new ListenerList();
    private ListenerList mIAuthHandlerList = new ListenerList();
    private ListenerList mGDPRListenerList = new ListenerList();
    private ListenerList mNotifyZAKRefreshListenerList = new ListenerList();
    private BroadcastReceiver mNetworkStateReceiver;
    private boolean mHasDataNetwork = false;
    private Handler mHandler = new Handler();
    private String mLatestMeetingId = "";
    private long mLatestMeetingNumber = 0L;
    private Runnable mRunnableDispatchCallStatusIdle = null;
    private boolean mNeedGDPRConfirm = false;
    private String mPrivacyUrl;
    private String mTosUrl;
    private static final long XMPP_AUTO_SIGNIN_CHECK_TIME = 30L;
    private static final long XMPP_AUTO_SIGNIN_THRESHOLD_WIFI = 1200000L;
    private static final long XMPP_AUTO_SIGNIN_THRESHOLD_NO_WIFI = 2700000L;
    private static final long XMPP_AUTO_SIGNIN_THRESHOLD_GCM = 0x6DDD00L;
    private static final int XMPP_AUTO_SIGNIN_TIME_INTERVAL_UNIT = 1200000;
    private int mXMPPAutoLoginRandomTimeInterval;
    private ScheduledExecutorService mXmppAutoSignInScheduler = null;
    private ScheduledFuture<?> mXmppAutoSignInTask = null;
    private long mXmppAutoSignInLastCheckTime = 0L;
    private Runnable mXmppAutoSignInRunnable = new Runnable(){

        @Override
        public void run() {
            if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
                return;
            }
            long delta = System.currentTimeMillis() - PTUI.this.mXmppAutoSignInLastCheckTime;
            long threshold = PTUI.this.getXmppAutoSignInThreshold();
            if (delta > 0L && delta < threshold) {
                return;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                PTUI.this.stopXmppAutoSignInTimer();
                return;
            }
            if (messenger.isConnectionGood()) {
                PTUI.this.mXmppAutoSignInLastCheckTime = System.currentTimeMillis();
                return;
            }
            if (messenger.isStreamConflict()) {
                return;
            }
            messenger.trySignon();
            PTUI.this.mXmppAutoSignInLastCheckTime = System.currentTimeMillis();
            VideoBoxApplication.getInstance().runOnMainThreadDelayed(PTUI.this.mXmppAutoSignInDoubleCheckRunnable, 60000L);
        }
    };
    private Runnable mXmppAutoSignInDoubleCheckRunnable = new Runnable(){

        @Override
        public void run() {
            if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
                return;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            if (messenger.isConnectionGood()) {
                return;
            }
            if (messenger.isStreamConflict()) {
                return;
            }
            messenger.trySignon();
        }
    };

    private PTUI() {
    }

    public void initialize() {
        this.nativeInit();
        this.startListenNetworkState();
    }

    public static synchronized PTUI getInstance() {
        if (instance == null) {
            instance = new PTUI();
        }
        return instance;
    }

    public void addPTUIListener(IPTUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mPTListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removePTUIListener((IPTUIListener)listeners[i]);
        }
        this.mPTListenerList.add((IListener)l);
    }

    public void removePTUIListener(IPTUIListener l) {
        this.mPTListenerList.remove((IListener)l);
    }

    public void addIMListener(IIMListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mIMListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeIMListener((IIMListener)listeners[i]);
        }
        this.mIMListenerList.add((IListener)l);
    }

    public void removeIMListener(IIMListener l) {
        this.mIMListenerList.remove((IListener)l);
    }

    public void addConfInvitationListener(IConfInvitationListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mConfInvitationListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeConfInvitationListener((IConfInvitationListener)listeners[i]);
        }
        this.mConfInvitationListenerList.add((IListener)l);
    }

    public void removeConfInvitationListener(IConfInvitationListener l) {
        this.mConfInvitationListenerList.remove((IListener)l);
    }

    public void addMeetingMgrListener(IMeetingMgrListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mMeetingMgrListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeMeetingMgrListener((IMeetingMgrListener)listeners[i]);
        }
        this.mMeetingMgrListenerList.add((IListener)l);
    }

    public void removeMeetingMgrListener(IMeetingMgrListener l) {
        this.mMeetingMgrListenerList.remove((IListener)l);
    }

    public void addFavoriteListener(IFavoriteListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mFavoriteListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeFavoriteListener((IFavoriteListener)listeners[i]);
        }
        this.mFavoriteListenerList.add((IListener)l);
    }

    public void removeFavoriteListener(IFavoriteListener l) {
        this.mFavoriteListenerList.remove((IListener)l);
    }

    public void addPhoneABListener(IPhoneABListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mPhoneABListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removePhoneABListener((IPhoneABListener)listeners[i]);
        }
        this.mPhoneABListenerList.add((IListener)l);
    }

    public void removePhoneABListener(IPhoneABListener l) {
        this.mPhoneABListenerList.remove((IListener)l);
    }

    public void addConfFailListener(IConfFailListener l) {
        if (l == null) {
            return;
        }
        this.mConfFailLisenerList.add((IListener)l);
    }

    public void removeConfFailListener(IConfFailListener l) {
        this.mConfFailLisenerList.remove((IListener)l);
    }

    public void addInviteByCallOutListener(IInviteByCallOutListener l) {
        if (l == null) {
            return;
        }
        this.mInviteByCallOutListenerList.add((IListener)l);
    }

    public void removeInviteByCallOutListener(IInviteByCallOutListener l) {
        this.mInviteByCallOutListenerList.remove((IListener)l);
    }

    public void addCallMeListener(ICallMeListener l) {
        if (l == null) {
            return;
        }
        this.mCallMeListenerList.add((IListener)l);
    }

    public void removeCallMeListener(ICallMeListener l) {
        this.mCallMeListenerList.remove((IListener)l);
    }

    public void addSDKAuthListener(ISDKAuthListener l) {
        if (l == null) {
            return;
        }
        this.mSDKAuthListenerList.add((IListener)l);
    }

    public void removeSDKAuthListener(ISDKAuthListener l) {
        this.mSDKAuthListenerList.remove((IListener)l);
    }

    public void addRoomCallListener(IRoomCallListener l) {
        if (l == null) {
            return;
        }
        this.mRoomCallListenerList.add((IListener)l);
    }

    public void removeRoomCallListener(IRoomCallListener l) {
        this.mRoomCallListenerList.remove((IListener)l);
    }

    public void addJoinConfMeetingStatusListener(IJoinConfMeetingStatusListener l) {
        if (l == null) {
            return;
        }
        this.mJoinConfMeetingStatusListener.add((IListener)l);
    }

    public void removeJoinConfMeetingStatusListener(IJoinConfMeetingStatusListener l) {
        this.mJoinConfMeetingStatusListener.remove((IListener)l);
    }

    public void addProfileListener(IProfileListener l) {
        this.mProfileListenerList.add((IListener)l);
    }

    public void removeProfileListener(IProfileListener l) {
        this.mProfileListenerList.remove((IListener)l);
    }

    public void addGDPRListener(IGDPRListener l) {
        this.mGDPRListenerList.add((IListener)l);
    }

    public void removeGDPRListener(IGDPRListener l) {
        this.mGDPRListenerList.remove((IListener)l);
    }

    public void addAuthHandler(IAuthHandlerListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mIAuthHandlerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removePTUIListener((IPTUIListener)listeners[i]);
        }
        this.mIAuthHandlerList.add((IListener)l);
    }

    public void removeAuthHandler(IAuthHandlerListener l) {
        this.mIAuthHandlerList.remove((IListener)l);
    }

    public void addINotifyZAKListener(INotifyZAKListener l) {
        this.mNotifyZAKRefreshListenerList.add((IListener)l);
    }

    public void removeINotifyZAKListener(INotifyZAKListener l) {
        this.mNotifyZAKRefreshListenerList.remove((IListener)l);
    }

    protected void onGoogleAuthReturn(String accessToken, String refreshToken, long error, String errorStr) {
        try {
            this.onGoogleAuthReturnImpl(accessToken, refreshToken, error, errorStr);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onGoogleAuthReturnImpl(String accessToken, String refreshToken, long error, String errorStr) {
        IListener[] listeners = this.mIAuthHandlerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IAuthHandlerListener l = (IAuthHandlerListener)lTmp;
                l.onGoogleAuthReturn(accessToken, refreshToken, error, errorStr);
            }
        }
    }

    protected void onFacebookAuthReturn(String accessToken, long expires_in, long error, String errorStr) {
        try {
            this.onFacebookAuthReturnImpl(accessToken, expires_in, error, errorStr);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onFacebookAuthReturnImpl(String accessToken, long expires_in, long error, String errorStr) {
        IListener[] listeners = this.mIAuthHandlerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IAuthHandlerListener l = (IAuthHandlerListener)lTmp;
                l.onFacebookAuthReturn(accessToken, expires_in, error, errorStr);
            }
        }
    }

    protected void NotifyUIToLogOut() {
        try {
            this.NotifyUIToLogOutImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void NotifyUIToLogOutImpl() {
        IListener[] listeners = this.mGDPRListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IGDPRListener l = (IGDPRListener)lTmp;
                l.NotifyUIToLogOut();
            }
        }
    }

    protected void OnShowPrivacyDialog(String privacyUrl, String tosUrl) {
        try {
            this.OnShowPrivacyDialogImpl(privacyUrl, tosUrl);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnShowPrivacyDialogImpl(String privacyUrl, String tosUrl) {
        this.mNeedGDPRConfirm = true;
        this.mPrivacyUrl = privacyUrl;
        this.mTosUrl = tosUrl;
        IListener[] listeners = this.mGDPRListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IGDPRListener l = (IGDPRListener)lTmp;
                l.OnShowPrivacyDialog(privacyUrl, tosUrl);
            }
        }
    }

    public boolean NeedGDPRConfirm() {
        return this.mNeedGDPRConfirm;
    }

    public void ClearGDPRConfirmFlag() {
        this.mNeedGDPRConfirm = false;
    }

    public String getGDPRPrivacyUrl() {
        return this.mPrivacyUrl;
    }

    public String getGDPRTosUrl() {
        return this.mTosUrl;
    }

    protected void dispatchPTAppEvent(int ptEvent, long result) {
        try {
            this.dispatchPTAppEventImpl(ptEvent, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void dispatchPTAppEventImpl(int ptEvent, long result) {
        IConfService confService;
        switch (ptEvent) {
            case 0: {
                this.onWebLogin(result);
                break;
            }
            case 8: {
                this.onIMLogin(result);
                break;
            }
            case 1: {
                this.onWebLogout(result);
                break;
            }
            case 14: {
                this.onIMLogout(result);
                break;
            }
            case 21: {
                this.onIMReconnecting();
                break;
            }
            case 35: {
                this.onGoogleWebAccessFail();
                break;
            }
            case 37: {
                this.onPTEventLogoutWithBrowser((int)result);
                break;
            }
            case 22: {
                if ((int)result == 0) {
                    if (VideoBoxApplication.getInstance().getConfProcessId() > 0 || VideoBoxApplication.getInstance().getConfService() != null) {
                        this.dispatchCallStatusIdleAfterConfServiceDisconnected();
                        return;
                    }
                } else {
                    this.mHandler.removeCallbacks(this.mRunnableDispatchCallStatusIdle);
                }
                this.onCallStatusChanged(result);
            }
        }
        IListener[] listeners = this.mPTListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IPTUIListener l = (IPTUIListener)lTmp;
                l.onPTAppEvent(ptEvent, result);
            }
        }
        if ((confService = VideoBoxApplication.getInstance().getConfService()) != null) {
            try {
                confService.sinkPTAppEvent(ptEvent, result);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void dispatchCallStatusIdleAfterConfServiceDisconnected() {
        if (this.mRunnableDispatchCallStatusIdle == null) {
            this.mRunnableDispatchCallStatusIdle = new Runnable(){

                @Override
                public void run() {
                    if (VideoBoxApplication.getInstance().getConfProcessId() > 0 || VideoBoxApplication.getInstance().getConfService() != null) {
                        PTUI.this.dispatchCallStatusIdleAfterConfServiceDisconnected();
                        return;
                    }
                    PTUI.this.dispatchPTAppEvent(22, 0L);
                }
            };
        }
        this.mHandler.postDelayed(this.mRunnableDispatchCallStatusIdle, 100L);
    }

    private void onIMLogin(long result) {
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper != null) {
            imHelper.setIMLocalStatus(result == 0L ? 4 : 5);
        }
        if (result == 0L) {
            VideoBoxApplication context;
            PTApp.getInstance().setTokenExpired(false);
            if (imHelper != null) {
                PTApp.getInstance().setRencentJid(imHelper.getJIDMyself());
            }
            if (!(context = VideoBoxApplication.getInstance()).isSDKMode()) {
                ZMServiceHelper.doServiceActionInFront(PTService.ACTION_START_FOREGROUND, PTService.class);
            }
        }
    }

    private void onWebLogin(long result) {
        PTApp.getInstance().setWebSignedOn(result == 0L);
        if (result == 0L) {
            VideoBoxApplication context;
            if (PTApp.getInstance().hasMessenger() && !VideoBoxApplication.getInstance().isSDKMode()) {
                CrawlerLinkPreview crawlerLinkPreview;
                MMPrivateStickerMgr mgr;
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger != null) {
                    messenger.setMsgUI(ZoomMessengerUI.getInstance());
                    PreferenceUtil.saveIntValue("giphy_opthion", messenger.getGiphyOption());
                    ZoomPublicRoomSearchData roomSearchData = messenger.getPublicRoomSearchData();
                    if (roomSearchData != null) {
                        roomSearchData.setCallback(ZoomPublicRoomSearchUI.getInstance());
                    }
                }
                if ((mgr = PTApp.getInstance().getZoomPrivateStickerMgr()) != null) {
                    mgr.registerUICallBack(PrivateStickerUICallBack.getInstance());
                }
                NOSMgr.getInstance().register();
                ZMBuddySyncInstance.getInsatance().refreshAllBuddy();
                NotificationSettingMgr notificationSettingMgr = PTApp.getInstance().getNotificationSettingMgr();
                if (notificationSettingMgr != null) {
                    notificationSettingMgr.registerUICallBack(NotificationSettingUI.getInstance());
                }
                if ((crawlerLinkPreview = PTApp.getInstance().getLinkCrawler()) != null) {
                    crawlerLinkPreview.RegisterUICallback(CrawlerLinkPreviewUI.getInstance());
                }
                IMCallbackUI.getInstance().registerCallback();
                ZoomMessageTemplate zoomMessageTemplate = PTApp.getInstance().getZoomMessageTemplate();
                if (zoomMessageTemplate != null) {
                    zoomMessageTemplate.registerCommonAppUICallback(ZoomMessageTemplateUI.getInstance());
                }
                PTUI.enableSendFileActivity(true);
            } else {
                PTUI.enableSendFileActivity(false);
            }
            if (!VideoBoxApplication.getInstance().isSDKMode()) {
                SipCallManager.getInstance().onZoomLoginFinished();
            }
            PTApp.getInstance().setTokenExpired(false);
            if (PTApp.getInstance().needDoWebStart()) {
                ForegroundTask task = new ForegroundTask("launchCallForWebStart"){

                    public boolean isValidActivity(String activityClass) {
                        return IMActivity.class.getName().equals(activityClass);
                    }

                    public boolean isOtherProcessSupported() {
                        return false;
                    }

                    public void run(ZMActivity activity) {
                        if (activity == null) {
                            return;
                        }
                        int ret = ConfActivity.launchCallForWebStart((Context)activity);
                        if (ret == 8) {
                            ForceUpdateDialogFragment.show(activity.getSupportFragmentManager());
                        }
                    }
                };
                ForegroundTaskManager.getInstance().runInForeground(task);
            }
            if (!(context = VideoBoxApplication.getInstance()).isSDKMode()) {
                ZMServiceHelper.doServiceActionInFront(PTService.ACTION_START_FOREGROUND, PTService.class);
            }
            this.checkStartKubiService();
        }
    }

    public void checkStartKubiService() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null && settingHelper.getIsKubiDeviceEnabled()) {
            KubiServiceManager kubiServiceMgr = KubiServiceManager.getInstance((Context)VideoBoxApplication.getInstance());
            kubiServiceMgr.startKubiService();
            kubiServiceMgr.connectKubiService(false);
        }
    }

    private void onWebLogout(long result) {
        int vendor;
        ZoomProductHelper productHelper;
        PTApp.getInstance().setWebSignedOn(false);
        NOSMgr.getInstance().unregister();
        PTApp.getInstance().setRencentJid("");
        PTApp.getInstance().setRencentZoomJid("");
        PTApp.getInstance().nos_ClearDeviceToken();
        this.stopXmppAutoSignInTimer();
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        if (!context.isSDKMode()) {
            ZMServiceHelper.doServiceAction(PTService.ACTION_STOP_FOREGROUND, PTService.class);
        }
        NotificationMgr.removeAllMessageNotificationMM(VideoBoxApplication.getGlobalContext());
        SipCallManager.getInstance().onZoomLogoutFinished();
        if (!VideoBoxApplication.getInstance().isSDKMode() && PTApp.getInstance().ismNeedSwitchVendor() && (productHelper = PTApp.getInstance().getZoomProductHelper()) != null && (vendor = productHelper.getCurrentVendor()) == 1) {
            productHelper.vendorSwitchTo(0);
        }
        PreferenceUtil.removeValue("first_open_contacts");
        ZMBuddySyncInstance.getInsatance().clearAllBuddies();
        PTUI.enableSendFileActivity(false);
        this.clearCloudStorageInfo();
        this.stopKubiService();
    }

    private void stopKubiService() {
        KubiServiceManager kubiServiceMgr = KubiServiceManager.getInstance((Context)VideoBoxApplication.getInstance());
        kubiServiceMgr.stopKubiService();
    }

    private void clearCloudStorageInfo() {
        GoogleDriveMgr.release();
        BoxMgr.release();
        ZMDropbox.release();
        OneDriveManager.release();
    }

    private void onIMLogout(long result) {
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper != null) {
            imHelper.setIMLocalStatus(0);
        }
    }

    private void onIMReconnecting() {
        boolean isActive;
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper == null) {
            return;
        }
        if (ZMActivity.getFrontActivity() instanceof LoginActivity) {
            return;
        }
        ZMActivity activity = ZMActivity.getFrontActivity();
        boolean bl = isActive = activity != null && activity.isActive() || PTApp.getInstance().hasActiveCall();
        if (NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance()) && isActive) {
            this.reconnectIM();
        }
    }

    private void onGoogleWebAccessFail() {
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper != null) {
            imHelper.setIMLocalStatus(5);
        }
    }

    public void onPTEventLogoutWithBrowser(final int snsType) {
        String avatar;
        if (!VideoBoxApplication.getInstance().isSDKMode()) {
            new Thread("ClearCookie"){

                @Override
                public void run() {
                    switch (snsType) {
                        case 0: {
                            ThirdPartyLoginFactory.build((LoginType)LoginType.Facebook, (Bundle)ThirdPartyLoginFactory.buildEmptyFacebookBundle()).logout((Context)VideoBoxApplication.getInstance());
                            break;
                        }
                        case 2: {
                            ThirdPartyLoginFactory.build((LoginType)LoginType.Google, (Bundle)ThirdPartyLoginFactory.buildEmptyGoogleBundle()).logout((Context)VideoBoxApplication.getInstance());
                            break;
                        }
                        case 101: {
                            ThirdPartyLoginFactory.build((LoginType)LoginType.Sso, (Bundle)ThirdPartyLoginFactory.buildEmptySsoBundle()).logout((Context)VideoBoxApplication.getInstance());
                        }
                    }
                }
            }.start();
        }
        if ((avatar = PreferenceUtil.readStringValue("local_avatar", "")).length() > 0) {
            PreferenceUtil.saveStringValue("local_avatar", "");
        }
    }

    private void startListenNetworkState() {
        this.mHasDataNetwork = NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance());
        if (this.mNetworkStateReceiver == null) {
            this.mNetworkStateReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    String action = intent.getAction();
                    if (!"android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
                        return;
                    }
                    PTUI.this.onNetworkState(intent);
                }
            };
            VideoBoxApplication.getInstance().registerReceiver(this.mNetworkStateReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private void stopListenNetworkState() {
        if (this.mNetworkStateReceiver != null) {
            try {
                VideoBoxApplication.getInstance().unregisterReceiver(this.mNetworkStateReceiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mNetworkStateReceiver = null;
        }
    }

    private void onNetworkState(Intent intent) {
        boolean hasDataNetwork = NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance());
        if (this.mHasDataNetwork != hasDataNetwork) {
            IConfService confService;
            if (hasDataNetwork && PTApp.getInstance().isWebSignedOn()) {
                boolean isActive;
                IMHelper imHelper = PTApp.getInstance().getIMHelper();
                IListener[] activity = ZMActivity.getFrontActivity();
                boolean bl = isActive = activity != null && activity.isActive() || PTApp.getInstance().hasActiveCall();
                if (imHelper != null && PTApp.getInstance().isCurrentLoginTypeSupportIM() && !imHelper.isIMSignedOn() && !imHelper.isIMLoggingIn() && isActive) {
                    this.reconnectIM();
                }
            }
            this.mHasDataNetwork = hasDataNetwork;
            IListener[] listeners = this.mPTListenerList.getAll();
            if (listeners != null) {
                for (IListener lTmp : listeners) {
                    IPTUIListener l = (IPTUIListener)lTmp;
                    l.onDataNetworkStatusChanged(hasDataNetwork);
                }
            }
            if ((confService = VideoBoxApplication.getInstance().getConfService()) != null) {
                try {
                    confService.sinkDataNetworkStatusChanged(hasDataNetwork);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    public void reconnectIM() {
        PTApp ptApp = PTApp.getInstance();
        ptApp.resetForReconnecting();
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            return;
        }
        int loginType = ptApp.getPTLoginType();
        if (loginType == 0) {
            this.sinkIMLocalStatusChanged(1);
            ptApp.loginFacebookWithLocalToken(true);
        } else if (loginType == 2) {
            this.sinkIMLocalStatusChanged(1);
            ptApp.retryLoginGoogle();
        }
    }

    protected void sinkOnQueryIPLocation(int result, byte[] body) {
        try {
            this.sinkOnQueryIPLocationImpl(result, body);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkOnQueryIPLocationImpl(int result, byte[] body) {
        if (body == null || body.length == 0) {
            return;
        }
        try {
            PTAppProtos.IPLocationInfo info = PTAppProtos.IPLocationInfo.parseFrom(body);
            IListener[] listeners = this.mIMListenerList.getAll();
            if (listeners != null) {
                for (IListener lTmp : listeners) {
                    IIMListener l = (IIMListener)lTmp;
                    l.onQueryIPLocation(result, info);
                }
            }
            NOSMgr.getInstance().onQueryIPLocation(info);
        }
        catch (IOException e) {
            return;
        }
    }

    protected void sinkQuerySSOVanityURL(String reqID, int result, String url) {
        try {
            this.sinkQuerySSOVanityURLImpl(reqID, result, url);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkQuerySSOVanityURLImpl(String reqID, int result, String url) {
        IListener[] listeners = this.mIMListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IIMListener l = (IIMListener)lTmp;
                l.onQuerySSOVanityURL(reqID, result, url);
            }
        }
    }

    protected void sinkIMReceived(byte[] content) {
        try {
            this.sinkIMReceivedImpl(content);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkIMReceivedImpl(byte[] content) {
        IConfService confService;
        IListener[] listeners;
        IMHelper imHelper;
        PTAppProtos.IMMessage message = null;
        try {
            message = PTAppProtos.IMMessage.parseFrom(content);
        }
        catch (IOException e) {
            return;
        }
        if (message.getMessageType() == 1 && (imHelper = PTApp.getInstance().getIMHelper()) != null) {
            IListener[] senderJID = message.getFromScreenName();
            if (senderJID == null) {
                return;
            }
            if (senderJID.equals(imHelper.getJIDMyself())) {
                imHelper.setIMMessageUnread(message, false);
            } else {
                PTAppProtos.InvitationItem callItem = IncomingCallManager.getInstance().getCurrentCall();
                if (callItem == null || message.getMessage().indexOf(String.valueOf(callItem.getMeetingNumber())) > 0) {
                    imHelper.setIMMessageUnread(message, false);
                }
            }
        }
        if ((listeners = this.mIMListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IIMListener l = (IIMListener)lTmp;
                l.onIMReceived(message);
            }
        }
        if ((listeners == null || listeners.length == 0) && message.getMessageType() == 0) {
            IMHelper imHelper2 = PTApp.getInstance().getIMHelper();
            if (imHelper2 == null) {
                return;
            }
            String jid = imHelper2.getJIDMyself();
            if (jid != null && jid.equals(message.getFromScreenName())) {
                imHelper2.setIMMessageUnread(message, false);
                return;
            }
            NotificationMgr.showMessageNotificationMM((Context)VideoBoxApplication.getInstance(), true);
        }
        if ((confService = VideoBoxApplication.getInstance().getConfService()) != null) {
            try {
                confService.sinkIMReceived(content);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    protected void sinkIMBuddyPresence(byte[] content) {
        try {
            this.sinkIMBuddyPresenceImpl(content);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkIMBuddyPresenceImpl(byte[] content) {
        IConfService confService;
        PTAppProtos.BuddyItem item = null;
        try {
            item = PTAppProtos.BuddyItem.parseFrom(content);
        }
        catch (IOException e) {
            return;
        }
        IListener[] listeners = this.mIMListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IIMListener l = (IIMListener)lTmp;
                l.onIMBuddyPresence(item);
            }
        }
        if ((confService = VideoBoxApplication.getInstance().getConfService()) != null) {
            try {
                confService.sinkIMBuddyPresence(content);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    protected void sinkIMBuddyPic(byte[] content) {
        try {
            this.sinkIMBuddyPicImpl(content);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkIMBuddyPicImpl(byte[] content) {
        IConfService confService;
        PTAppProtos.BuddyItem item = null;
        try {
            item = PTAppProtos.BuddyItem.parseFrom(content);
        }
        catch (IOException e) {
            return;
        }
        IListener[] listeners = this.mIMListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IIMListener l = (IIMListener)lTmp;
                l.onIMBuddyPic(item);
            }
        }
        if ((confService = VideoBoxApplication.getInstance().getConfService()) != null) {
            try {
                confService.sinkIMBuddyPic(content);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    protected void sinkIMBuddySort() {
        try {
            this.sinkIMBuddySortImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkIMBuddySortImpl() {
        IConfService confService;
        IListener[] listeners = this.mIMListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IIMListener l = (IIMListener)lTmp;
                l.onIMBuddySort();
            }
        }
        if ((confService = VideoBoxApplication.getInstance().getConfService()) != null) {
            try {
                confService.sinkIMBuddySort();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    protected void sinkIMLocalStatusChanged(int status) {
        try {
            this.sinkIMLocalStatusChangedImpl(status);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkIMLocalStatusChangedImpl(int status) {
        IConfService confService;
        IListener[] listeners;
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper != null) {
            imHelper.setIMLocalStatus(status);
        }
        if ((listeners = this.mIMListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IIMListener l = (IIMListener)lTmp;
                l.onIMLocalStatusChanged(status);
            }
        }
        if ((confService = VideoBoxApplication.getInstance().getConfService()) != null) {
            try {
                confService.sinkIMLocalStatusChanged(status);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    protected void sinkIMCallDeclined(byte[] content) {
        try {
            this.sinkIMCallDeclinedImpl(content);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkIMCallDeclinedImpl(byte[] content) {
        long activeMeetingNumber;
        PTAppProtos.InvitationItem item = null;
        try {
            item = PTAppProtos.InvitationItem.parseFrom(content);
        }
        catch (IOException e) {
            return;
        }
        long meetingNumber = item.getMeetingNumber();
        IListener[] listeners = this.mConfInvitationListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfInvitationListener l = (IConfInvitationListener)lTmp;
                l.onCallDeclined(item);
            }
        }
        if ((activeMeetingNumber = PTApp.getInstance().getActiveMeetingNo()) == meetingNumber) {
            PTApp.getInstance().tryEndCallForDeclined();
        }
    }

    protected void sinkIMCallAccepted(byte[] content) {
        try {
            this.sinkIMCallAcceptedImpl(content);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkIMCallAcceptedImpl(byte[] content) {
        PTAppProtos.InvitationItem item = null;
        try {
            item = PTAppProtos.InvitationItem.parseFrom(content);
        }
        catch (IOException e) {
            return;
        }
        long meetingNumber = item.getMeetingNumber();
        IListener[] listeners = this.mConfInvitationListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfInvitationListener l = (IConfInvitationListener)lTmp;
                l.onCallAccepted(item);
            }
        }
    }

    protected void sinkConfInvitation(byte[] content) {
        try {
            this.sinkConfInvitationImpl(content);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkConfInvitationImpl(byte[] content) {
        PTAppProtos.InvitationItem item = null;
        try {
            item = PTAppProtos.InvitationItem.parseFrom(content);
        }
        catch (IOException e) {
            return;
        }
        long meetingNumber = item.getMeetingNumber();
        long activeMeetingNumber = PTApp.getInstance().getActiveMeetingNo();
        if (activeMeetingNumber == meetingNumber) {
            return;
        }
        this.onConfInvitation(item);
        IListener[] listeners = this.mConfInvitationListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfInvitationListener l = (IConfInvitationListener)lTmp;
                l.onConfInvitation(item);
            }
        }
    }

    private void onConfInvitation(PTAppProtos.InvitationItem invitation) {
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper == null) {
            return;
        }
        String senderJID = invitation.getSenderJID();
        if (senderJID == null) {
            return;
        }
        if (senderJID.equals(imHelper.getJIDMyself())) {
            return;
        }
        IncomingCallManager.getInstance().onConfInvitation(invitation);
    }

    protected void sinkIPCWebStartNoLogin() {
        try {
            this.sinkIPCWebStartNoLoginImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkIPCWebStartNoLoginImpl() {
        ZMActivity curActivity = ZMActivity.getFrontActivity();
        if (curActivity instanceof IMActivity && curActivity.isActive()) {
            ((IMActivity)curActivity).loginToUse();
        } else {
            Object context = curActivity != null ? curActivity : VideoBoxApplication.getInstance();
            IMActivity.showLoginToUse((Context)context);
        }
    }

    protected void sinkIPCWebJoinNoConfNo() {
        try {
            this.sinkIPCWebJoinNoConfNoImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkIPCWebJoinNoConfNoImpl() {
        ZMActivity curActivity = ZMActivity.getFrontActivity();
        if (curActivity != null) {
            if (UIMgr.isLargeMode((Context)curActivity)) {
                JoinConfFragment.showJoinByNumber(curActivity.getSupportFragmentManager(), null, null);
            } else {
                JoinConfActivity.showJoinByNumber((Context)curActivity, null, null);
            }
        } else {
            IMHelper imHelper = PTApp.getInstance().getIMHelper();
            if (imHelper == null) {
                return;
            }
            IMActivity.showJoinByNumber((Context)VideoBoxApplication.getInstance());
        }
    }

    protected void sinkIPCWebStartNeedForceUpdate() {
        try {
            this.sinkIPCWebStartNeedForceUpdateImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkIPCWebStartNeedForceUpdateImpl() {
        ZMActivity frontActivity = ZMActivity.getFrontActivity();
        if (frontActivity instanceof IMActivity && frontActivity.isActive()) {
            ForceUpdateDialogFragment.show(frontActivity.getSupportFragmentManager());
        } else {
            IMActivity.showStartCallFailedNeedUpdateOnResume();
            if (frontActivity != null) {
                IMActivity.show((Context)frontActivity);
            } else {
                Intent i = new Intent((Context)VideoBoxApplication.getInstance(), IMActivity.class);
                i.addFlags(0x10020000);
                VideoBoxApplication.getInstance().startActivity(i);
            }
        }
    }

    protected void sinkIPCLoginToClaimHost(int snsType) {
        try {
            this.sinkIPCLoginToClaimHostImpl(snsType);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkIPCLoginToClaimHostImpl(int snsType) {
    }

    protected void sinkIPCConfirmConfLeave(String leaveReason, boolean leaveOrNot, int errorCode) {
        try {
            this.sinkIPCConfirmConfLeaveImpl(leaveReason, leaveOrNot, errorCode);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkIPCConfirmConfLeaveImpl(String leaveReason, boolean leaveOrNot, int errorCode) {
        IListener[] listeners;
        if (leaveReason == null) {
            return;
        }
        int reason = -1;
        try {
            reason = Integer.parseInt(leaveReason);
        }
        catch (NumberFormatException e) {
            return;
        }
        for (IListener l : listeners = this.mConfFailLisenerList.getAll()) {
            ((IConfFailListener)l).onConfFail(reason, errorCode);
        }
    }

    protected void sinkIPCConfCallOutStatusChanged(int status) {
        try {
            this.sinkIPCConfCallOutStatusChangedImpl(status);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkIPCConfCallOutStatusChangedImpl(int status) {
        IListener[] listeners = this.mInviteByCallOutListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IInviteByCallOutListener l = (IInviteByCallOutListener)lTmp;
                l.onCallOutStatusChanged(status);
            }
        }
    }

    public void dispatchCallMeStatusChanged(int status) {
        IListener[] listeners = this.mCallMeListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                ICallMeListener l = (ICallMeListener)lTmp;
                l.onCallMeStatusChanged(status);
            }
        }
    }

    protected void sinkSubscriptionRequest() {
        try {
            this.sinkSubscriptionRequestImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkSubscriptionRequestImpl() {
        IListener[] listeners = this.mIMListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IIMListener l = (IIMListener)lTmp;
                l.onSubscriptionRequest();
            }
        }
    }

    protected void sinkSubscriptionUpdate() {
        try {
            this.sinkSubscriptionUpdateImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkSubscriptionUpdateImpl() {
        IListener[] listeners = this.mIMListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IIMListener l = (IIMListener)lTmp;
                l.onSubscriptionUpdate();
            }
        }
    }

    protected void sinkScheduleMeetingResult(int result, MeetingInfo meetingInfo, String errorMsg) {
        try {
            this.sinkScheduleMeetingResultImpl(result, meetingInfo, errorMsg);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkScheduleMeetingResultImpl(int result, MeetingInfo meetingInfo, String errorMsg) {
        IListener[] listeners = this.mMeetingMgrListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IMeetingMgrListener l = (IMeetingMgrListener)lTmp;
                l.onScheduleMeetingResult(result, meetingInfo, errorMsg);
            }
        }
    }

    protected void sinkListMeetingResult(int result) {
        try {
            this.sinkListMeetingResultImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkListMeetingResultImpl(int result) {
        IListener[] listeners = this.mMeetingMgrListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IMeetingMgrListener l = (IMeetingMgrListener)lTmp;
                l.onListMeetingResult(result);
            }
        }
    }

    protected void sinkListCalendarEventsResult(int result) {
        try {
            this.sinkListCalendarEventsResultImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkListCalendarEventsResultImpl(int result) {
        IListener[] listeners = this.mMeetingMgrListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IMeetingMgrListener l = (IMeetingMgrListener)lTmp;
                l.onListCalendarEventsResult(result);
            }
        }
    }

    protected void sinkUpdateMeetingResult(int result, MeetingInfo meetingInfo, String errorMsg) {
        try {
            this.sinkUpdateMeetingResultImpl(result, meetingInfo, errorMsg);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkUpdateMeetingResultImpl(int result, MeetingInfo meetingInfo, String errorMsg) {
        IListener[] listeners = this.mMeetingMgrListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IMeetingMgrListener l = (IMeetingMgrListener)lTmp;
                l.onUpdateMeetingResult(result, meetingInfo, errorMsg);
            }
        }
    }

    protected void sinkDeleteMeetingResult(int result) {
        try {
            this.sinkDeleteMeetingResultImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkDeleteMeetingResultImpl(int result) {
        IListener[] listeners = this.mMeetingMgrListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IMeetingMgrListener l = (IMeetingMgrListener)lTmp;
                l.onDeleteMeetingResult(result);
            }
        }
    }

    protected void sinkStartFailBeforeLaunch(int result) {
        try {
            this.sinkStartFailBeforeLaunchImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkStartFailBeforeLaunchImpl(int result) {
        IListener[] listeners;
        ZMActivity activity = ZMActivity.getFrontActivity();
        if (activity != null && activity.isActive()) {
            SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(activity.getString(R.string.zm_msg_cannot_start_meeting, new Object[]{result}));
            dialog.show(activity.getSupportFragmentManager(), SimpleMessageDialog.class.getName());
        }
        if ((listeners = this.mMeetingMgrListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IMeetingMgrListener l = (IMeetingMgrListener)lTmp;
                l.onStartFailBeforeLaunch(result);
            }
        }
    }

    protected void sinkPMIEvent(int event, int result, MeetingInfo meetingInfo) {
        try {
            this.sinkPMIEventImpl(event, result, meetingInfo);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkPMIEventImpl(int event, int result, MeetingInfo meetingInfo) {
        IListener[] listeners = this.mMeetingMgrListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IMeetingMgrListener l = (IMeetingMgrListener)lTmp;
                l.onPMIEvent(event, result, meetingInfo);
            }
        }
    }

    protected void sinkSearchDomainUser(String requestID, int result, int contactCount, List<ZoomContact> contacts) {
        try {
            this.sinkSearchDomainUserImpl(requestID, result, contactCount, contacts);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkSearchDomainUserImpl(String requestID, int result, int contactCount, List<ZoomContact> contacts) {
        IListener[] listeners = this.mFavoriteListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IFavoriteListener l = (IFavoriteListener)lTmp;
                l.onFinishSearchDomainUser(requestID, result, contactCount, contacts);
            }
        }
    }

    protected void sinkFavoriteEvent(int event, long result) {
        try {
            this.sinkFavoriteEventImpl(event, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkFavoriteEventImpl(int event, long result) {
        IListener[] listeners = this.mFavoriteListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IFavoriteListener l = (IFavoriteListener)lTmp;
                l.onFavoriteEvent(event, result);
            }
        }
    }

    protected void sinkFavAvatarReady(String userId) {
        try {
            this.sinkFavAvatarReadyImpl(userId);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkFavAvatarReadyImpl(String userId) {
        IListener[] listeners = this.mFavoriteListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IFavoriteListener l = (IFavoriteListener)lTmp;
                l.onFavAvatarReady(userId);
            }
        }
    }

    protected void sinkPhoneABEvent(int event, long result, Object content) {
        try {
            this.sinkPhoneABEventImpl(event, result, content);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkPhoneABEventImpl(int event, long result, Object content) {
        if (event == 1 && result == 0L) {
            ABContactsHelper.setMatchPhoneNumbersCalled(false);
            ABContactsHelper.setAddrBookEnabledDone(false);
        }
        if (event == 0 && result == 0L) {
            VideoBoxApplication.getInstance().enableWakeUpMessagesReceiver(NOSMgr.getInstance().isTCPConnected());
        } else if (event == 1) {
            IMAddrBookListView.clearCaches();
            if (!PTApp.getInstance().isDirectCallAvailable()) {
                VideoBoxApplication.getInstance().enableWakeUpMessagesReceiver(false);
            }
        } else if (event == 3) {
            IMAddrBookListView.clearCaches();
            switch ((int)result) {
                case 0: 
                case 1102: 
                case 1104: {
                    break;
                }
                default: {
                    ABContactsHelper.setLastMatchPhoneNumbersTime(0L);
                }
            }
        }
        IListener[] listeners = this.mPhoneABListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IPhoneABListener l = (IPhoneABListener)lTmp;
                l.onPhoneABEvent(event, result, content);
            }
        }
    }

    protected boolean promptToInputUserNamePasswordForProxyServer(final String proxyHost, final int port, String description) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                PTUI.this.promptToInputUserNamePasswordForProxyServerImpl(proxyHost, port);
            }
        });
        return true;
    }

    private void promptToInputUserNamePasswordForProxyServerImpl(final String proxyHost, final int port) {
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            PromptProxyServerTask task = new PromptProxyServerTask("promptToInputUserNamePasswordForProxyServer"){

                @Override
                public void run() {
                    IntegrationActivity.promptToInputUserNamePasswordForProxyServer((Context)VideoBoxApplication.getInstance(), proxyHost, port);
                }
            };
            PromptProxyServerTaskManager.getInstance().run(task);
            return;
        }
        ForegroundTask task = new ForegroundTask("promptToInputUserNamePasswordForProxyServer"){

            public void run(ZMActivity activity) {
                IntegrationActivity.promptToInputUserNamePasswordForProxyServer((Context)VideoBoxApplication.getInstance(), proxyHost, port);
            }

            public boolean isValidActivity(String activityClass) {
                if (LauncherActivity.class.getName().equals(activityClass)) {
                    return false;
                }
                return super.isValidActivity(activityClass);
            }

            public boolean hasAnotherProcessAtFront() {
                IConfService confService = VideoBoxApplication.getInstance().getConfService();
                if (confService != null) {
                    try {
                        return confService.isConfAppAtFront();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                return false;
            }

            public boolean isMultipleInstancesAllowed() {
                return false;
            }
        };
        ForegroundTaskManager.getInstance().runInForeground(task);
    }

    protected void sinkSDKOnAuth(int result) {
        try {
            this.sinkSDKOnAuthImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkSDKOnAuthImpl(int result) {
        IListener[] listeners = this.mSDKAuthListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                ISDKAuthListener l = (ISDKAuthListener)lTmp;
                l.onSDKAuth(result);
            }
        }
    }

    protected void NotifyZAKRefreshFailed(int result) {
        try {
            this.notifyZAKRefreshFailedImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notifyZAKRefreshFailedImpl(int errCode) {
        IListener[] listeners = this.mNotifyZAKRefreshListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                INotifyZAKListener l = (INotifyZAKListener)lTmp;
                l.notifyZAKRefreshFailed(errCode);
            }
        }
    }

    protected void sinkRoomCallEvent(int event, long result, boolean isActiveMeeting) {
        try {
            this.sinkRoomCallEventImpl(event, result, isActiveMeeting);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkRoomCallEventImpl(int event, long result, boolean isActiveMeeting) {
        IListener[] listeners = this.mRoomCallListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IRoomCallListener l = (IRoomCallListener)lTmp;
                l.onRoomCallEvent(event, result, isActiveMeeting);
            }
        }
        IPCHelper.getInstance().sendRoomSystemCallStatus(event, result, isActiveMeeting);
    }

    protected void sinkOnProfileFieldUpdated(String reqID, int result, int type, String param) {
        try {
            this.sinkOnProfileFieldUpdatedImpl(reqID, result, type, param);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void sinkOnProfileFieldUpdatedImpl(String reqID, int result, int type, String param) {
        IListener[] listeners = this.mProfileListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IProfileListener l = (IProfileListener)lTmp;
                l.OnProfileFieldUpdated(reqID, result, type, param);
            }
        }
    }

    private boolean VTLS_NotifyCertItemVerifyFailed(VerifyCertEvent event) {
        try {
            this.VTLS_NotifyCertItemVerifyFailedImpl(event);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
        return true;
    }

    private void VTLS_NotifyCertItemVerifyFailedImpl(final VerifyCertEvent event) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                PTUI.this.promptVerifyCertFailureConfirmation(event);
            }
        });
    }

    private void promptVerifyCertFailureConfirmation(final VerifyCertEvent event) {
        ForegroundTask task = new ForegroundTask("promptVerifyCertFailureConfirmation"){

            public void run(ZMActivity activity) {
                IntegrationActivity.promptVerifyCertFailureConfirmation(VideoBoxApplication.getInstance(), event);
            }

            public boolean isValidActivity(String activityClass) {
                if (LauncherActivity.class.getName().equals(activityClass)) {
                    return false;
                }
                return super.isValidActivity(activityClass);
            }

            public boolean hasAnotherProcessAtFront() {
                IConfService confService = VideoBoxApplication.getInstance().getConfService();
                if (confService != null) {
                    try {
                        return confService.isConfAppAtFront();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                return false;
            }
        };
        ForegroundTaskManager.getInstance().runInForeground(task);
    }

    public String getLatestMeetingId() {
        return this.mLatestMeetingId;
    }

    public long getLatestMeetingNumber() {
        return this.mLatestMeetingNumber;
    }

    private void onCallStatusChanged(long result) {
        if ((int)result == 2) {
            this.mLatestMeetingId = PTApp.getInstance().getActiveCallId();
            this.mLatestMeetingNumber = PTApp.getInstance().getActiveMeetingNo();
            BOStatusChangeMgrOnPT.getInstance().handleStatusChangeCompeleted();
        }
        this.broadcastCallStatus((int)result);
    }

    private void broadcastCallStatus(int callStatus) {
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        switch (callStatus) {
            case 2: {
                SDKHost.broadcastMeetingStatus((Context)context, 2);
                break;
            }
            case 1: {
                SDKHost.broadcastMeetingStatus((Context)context, 1);
                break;
            }
            default: {
                SDKHost.broadcastMeetingStatus((Context)context, 0);
            }
        }
    }

    public void onJoinConfMeetingStatus(boolean canJoinNow, boolean hasScreenName) {
        IListener[] listeners = this.mJoinConfMeetingStatusListener.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IJoinConfMeetingStatusListener l = (IJoinConfMeetingStatusListener)lTmp;
                l.onJoinConfMeetingStatus(canJoinNow, hasScreenName);
            }
        }
    }

    private long getXmppAutoSignInThreshold() {
        if (this.mXMPPAutoLoginRandomTimeInterval == 0) {
            this.mXMPPAutoLoginRandomTimeInterval = new Random().nextInt(1200000);
        }
        if (NOSMgr.getInstance().isGCMRegistered()) {
            return 0x6DDD00L + (long)this.mXMPPAutoLoginRandomTimeInterval;
        }
        int networkType = NetworkUtil.getDataNetworkType((Context)VideoBoxApplication.getInstance());
        if (networkType == 1 || networkType == 4) {
            return 1200000L + (long)this.mXMPPAutoLoginRandomTimeInterval;
        }
        return 2700000L + (long)this.mXMPPAutoLoginRandomTimeInterval;
    }

    public void startXmppAutoSignInTimer() {
        if (this.mXmppAutoSignInTask != null) {
            return;
        }
        this.mXmppAutoSignInLastCheckTime = System.currentTimeMillis();
        this.mXmppAutoSignInScheduler = Executors.newSingleThreadScheduledExecutor();
        this.mXmppAutoSignInTask = this.mXmppAutoSignInScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                VideoBoxApplication.getInstance().runOnMainThread(PTUI.this.mXmppAutoSignInRunnable);
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    private void stopXmppAutoSignInTimer() {
        if (this.mXmppAutoSignInTask == null) {
            return;
        }
        this.mXmppAutoSignInTask.cancel(false);
        this.mXmppAutoSignInTask = null;
        if (this.mXmppAutoSignInScheduler != null) {
            this.mXmppAutoSignInScheduler.shutdown();
            this.mXmppAutoSignInScheduler = null;
        }
    }

    public static void enableSendFileActivity(boolean enabled) {
        try {
            VideoBoxApplication context = VideoBoxApplication.getInstance();
            ComponentName component = new ComponentName((Context)context, "us.zoom.videomeetings.SendFileActivity");
            context.getPackageManager().setComponentEnabledSetting(component, enabled ? 1 : 2, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private native void nativeInit();

    public static interface INotifyZAKListener
    extends IListener {
        public void notifyZAKRefreshFailed(int var1);
    }

    public static interface IGDPRListener
    extends IListener {
        public void OnShowPrivacyDialog(String var1, String var2);

        public void NotifyUIToLogOut();
    }

    public static interface IAuthHandlerListener
    extends IListener {
        public void onGoogleAuthReturn(String var1, String var2, long var3, String var5);

        public void onFacebookAuthReturn(String var1, long var2, long var4, String var6);
    }

    public static interface IJoinConfMeetingStatusListener
    extends IListener {
        public void onJoinConfMeetingStatus(boolean var1, boolean var2);
    }

    public static interface IRoomCallListener
    extends IListener {
        public void onRoomCallEvent(int var1, long var2, boolean var4);
    }

    public static interface ISDKAuthListener
    extends IListener {
        public void onSDKAuth(int var1);
    }

    public static interface IConfFailListener
    extends IListener {
        public void onConfFail(int var1, int var2);
    }

    public static interface IPhoneABListener
    extends IListener {
        public void onPhoneABEvent(int var1, long var2, Object var4);
    }

    public static interface IFavoriteListener
    extends IListener {
        public void onFavoriteEvent(int var1, long var2);

        public void onFavAvatarReady(String var1);

        public void onFinishSearchDomainUser(String var1, int var2, int var3, List<ZoomContact> var4);
    }

    public static class SimpleMeetingMgrListener
    implements IMeetingMgrListener {
        @Override
        public void onScheduleMeetingResult(int result, MeetingInfo meetingInfo, String errorMsg) {
        }

        @Override
        public void onListMeetingResult(int result) {
        }

        @Override
        public void onListCalendarEventsResult(int result) {
        }

        @Override
        public void onDeleteMeetingResult(int result) {
        }

        @Override
        public void onUpdateMeetingResult(int result, MeetingInfo meetingInfo, String errorMsg) {
        }

        @Override
        public void onStartFailBeforeLaunch(int result) {
        }

        @Override
        public void onPMIEvent(int event, int result, MeetingInfo item) {
        }
    }

    public static class SimplePTUIListener
    implements IPTUIListener {
        @Override
        public void onPTAppEvent(int event, long result) {
        }

        @Override
        public void onDataNetworkStatusChanged(boolean connected) {
        }
    }

    public static class SimpleProfileListener
    implements IProfileListener {
        @Override
        public void OnProfileFieldUpdated(String reqID, int result, int type, String param) {
        }
    }

    public static interface IProfileListener
    extends IListener {
        public void OnProfileFieldUpdated(String var1, int var2, int var3, String var4);
    }

    public static interface ICallMeListener
    extends IListener {
        public void onCallMeStatusChanged(int var1);
    }

    public static interface IInviteByCallOutListener
    extends IListener {
        public void onCallOutStatusChanged(int var1);
    }

    public static interface IMeetingMgrListener
    extends IListener {
        public void onScheduleMeetingResult(int var1, MeetingInfo var2, String var3);

        public void onListMeetingResult(int var1);

        public void onListCalendarEventsResult(int var1);

        public void onDeleteMeetingResult(int var1);

        public void onUpdateMeetingResult(int var1, MeetingInfo var2, String var3);

        public void onStartFailBeforeLaunch(int var1);

        public void onPMIEvent(int var1, int var2, MeetingInfo var3);
    }

    public static interface IConfInvitationListener
    extends IListener {
        public void onConfInvitation(PTAppProtos.InvitationItem var1);

        public void onCallAccepted(PTAppProtos.InvitationItem var1);

        public void onCallDeclined(PTAppProtos.InvitationItem var1);
    }

    public static interface IIMListener
    extends IListener {
        public void onIMLocalStatusChanged(int var1);

        public void onIMReceived(PTAppProtos.IMMessage var1);

        public void onIMBuddyPresence(PTAppProtos.BuddyItem var1);

        public void onIMBuddyPic(PTAppProtos.BuddyItem var1);

        public void onIMBuddySort();

        public void onSubscriptionRequest();

        public void onSubscriptionUpdate();

        public void onQuerySSOVanityURL(String var1, int var2, String var3);

        public void onQueryIPLocation(int var1, PTAppProtos.IPLocationInfo var2);
    }

    public static interface IPTUIListener
    extends IListener {
        public void onPTAppEvent(int var1, long var2);

        public void onDataNetworkStatusChanged(boolean var1);
    }
}

