/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.PreferenceUtil;

public class PTSettingHelper {
    private static final String TAG = PTSettingHelper.class.getSimpleName();
    private long mNativeHandle = 0L;

    public static int getShowChatMessageReminder() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return 0;
        }
        boolean block3rdIM = !settingHelper.getShowIMMessageReminder();
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return block3rdIM ? 2 : 5;
        }
        int type = messenger.blockAll_Get();
        if (type == 0 || type == 1) {
            return block3rdIM ? 2 : 5;
        }
        return type;
    }

    public static boolean saveShowChatMessageReminder(int type) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        return messenger.blockAll_Set(type);
    }

    public PTSettingHelper(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public void setGeneralSettings(long settings) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        this.setGeneralSettingsImpl(this.mNativeHandle, settings);
    }

    public long getGeneralSettings() {
        if (this.mNativeHandle == 0L) {
            return 0L;
        }
        return this.getGeneralSettingsImpl(this.mNativeHandle);
    }

    public void setShowIMMessageReminder(boolean show) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        this.setShowIMMessageReminderImpl(this.mNativeHandle, show);
    }

    public boolean getShowIMMessageReminder() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.getShowIMMessageReminderImpl(this.mNativeHandle);
    }

    public boolean setDriveMode(boolean driveMode) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.setDriveModeImpl(this.mNativeHandle, driveMode);
    }

    public boolean isDriveModeSettingOn() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isDriveModeSettingOnImpl(this.mNativeHandle);
    }

    public void setAlwaysUseVoIPWhenJoinMeeting(boolean bOn) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        this.setAlwaysUseVoIPWhenJoinMeetingImpl(this.mNativeHandle, bOn);
    }

    public boolean alwaysUseVoIPWhenJoinMeeting() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.alwaysUseVoIPWhenJoinMeetingImpl(this.mNativeHandle);
    }

    public boolean getShowOfflineBuddies() {
        return true;
    }

    public void saveShowOfflineBuddies(boolean show) {
        PreferenceUtil.saveBooleanValue("show_offline_user", show);
    }

    public static boolean getPlayAlertSound() {
        return PreferenceUtil.readBooleanValue("play_alert_sound", true);
    }

    public void savePlayAlertSound(boolean b) {
        PreferenceUtil.saveBooleanValue("play_alert_sound", b);
    }

    public static boolean getPlayAlertVibrate() {
        return PreferenceUtil.readBooleanValue("play_alert_vibrate", true);
    }

    public void savePlayAlertVibrate(boolean b) {
        PreferenceUtil.saveBooleanValue("play_alert_vibrate", b);
    }

    public void setNeverStartVideoWhenJoinMeeting(boolean bOn) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        this.setNeverStartVideoWhenJoinMeetingImpl(this.mNativeHandle, bOn);
    }

    public boolean neverStartVideoWhenJoinMeeting() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.neverStartVideoWhenJoinMeetingImpl(this.mNativeHandle);
    }

    public void setAlwaysMuteMicWhenJoinVoIP(boolean bOn) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        this.setAlwaysMuteMicWhenJoinVoIPImpl(this.mNativeHandle, bOn);
    }

    public boolean alwaysMuteMicWhenJoinVoIP() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.alwaysMuteMicWhenJoinVoIPImpl(this.mNativeHandle);
    }

    public boolean getIsKubiDeviceEnabled() {
        return PreferenceUtil.readBooleanValue("enable_kubi_device", false);
    }

    public void saveIsKubiDeviceEnabled(boolean b) {
        PreferenceUtil.saveBooleanValue("enable_kubi_device", b);
    }

    public static boolean isImLlinkPreviewDescription() {
        return PreferenceUtil.readBooleanValue("im_link_preview_description", true);
    }

    public static void saveImLlinkPreviewDescription(boolean b) {
        PreferenceUtil.saveBooleanValue("im_link_preview_description", b);
    }

    private native void setGeneralSettingsImpl(long var1, long var3);

    private native long getGeneralSettingsImpl(long var1);

    private native boolean getShowIMMessageReminderImpl(long var1);

    private native void setShowIMMessageReminderImpl(long var1, boolean var3);

    private native boolean setDriveModeImpl(long var1, boolean var3);

    private native boolean isDriveModeSettingOnImpl(long var1);

    private native void setAlwaysUseVoIPWhenJoinMeetingImpl(long var1, boolean var3);

    private native boolean alwaysUseVoIPWhenJoinMeetingImpl(long var1);

    private native void setNeverStartVideoWhenJoinMeetingImpl(long var1, boolean var3);

    private native boolean neverStartVideoWhenJoinMeetingImpl(long var1);

    private native void setAlwaysMuteMicWhenJoinVoIPImpl(long var1, boolean var3);

    private native boolean alwaysMuteMicWhenJoinVoIPImpl(long var1);
}

