/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.os.RemoteException;
import com.zipow.videobox.IConfService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.ConfProcessMgr;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.NumberUtil;

public class PTIPCPort {
    private static final String TAG = PTIPCPort.class.getSimpleName();
    private static PTIPCPort instance = null;
    private long mNativeHandle = 0L;
    private List<byte[]> mSendMessageBuff = new ArrayList<byte[]>();
    private List<byte[]> mReceiveMessageBuff = new ArrayList<byte[]>();

    private PTIPCPort() {
    }

    public static synchronized PTIPCPort getInstance() {
        if (instance == null) {
            instance = new PTIPCPort();
        }
        return instance;
    }

    public void initialize() {
        this.nativeInit();
    }

    public boolean sendMessage(byte[] message) {
        if (message == null) {
            return false;
        }
        IConfService confService = VideoBoxApplication.getInstance().getConfService();
        if (confService == null) {
            this.mSendMessageBuff.add(message);
            return false;
        }
        boolean success = true;
        try {
            this.sendBufferedMessages(confService);
            this.sendMessageImpl(message, confService);
        }
        catch (Exception e) {
            this.mSendMessageBuff.add(message);
            success = false;
        }
        return success;
    }

    public void sendBufferedMessages() {
        IConfService confService = VideoBoxApplication.getInstance().getConfService();
        if (confService == null) {
            return;
        }
        try {
            this.sendBufferedMessages(confService);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void sendBufferedMessages(IConfService confService) throws RemoteException {
        if (this.mSendMessageBuff.size() > 0) {
            for (int i = 0; i <= this.mSendMessageBuff.size() - 1; ++i) {
                byte[] msgTmp = this.mSendMessageBuff.get(i);
                this.sendMessageImpl(msgTmp, confService);
            }
            this.mSendMessageBuff.clear();
        }
    }

    public synchronized void onMessageReceived(byte[] message) {
        int curConfPid;
        if (message == null || message.length <= 4) {
            return;
        }
        int pid = NumberUtil.byteArrayToInt((byte[])message, (int)0);
        if (pid != (curConfPid = ConfProcessMgr.getInstance().getCurrentConfProcessId())) {
            return;
        }
        if (this.mNativeHandle == 0L) {
            this.mReceiveMessageBuff.add(message);
            return;
        }
        try {
            this.onMessageReceivedImpl(this.mNativeHandle, message, 4);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public synchronized void setNativeHandle(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        if (this.mNativeHandle != 0L) {
            this.receiveBufferedMessages();
        }
    }

    private void receiveBufferedMessages() {
        if (this.mReceiveMessageBuff.size() > 0) {
            int curConfPid = ConfProcessMgr.getInstance().getCurrentConfProcessId();
            for (byte[] message : this.mReceiveMessageBuff) {
                int pid = NumberUtil.byteArrayToInt((byte[])message, (int)0);
                if (pid != curConfPid) continue;
                try {
                    this.onMessageReceivedImpl(this.mNativeHandle, message, 4);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            }
            this.mReceiveMessageBuff.clear();
        }
    }

    private void sendMessageImpl(byte[] message, IConfService confService) throws RemoteException {
        try {
            int pid = ConfProcessMgr.getInstance().getCurrentConfProcessId();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(NumberUtil.intToByteArray((int)pid));
            os.write(message);
            byte[] buff = os.toByteArray();
            os.close();
            confService.sendMessage(buff);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private native void nativeInit();

    private native void onMessageReceivedImpl(long var1, byte[] var3, int var4);
}

