/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.zipow.videobox.CmmSavedMeeting;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.AlterHost;
import com.zipow.videobox.ptapp.FBAuthHelper;
import com.zipow.videobox.ptapp.FavoriteMgr;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTAppAPI4SDKSinkUI;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTBuddyHelper;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.ptapp.PT_LOGIN_TYPE;
import com.zipow.videobox.ptapp.UrlActionData;
import com.zipow.videobox.ptapp.UrlActionInfo;
import com.zipow.videobox.ptapp.VerifyCertEvent;
import com.zipow.videobox.ptapp.ZoomProductHelper;
import com.zipow.videobox.ptapp.mm.CrawlerLinkPreview;
import com.zipow.videobox.ptapp.mm.FileInfoChecker;
import com.zipow.videobox.ptapp.mm.GroupMemberSynchronizer;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.MMPrivateStickerMgr;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.ptapp.mm.UnSupportMessageMgr;
import com.zipow.videobox.ptapp.mm.ZoomMessageTemplate;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.sip.CallHistoryMgr;
import com.zipow.videobox.sip.SIPConfiguration;
import com.zipow.videobox.util.BuildTarget;
import com.zipow.videobox.util.PreferenceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;
import us.zoom.videomeetings.ZMBuildConfig;

public class PTApp {
    private static final String TAG = PTApp.class.getSimpleName();
    private static PTApp instance = null;
    private IMHelper mIMHelper;
    private boolean mWebSignedOn = false;
    private boolean mTokenExpired = false;
    private boolean mNeedSwitchVendor = true;
    private long mLastUpdateNotesDisplayTime = 0L;

    private PTApp() {
    }

    public static synchronized PTApp getInstance() {
        if (instance == null) {
            instance = new PTApp();
        }
        return instance;
    }

    public void initialize() {
    }

    public boolean autoSignin() {
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            return false;
        }
        if (this.isAuthenticating()) {
            return true;
        }
        if (BuildTarget.isRingCentralLogin(ZMBuildConfig.BUILD_TARGET)) {
            if (this.getPTLoginType() == 98) {
                int res = this.loginRingCentralWithLocalToken();
                return res == 0;
            }
            return false;
        }
        if (this.getPTLoginType() == 2) {
            int res = this.loginGoogleWithLocalToken();
            return res == 0;
        }
        if (this.getPTLoginType() == 0) {
            int res = this.loginFacebookWithLocalToken();
            return res == 0;
        }
        if (this.getPTLoginType() == 100) {
            int res = this.loginZoomWithLocalToken();
            return res == 0;
        }
        if (this.getPTLoginType() == 101) {
            int res = this.loginSSOWithLocalToken();
            return res == 0;
        }
        return false;
    }

    public void setTokenExpired(boolean expired) {
        this.mTokenExpired = expired;
    }

    public boolean isTokenExpired() {
        return this.mTokenExpired;
    }

    public void setmNeedSwitchVendor(boolean mNeedSwitchVendor) {
        this.mNeedSwitchVendor = mNeedSwitchVendor;
    }

    public boolean ismNeedSwitchVendor() {
        return this.mNeedSwitchVendor;
    }

    public boolean isAuthenticating() {
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            return false;
        }
        return this.isAuthenticatingImpl();
    }

    public boolean isWebSignedOn() {
        return this.mWebSignedOn;
    }

    public void setWebSignedOn(boolean signedOn) {
        this.mWebSignedOn = signedOn;
    }

    public void forceLeaveCurrentCall() {
        String activeCallId = this.getActiveCallId();
        if (activeCallId != null && activeCallId.length() > 0) {
            this.stopGroupVideoCall(activeCallId, String.valueOf(0));
        }
        VideoBoxApplication app = VideoBoxApplication.getInstance();
        int times = 0;
        while (app.isConfProcessRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (++times <= 20) continue;
            app.stopConfService();
            return;
        }
        app.stopConfService();
    }

    public void tryEndCallForDeclined() {
        String activeCallId = this.getActiveCallId();
        if (activeCallId != null && activeCallId.length() > 0) {
            this.stopGroupVideoCall(activeCallId, String.valueOf(38));
        }
    }

    public PTBuddyHelper getBuddyHelper() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = this.getBuddyHelperHandle();
        if (nativeHandle != 0L) {
            return new PTBuddyHelper(nativeHandle);
        }
        return null;
    }

    public PTUserProfile getCurrentUserProfile() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = this.getCurrentUserProfileHandle();
        if (nativeHandle != 0L) {
            return new PTUserProfile(nativeHandle);
        }
        return null;
    }

    public FBAuthHelper getFBAuthHelper() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = this.getFBAuthHelperHandle();
        if (nativeHandle != 0L) {
            return new FBAuthHelper(nativeHandle);
        }
        return null;
    }

    public IMHelper getIMHelper() {
        long nativeHandle;
        if (!this.isInitialForMainboard()) {
            return null;
        }
        if (this.mIMHelper == null && (nativeHandle = this.getIMHelperHandle()) != 0L) {
            this.mIMHelper = new IMHelper(nativeHandle);
        }
        return this.mIMHelper;
    }

    public PTSettingHelper getSettingHelper() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = this.getSettingHelperHandle();
        if (nativeHandle != 0L) {
            return new PTSettingHelper(nativeHandle);
        }
        return null;
    }

    public MeetingHelper getMeetingHelper() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = this.getMeetingHelperHandle();
        if (nativeHandle != 0L) {
            return new MeetingHelper(nativeHandle);
        }
        return null;
    }

    public FavoriteMgr getFavoriteMgr() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = this.getFavoriteMgrHandle();
        if (nativeHandle != 0L) {
            return new FavoriteMgr(nativeHandle);
        }
        return null;
    }

    public ABContactsHelper getABContactsHelper() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = this.getABContactsHelperHandle();
        if (nativeHandle != 0L) {
            return new ABContactsHelper(nativeHandle);
        }
        return null;
    }

    public ZoomMessenger getZoomMessenger() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = 0L;
        nativeHandle = this.getBusinessMessengerHandle();
        if (nativeHandle != 0L) {
            return new ZoomMessenger(nativeHandle);
        }
        return null;
    }

    public boolean hasZoomMessenger() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.hasBusinessMessengerImpl();
    }

    public boolean hasContacts() {
        return this.hasMessenger();
    }

    public boolean hasMessenger() {
        return PTApp.getInstance().hasZoomMessenger() || this.isFacebookImEnabled() || this.isGoogleImEnabled();
    }

    public ZoomProductHelper getZoomProductHelper() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = this.getZoomProductHelperHandle();
        if (nativeHandle != 0L) {
            return new ZoomProductHelper(nativeHandle);
        }
        return null;
    }

    public GroupMemberSynchronizer getGroupMemberSynchronizer() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = this.getGroupMemberSynchronizerHandle();
        if (nativeHandle != 0L) {
            return new GroupMemberSynchronizer(nativeHandle);
        }
        return null;
    }

    public ZoomMessageTemplate getZoomMessageTemplate() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = this.getZoomMessageTemplateHandle();
        if (nativeHandle != 0L) {
            return new ZoomMessageTemplate(nativeHandle);
        }
        return null;
    }

    public void dispatchIdleMessage() {
        Mainboard mainboard;
        this.dispatchIdleMessageImpl();
        if (VideoBoxApplication.getInstance().isSDKMode() && (mainboard = Mainboard.getMainboard()) != null && mainboard.isInitialized()) {
            mainboard.heartBeatForSDK();
        }
    }

    public void loginXmppServer(String accessToken) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)accessToken)) {
            return;
        }
        this.loginXmppServerImpl(accessToken);
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper != null) {
            imHelper.setIMLocalStatus(1);
        }
    }

    public void loginWithFacebook(String accessToken, long tokenExpiresInSeconds) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)accessToken)) {
            return;
        }
        this.loginWithFacebookImpl(accessToken, tokenExpiresInSeconds, false);
    }

    public void loginWithFacebook(String accessToken, long tokenExpiresInSeconds, boolean acceptedTos) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)accessToken)) {
            return;
        }
        this.loginWithFacebookImpl(accessToken, tokenExpiresInSeconds, acceptedTos);
    }

    public void loginWithFacebookWithToken(String accessToken, long tokenExpiresInSeconds) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)accessToken)) {
            return;
        }
        this.loginFacebookWithTokenImpl(accessToken, tokenExpiresInSeconds);
    }

    public int loginFacebookWithLocalToken() {
        return this.loginFacebookWithLocalToken(false);
    }

    public int loginFacebookWithLocalToken(boolean bLoginIMOnly) {
        IMHelper imHelper;
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        int res = this.loginFacebookWithLocalTokenImpl(bLoginIMOnly, false);
        if (res == 0 && (imHelper = PTApp.getInstance().getIMHelper()) != null) {
            imHelper.setIMLocalStatus(1);
        }
        return res;
    }

    public boolean logout(int logoutOption) {
        return this.logout(logoutOption, true);
    }

    public boolean logout(int logoutOption, boolean isNeedSwitchVendor) {
        String avatar;
        if (!this.isInitialForMainboard()) {
            return false;
        }
        this.mNeedSwitchVendor = isNeedSwitchVendor;
        boolean res = this.logoutImpl(logoutOption);
        this.setWebSignedOn(false);
        this.setTokenExpired(false);
        IMHelper imHelper = this.getIMHelper();
        if (imHelper != null) {
            imHelper.setIMLocalStatus(0);
        }
        if ((avatar = PreferenceUtil.readStringValue("local_avatar", "")).length() > 0) {
            PreferenceUtil.saveStringValue("local_avatar", "");
        }
        return res;
    }

    public void resetForReconnecting() {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.resetForReconnectingImpl();
    }

    public boolean joinFromIconTray(String userName, String vanityUrl, long meetingNumber, String pwd, boolean noAudio, boolean noVideo) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (userName == null) {
            userName = "";
        }
        if (pwd == null) {
            pwd = "";
        }
        return this.joinFromIconTrayImpl(userName, vanityUrl, meetingNumber, pwd, noAudio, noVideo);
    }

    public int inviteToVideoCall(String jid, String invitationMsgTemplate, int confType) {
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        return this.inviteToVideoCallImpl(jid, invitationMsgTemplate, confType);
    }

    public int acceptVideoCall(PTAppProtos.InvitationItem invitation, String invitationMsgTemplate, boolean isAutoAccept) {
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        if (invitation == null) {
            return 1;
        }
        return this.acceptVideoCallImpl(invitation.toByteArray(), invitationMsgTemplate, isAutoAccept);
    }

    public int declineVideoCall(PTAppProtos.InvitationItem invitation, String invitationMsgTemplate) {
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        if (invitation == null) {
            return 1;
        }
        return this.declineVideoCallImpl(invitation.toByteArray(), invitationMsgTemplate);
    }

    public int startGroupVideoCall(String[] buddyJids, String[] emails, String invitationMsgTemplate) {
        return this.startGroupVideoCall(buddyJids, emails, invitationMsgTemplate, 0L, 3);
    }

    public int startGroupVideoCall(String[] buddyJids, String[] emails, String invitationMsgTemplate, long meetingNo, int confType) {
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        if (buddyJids == null) {
            buddyJids = new String[]{};
        }
        if (emails == null) {
            emails = new String[]{};
        }
        return this.startGroupVideoCallImpl(buddyJids, emails, invitationMsgTemplate, meetingNo, confType);
    }

    public int inviteBuddiesToConf(String[] buddyJids, String[] emails, String meetingId, long meetingNum, String invitationMsgTemplate) {
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        if (buddyJids == null) {
            buddyJids = new String[]{};
        }
        if (emails == null) {
            emails = new String[]{};
        }
        return this.inviteBuddiesToConfImpl(buddyJids, emails, meetingId, meetingNum, invitationMsgTemplate);
    }

    public String getActiveCallId() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getActiveCallIdImpl();
    }

    public long getActiveMeetingNo() {
        if (!this.isInitialForMainboard()) {
            return 0L;
        }
        return this.getActiveMeetingNoImpl();
    }

    public MeetingInfo getActiveMeetingItem() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getActiveMeetingItemImpl();
    }

    public int getCallStatus() {
        if (!this.isInitialForMainboard()) {
            return 0;
        }
        int callStatus = this.getCallStatusImpl();
        if (callStatus == 0 && (VideoBoxApplication.getInstance().getConfProcessId() > 0 || VideoBoxApplication.getInstance().getConfService() != null)) {
            callStatus = 1;
        }
        return callStatus;
    }

    public boolean hasActiveCall() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        int callStatus = this.getCallStatus();
        return callStatus == 2 || callStatus == 1;
    }

    public int stopGroupVideoCall(String meetingId, String reason) {
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        if (meetingId == null) {
            return 1;
        }
        if (reason == null) {
            reason = "";
        }
        return this.stopGroupVideoCallImpl(meetingId, reason);
    }

    public boolean probeUserStatus(String jid) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        return this.probeUserStatusImpl(jid);
    }

    public String parseConfNumberFromURLAction(String urlAction) {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        UrlActionData data = this.parseURLActionData(urlAction);
        if (data != null) {
            return data.getConfno();
        }
        return "";
    }

    public UrlActionData parseURLActionData(String urlAction) {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.parseURLActionDataImpl(urlAction);
    }

    public boolean parseAppProtocol(UrlActionInfo urlActionInfo, String url, boolean curr_host_is_cn) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.parseAppProtocolImpl(urlActionInfo, url, curr_host_is_cn);
    }

    public boolean validateConfNumber(String confNumber) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.validateConfNumberImpl(confNumber);
    }

    public boolean sendFeedback(String feedback) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.sendFeedbackImpl(feedback);
    }

    public String getRecentJid() {
        String jid = PreferenceUtil.readStringValue("recent_jid", null);
        return jid;
    }

    public void setRencentJid(String jid) {
        PreferenceUtil.saveStringValue("recent_jid", jid);
    }

    public String getRecentZoomJid() {
        String jid = PreferenceUtil.readStringValue("recent_zoom_jid", null);
        return jid;
    }

    public void setRencentZoomJid(String jid) {
        PreferenceUtil.saveStringValue("recent_zoom_jid", jid);
    }

    public int loginGoogleWithCodes(String authCode, String refreshCode) {
        IMHelper imHelper;
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        int res = this.loginGoogleWithTokensImpl(authCode, refreshCode);
        if (res == 0 && (imHelper = PTApp.getInstance().getIMHelper()) != null) {
            imHelper.setIMLocalStatus(1);
        }
        return res;
    }

    public int loginGoogleWithLocalToken() {
        IMHelper imHelper;
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        int res = this.loginGoogleWithLocalTokenImpl();
        if (res == 0 && (imHelper = PTApp.getInstance().getIMHelper()) != null) {
            imHelper.setIMLocalStatus(1);
        }
        return res;
    }

    public int getPTLoginType() {
        if (!this.isInitialForMainboard()) {
            return 102;
        }
        return this.getPTLoginTypeImpl();
    }

    public boolean isCurrentLoginTypeSupportFavoriteContacts() {
        ZoomProductHelper productHelper;
        if (ZMBuildConfig.BUILD_TARGET != 0) {
            return false;
        }
        int loginType = this.getPTLoginType();
        if (loginType == 100 && (productHelper = PTApp.getInstance().getZoomProductHelper()) != null && 1 == productHelper.getCurrentVendor()) {
            return false;
        }
        return PT_LOGIN_TYPE.isTypeSupportFavoriteContacts(loginType);
    }

    public boolean isKeepMeLoggedIn() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isKeepMeLoggedInImpl();
    }

    public int retryLoginGoogle() {
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        return this.retryLoginGoogleImpl();
    }

    public int loginZoom(String email, String password, boolean rememberMe) {
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        return this.loginZoomImpl(email, password, rememberMe);
    }

    public int loginZoomWithLocalToken() {
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        return this.loginZoomWithLocalTokenImpl();
    }

    public void nos_SetDeviceToken(final String token, final String deviceId) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (Mainboard.getMainboard() == null || !Mainboard.getMainboard().isInitialized()) {
                    return;
                }
                PTApp.this.nosSetDeviceTokenImpl(token == null ? "" : token, deviceId == null ? "" : deviceId);
            }
        });
    }

    public boolean nos_UpdateDeviceToken(String token, String deviceId, String userId) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (token == null) {
            token = "";
        }
        if (deviceId == null) {
            deviceId = "";
        }
        if (userId == null) {
            userId = "";
        }
        return this.nosUpdateDeviceTokenImpl(token, deviceId, userId);
    }

    public boolean nos_NotificationReceived(String caption, String body) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (caption == null) {
            caption = "";
        }
        if (body == null) {
            body = "";
        }
        return this.nosNotificationReceivedImpl(caption, body);
    }

    public boolean nos_MessageNotificationReceived(int msgType, String body, String senderID, String senderName) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (body == null) {
            body = "";
        }
        if (senderID == null) {
            senderID = "";
        }
        if (senderName == null) {
            senderName = "";
        }
        return this.nosMessageNotificationReceivedImpl(msgType, body, senderID, senderName);
    }

    public boolean nos_ClearDeviceToken() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.nosClearDeviceTokenImpl();
    }

    public boolean needDoWebStart() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        boolean need = this.needDoWebStartImpl();
        return need;
    }

    public int launchCallForWebStart() {
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        int ret = this.launchCallForWebStartImpl();
        return ret;
    }

    public boolean canAccessZoomWebservice() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.canAccessZoomWebserviceImpl();
    }

    public boolean hasPrescheduleMeeting() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.hasPrescheduleMeetingImpl();
    }

    public String getZoomInvitationEmailSubject() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getZoomInvitationEmailSubjectImpl();
    }

    public String getZoomInvitationEmailBody() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getZoomInvitationEmailBodyImpl();
    }

    public boolean signup(String firstName, String lastName, String email, String password) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)firstName) || StringUtil.isEmptyOrNull((String)lastName) || StringUtil.isEmptyOrNull((String)email)) {
            return false;
        }
        if (password == null) {
            password = "";
        }
        return this.signupImpl(firstName, lastName, email, password);
    }

    public boolean sendActivationEmail(String firstName, String lastName, String email) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)firstName) || StringUtil.isEmptyOrNull((String)lastName) || StringUtil.isEmptyOrNull((String)email)) {
            return false;
        }
        return this.sendActivationEmailImpl(firstName, lastName, email);
    }

    public boolean forgotPassword(String email) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)email)) {
            return false;
        }
        return this.forgotPasswordImpl(email);
    }

    public boolean setPassword(boolean reset, String email, String password, String securityCode) {
        return this.setPassword(reset, email, password, securityCode, null, null);
    }

    public boolean setPassword(boolean reset, String email, String password, String securityCode, String firstName, String lastName) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)password) || StringUtil.isEmptyOrNull((String)email) || StringUtil.isEmptyOrNull((String)securityCode)) {
            return false;
        }
        if (firstName == null) {
            firstName = "";
        }
        if (lastName == null) {
            lastName = "";
        }
        return this.setPasswordImpl(reset, email, password, securityCode, firstName, lastName);
    }

    public boolean isCurrentLoginTypeSupportIM() {
        return PTApp.getInstance().isFacebookImEnabled() || PTApp.getInstance().isGoogleImEnabled();
    }

    public boolean isCurrentLoginTypeSupportMyMeetings() {
        return PT_LOGIN_TYPE.isTypeSupportMyMeetings(this.getPTLoginType());
    }

    public boolean isCurrentLoginTypeSupportMyProfileWebPage() {
        return PT_LOGIN_TYPE.isTypeSupportMyProfileWebPage(this.getPTLoginType());
    }

    public boolean isDirectCallAvailable() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.hasMessenger();
    }

    public String getRegisteredPhoneNumber() {
        ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
        if (contactsHelper != null) {
            return contactsHelper.getVerifiedPhoneNumber();
        }
        return null;
    }

    public boolean isPhoneNumberRegistered() {
        return !StringUtil.isEmptyOrNull((String)this.getRegisteredPhoneNumber());
    }

    public boolean startMeeting(long meetingNo) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.startMeetingImpl(meetingNo);
    }

    public void startScheduleConfirm(long meetingNo, boolean join) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.startScheduleConfirmImpl(meetingNo, join);
    }

    public PTAppProtos.ZoomAccount getSavedZoomAccount() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        byte[] data = this.getSavedZoomAccountDataImpl();
        if (data == null) {
            return null;
        }
        PTAppProtos.ZoomAccount account = null;
        try {
            account = PTAppProtos.ZoomAccount.parseFrom(data);
            if (StringUtil.isEmptyOrNull((String)account.getUserName()) || StringUtil.isEmptyOrNull((String)account.getToken())) {
                return null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return account;
    }

    public void userInputUsernamePasswordForProxy(String proxyHost, int port, String uname, String password, boolean cancel) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.userInputUsernamePasswordForProxyImpl(proxyHost, port, uname, password, cancel);
    }

    public int getAuthInfo(int type, String server, int port, String[] uname, String[] psw) {
        if (!this.isInitialForMainboard()) {
            return 0;
        }
        if (StringUtil.isEmptyOrNull((String)server) || port <= 0 || uname == null || uname.length == 0 || psw == null || psw.length == 0) {
            return 0;
        }
        return this.getAuthInfoImpl(type, server, port, uname, psw);
    }

    public int navWebWithDefaultBrowser(int type, String url) {
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        if (url == null) {
            url = "";
        }
        return this.navWebWithDefaultBrowserImpl(type, url);
    }

    public int loginWithSSOToken(String ssoToken) {
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        if (ssoToken == null) {
            return 1;
        }
        return this.loginWithSSOTokenImpl(ssoToken);
    }

    public int loginSSOWithLocalToken() {
        if (!this.isInitialForMainboard()) {
            return 1;
        }
        return this.loginSSOWithLocalTokenImpl();
    }

    public String getSSOURL() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getSSOURLImpl();
    }

    public void setSSOURL(String url) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        if (url == null) {
            url = "";
        }
        this.setSSOURLImpl(url);
    }

    public String getLatestVersionString() {
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            return "";
        }
        return this.getLatestVersionStringImpl();
    }

    public String getLatestVersionReleaseNote() {
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            return "";
        }
        return this.getLatestVersionReleaseNoteImpl();
    }

    public void setLastUpdateNotesDisplayTime(long time) {
        this.mLastUpdateNotesDisplayTime = time;
    }

    public long getLastUpdateNotesDisplayTime() {
        return this.mLastUpdateNotesDisplayTime;
    }

    public boolean checkForUpdates(boolean resetLastUpdateNoteDisplayTime) {
        return this.checkForUpdates(resetLastUpdateNoteDisplayTime, false);
    }

    public boolean checkForUpdates(boolean resetLastUpdateNoteDisplayTime, boolean forceReCheck) {
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            return false;
        }
        if (resetLastUpdateNoteDisplayTime) {
            this.setLastUpdateNotesDisplayTime(0L);
        }
        return this.checkForUpdatesImpl(forceReCheck);
    }

    public void setDeviceUserName(String name) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        PreferenceUtil.saveBooleanValue("is_device_name_customized", true);
        this.setDeviceUserNameImpl(name);
    }

    public String getDeviceUserName() {
        if (!this.isInitialForMainboard()) {
            return "";
        }
        return this.getDeviceUserNameImpl();
    }

    public void logUICommand(String uiContainer, String action, String param) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.logUICommandImpl(uiContainer, action, param);
    }

    public boolean user_UploadMyPicture(String path) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.userUploadMyPictureImpl(path);
    }

    public boolean user_UpdateMyName(String first, String last) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.userUpdateMyNameImpl(first, last);
    }

    public int getAltHostCount() {
        if (!this.isInitialForMainboard()) {
            return 0;
        }
        return this.getAltHostCountImpl();
    }

    public AlterHost getAltHostAt(int idx) {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getAltHostAtImpl(idx);
    }

    public boolean isPaidUser() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isPaidUserImpl();
    }

    public int getMaxChatGroupBuddyNumber() {
        if (this.isPaidUser()) {
            return 2000;
        }
        return 200;
    }

    public String getVendorRegion() {
        String vendorRegion = null;
        ZoomProductHelper productHelper = this.getZoomProductHelper();
        if (productHelper != null && productHelper.getCurrentVendor() == 1) {
            vendorRegion = Locale.CHINA.getCountry();
        }
        return vendorRegion;
    }

    public String getRegionCodeForNameFormating() {
        if (ZMBuildConfig.BUILD_TARGET == 0) {
            return this.getVendorRegion();
        }
        return ResourcesUtil.getString((Context)VideoBoxApplication.getInstance(), (int)R.string.zm_config_region_code_for_name_formating);
    }

    public String getPackageCheckSum() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getPackageCheckSumImpl();
    }

    public String getPackageDownloadUrl() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getPackageDownloadUrlImpl();
    }

    public String getPackageName() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getPackageNameImpl();
    }

    public boolean isCallOutInProgress(int[] status) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (status == null || status.length == 0) {
            status = new int[1];
        }
        return this.isCallOutInProgressImpl(status);
    }

    public int getCallOutStatus() {
        int[] status = new int[1];
        this.isCallOutInProgress(status);
        return status[0];
    }

    public boolean inviteCallOutUser(String callOutNumber, String userName) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)callOutNumber)) {
            return false;
        }
        if (userName == null) {
            userName = "";
        }
        return this.inviteCallOutUserImpl(callOutNumber, userName);
    }

    public boolean cancelCallOut() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.cancelCallOutImpl();
    }

    public boolean isFeedbackOff() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isFeedbackOffImpl();
    }

    public boolean isCNMeetingON() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isCNMeetingONImpl();
    }

    public String getURLByType(int navWebType) {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getURLByTypeImpl(navWebType);
    }

    public String getMyName() {
        String name = "";
        PTUserProfile profile = this.getCurrentUserProfile();
        if (profile != null) {
            return profile.getUserName();
        }
        return name;
    }

    public String getZoomDomain() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getZoomDomainImpl();
    }

    public void configZoomDomain(String domain) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.configZoomDomainImpl(domain);
    }

    public boolean sdk_Auth(String appKey, String appSecret) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.sdkAuthImpl(appKey, appSecret);
    }

    public boolean isSdkNeedWaterMark() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isSdkNeedWaterMarkImpl();
    }

    public boolean isSdkEnableCustomizedUI() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isSdkEnableCustomizedUIImpl();
    }

    public int getSdkAuthResult() {
        if (!this.isInitialForMainboard()) {
            return -1;
        }
        return this.getSdkAuthResultImpl();
    }

    public void configSdkDSCP(int audio, int video, boolean reset) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.configSDKDSCPImpl(audio, video, reset);
    }

    public void enableHideFullPhoneNumber4PureCallinUser(boolean bHide) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.enableHideFullPhoneNumber4PureCallinUserImpl(bHide);
    }

    public void setPTAppAPI4SDKSink(PTAppAPI4SDKSinkUI pSink) {
        if (pSink == null) {
            return;
        }
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.setPTAppAPI4SDKSinkImpl(pSink.getNativeHandle());
    }

    public void setLanguageID(String langID) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.setLanguageIDImpl(langID);
    }

    public String getH323Gateway() {
        if (!this.isMainboardInitialized()) {
            return "";
        }
        return this.getH323GatewayImpl();
    }

    public long getH323AccessCode() {
        if (!this.isMainboardInitialized()) {
            return 0L;
        }
        return this.getH323AccessCodeImpl();
    }

    public String getH323Password() {
        if (!this.isMainboardInitialized()) {
            return "";
        }
        return this.getH323PasswordImpl();
    }

    public void setLanguageIdAsSystemConfiguration() {
        Locale locale = CompatUtils.getLocalDefault();
        if (locale == null) {
            return;
        }
        String langID = locale.getLanguage() + "-" + locale.getCountry();
        this.setLanguageID(langID);
    }

    public boolean isPublicGmailUser() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isPublicGmailUserImpl();
    }

    public boolean isGoogleImEnabled() {
        return false;
    }

    public boolean isFacebookImEnabled() {
        return false;
    }

    public boolean isAutoReponseON() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isAutoReponseONImpl();
    }

    public boolean isSignedInUserMeetingOn() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isSignedInUserMeetingOnImpl();
    }

    public boolean isSpecifiedDomainsMeetingOn() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isSpecifiedDomainsMeetingOnImpl();
    }

    public String querySSOVanityURL(String email) {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.querySSOVanityURLImpl(email);
    }

    public PTAppProtos.IPLocationInfo getIPLocation(boolean refreshNow) {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        byte[] res = this.getIPLocationImpl(refreshNow);
        if (res == null || res.length == 0) {
            return null;
        }
        try {
            return PTAppProtos.IPLocationInfo.parseFrom(res);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean nos_SetDeviceInfo(byte[] info) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (info == null) {
            return false;
        }
        return this.nosSetDeviceInfoImpl(info);
    }

    public MMFileContentMgr getZoomFileContentMgr() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = this.getZoomFileContentMgrImpl();
        if (nativeHandle != 0L) {
            return new MMFileContentMgr(nativeHandle);
        }
        return null;
    }

    public MMPrivateStickerMgr getZoomPrivateStickerMgr() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = this.getZoomPrivateStickerMgrImpl();
        if (nativeHandle != 0L) {
            return new MMPrivateStickerMgr(nativeHandle);
        }
        return null;
    }

    public void VTLSConfirmAcceptCertItem(VerifyCertEvent event, boolean accept, boolean permanent) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.VTLSConfirmAcceptCertItemImpl(event, accept, permanent);
    }

    public boolean isSyncUserGroupON() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isSyncUserGroupONImpl();
    }

    public String modifyCountryCode(String countryCode) {
        if (!this.isInitialForMainboard()) {
            return "";
        }
        return this.modifyCountryCodeImpl(countryCode);
    }

    public String modifyVanityUrl(String vanityUrl) {
        if (!this.isInitialForMainboard()) {
            return "";
        }
        return this.modifyVanityUrlImpl(vanityUrl);
    }

    public String changeUserPassword(String oldPassword, String newPassword) {
        if (!this.isInitialForMainboard()) {
            return "";
        }
        return this.changeUserPasswordImpl(oldPassword, newPassword);
    }

    public boolean isPremiumFeatureEnabled() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isPremiumFeatureEnabledImpl();
    }

    public boolean isChangeNamepicEnabled() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isChangeNamepicEnabledImpl();
    }

    public FileInfoChecker getZoomFileInfoChecker() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = this.getZoomFileInfoCheckerImpl();
        if (nativeHandle == 0L) {
            return null;
        }
        return new FileInfoChecker(nativeHandle);
    }

    public boolean isFileTransferDisabled() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isFileTransferDisabledImpl();
    }

    public String getMyLocalAddress() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getMyLocalAddressImpl();
    }

    public CallHistoryMgr getCallHistoryMgr() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long nativeHandle = this.getCallHistoryMgrImpl();
        if (nativeHandle == 0L) {
            return null;
        }
        return new CallHistoryMgr(nativeHandle);
    }

    public boolean updateSipPhoneStatus(SIPConfiguration config) {
        if (config == null || StringUtil.isEmptyOrNull((String)config.userName)) {
            return false;
        }
        if (!this.isInitialForMainboard()) {
            return false;
        }
        PTAppProtos.SipPhoneIntegration.Builder builder = PTAppProtos.SipPhoneIntegration.newBuilder();
        builder.setAuthoriztionName(config.authName);
        builder.setDomain(config.domain);
        builder.setErrorCode(config.respCode);
        builder.setErrorString(config.respDescription == null ? "" : config.respDescription);
        builder.setPassword(config.userPassword);
        builder.setProtocol(config.protocol);
        builder.setProxyServer(config.proxy);
        builder.setRegisterServer(config.regServerAddress);
        builder.setStatus(config.status);
        builder.setUserName(config.userName);
        return this.updateSipPhoneStatusImpl(builder.build().toByteArray());
    }

    public boolean isSipPhoneEnabled() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isSipPhoneEnabledImpl();
    }

    public NotificationSettingMgr getNotificationSettingMgr() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getNotificationSettingMgrImpl();
        if (handle == 0L) {
            return null;
        }
        return new NotificationSettingMgr(handle);
    }

    public CrawlerLinkPreview getLinkCrawler() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getLinkCrawlerImpl();
        if (handle == 0L) {
            return null;
        }
        return new CrawlerLinkPreview(handle);
    }

    public boolean beforeLogout() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.beforeLogoutImpl();
    }

    public UnSupportMessageMgr getUnsupportMessageMgr() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getUnsupportMessageMgrImpl();
        if (handle == 0L) {
            return null;
        }
        return new UnSupportMessageMgr(handle);
    }

    public int loginWithRingCentral(String phoneNumber, String ext, String password, int countryType, boolean rememberMe) {
        if (BuildTarget.isRingCentralLogin(ZMBuildConfig.BUILD_TARGET)) {
            if (!this.isInitialForMainboard()) {
                return 1;
            }
            if (StringUtil.isEmptyOrNull((String)phoneNumber) || StringUtil.isEmptyOrNull((String)password)) {
                return 1;
            }
            if (ext == null) {
                ext = "";
            }
            return this.loginWithRingCentralImpl(phoneNumber, ext, password, countryType, rememberMe);
        }
        return 0;
    }

    public int loginRingCentralWithLocalToken() {
        if (BuildTarget.isRingCentralLogin(ZMBuildConfig.BUILD_TARGET)) {
            if (!this.isInitialForMainboard()) {
                return 1;
            }
            if (this.isAuthenticating() && this.getPTLoginType() == 98) {
                return 0;
            }
            return this.loginRingCentralWithLocalTokenImpl();
        }
        return 0;
    }

    public int getSavedRingCentralPhoneNumberAndExt(String[] phoneNumber, String[] ext) {
        if (BuildTarget.isRingCentralLogin(ZMBuildConfig.BUILD_TARGET)) {
            if (!this.isInitialForMainboard()) {
                return -1;
            }
            if (phoneNumber == null || phoneNumber.length == 0 || ext == null || ext.length == 0) {
                return -1;
            }
            return this.getSavedRingCentralPhoneNumberAndExtImpl(phoneNumber, ext);
        }
        return -1;
    }

    public int RC_getDefaultCountryTypeByName(String countryName) {
        if (BuildTarget.isRingCentralLogin(ZMBuildConfig.BUILD_TARGET)) {
            if (!this.isInitialForMainboard()) {
                return -1;
            }
            if (countryName == null) {
                return -1;
            }
            return this.RCgetDefaultCountryTypeByNameImpl(countryName);
        }
        return -1;
    }

    public String RC_getCountryCodeByCountryType(int countryType) {
        if (BuildTarget.isRingCentralLogin(ZMBuildConfig.BUILD_TARGET)) {
            if (!this.isInitialForMainboard()) {
                return null;
            }
            return this.RCgetCountryCodeByCountryTypeImpl(countryType);
        }
        return null;
    }

    public void RC_setCountryType(int countryType) {
        if (BuildTarget.isRingCentralLogin(ZMBuildConfig.BUILD_TARGET)) {
            if (!this.isInitialForMainboard()) {
                return;
            }
        } else {
            return;
        }
        this.RCsetCountryTypeImpl(countryType);
    }

    private boolean isMainboardInitialized() {
        return this.isInitialForMainboard();
    }

    public ArrayList<CmmSavedMeeting> getSavedMeetingList() {
        ArrayList<CmmSavedMeeting> list = new ArrayList<CmmSavedMeeting>();
        if (!this.isInitialForMainboard()) {
            return list;
        }
        CmmSavedMeeting[] arrMeetingList = this.getSavedMeetingListImpl();
        if (arrMeetingList == null || arrMeetingList.length <= 0) {
            return list;
        }
        for (CmmSavedMeeting it : arrMeetingList) {
            if (it == null) continue;
            list.add(it);
        }
        return list;
    }

    public void clearSavedMeetingList() {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.clearSavedMeetingListImpl();
    }

    public boolean confirmGDPR(boolean agree) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.confirmGDPRImpl(agree);
    }

    private boolean isInitialForMainboard() {
        Mainboard mainboard = Mainboard.getMainboard();
        return mainboard != null && mainboard.isInitialized();
    }

    public void getCalendarIntegrationConfig() {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.getCalendarIntegrationConfigImpl();
    }

    public String getWebDomain() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getWebDomainImpl();
    }

    private native void dispatchIdleMessageImpl();

    private native long getBuddyHelperHandle();

    private native long getCurrentUserProfileHandle();

    private native long getFBAuthHelperHandle();

    private native long getIMHelperHandle();

    private native long getSettingHelperHandle();

    private native long getMeetingHelperHandle();

    private native long getFavoriteMgrHandle();

    private native long getABContactsHelperHandle();

    private native long getZoomMessengerHandle();

    private native long getBusinessMessengerHandle();

    private native boolean hasBusinessMessengerImpl();

    private native long getZoomProductHelperHandle();

    private native void loginXmppServerImpl(String var1);

    private native long getGroupMemberSynchronizerHandle();

    private native long getZoomMessageTemplateHandle();

    private native void loginWithFacebookImpl(String var1, long var2, boolean var4);

    private native void loginFacebookWithTokenImpl(String var1, long var2);

    private native int loginFacebookWithLocalTokenImpl(boolean var1, boolean var2);

    private native boolean logoutImpl(int var1);

    private native boolean joinFromIconTrayImpl(String var1, String var2, long var3, String var5, boolean var6, boolean var7);

    private native int inviteToVideoCallImpl(String var1, String var2, int var3);

    private native int acceptVideoCallImpl(byte[] var1, String var2, boolean var3);

    private native int declineVideoCallImpl(byte[] var1, String var2);

    private native int startGroupVideoCallImpl(String[] var1, String[] var2, String var3, long var4, int var6);

    private native int inviteBuddiesToConfImpl(String[] var1, String[] var2, String var3, long var4, String var6);

    private native void resetForReconnectingImpl();

    private native String getActiveCallIdImpl();

    private native long getActiveMeetingNoImpl();

    private native MeetingInfo getActiveMeetingItemImpl();

    private native int stopGroupVideoCallImpl(String var1, String var2);

    private native int getCallStatusImpl();

    private native boolean probeUserStatusImpl(String var1);

    private native UrlActionData parseURLActionDataImpl(String var1);

    private native boolean validateConfNumberImpl(String var1);

    private native boolean sendFeedbackImpl(String var1);

    private native int loginGoogleWithLocalTokenImpl();

    private native int loginGoogleWithTokensImpl(String var1, String var2);

    private native String getSavedGoogleIDImpl();

    private native int getPTLoginTypeImpl();

    private native boolean isKeepMeLoggedInImpl();

    private native int retryLoginGoogleImpl();

    private native int loginZoomImpl(String var1, String var2, boolean var3);

    private native int loginZoomWithLocalTokenImpl();

    private native boolean nosSetDeviceTokenImpl(String var1, String var2);

    private native boolean nosNotificationReceivedImpl(String var1, String var2);

    private native boolean nosMessageNotificationReceivedImpl(int var1, String var2, String var3, String var4);

    private native boolean nosClearDeviceTokenImpl();

    private native boolean nosUpdateDeviceTokenImpl(String var1, String var2, String var3);

    private native boolean needDoAutoLoginImpl();

    private native boolean needDoWebStartImpl();

    private native int launchCallForWebStartImpl();

    private native boolean canAccessZoomWebserviceImpl();

    private native boolean hasPrescheduleMeetingImpl();

    private native boolean isAuthenticatingImpl();

    private native boolean signupImpl(String var1, String var2, String var3, String var4);

    private native boolean sendActivationEmailImpl(String var1, String var2, String var3);

    private native boolean forgotPasswordImpl(String var1);

    private native boolean setPasswordImpl(boolean var1, String var2, String var3, String var4, String var5, String var6);

    private native String getZoomInvitationEmailSubjectImpl();

    private native String getZoomInvitationEmailBodyImpl();

    private native boolean startMeetingImpl(long var1);

    private native void startScheduleConfirmImpl(long var1, boolean var3);

    private native byte[] getSavedZoomAccountDataImpl();

    private native void userInputUsernamePasswordForProxyImpl(String var1, int var2, String var3, String var4, boolean var5);

    private native int getAuthInfoImpl(int var1, String var2, int var3, String[] var4, String[] var5);

    private native int navWebWithDefaultBrowserImpl(int var1, String var2);

    private native int loginWithSSOTokenImpl(String var1);

    private native int loginSSOWithLocalTokenImpl();

    private native String getSSOURLImpl();

    private native void setSSOURLImpl(String var1);

    private native String getLatestVersionStringImpl();

    private native String getLatestVersionReleaseNoteImpl();

    private native boolean checkForUpdatesImpl(boolean var1);

    private native void setDeviceUserNameImpl(String var1);

    private native String getDeviceUserNameImpl();

    private native void logUICommandImpl(String var1, String var2, String var3);

    private native boolean userUploadMyPictureImpl(String var1);

    private native boolean userUpdateMyNameImpl(String var1, String var2);

    private native int getAltHostCountImpl();

    private native AlterHost getAltHostAtImpl(int var1);

    private native boolean isPaidUserImpl();

    private native String getPackageCheckSumImpl();

    private native String getPackageDownloadUrlImpl();

    private native String getPackageNameImpl();

    private native boolean isCallOutInProgressImpl(int[] var1);

    private native boolean inviteCallOutUserImpl(String var1, String var2);

    private native boolean cancelCallOutImpl();

    private native boolean isFeedbackOffImpl();

    private native boolean isCNMeetingONImpl();

    private native String getURLByTypeImpl(int var1);

    private native String getZoomDomainImpl();

    private native void configZoomDomainImpl(String var1);

    private native boolean sdkAuthImpl(String var1, String var2);

    private native boolean isSdkNeedWaterMarkImpl();

    private native boolean isSdkEnableCustomizedUIImpl();

    private native int getSdkAuthResultImpl();

    private native void configSDKDSCPImpl(int var1, int var2, boolean var3);

    private native void enableHideFullPhoneNumber4PureCallinUserImpl(boolean var1);

    private native void setPTAppAPI4SDKSinkImpl(long var1);

    private native void setLanguageIDImpl(String var1);

    private native boolean isPublicGmailUserImpl();

    private native String getH323GatewayImpl();

    private native long getH323AccessCodeImpl();

    private native String getH323PasswordImpl();

    private native boolean isAutoReponseONImpl();

    private native boolean isSignedInUserMeetingOnImpl();

    private native boolean isSpecifiedDomainsMeetingOnImpl();

    private native String querySSOVanityURLImpl(String var1);

    private native byte[] getIPLocationImpl(boolean var1);

    private native boolean nosSetDeviceInfoImpl(byte[] var1);

    private native void VTLSConfirmAcceptCertItemImpl(VerifyCertEvent var1, boolean var2, boolean var3);

    private native boolean isSyncUserGroupONImpl();

    private native long getZoomFileContentMgrImpl();

    private native String modifyCountryCodeImpl(String var1);

    private native String modifyVanityUrlImpl(String var1);

    private native String changeUserPasswordImpl(String var1, String var2);

    private native long getZoomPrivateStickerMgrImpl();

    private native boolean isPremiumFeatureEnabledImpl();

    private native boolean isChangeNamepicEnabledImpl();

    private native long getZoomFileInfoCheckerImpl();

    private native boolean isFileTransferDisabledImpl();

    private native String getMyLocalAddressImpl();

    private native boolean sendCustomMessageToConfInstanceImpl(int var1, byte[] var2);

    private native long getCallHistoryMgrImpl();

    private native boolean updateSipPhoneStatusImpl(byte[] var1);

    private native boolean isSipPhoneEnabledImpl();

    private native long getNotificationSettingMgrImpl();

    private native long getLinkCrawlerImpl();

    private native boolean parseAppProtocolImpl(UrlActionInfo var1, String var2, boolean var3);

    private native boolean beforeLogoutImpl();

    private native long getUnsupportMessageMgrImpl();

    private native int loginWithRingCentralImpl(String var1, String var2, String var3, int var4, boolean var5);

    private native int loginRingCentralWithLocalTokenImpl();

    private native int getSavedRingCentralPhoneNumberAndExtImpl(String[] var1, String[] var2);

    private native int RCgetDefaultCountryTypeByNameImpl(String var1);

    private native String RCgetCountryCodeByCountryTypeImpl(int var1);

    private native void RCsetCountryTypeImpl(int var1);

    private native CmmSavedMeeting[] getSavedMeetingListImpl();

    private native void clearSavedMeetingListImpl();

    private native boolean confirmGDPRImpl(boolean var1);

    private native void getCalendarIntegrationConfigImpl();

    private native String getWebDomainImpl();
}

