/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.content.Context;
import android.content.res.Resources;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.CallingActivity;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.IntegrationActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.sip.CallHistory;
import com.zipow.videobox.sip.CallHistoryMgr;
import com.zipow.videobox.sip.server.SipCallManager;
import java.util.Calendar;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.videomeetings.R;

public class IncomingCallManager {
    private static IncomingCallManager instance = null;
    private Context mContext;
    private PTAppProtos.InvitationItem mCurrentInvitation;
    private static final String TAG = IncomingCallManager.class.getSimpleName();

    private IncomingCallManager() {
    }

    public static synchronized IncomingCallManager getInstance() {
        if (instance == null) {
            instance = new IncomingCallManager();
        }
        return instance;
    }

    public void initialize(Context context) {
        this.mContext = context;
        if (this.mContext == null) {
            throw new NullPointerException("context is null");
        }
    }

    public void onConfInvitation(PTAppProtos.InvitationItem invitation) {
        ZoomMessenger messenger;
        if (invitation == null) {
            return;
        }
        if (this.isInDndNow()) {
            this.declineCall(invitation);
            return;
        }
        PTApp ptApp = PTApp.getInstance();
        if (ptApp.isAutoReponseON() && (messenger = ptApp.getZoomMessenger()) != null && messenger.isAutoAcceptBuddy(invitation.getSenderJID())) {
            if (this.mCurrentInvitation != null) {
                this.declineCall();
            }
            this.mCurrentInvitation = invitation;
            this.acceptCall(this.mContext, true);
            return;
        }
        boolean hasCallingActivity = ZMActivity.getFrontActivity() instanceof CallingActivity;
        if (!hasCallingActivity || this.mCurrentInvitation == null) {
            this.mCurrentInvitation = invitation;
            if (!PTApp.getInstance().hasActiveCall()) {
                CallingActivity.show(this.mContext, invitation);
            } else {
                IntegrationActivity.onNewIncomingCall((Context)VideoBoxApplication.getInstance(), invitation);
            }
        }
    }

    public PTAppProtos.InvitationItem getCurrentCall() {
        return this.mCurrentInvitation;
    }

    public void acceptCall(Context context, boolean isAutoAccept) {
        if (this.mCurrentInvitation == null) {
            return;
        }
        PTApp ptApp = PTApp.getInstance();
        ptApp.forceLeaveCurrentCall();
        PTApp.getInstance().dispatchIdleMessage();
        ConfActivity.acceptCall(context, this.mCurrentInvitation, isAutoAccept);
        if (this.mCurrentInvitation == null) {
            return;
        }
        this.mCurrentInvitation = null;
        if (SipCallManager.getInstance().isInSIPCall()) {
            SipCallManager.getInstance().hangupActiveCall();
        }
    }

    public boolean declineCall() {
        if (this.mCurrentInvitation == null) {
            return false;
        }
        boolean res = this.declineCall(this.mCurrentInvitation);
        if (res) {
            this.mCurrentInvitation = null;
        }
        return res;
    }

    public boolean declineCall(PTAppProtos.InvitationItem invitation) {
        if (invitation == null || this.mContext == null) {
            return false;
        }
        Resources res = this.mContext.getResources();
        if (res == null) {
            return false;
        }
        PTApp ptApp = PTApp.getInstance();
        ptApp.declineVideoCall(invitation, res.getString(R.string.zm_msg_decline_call));
        return true;
    }

    private boolean isInDndNow() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return false;
        }
        long[] snoozedSetting = mgr.getSnoozeSettings();
        if (snoozedSetting == null) {
            return false;
        }
        long time = snoozedSetting[2] - CmmTime.getMMNow();
        if (time > 0L) {
            return true;
        }
        NotificationSettingMgr.DndSetting dndSettings = mgr.getDndSettings();
        if (dndSettings == null || !dndSettings.isEnable()) {
            return false;
        }
        Calendar start = dndSettings.getStart();
        Calendar end = dndSettings.getEnd();
        Calendar now = Calendar.getInstance();
        if (start.after(end)) {
            return now.after(start) || now.before(end);
        }
        return now.after(start) && now.before(end);
    }

    private void insertCallHistory(int callState, String sendJid, String senderName, String meetingId, boolean isVideoCall, String messageId) {
        CallHistoryMgr mgr = PTApp.getInstance().getCallHistoryMgr();
        if (mgr == null) {
            return;
        }
        CallHistory item = new CallHistory();
        item.setType(isVideoCall ? 1 : 2);
        item.setState(callState);
        item.setCallerJid(sendJid);
        item.setCallerDisplayName(senderName);
        item.setId(messageId);
        item.setNumber(meetingId);
        item.setDirection(1);
        item.setTime(CmmTime.getMMNow());
        mgr.addCallHistory(item);
    }

    public void insertDeclineCallMsg() {
        if (this.mCurrentInvitation == null || this.mContext == null) {
            return;
        }
    }

    public void insertCallActionMessage(String senderJID, String senderName, long time, int type, String msgID, long serverTime, long prevMsgTime, long meetingNO, boolean isVideoCall) {
        ZoomMessenger zm = PTApp.getInstance().getZoomMessenger();
        Resources res = this.mContext.getResources();
        if (zm == null || res == null) {
            return;
        }
        boolean isZoomZRoom = false;
        ZoomBuddy buddy = zm.getBuddyWithJID(senderJID);
        if (buddy != null) {
            isZoomZRoom = buddy.isZoomRoom();
        }
        switch (type) {
            case 51: {
                zm.insertSystemMessage("", senderJID, res.getString(R.string.zm_mm_accepted_call_35364), time, type, msgID, serverTime, prevMsgTime);
                this.insertCallHistory(2, senderJID, senderName, meetingNO + "", isVideoCall, msgID);
                break;
            }
            case 52: {
                zm.insertSystemMessage("", senderJID, res.getString(R.string.zm_mm_declined_call), time, type, msgID, serverTime, prevMsgTime);
                this.insertCallHistory(1, senderJID, senderName, meetingNO + "", isVideoCall, msgID);
                break;
            }
            case 50: {
                zm.insertSystemMessage("", senderJID, res.getString(R.string.zm_mm_miss_call), time, isZoomZRoom, type, msgID, serverTime, prevMsgTime);
                this.insertCallHistory(1, senderJID, senderName, meetingNO + "", isVideoCall, msgID);
                break;
            }
            default: {
                zm.insertSystemMessage("", senderJID, res.getString(R.string.zm_mm_unknow_call_35364), time, type, msgID, serverTime, prevMsgTime);
                this.insertCallHistory(0, senderJID, senderName, meetingNO + "", isVideoCall, msgID);
            }
        }
    }

    public void ignoreCall() {
        if (this.mCurrentInvitation == null) {
            return;
        }
        this.mCurrentInvitation = null;
    }

    public void onCallTimeout() {
        if (this.mCurrentInvitation == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        messenger.notifyMissedCall(this.mCurrentInvitation.getMeetingNumber());
        this.declineCall();
    }

    public void clearCurrentInvitation() {
        this.mCurrentInvitation = null;
    }
}

