/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.os.Handler;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;

public class ImageDownloadChecker {
    private static final int IMAGE_DOWNLOAD_TIMEOUT = 60000;
    private List<ImageDownloadInfo> mDownloadedImages = new ArrayList<ImageDownloadInfo>();
    private Handler mHandler;
    private static ImageDownloadChecker instance;
    private List<ImageDownloadTimeoutListener> mListeners = new ArrayList<ImageDownloadTimeoutListener>();
    private Runnable mTimeoutCheckTask = new Runnable(){

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            for (int i = 0; i < ImageDownloadChecker.this.mDownloadedImages.size(); ++i) {
                ImageDownloadInfo info = (ImageDownloadInfo)ImageDownloadChecker.this.mDownloadedImages.get(i);
                if (info == null) {
                    ImageDownloadChecker.this.mDownloadedImages.remove(i);
                    --i;
                    continue;
                }
                long timeStamp = info.timeStamp;
                if (now - timeStamp <= 60000L) continue;
                ImageDownloadChecker.this.mDownloadedImages.remove(i);
                --i;
                for (ImageDownloadTimeoutListener listener : ImageDownloadChecker.this.mListeners) {
                    if (listener == null) continue;
                    listener.onImageDownloadTimeout(info.sessionId, info.msgId);
                }
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) continue;
                messenger.FT_Cancel(info.sessionId, info.msgId);
            }
            if (ImageDownloadChecker.this.mDownloadedImages.size() > 0) {
                ImageDownloadChecker.this.mHandler.postDelayed(ImageDownloadChecker.this.mTimeoutCheckTask, 1000L);
            }
        }
    };
    private ZoomMessengerUI.IZoomMessengerUIListener mListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void FT_OnProgress(String sessionID, String messageID, int ratio, long completeSize, long bitPerSecond) {
            ImageDownloadChecker.this.FT_OnProgress(sessionID, messageID, ratio, completeSize, bitPerSecond);
        }

        @Override
        public void onConfirmFileDownloaded(String sessionId, String messageId, int result) {
            ImageDownloadChecker.this.onConfirmFileDownloaded(sessionId, messageId, result);
        }
    };

    private ImageDownloadChecker() {
        this.mHandler = new Handler();
    }

    public void addTimeoutListener(ImageDownloadTimeoutListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
        this.mHandler.removeCallbacks(this.mTimeoutCheckTask);
        this.mHandler.postDelayed(this.mTimeoutCheckTask, 1000L);
    }

    public void removeTimeoutListener(ImageDownloadTimeoutListener listener) {
        if (listener == null) {
            return;
        }
        this.mListeners.remove(listener);
    }

    public void startChecker() {
        ZoomMessengerUI.getInstance().addListener(this.mListener);
    }

    public void stopChecker() {
        ZoomMessengerUI.getInstance().removeListener(this.mListener);
    }

    public static ImageDownloadChecker getInstance() {
        if (instance == null) {
            instance = new ImageDownloadChecker();
        }
        return instance;
    }

    public void listenerImageDownload(String sessionId, String msgId) {
        ImageDownloadInfo info = new ImageDownloadInfo();
        info.sessionId = sessionId;
        info.msgId = msgId;
        info.timeStamp = System.currentTimeMillis();
        this.mDownloadedImages.add(info);
        this.mHandler.removeCallbacks(this.mTimeoutCheckTask);
        this.mHandler.postDelayed(this.mTimeoutCheckTask, 1000L);
    }

    private void FT_OnProgress(String sessionID, String messageID, int ratio, long completeSize, long bitPerSecond) {
        int idx = this.findImageDownloadinfo(sessionID, messageID);
        if (idx == -1) {
            return;
        }
        ImageDownloadInfo info = this.mDownloadedImages.get(idx);
        if (completeSize != info.completeSize) {
            info.completeSize = completeSize;
            info.timeStamp = System.currentTimeMillis();
        }
    }

    private int findImageDownloadinfo(String sessionID, String messageID) {
        for (int i = 0; i < this.mDownloadedImages.size(); ++i) {
            ImageDownloadInfo info = this.mDownloadedImages.get(i);
            if (!StringUtil.isSameString((String)info.sessionId, (String)sessionID) || !StringUtil.isSameString((String)info.msgId, (String)messageID)) continue;
            return i;
        }
        return -1;
    }

    private void onConfirmFileDownloaded(String sessionId, String messageId, int result) {
        this.mDownloadedImages.remove(sessionId + "," + messageId);
        if (this.mDownloadedImages.size() == 0) {
            this.mHandler.removeCallbacks(this.mTimeoutCheckTask);
        }
    }

    public static interface ImageDownloadTimeoutListener {
        public void onImageDownloadTimeout(String var1, String var2);
    }

    static class ImageDownloadInfo {
        String sessionId;
        String msgId;
        long timeStamp;
        long completeSize;

        ImageDownloadInfo() {
        }
    }
}

