/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import com.zipow.videobox.ptapp.PTAppProtos;
import java.io.IOException;

public class IMSession {
    private static final String TAG = IMSession.class.getSimpleName();
    private long mNativeHandle = 0L;

    public IMSession(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public String getSessionName() {
        return this.getSessionNameImpl(this.mNativeHandle);
    }

    public int getIMMessageCount() {
        return this.getIMMessageCountImpl(this.mNativeHandle);
    }

    public PTAppProtos.IMMessage getIMMessageByIndex(int index) {
        byte[] data = this.getIMMessageByIndexImpl(this.mNativeHandle, index);
        if (data == null) {
            return null;
        }
        PTAppProtos.IMMessage message = null;
        try {
            message = PTAppProtos.IMMessage.parseFrom(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return message;
    }

    public int getUnreadMessageCount() {
        return this.getUnreadMessageCountImpl(this.mNativeHandle);
    }

    private native String getSessionNameImpl(long var1);

    private native int getIMMessageCountImpl(long var1);

    private native byte[] getIMMessageByIndexImpl(long var1, int var3);

    private native int getUnreadMessageCountImpl(long var1);
}

