/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import com.zipow.videobox.ptapp.IMSession;
import com.zipow.videobox.ptapp.IMSubscription;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTBuddyHelper;

public class IMHelper {
    private static final String TAG = IMHelper.class.getSimpleName();
    private long mNativeHandle = 0L;
    private int mLocalStatus = 0;

    public IMHelper(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public boolean isIMSignedOn() {
        return this.isIMSignedOnImpl(this.mNativeHandle);
    }

    public int sendIMMessage(String jid, String message, boolean backToSelf) {
        return this.sendIMMessageImpl(this.mNativeHandle, jid, message, backToSelf);
    }

    public String getJIDMyself() {
        return this.getJIDMyselfImpl(this.mNativeHandle);
    }

    public IMSession getSessionBySessionName(String sessionName) {
        long sessionHandle = this.getSessionBySessionNameImpl(this.mNativeHandle, sessionName);
        if (sessionHandle != 0L) {
            return new IMSession(sessionHandle);
        }
        return null;
    }

    public void setIMMessageUnread(PTAppProtos.IMMessage message, boolean unread) {
        if (message == null) {
            return;
        }
        this.setIMMessageUnreadImpl(this.mNativeHandle, message.getNativeHandle(), unread);
    }

    public boolean isIMLoggingIn() {
        return this.isIMLoggingInImpl(this.mNativeHandle);
    }

    public boolean isIMDisconnected() {
        return this.isIMDisconnectedImpl(this.mNativeHandle);
    }

    public int getUnreadMsgCount() {
        int count = 0;
        PTBuddyHelper buddyHelper = PTApp.getInstance().getBuddyHelper();
        int cntBuddy = buddyHelper.getBuddyItemCount();
        for (int i = 0; i < cntBuddy; ++i) {
            String jid = buddyHelper.getBuddyItemJid(i);
            IMSession session = this.getSessionBySessionName(jid);
            if (session == null) continue;
            count += session.getUnreadMessageCount();
        }
        return count;
    }

    protected void setIMLocalStatus(int status) {
        this.mLocalStatus = status;
    }

    public int getIMLocalStatus() {
        return this.mLocalStatus;
    }

    public boolean subscribeBuddy(String jid) {
        return this.subscribeBuddyImpl(this.mNativeHandle, jid);
    }

    public boolean unsubscribeBuddy(String jid) {
        return this.unsubscribeBuddyImpl(this.mNativeHandle, jid);
    }

    public boolean acknowledgeSubscription(String jid, boolean accept) {
        return this.acknowledgeSubscriptionImpl(this.mNativeHandle, jid, accept);
    }

    public boolean cancelSubscription(String jid) {
        return this.cancelSubscriptionImpl(this.mNativeHandle, jid);
    }

    public IMSubscription[] getUnhandledSubscriptions() {
        return this.getUnhandledSubscriptionsImpl(this.mNativeHandle);
    }

    private native boolean isIMSignedOnImpl(long var1);

    private native int sendIMMessageImpl(long var1, String var3, String var4, boolean var5);

    private native String getJIDMyselfImpl(long var1);

    private native long getSessionBySessionNameImpl(long var1, String var3);

    private native void setIMMessageUnreadImpl(long var1, long var3, boolean var5);

    private native boolean isIMLoggingInImpl(long var1);

    private native boolean isIMDisconnectedImpl(long var1);

    private native boolean subscribeBuddyImpl(long var1, String var3);

    private native boolean unsubscribeBuddyImpl(long var1, String var3);

    private native boolean acknowledgeSubscriptionImpl(long var1, String var3, boolean var4);

    private native boolean cancelSubscriptionImpl(long var1, String var3);

    private native IMSubscription[] getUnhandledSubscriptionsImpl(long var1);
}

