/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class GroupMemberSynchronizerUI {
    private static final String TAG = GroupMemberSynchronizerUI.class.getSimpleName();
    private static GroupMemberSynchronizerUI instance = null;
    private ListenerList mListenerList = new ListenerList();
    private long mNativeHandle;

    public void addListener(IGroupMemberSynchronizerUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((IGroupMemberSynchronizerUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(IGroupMemberSynchronizerUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public static synchronized GroupMemberSynchronizerUI getInstance() {
        if (instance == null) {
            instance = new GroupMemberSynchronizerUI();
        }
        if (!instance.initialized()) {
            instance.init();
        }
        return instance;
    }

    private GroupMemberSynchronizerUI() {
        this.init();
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    private void init() {
        try {
            this.mNativeHandle = this.nativeInit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void notifyAsyncMUCGroupInfoUpdated(String groupid) {
        try {
            this.notifyAsyncMUCGroupInfoUpdatedImpl(groupid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notifyAsyncMUCGroupInfoUpdatedImpl(String groupid) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IGroupMemberSynchronizerUIListener l = (IGroupMemberSynchronizerUIListener)lTmp;
                l.Notify_AsyncMUCGroupInfoUpdated(groupid);
            }
        }
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    private native long nativeInit();

    private native void nativeUninit(long var1);

    public static abstract class SimpleGroupMemberSynchronizerUIListener
    implements IGroupMemberSynchronizerUIListener {
        @Override
        public void Notify_AsyncMUCGroupInfoUpdated(String groupid) {
        }
    }

    public static interface IGroupMemberSynchronizerUIListener
    extends IListener {
        public void Notify_AsyncMUCGroupInfoUpdated(String var1);
    }
}

