/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.content.Context;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.PTApp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import us.zoom.androidlib.util.StringUtil;

public class ContactsMatchHelper {
    private static final String TAG = ContactsMatchHelper.class.getSimpleName();
    private static ContactsMatchHelper instance = null;
    private static long mLastestSyncTime;
    private static final int FULL_MATCH_DURATION = 86400000;

    public static synchronized ContactsMatchHelper getInstance() {
        if (instance == null) {
            instance = new ContactsMatchHelper();
        }
        return instance;
    }

    public int matchAllNumbers(Context context) {
        if (context == null) {
            return 11;
        }
        ABContactsCache cache = ABContactsCache.getInstance();
        if (!cache.isCached() && !cache.reloadAllContacts()) {
            return -1;
        }
        boolean clearLocalCache = CmmTime.getMMNow() - mLastestSyncTime > 86400000L;
        mLastestSyncTime = CmmTime.getMMNow();
        ArrayList<String> numbers = new ArrayList<String>();
        Collator usCollator = Collator.getInstance(Locale.US);
        for (int i = 0; i < cache.getCachedContactsCount(); ++i) {
            int idx;
            ABContactsCache.Contact contact = cache.getCachedContact(i);
            String number = contact.normalizedNumber;
            if (StringUtil.isEmptyOrNull((String)number) || (idx = Collections.binarySearch(numbers, number, usCollator)) >= 0) continue;
            numbers.add(-idx - 1, number);
        }
        int ret = this.matchNumbers(numbers, clearLocalCache);
        if (ret == 0) {
            cache.clearNewContacts();
        }
        return ret;
    }

    public int matchNewNumbers(Context context) {
        if (context == null) {
            return 11;
        }
        ABContactsCache cache = ABContactsCache.getInstance();
        int newContactsCount = cache.getNewContactsCount();
        if (newContactsCount <= 0) {
            return -1;
        }
        ArrayList<String> numbers = new ArrayList<String>();
        Collator usCollator = Collator.getInstance(Locale.US);
        for (int i = 0; i < newContactsCount; ++i) {
            int idx;
            String number;
            ABContactsCache.Contact contact = cache.getNewContact(i);
            if (contact == null || StringUtil.isEmptyOrNull((String)(number = contact.normalizedNumber)) || (idx = Collections.binarySearch(numbers, number, usCollator)) >= 0) continue;
            numbers.add(-idx - 1, number);
        }
        int ret = this.matchNumbers(numbers, false);
        if (ret == 0) {
            cache.clearNewContacts();
        }
        return ret;
    }

    private int matchNumbers(ArrayList<String> numbers, boolean clearLocalCache) {
        if (numbers == null || numbers.size() == 0) {
            return -1;
        }
        ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
        if (contactsHelper == null) {
            return 11;
        }
        int ret = contactsHelper.matchPhoneNumbers(numbers, clearLocalCache);
        return ret;
    }
}

