/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class AutoStreamConflictChecker {
    private static AutoStreamConflictChecker mInstance;
    private boolean mHasStreamConflict = false;
    private ZoomMessengerUI.SimpleZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onConnectReturn(int errorCode) {
            AutoStreamConflictChecker.this.onZoomMessengerConnectReturn();
        }
    };
    private ZMActivity.GlobalActivityListener mGlobalActivityListener = new ZMActivity.GlobalActivityListener(){

        public void onActivityMoveToFront(ZMActivity activity) {
            AutoStreamConflictChecker.this.checkStreamConflict(activity);
        }

        public void onUIMoveToBackground() {
        }

        public void onUserActivityOnUI() {
        }
    };

    private AutoStreamConflictChecker() {
    }

    public static synchronized AutoStreamConflictChecker getInstance() {
        if (mInstance == null) {
            mInstance = new AutoStreamConflictChecker();
        }
        return mInstance;
    }

    public void startChecker() {
        VideoBoxApplication app = VideoBoxApplication.getInstance();
        if (app == null) {
            return;
        }
        if (app.isPTApp()) {
            ZMActivity.addGlobalActivityListener((ZMActivity.GlobalActivityListener)this.mGlobalActivityListener);
            ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        }
    }

    public void stopChecker() {
        ZMActivity.removeGlobalActivityListener((ZMActivity.GlobalActivityListener)this.mGlobalActivityListener);
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
    }

    private void checkStreamConflict(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (activity.isActive() && !messenger.isConnectionGood() && messenger.isStreamConflict()) {
            if (!this.mHasStreamConflict) {
                this.mHasStreamConflict = true;
                this.showStreamConflictMessage((FragmentActivity)activity);
            }
        } else if (!messenger.isStreamConflict()) {
            this.mHasStreamConflict = false;
        }
    }

    public void showStreamConflictMessage(FragmentActivity context) {
        if (context == null) {
            return;
        }
        ShowAlertDialog.showDialog(context.getSupportFragmentManager());
    }

    private void onZoomMessengerConnectReturn() {
        this.checkStreamConflict(ZMActivity.getFrontActivity());
    }

    public static class ShowAlertDialog
    extends ZMDialogFragment {
        private void forceConnectMessenger() {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger != null) {
                messenger.forceSignon();
            }
        }

        public static void showDialog(FragmentManager fragmentMgr) {
            ShowAlertDialog dlg = new ShowAlertDialog();
            dlg.show(fragmentMgr, ShowAlertDialog.class.getName());
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            ZMAlertDialog mStreamConflictDialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_mm_msg_stream_conflict_msg).setCancelable(true).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).setPositiveButton(R.string.zm_btn_sign_in_again, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ShowAlertDialog.this.forceConnectMessenger();
                }
            }).create();
            mStreamConflictDialog.setCanceledOnTouchOutside(false);
            return mStreamConflictDialog;
        }
    }
}

