/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.os.Handler;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.ConfActivityNormal;
import com.zipow.videobox.LoginActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;

public class AutoLogoffChecker
implements PTUI.IPTUIListener {
    private static AutoLogoffChecker instance;
    private static final String TAG;
    private List<AutoLogoffInfo> mNoActivityDelayForAutoLogoffInfo = new ArrayList<AutoLogoffInfo>();
    private Runnable mAutoLogoffTask;
    private Handler mHandler = new Handler();
    private boolean mLogoffWhenFront = false;
    private long mLastCheckTimeStamps;

    private AutoLogoffChecker() {
        ZMActivity.addGlobalActivityListener((ZMActivity.GlobalActivityListener)new ZMActivity.GlobalActivityListener(){

            public void onActivityMoveToFront(ZMActivity activity) {
                if (AutoLogoffChecker.this.mLogoffWhenFront && AutoLogoffChecker.this.mAutoLogoffTask != null) {
                    AutoLogoffChecker.this.mAutoLogoffTask.run();
                }
                AutoLogoffChecker.this.mLogoffWhenFront = false;
            }

            public void onUIMoveToBackground() {
            }

            public void onUserActivityOnUI() {
                AutoLogoffChecker.this.onUserActivityOnUI();
            }
        });
    }

    public static AutoLogoffChecker getInstance() {
        if (instance == null) {
            instance = new AutoLogoffChecker();
        }
        return instance;
    }

    public void startChecker() {
        VideoBoxApplication app = VideoBoxApplication.getInstance();
        if (app == null) {
            return;
        }
        if (app.isPTApp()) {
            PTUI.getInstance().addPTUIListener(this);
            if (PTApp.getInstance().isWebSignedOn()) {
                this.startTask();
            }
        }
    }

    private void onUserActivityOnUI() {
        if (this.mAutoLogoffTask != null && this.mNoActivityDelayForAutoLogoffInfo.size() > 0) {
            this.mLastCheckTimeStamps = CmmTime.getMMNow();
            this.mHandler.removeCallbacks(this.mAutoLogoffTask);
            this.mHandler.postDelayed(this.mAutoLogoffTask, 60000L);
        }
    }

    private void stopCheck() {
        this.mHandler.removeCallbacks(this.mAutoLogoffTask);
        this.mAutoLogoffTask = null;
    }

    private void startTask() {
        int e2eMinutes;
        if (this.mAutoLogoffTask != null) {
            this.mHandler.removeCallbacks(this.mAutoLogoffTask);
        }
        this.mNoActivityDelayForAutoLogoffInfo.clear();
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        this.mLastCheckTimeStamps = CmmTime.getMMNow();
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return;
        }
        int ssoMinutes = profile.getSSOEnforceLogoutTimeInMins();
        if (ssoMinutes != 0) {
            AutoLogoffInfo info = new AutoLogoffInfo();
            info.type = 2;
            info.minutes = ssoMinutes;
            this.mNoActivityDelayForAutoLogoffInfo.add(info);
        }
        if ((e2eMinutes = messenger.e2eGetAutologoffMinutes()) != 0) {
            AutoLogoffInfo info = new AutoLogoffInfo();
            info.type = 1;
            info.minutes = e2eMinutes;
            this.mNoActivityDelayForAutoLogoffInfo.add(info);
        }
        if (this.mNoActivityDelayForAutoLogoffInfo.size() > 0) {
            this.mAutoLogoffTask = new Runnable(){

                @Override
                public void run() {
                    if (AutoLogoffChecker.this.mNoActivityDelayForAutoLogoffInfo.size() == 0) {
                        return;
                    }
                    AutoLogoffInfo info = null;
                    for (AutoLogoffInfo item : AutoLogoffChecker.this.mNoActivityDelayForAutoLogoffInfo) {
                        long time = CmmTime.getMMNow() - AutoLogoffChecker.this.mLastCheckTimeStamps;
                        if (time <= item.minutes * 60000L) continue;
                        info = item;
                        break;
                    }
                    if (info == null) {
                        AutoLogoffChecker.this.mHandler.postDelayed(AutoLogoffChecker.this.mAutoLogoffTask, 60000L);
                        return;
                    }
                    ZMActivity front = ZMActivity.getFrontActivity();
                    if (front == null || !front.isActive()) {
                        AutoLogoffChecker.this.mLogoffWhenFront = true;
                        return;
                    }
                    PTAppProtos.ZoomAccount account = PTApp.getInstance().getSavedZoomAccount();
                    if (account != null) {
                        info.userName = account.getUserName();
                    }
                    PTApp.getInstance().logout(0);
                    int activityCount = ZMActivity.getInProcessActivityCountInStack();
                    if (activityCount > 0) {
                        for (int i = activityCount - 1; i >= 0; --i) {
                            ZMActivity activity = ZMActivity.getInProcessActivityInStackAt((int)i);
                            if (activity instanceof ConfActivityNormal || activity == null) continue;
                            activity.finish();
                        }
                    }
                    LoginActivity.show(VideoBoxApplication.getGlobalContext(), false, -1, info);
                    AutoLogoffChecker.this.mHandler.removeCallbacks(AutoLogoffChecker.this.mAutoLogoffTask);
                    AutoLogoffChecker.this.mAutoLogoffTask = null;
                }
            };
            this.mHandler.postDelayed(this.mAutoLogoffTask, 60000L);
        }
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 0: {
                if (result != 0L) break;
                this.startTask();
                break;
            }
            case 1: {
                this.stopCheck();
                break;
            }
            case 22: {
                if (PTApp.getInstance().hasActiveCall() && VideoBoxApplication.getInstance().isConfProcessRunning()) {
                    this.stopCheck();
                    break;
                }
                this.startChecker();
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    static {
        TAG = AutoLogoffChecker.class.getSimpleName();
    }

    public static class AutoLogoffInfo
    implements Serializable {
        public static final int TYPE_UNKNOW = 0;
        public static final int TYPE_E2E = 1;
        public static final int TYPE_SSO = 2;
        private static final long serialVersionUID = 1L;
        public long minutes;
        public int type;
        public String userName;
    }
}

