/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.text.TextUtils;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.ptapp.PTApp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.zoom.androidlib.util.PhoneNumberUtil;
import us.zoom.androidlib.util.StringUtil;

public class ABContactsHelper {
    private static final String TAG = ABContactsHelper.class.getSimpleName();
    private long mNativeHandle = 0L;
    private static boolean gMatchCalled = false;
    private static long gLastMatchTime = 0L;
    private static boolean gABEnabledDone = false;
    private static Map<String, Long> mWaitingVerifyNumbers = new HashMap<String, Long>();

    public ABContactsHelper(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public int registerPhoneNumber(String phoneNumber, String countryCode, String deviceID) {
        if (this.mNativeHandle == 0L || phoneNumber == null || deviceID == null) {
            return 1;
        }
        int code = this.registerPhoneNumberImpl(this.mNativeHandle, phoneNumber, countryCode, deviceID);
        if (code == 0) {
            ABContactsHelper.addSMSSentSuccess(phoneNumber, countryCode);
        }
        return code;
    }

    public int unregisterPhoneNumber(String phoneNumber, String deviceID) {
        if (this.mNativeHandle == 0L || phoneNumber == null || deviceID == null) {
            return 1;
        }
        return this.unregisterPhoneNumberImpl(this.mNativeHandle, phoneNumber, deviceID);
    }

    public int verifyPhoneNumber(String phoneNumber, String deviceID, String code) {
        if (this.mNativeHandle == 0L || phoneNumber == null || deviceID == null || code == null) {
            return 1;
        }
        return this.verifyPhoneNumberImpl(this.mNativeHandle, phoneNumber, deviceID, code);
    }

    public int callABContact(int callType, List<String> phoneNumbers, String screenName, String invitationMsgTemplate) {
        if (this.mNativeHandle == 0L || phoneNumbers == null || screenName == null || invitationMsgTemplate == null) {
            return 1;
        }
        return this.callABContactImpl(this.mNativeHandle, callType, phoneNumbers, screenName, invitationMsgTemplate);
    }

    public int matchPhoneNumbers(List<String> phoneNumbers, boolean clearLocalCache) {
        if (this.mNativeHandle == 0L || phoneNumbers == null) {
            return 1;
        }
        if (phoneNumbers.size() == 0) {
            return 6;
        }
        if (StringUtil.isEmptyOrNull((String)this.getVerifiedPhoneNumber())) {
            return 11;
        }
        int ret = this.matchPhoneNumbersImpl(this.mNativeHandle, phoneNumbers, clearLocalCache);
        if (ret == 0) {
            ABContactsHelper.setMatchPhoneNumbersCalled(true);
            ABContactsHelper.setLastMatchPhoneNumbersTime(System.currentTimeMillis());
        }
        return ret;
    }

    public static boolean isMatchPhoneNumbersCalled() {
        return gMatchCalled;
    }

    protected static void setMatchPhoneNumbersCalled(boolean called) {
        gMatchCalled = called;
        if (!called) {
            ABContactsHelper.setLastMatchPhoneNumbersTime(0L);
        }
    }

    private static void addSMSSentSuccess(String phoneNo, String countryCode) {
        mWaitingVerifyNumbers.put(ABContactsHelper.getFormatSMSPhoneNo(phoneNo, countryCode), CmmTime.getMMNow());
    }

    public static int getRemainSMSTimeInSecond(String phoneNo, String countryCode) {
        Long stamp = mWaitingVerifyNumbers.get(ABContactsHelper.getFormatSMSPhoneNo(phoneNo, countryCode));
        if (stamp != null) {
            long seconds = (CmmTime.getMMNow() - stamp) / 1000L;
            if ((seconds = 60L - seconds) < 0L) {
                return 0;
            }
            return (int)seconds;
        }
        return 0;
    }

    private static String getFormatSMSPhoneNo(String phoneNo, String countryCode) {
        if (TextUtils.isEmpty((CharSequence)phoneNo) || TextUtils.isEmpty((CharSequence)countryCode)) {
            return null;
        }
        if (phoneNo.startsWith("+")) {
            return PhoneNumberUtil.formatNumber((String)phoneNo, (String)countryCode);
        }
        if (phoneNo.startsWith("0")) {
            phoneNo = phoneNo.substring(1);
            return "+" + countryCode + phoneNo;
        }
        return "+" + countryCode + phoneNo;
    }

    public static void setLastMatchPhoneNumbersTime(long time) {
        gLastMatchTime = time;
    }

    public static boolean isTimeToMatchPhoneNumbers() {
        if (!ABContactsHelper.isMatchPhoneNumbersCalled()) {
            return true;
        }
        return System.currentTimeMillis() - gLastMatchTime > 43200000L;
    }

    public int getMatchedPhoneNumbers(List<String> phoneNumbers) {
        if (this.mNativeHandle == 0L || phoneNumbers == null) {
            return 1;
        }
        return this.getMatchedPhoneNumbersImpl(this.mNativeHandle, phoneNumbers);
    }

    public String getVerifiedPhoneNumber() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getVerifiedPhoneNumberImpl(this.mNativeHandle);
    }

    public int inviteABContacts(List<String> phoneNumbers, String invitationMsgTemplate) {
        if (this.mNativeHandle == 0L || phoneNumbers == null || invitationMsgTemplate == null) {
            return 1;
        }
        return this.inviteABContactsImpl(this.mNativeHandle, phoneNumbers, invitationMsgTemplate);
    }

    public static void setAddrBookEnabledDone(boolean done) {
        gABEnabledDone = done;
    }

    public static boolean isAddrBookEnabledDone() {
        ABContactsHelper helper = PTApp.getInstance().getABContactsHelper();
        if (helper == null) {
            return false;
        }
        return gABEnabledDone && !StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber());
    }

    public boolean needValidatePhoneNumber() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.needValidatePhoneNumberImpl(this.mNativeHandle);
    }

    public boolean updateValidatePhoneNumber(String newNumber) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.updateValidatePhoneNumberImpl(this.mNativeHandle, newNumber);
    }

    private native int registerPhoneNumberImpl(long var1, String var3, String var4, String var5);

    private native int unregisterPhoneNumberImpl(long var1, String var3, String var4);

    private native int verifyPhoneNumberImpl(long var1, String var3, String var4, String var5);

    private native int callABContactImpl(long var1, int var3, List<String> var4, String var5, String var6);

    private native int matchPhoneNumbersImpl(long var1, List<String> var3, boolean var4);

    private native int getMatchedPhoneNumbersImpl(long var1, List<String> var3);

    private native String getVerifiedPhoneNumberImpl(long var1);

    private native int inviteABContactsImpl(long var1, List<String> var3, String var4);

    private native boolean needValidatePhoneNumberImpl(long var1);

    private native boolean updateValidatePhoneNumberImpl(long var1, String var3);
}

