/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Build;
import android.os.Handler;
import android.os.Process;
import android.provider.ContactsContract;
import android.text.TextUtils;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.CountryCodeUtil;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.PhoneNumberUtil;
import us.zoom.androidlib.util.SortUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMAsyncTask;

public class ABContactsCache
extends ContentObserver {
    private static final String TAG = ABContactsCache.class.getSimpleName();
    private static ABContactsCache instance = null;
    private ArrayList<Contact> mCache = new ArrayList();
    private ArrayList<Contact> mNewItems = null;
    private boolean mIsCached = false;
    private boolean mNeedReloadAll = false;
    private int mLastReloadContactPermission = -1;
    private LoadContactsTask mLoadContactsTask;
    private Object mLockReload = new Object();
    private ListenerList mListenerList = new ListenerList();
    private HashMap<String, Contact> mMapPhoneNumberToContact = new HashMap();

    public static synchronized ABContactsCache getInstance() {
        if (instance == null) {
            instance = new ABContactsCache();
        }
        return instance;
    }

    private ABContactsCache() {
        super(new Handler());
        this.registerContentObserver();
    }

    public void registerContentObserver() {
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        if (context == null) {
            return;
        }
        if (!OsUtil.isAtLeastM() || context.checkPermission("android.permission.READ_CONTACTS", Process.myPid(), Process.myUid()) == 0) {
            context.getContentResolver().unregisterContentObserver((ContentObserver)this);
            context.getContentResolver().registerContentObserver(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, false, (ContentObserver)this);
        }
    }

    public void addListener(IABContactsCacheListener l) {
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((IABContactsCacheListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(IABContactsCacheListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public boolean reloadAllContacts() {
        return this.reloadAllContacts(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reloadAllContacts(boolean force) {
        if (!force && !PTApp.getInstance().hasZoomMessenger()) {
            return false;
        }
        Object object = this.mLockReload;
        synchronized (object) {
            try {
                this.mLastReloadContactPermission = VideoBoxApplication.getInstance().checkPermission("android.permission.READ_CONTACTS", Process.myPid(), Process.myUid());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.mLoadContactsTask == null) {
                ArrayList<Contact> reloadCache = new ArrayList<Contact>();
                reloadCache.addAll(this.mCache);
                this.mLoadContactsTask = new LoadContactsTask(reloadCache);
                this.mLoadContactsTask.execute(null);
                try {
                    LoadContactsResult loadContactsResult = (LoadContactsResult)this.mLoadContactsTask.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLoadContactsTaskComplete(ArrayList<Contact> reloadCache, LoadContactsResult result) {
        Object object = this.mLockReload;
        synchronized (object) {
            this.mLoadContactsTask = null;
            this.mIsCached = true;
            if (result.updated) {
                this.mNewItems = new ArrayList();
                if (result.changeFromIndex >= 0) {
                    for (int i = result.changeFromIndex; i < reloadCache.size(); ++i) {
                        Contact contact = reloadCache.get(i);
                        int idx = this.findContactCompareIdNumber(contact, result.changedItems);
                        if (idx >= 0) continue;
                        this.mNewItems.add(contact);
                    }
                }
            }
            this.mCache.clear();
            this.mCache.addAll(reloadCache);
            this.mMapPhoneNumberToContact.clear();
            this.mNeedReloadAll = false;
            if (result.updated) {
                this.notifyContactsCachedUpdated();
            }
        }
    }

    private void notifyContactsCachedUpdated() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IABContactsCacheListener l = (IABContactsCacheListener)lTmp;
                l.onContactsCacheUpdated();
            }
        }
    }

    private static LoadContactsResult reloadAllContactsImpl(ArrayList<Contact> oldCache) {
        LoadContactsResult result = new LoadContactsResult();
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        if (context == null) {
            return result;
        }
        boolean cacheUpdated = false;
        String[] projection = new String[]{"_id", "contact_id", "display_name", "data1", "data2"};
        String sortOrder = "contact_id ASC, _id ASC";
        Cursor cursor = null;
        try {
            cursor = context.getContentResolver().query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, projection, null, null, sortOrder);
        }
        catch (Exception e) {
            return result;
        }
        ArrayList<Contact> changedItems = new ArrayList<Contact>();
        int changeFromIdx = -1;
        if (cursor != null) {
            boolean hasItem = cursor.moveToFirst();
            if (!hasItem) {
                oldCache.clear();
                cacheUpdated = true;
            } else {
                int idx = 0;
                String isoCountryCode = CountryCodeUtil.getIsoCountryCode((Context)context);
                String phoneCountryCode = CountryCodeUtil.isoCountryCode2PhoneCountryCode((String)isoCountryCode);
                Locale locale = CompatUtils.getLocalDefault();
                while (hasItem) {
                    int id2 = cursor.getInt(0);
                    int contactId = cursor.getInt(1);
                    String name = cursor.getString(2);
                    String number = cursor.getString(3);
                    int type = cursor.getInt(4);
                    if (!StringUtil.isEmptyOrNull((String)number)) {
                        if (StringUtil.isEmptyOrNull((String)name)) {
                            name = number;
                        }
                        Contact contact = new Contact();
                        contact.id = id2;
                        contact.contactId = contactId;
                        contact.displayName = name;
                        contact.number = number;
                        contact.type = type;
                        contact.normalizedNumber = PhoneNumberUtil.formatNumber((String)number, (String)phoneCountryCode);
                        contact.normalizeCountryCode = PhoneNumberUtil.getCountryCodeFromFormatedPhoneNumber((String)contact.normalizedNumber);
                        if (contact.normalizedNumber.startsWith("+86") && (!contact.normalizedNumber.startsWith("+861") || contact.normalizedNumber.length() < 14)) {
                            hasItem = cursor.moveToNext();
                            continue;
                        }
                        boolean changed = cacheUpdated;
                        if (!changed) {
                            if (idx < oldCache.size()) {
                                Contact oldContact = oldCache.get(idx);
                                if (contact.id != oldContact.id || contact.contactId != contactId || !StringUtil.isSameString((String)contact.displayName, (String)oldContact.displayName) || !StringUtil.isSameString((String)contact.normalizedNumber, (String)oldContact.normalizedNumber)) {
                                    changed = true;
                                }
                            } else {
                                changed = true;
                            }
                            if (changed) {
                                cacheUpdated = true;
                                changeFromIdx = idx;
                                for (int i = oldCache.size() - 1; i >= idx; --i) {
                                    Contact contactRemoved = oldCache.remove(i);
                                    changedItems.add(0, contactRemoved);
                                }
                                contact.sortKey = SortUtil.getSortKey((String)contact.displayName, (Locale)locale);
                                oldCache.add(contact);
                            }
                        } else {
                            contact.sortKey = SortUtil.getSortKey((String)contact.displayName, (Locale)locale);
                            oldCache.add(contact);
                        }
                        ++idx;
                    }
                    if ((hasItem = cursor.moveToNext()) || idx >= oldCache.size()) continue;
                    while (idx < oldCache.size()) {
                        oldCache.remove(oldCache.size() - 1);
                    }
                }
            }
            try {
                cursor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        result.updated = cacheUpdated;
        result.changeFromIndex = changeFromIdx;
        result.changedItems = changedItems;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached() {
        Object object = this.mLockReload;
        synchronized (object) {
            return this.mIsCached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCachedContactsCount() {
        Object object = this.mLockReload;
        synchronized (object) {
            return this.mCache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Contact getCachedContact(int index) {
        Object object = this.mLockReload;
        synchronized (object) {
            if (index < 0 || index >= this.mCache.size()) {
                return null;
            }
            return this.mCache.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNewContactsCount() {
        Object object = this.mLockReload;
        synchronized (object) {
            if (this.mNewItems == null) {
                return 0;
            }
            return this.mNewItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Contact getNewContact(int index) {
        Object object = this.mLockReload;
        synchronized (object) {
            if (this.mNewItems == null) {
                return null;
            }
            if (index < 0 || index >= this.mNewItems.size()) {
                return null;
            }
            return this.mNewItems.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNewContacts() {
        Object object = this.mLockReload;
        synchronized (object) {
            this.mNewItems = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllContactsPhoneNumber() {
        Object object = this.mLockReload;
        synchronized (object) {
            HashSet<String> nums = new HashSet<String>();
            if (!this.isCached() && !this.reloadAllContacts()) {
                return nums;
            }
            for (int i = 0; i < this.getCachedContactsCount(); ++i) {
                Contact contact = this.getCachedContact(i);
                if (StringUtil.isEmptyOrNull((String)contact.normalizedNumber)) continue;
                nums.add(contact.normalizedNumber);
            }
            return nums;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Contact getFirstContactByPhoneNumber(String phoneNumber) {
        Object object = this.mLockReload;
        synchronized (object) {
            if (StringUtil.isEmptyOrNull((String)phoneNumber)) {
                return null;
            }
            Contact contact = this.mMapPhoneNumberToContact.get(phoneNumber);
            if (contact != null) {
                if (contact.isInvalidInstance()) {
                    return null;
                }
                return contact;
            }
            if (!this.isCached() && !this.reloadAllContacts()) {
                return null;
            }
            for (int i = 0; i < this.getCachedContactsCount(); ++i) {
                contact = this.getCachedContact(i);
                String normalizedNumber = contact.normalizedNumber;
                if (normalizedNumber == null || !normalizedNumber.equals(phoneNumber)) continue;
                this.mMapPhoneNumberToContact.put(phoneNumber, contact);
                return contact;
            }
            this.mMapPhoneNumberToContact.put(phoneNumber, Contact.invalidInstance());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(boolean selfChange) {
        Object object = this.mLockReload;
        synchronized (object) {
            this.mNeedReloadAll = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needReloadAll() {
        Object object = this.mLockReload;
        synchronized (object) {
            boolean bPermChange = false;
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    int permission2 = VideoBoxApplication.getInstance().checkPermission("android.permission.READ_CONTACTS", Process.myPid(), Process.myUid());
                    if (permission2 != this.mLastReloadContactPermission && permission2 == 0) {
                        bPermChange = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.mNeedReloadAll || !this.mIsCached || bPermChange;
        }
    }

    private int findContactCompareIdNumber(Contact contact, ArrayList<Contact> contacts) {
        int idxFrom;
        int idx = Collections.binarySearch(contacts, contact, new Comparator<Contact>(){

            @Override
            public int compare(Contact lhs, Contact rhs) {
                if (lhs == null && rhs != null) {
                    return -1;
                }
                if (lhs != null && rhs == null) {
                    return 1;
                }
                if (lhs == null) {
                    return 0;
                }
                return lhs.contactId - rhs.contactId;
            }
        });
        if (idx < 0) {
            return idx;
        }
        Contact item = contacts.get(idx);
        if (item.normalizedNumber.equals(contact.normalizedNumber)) {
            return idx;
        }
        for (idxFrom = idx; idxFrom > 0; --idxFrom) {
            item = contacts.get(idxFrom - 1);
            if (item.contactId != contact.contactId) break;
            if (!item.normalizedNumber.equals(contact.normalizedNumber)) continue;
            return idxFrom;
        }
        for (idxFrom = idx; idxFrom < contacts.size() - 1; ++idxFrom) {
            item = contacts.get(idxFrom + 1);
            if (item.contactId != contact.contactId) break;
            if (!item.normalizedNumber.equals(contact.normalizedNumber)) continue;
            return idxFrom;
        }
        return -1;
    }

    public static class ContactsComparator
    implements Comparator<Contact> {
        private Collator mCollator;

        public ContactsComparator(Locale locale) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
        }

        @Override
        public int compare(Contact lhs, Contact rhs) {
            String str1 = lhs.sortKey;
            String str2 = rhs.sortKey;
            if (str1 == null) {
                str1 = "";
            }
            if (str2 == null) {
                str2 = "";
            }
            return this.mCollator.compare(str1, str2);
        }
    }

    class LoadContactsTask
    extends ZMAsyncTask<ArrayList<Contact>, Integer, LoadContactsResult> {
        ArrayList<Contact> reloadCache = null;
        LoadContactsResult result = null;

        public LoadContactsTask(ArrayList<Contact> reloadCache) {
            this.reloadCache = reloadCache;
        }

        protected LoadContactsResult doInBackground(ArrayList<Contact> ... params) {
            this.result = ABContactsCache.reloadAllContactsImpl(this.reloadCache);
            return this.result;
        }

        protected void onPostExecute(LoadContactsResult result) {
            if (!this.isCancelled()) {
                ABContactsCache.this.onLoadContactsTaskComplete(this.reloadCache, result);
            }
        }

        protected void onCancelled() {
            ABContactsCache.this.onLoadContactsTaskComplete(this.reloadCache, this.result);
        }
    }

    static class LoadContactsResult {
        boolean updated = false;
        int changeFromIndex = -1;
        ArrayList<Contact> changedItems = null;

        LoadContactsResult() {
        }
    }

    public static class Contact {
        private int id;
        public int contactId;
        public String displayName;
        public String number;
        public int type;
        public String normalizedNumber;
        public String normalizeCountryCode;
        public String sortKey;
        private static Contact _invalidInstance = new Contact(-1);

        public Contact() {
        }

        private Contact(int contactId) {
            this.contactId = contactId;
        }

        public static Contact invalidInstance() {
            return _invalidInstance;
        }

        private boolean isInvalidInstance() {
            return this == _invalidInstance;
        }

        public boolean filter(String key) {
            String t;
            if (TextUtils.isEmpty((CharSequence)key)) {
                return true;
            }
            Locale locale = CompatUtils.getLocalDefault();
            key = key.toLowerCase(locale);
            if (this.displayName != null && this.displayName.toLowerCase(locale).contains(key)) {
                return true;
            }
            if (this.normalizedNumber != null && this.normalizedNumber.contains(key)) {
                return true;
            }
            return this.number != null && (t = this.number.replace(" ", "").replace("-", "")).contains(key);
        }
    }

    public static interface IABContactsCacheListener
    extends IListener {
        public void onContactsCacheUpdated();
    }
}

