/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.poll;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.text.NumberFormat;
import java.util.ArrayList;
import us.zoom.videomeetings.R;

public class PollingResultItem {
    private String mQuestion;
    private int mQuestionType = 0;
    private ArrayList<Answer> mAnswers = new ArrayList();
    private boolean mbShowSelectedCount = true;

    public String getQuestion() {
        return this.mQuestion;
    }

    public void setQuestion(String question) {
        this.mQuestion = question;
    }

    public void setQuestionType(int questionType) {
        this.mQuestionType = questionType;
    }

    public int getQuestionType() {
        return this.mQuestionType;
    }

    public void addAnswer(Answer answer) {
        if (answer != null) {
            this.mAnswers.add(answer);
        }
    }

    public int getAnswerCount() {
        return this.mAnswers.size();
    }

    public Answer getAnswerAt(int index) {
        return this.mAnswers.get(index);
    }

    public void setShowSelectedCount(boolean show) {
        this.mbShowSelectedCount = show;
    }

    public boolean getShowSelectedCount() {
        return this.mbShowSelectedCount;
    }

    public ArrayList<Integer> getMaxSelectedAnswers() {
        Answer answer;
        int i;
        ArrayList<Integer> items = new ArrayList<Integer>();
        int maxVal = 0;
        int countAnswers = this.getAnswerCount();
        if (countAnswers <= 0) {
            return items;
        }
        int firstVal = this.getAnswerAt(0).getCountSelected();
        for (i = 0; i < countAnswers; ++i) {
            int val;
            answer = this.getAnswerAt(i);
            if (answer == null || maxVal >= (val = answer.getCountSelected())) continue;
            maxVal = val;
        }
        for (i = 0; i < countAnswers; ++i) {
            answer = this.getAnswerAt(i);
            if (answer == null || answer.getCountSelected() != maxVal) continue;
            items.add(i);
        }
        return items;
    }

    public View getView(int questionIndex, Context context, View convertView, ViewGroup parent) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View view = null;
        String tag = "PollingResultItemView";
        if (convertView != null && "PollingResultItemView".equals(convertView.getTag())) {
            view = convertView;
        } else {
            view = inflater.inflate(R.layout.zm_polling_result_question, parent, false);
            view.setTag((Object)"PollingResultItemView");
        }
        TextView txtQuestion = (TextView)view.findViewById(R.id.txtQuestion);
        ViewGroup panelAnswersContainer = (ViewGroup)view.findViewById(R.id.panelAnswersContainer);
        int questionNum = questionIndex + 1;
        String questionText = questionNum + ". " + this.getQuestion();
        if (this.mQuestionType == 1) {
            questionText = questionText + " (" + context.getString(R.string.zm_polling_multiple_choice) + ")";
        }
        txtQuestion.setText((CharSequence)questionText);
        View[] oldChildren = new View[panelAnswersContainer.getChildCount()];
        for (int i = 0; i < oldChildren.length; ++i) {
            oldChildren[i] = panelAnswersContainer.getChildAt(i);
        }
        panelAnswersContainer.removeAllViews();
        ArrayList<Integer> maxSelectedAnswers = this.getMaxSelectedAnswers();
        int countAnswers = this.getAnswerCount();
        for (int i = 0; i < countAnswers; ++i) {
            Answer answer = this.getAnswerAt(i);
            if (answer == null) continue;
            View answerConvertView = null;
            if (i < oldChildren.length) {
                answerConvertView = oldChildren[i];
            }
            panelAnswersContainer.addView(this.buildAnswerView(answer, maxSelectedAnswers.contains(i), inflater, answerConvertView, panelAnswersContainer));
        }
        return view;
    }

    private View buildAnswerView(Answer answer, boolean maxSelected, LayoutInflater inflater, View convertView, ViewGroup parent) {
        View view = null;
        String tag = "AnswerView";
        if (convertView != null && "AnswerView".equals(convertView.getTag())) {
            view = convertView;
        } else {
            view = inflater.inflate(R.layout.zm_polling_result_answer, parent, false);
            view.setTag((Object)"AnswerView");
        }
        TextView txtAnswer = (TextView)view.findViewById(R.id.txtAnswer);
        TextView txtPercent = (TextView)view.findViewById(R.id.txtPercent);
        TextView txtSelectedCount = (TextView)view.findViewById(R.id.txtSelectedCount);
        ProgressBar percent = (ProgressBar)view.findViewById(R.id.percent);
        txtAnswer.setText((CharSequence)answer.getContent());
        txtSelectedCount.setText((CharSequence)("(" + answer.getCountSelected() + ")"));
        if (this.getShowSelectedCount()) {
            txtSelectedCount.setVisibility(0);
        } else {
            txtSelectedCount.setVisibility(8);
        }
        NumberFormat percentFormat = NumberFormat.getNumberInstance();
        percentFormat.setMaximumFractionDigits(1);
        String sPercent = percentFormat.format(answer.getPercent());
        txtPercent.setText((CharSequence)(sPercent + "%"));
        if (maxSelected) {
            percent.setProgress(0);
            percent.setSecondaryProgress((int)(answer.getPercent() + 0.5f));
        } else {
            percent.setProgress((int)(answer.getPercent() + 0.5f));
            percent.setSecondaryProgress(0);
        }
        return view;
    }

    public static class Answer {
        private String mContent;
        private int mCountSelected;
        private float mPercent;

        public Answer(String content, int countSelected, float percent) {
            this.mContent = content;
            this.mCountSelected = countSelected;
            this.mPercent = percent;
        }

        public String getContent() {
            return this.mContent;
        }

        public void setContent(String content) {
            this.mContent = content;
        }

        public int getCountSelected() {
            return this.mCountSelected;
        }

        public void setCountSelected(int countSelected) {
            this.mCountSelected = countSelected;
        }

        public float getPercent() {
            return this.mPercent;
        }

        public void setPercent(float percent) {
            this.mPercent = percent;
        }
    }
}

