/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.poll;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.poll.IPollingListener;
import com.zipow.videobox.poll.IPollingMgr;
import com.zipow.videobox.poll.PollingResultFragment;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;

public class PollingResultActivity
extends ZMActivity
implements IPollingListener {
    public static final String EXTRA_POLLING_ID = "pollingId";
    private PollingResultFragment mResultFragment = null;
    private IPollingMgr mPollingMgr;
    private String mPollingId;

    public PollingResultActivity() {
        this.loadPollingMgr();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.finish();
            return;
        }
        if (VideoBoxApplication.getInstance() == null || VideoBoxApplication.getInstance().isSDKMode() && !mainboard.isSDKConfAppCreated()) {
            this.finish();
            return;
        }
        Intent intent = this.getIntent();
        this.mPollingId = intent.getStringExtra(EXTRA_POLLING_ID);
        if (savedInstanceState == null) {
            this.showPollingResult();
        }
    }

    public void showPollingResult() {
        if (this.mPollingMgr == null) {
            return;
        }
        FragmentManager fm = this.getSupportFragmentManager();
        if (fm == null) {
            return;
        }
        this.mResultFragment = new PollingResultFragment();
        Bundle args = new Bundle();
        args.putString(EXTRA_POLLING_ID, this.mPollingId);
        this.mResultFragment.setArguments(args);
        FragmentTransaction ft = fm.beginTransaction();
        ft.replace(0x1020002, (Fragment)this.mResultFragment, PollingResultFragment.class.getName());
        ft.commit();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mPollingMgr != null) {
            this.mPollingMgr.removeListener(this);
        }
    }

    @Override
    public void onPollingSubmitResult(String pollingId, int result) {
    }

    @Override
    public void onPollingStatusChanged(String pollingId, int status) {
        if (StringUtil.isSameString((String)pollingId, (String)this.mPollingId) && status == 2) {
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

                public void run(IUIElement ui) {
                    ((PollingResultActivity)ui).handlePollingClosed();
                }
            });
        }
    }

    private void handlePollingClosed() {
        this.setResult(0);
        this.finish();
    }

    protected void loadPollingMgr() {
    }

    public void setPollingMgr(IPollingMgr pollingMgr) {
        if (this.mPollingMgr != null) {
            this.mPollingMgr.removeListener(this);
        }
        this.mPollingMgr = pollingMgr;
        if (this.mPollingMgr != null) {
            this.mPollingMgr.addListener(this);
        }
    }

    public IPollingMgr getPollingMgr() {
        return this.mPollingMgr;
    }
}

