/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.poll;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.zipow.videobox.poll.IPollingAnswer;
import com.zipow.videobox.poll.IPollingDoc;
import com.zipow.videobox.poll.IPollingMgr;
import com.zipow.videobox.poll.IPollingQuestion;
import com.zipow.videobox.poll.PollingActivity;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.videomeetings.R;

public class PollingQuestionFragment
extends ZMFragment
implements View.OnClickListener {
    private static final String TAG = PollingQuestionFragment.class.getSimpleName();
    public static final String ARG_QUESTION_INDEX = "questionIndex";
    public static final String ARG_POLLING_ID = "pollingId";
    public static final String ARG_QUESTION_ID = "questionId";
    public static final String ARG_IS_READONLY = "isReadOnly";
    public static final String ARG_READYONLY_MESSAGE_RES = "readOnlyMessageRes";
    private int mQuestionIndex = -1;
    private String mPollingId;
    private String mQuestionId;
    private boolean mIsReadOnly = false;
    private int mReadOnlyMessageRes = 0;
    private View mBtnBack;
    private Button mBtnPrev;
    private Button mBtnNext;
    private Button mBtnSubmitCenter;
    private TextView mTxtQuestionIndex;
    private TextView mTxtTitle;
    private TextView mTxtQuestion;
    private TextView mTxtReadOnlyMessage;
    private ViewGroup mPanelAnswersContainer;
    private ViewGroup mPanelButtons;
    private int mQuestionType = 0;
    private View.OnClickListener mChoiceClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            PollingQuestionFragment.this.onClickChoiceItem(v);
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        this.mQuestionIndex = args.getInt(ARG_QUESTION_INDEX, -1);
        this.mPollingId = args.getString(ARG_POLLING_ID);
        this.mQuestionId = args.getString(ARG_QUESTION_ID);
        this.mIsReadOnly = args.getBoolean(ARG_IS_READONLY);
        this.mReadOnlyMessageRes = args.getInt(ARG_READYONLY_MESSAGE_RES);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_polling_question, container, false);
        this.mBtnBack = view.findViewById(R.id.btnBack);
        this.mBtnPrev = (Button)view.findViewById(R.id.btnPrev);
        this.mBtnNext = (Button)view.findViewById(R.id.btnNext);
        this.mBtnSubmitCenter = (Button)view.findViewById(R.id.btnSubmitCenter);
        this.mTxtQuestionIndex = (TextView)view.findViewById(R.id.txtQuestionIndex);
        this.mTxtQuestion = (TextView)view.findViewById(R.id.txtQuestion);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mPanelAnswersContainer = (ViewGroup)view.findViewById(R.id.panelAnswersContainer);
        this.mTxtReadOnlyMessage = (TextView)view.findViewById(R.id.txtReadOnlyMessage);
        this.mPanelButtons = (ViewGroup)view.findViewById(R.id.panelButtons);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnPrev.setOnClickListener((View.OnClickListener)this);
        this.mBtnNext.setOnClickListener((View.OnClickListener)this);
        this.mBtnSubmitCenter.setOnClickListener((View.OnClickListener)this);
        this.initView(inflater, savedInstanceState);
        return view;
    }

    private void initView(LayoutInflater inflater, Bundle savedInstanceState) {
        PollingActivity activity = (PollingActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        int questionIdx = this.getQuestionIndex();
        int questionCount = activity.getQuestionCount();
        if (questionCount > 1) {
            this.mBtnSubmitCenter.setVisibility(8);
            if (questionIdx == questionCount - 1) {
                if (this.mIsReadOnly) {
                    this.mBtnNext.setVisibility(8);
                } else {
                    this.mBtnNext.setText(R.string.zm_polling_btn_submit);
                }
            }
        } else {
            this.mPanelButtons.setVisibility(8);
            if (this.mIsReadOnly) {
                this.mBtnSubmitCenter.setVisibility(8);
            }
        }
        if (questionIdx == 0) {
            this.mBtnPrev.setVisibility(8);
        }
        int questionNum = questionIdx + 1;
        this.mTxtQuestionIndex.setText((CharSequence)(String.valueOf(questionNum) + "/" + String.valueOf(activity.getQuestionCount())));
        IPollingDoc doc = this.getPollingDoc();
        if (doc == null) {
            return;
        }
        String name = doc.getPollingName();
        if (name == null) {
            name = "";
        }
        this.mTxtTitle.setText((CharSequence)name);
        if (this.mQuestionId == null) {
            return;
        }
        IPollingQuestion question = doc.getQuestionById(this.mQuestionId);
        if (question == null) {
            return;
        }
        String text = question.getQuestionText();
        if (questionCount > 1) {
            text = questionNum + ". " + text;
        }
        if (question.getQuestionType() == 1) {
            text = text + " (" + this.getString(R.string.zm_polling_multiple_choice) + ")";
        }
        this.mTxtQuestion.setText((CharSequence)text);
        this.buildAnswersComponents(inflater, question);
        this.updateButtonsStatus();
        if (this.mReadOnlyMessageRes != 0) {
            this.mTxtReadOnlyMessage.setVisibility(0);
            this.mTxtReadOnlyMessage.setText(this.mReadOnlyMessageRes);
        } else {
            this.mTxtReadOnlyMessage.setVisibility(8);
        }
    }

    private void buildAnswersComponents(LayoutInflater inflater, IPollingQuestion question) {
        this.mPanelAnswersContainer.removeAllViews();
        this.mQuestionType = question.getQuestionType();
        int cnt = question.getAnswerCount();
        for (int i = 0; i < cnt; ++i) {
            IPollingAnswer answer = question.getAnswerAt(i);
            if (answer == null) continue;
            this.buildAnswerComponent(inflater, this.mQuestionType, answer, i);
        }
    }

    private void buildAnswerComponent(LayoutInflater inflater, int questionType, IPollingAnswer answer, int answerIndex) {
        String text = answer.getAnswerText();
        if (text == null) {
            text = "";
        }
        if (questionType == 0) {
            ViewGroup item = (ViewGroup)inflater.inflate(R.layout.zm_polling_single_choice, this.mPanelAnswersContainer, false);
            TextView txtContent = (TextView)item.findViewById(R.id.txtContent);
            boolean selected = answer.isChecked();
            txtContent.setText((CharSequence)text);
            item.setSelected(selected);
            item.setTag((Object)answer.getAnswerId());
            item.setEnabled(!this.mIsReadOnly);
            this.mPanelAnswersContainer.addView((View)item);
            item.setOnClickListener(this.mChoiceClickListener);
        } else if (questionType == 1) {
            ViewGroup item = (ViewGroup)inflater.inflate(R.layout.zm_polling_multiple_choice, this.mPanelAnswersContainer, false);
            TextView txtContent = (TextView)item.findViewById(R.id.txtContent);
            boolean selected = answer.isChecked();
            txtContent.setText((CharSequence)text);
            item.setSelected(selected);
            item.setTag((Object)answer.getAnswerId());
            item.setEnabled(!this.mIsReadOnly);
            this.mPanelAnswersContainer.addView((View)item);
            item.setOnClickListener(this.mChoiceClickListener);
        }
    }

    private void onClickChoiceItem(View v) {
        if (v == null) {
            return;
        }
        IPollingQuestion question = this.getPollingQuestion();
        if (question == null) {
            return;
        }
        String answerId = (String)v.getTag();
        if (answerId == null) {
            return;
        }
        if (this.mQuestionType == 0) {
            int cnt = this.mPanelAnswersContainer.getChildCount();
            for (int i = 0; i < cnt; ++i) {
                IPollingAnswer answer;
                View item = this.mPanelAnswersContainer.getChildAt(i);
                String itemAnswerId = (String)item.getTag();
                if (itemAnswerId == null || (answer = question.getAnswerById(itemAnswerId)) == null) continue;
                item.setSelected(v == item);
                answer.setChecked(item.isSelected());
            }
        } else {
            v.setSelected(!v.isSelected());
            IPollingAnswer answer = question.getAnswerById(answerId);
            if (answer == null) {
                return;
            }
            answer.setChecked(v.isSelected());
        }
        this.updateButtonsStatus();
    }

    public int getQuestionIndex() {
        if (this.mQuestionIndex >= 0) {
            return this.mQuestionIndex;
        }
        Bundle args = this.getArguments();
        if (args == null) {
            return -1;
        }
        this.mQuestionIndex = args.getInt(ARG_QUESTION_INDEX, -1);
        return this.mQuestionIndex;
    }

    private IPollingQuestion getPollingQuestion() {
        if (this.mQuestionId == null) {
            return null;
        }
        IPollingDoc doc = this.getPollingDoc();
        if (doc == null) {
            return null;
        }
        IPollingQuestion question = doc.getQuestionById(this.mQuestionId);
        return question;
    }

    private IPollingDoc getPollingDoc() {
        if (this.mPollingId == null) {
            return null;
        }
        PollingActivity activity = (PollingActivity)this.getActivity();
        if (activity == null) {
            return null;
        }
        IPollingMgr pollingMgr = activity.getPollingMgr();
        if (pollingMgr == null) {
            return null;
        }
        IPollingDoc doc = pollingMgr.getPollingDocById(this.mPollingId);
        if (doc == null) {
            return null;
        }
        return doc;
    }

    private void updateButtonsStatus() {
        this.updateNextButtonStatus();
        this.updateSubmitCenterButtonStatus();
    }

    private void updateNextButtonStatus() {
        this.mBtnNext.setEnabled(this.mIsReadOnly || this.isAnswered());
    }

    private void updateSubmitCenterButtonStatus() {
        this.mBtnSubmitCenter.setEnabled(this.mIsReadOnly || this.isAnswered());
    }

    private boolean isAnswered() {
        View button = null;
        int cnt = this.mPanelAnswersContainer.getChildCount();
        for (int i = 0; i < cnt; ++i) {
            button = this.mPanelAnswersContainer.getChildAt(i);
            if (!button.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void onClick(View v) {
        if (v == this.mBtnBack) {
            this.onClickBtnBack();
        } else if (v == this.mBtnPrev) {
            this.onClickBtnPrev();
        } else if (v == this.mBtnNext) {
            this.onClickBtnNext();
        } else if (v == this.mBtnSubmitCenter) {
            this.onClickBtnSubmit();
        }
    }

    private void onClickBtnBack() {
        PollingActivity activity = (PollingActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        activity.finish();
    }

    private void onClickBtnPrev() {
        PollingActivity activity = (PollingActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        activity.showPreviousQuesion();
    }

    private void onClickBtnNext() {
        if (!this.mIsReadOnly && !this.isAnswered()) {
            return;
        }
        PollingActivity activity = (PollingActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        if (this.getQuestionIndex() < activity.getQuestionCount() - 1) {
            activity.showNextQuestion();
        } else {
            this.submit();
        }
    }

    private void onClickBtnSubmit() {
        if (!this.mIsReadOnly && !this.isAnswered()) {
            return;
        }
        this.submit();
    }

    private void submit() {
        PollingActivity activity = (PollingActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        activity.submitPolling();
    }
}

