/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.photopicker;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.CheckBox;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.TextView;
import com.bumptech.glide.RequestManager;
import com.zipow.videobox.photopicker.OnItemCheckStateChangedListener;
import com.zipow.videobox.photopicker.OnPhotoClickListener;
import com.zipow.videobox.photopicker.PhotoGridAdapter;
import com.zipow.videobox.photopicker.PhotoPagerFragment;
import com.zipow.videobox.photopicker.PhotoPickerActivity;
import com.zipow.videobox.photopicker.PopupDirectoryListAdapter;
import com.zipow.videobox.photopicker.entity.Photo;
import com.zipow.videobox.photopicker.entity.PhotoDirectory;
import com.zipow.videobox.util.ZMGlideUtil;
import com.zipow.videobox.util.photopicker.ImageCaptureManager;
import com.zipow.videobox.util.photopicker.MediaStoreHelper;
import com.zipow.videobox.util.photopicker.PermissionsUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.AndroidLifecycleUtils;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.videomeetings.R;

public class PhotoPickerFragment
extends Fragment {
    private TextView mTextView_Send;
    private TextView mTextView_Title;
    private TextView mTextView_Preview;
    private CheckBox mCheckBox_Source;
    private TextView mBtnPhotoDirectory;
    private boolean mSourceChecked = false;
    private ImageCaptureManager mCaptureManager;
    private PhotoGridAdapter mPhotoGridAdapter;
    private PopupDirectoryListAdapter mListAdapter;
    private List<PhotoDirectory> mPhotoDirectories;
    private int SCROLL_THRESHOLD = 30;
    int mColumn;
    int mMaxSelectedCount;
    public static int COUNT_MAX_PHOTO_DIRECTORY = 6;
    private ListPopupWindow mPhotoDirsPopupWindow;
    private RequestManager mGlideRequestManager;

    public static PhotoPickerFragment newInstance(boolean showCamera, boolean showGif, boolean previewEnable, int column, int maxCount, ArrayList<String> originalPhotos) {
        Bundle args = new Bundle();
        args.putBoolean("SHOW_CAMERA", showCamera);
        args.putBoolean("SHOW_GIF", showGif);
        args.putBoolean("PREVIEW_ENABLED", previewEnable);
        args.putInt("column", column);
        args.putInt("MAX_COUNT", maxCount);
        args.putStringArrayList("android.speech.extra.ORIGIN", originalPhotos);
        PhotoPickerFragment fragment = new PhotoPickerFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        this.mGlideRequestManager = ZMGlideUtil.getGlideRequestManager(this);
        this.mPhotoDirectories = new ArrayList<PhotoDirectory>();
        this.mMaxSelectedCount = this.getArguments().getInt("MAX_COUNT", 9);
        this.mColumn = this.getArguments().getInt("column", 3);
        boolean showCamera = this.getArguments().getBoolean("SHOW_CAMERA", true);
        boolean previewEnable = this.getArguments().getBoolean("PREVIEW_ENABLED", true);
        this.mPhotoGridAdapter = new PhotoGridAdapter((Context)this.getActivity(), this.mGlideRequestManager, this.mPhotoDirectories, this.getArguments().getStringArrayList("android.speech.extra.ORIGIN"), this.mColumn, this.mMaxSelectedCount);
        this.mPhotoGridAdapter.setShowCamera(showCamera);
        this.mPhotoGridAdapter.setPreviewEnable(previewEnable);
        this.mPhotoGridAdapter.setOnItemCheckStateChangedListener(new OnItemCheckStateChangedListener(){

            @Override
            public void onItemCheckStateChanged(int position, Photo photo, int selectedItemCount) {
                PhotoPickerFragment.this.updateSelectState();
            }
        });
        this.mListAdapter = new PopupDirectoryListAdapter(this.mGlideRequestManager, this.mPhotoDirectories);
        Bundle mediaStoreArgs = new Bundle();
        boolean showGif = this.getArguments().getBoolean("SHOW_GIF");
        mediaStoreArgs.putBoolean("SHOW_GIF", showGif);
        MediaStoreHelper.getPhotoDirs(this.getActivity(), mediaStoreArgs, new MediaStoreHelper.PhotosResultCallback(){

            @Override
            public void onResultCallback(List<PhotoDirectory> dirs) {
                PhotoPickerFragment.this.mPhotoDirectories.clear();
                PhotoPickerFragment.this.mPhotoDirectories.addAll(dirs);
                PhotoPickerFragment.this.mPhotoGridAdapter.notifyDataSetChanged();
                PhotoPickerFragment.this.setCurrentPhotoDirectory(0);
                PhotoPickerFragment.this.mListAdapter.notifyDataSetChanged();
                PhotoPickerFragment.this.adjustHeight();
            }
        });
        this.mCaptureManager = new ImageCaptureManager((Context)this.getActivity());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.zm_picker_fragment_photo_picker, container, false);
        this.mTextView_Send = (TextView)rootView.findViewById(R.id.btnSend);
        this.mTextView_Send.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ((PhotoPickerActivity)PhotoPickerFragment.this.getActivity()).completeSelect(PhotoPickerFragment.this.mCheckBox_Source.isChecked(), PhotoPickerFragment.this.mPhotoGridAdapter.getSelectedPhotoPaths());
            }
        });
        this.mTextView_Title = (TextView)rootView.findViewById(R.id.txtTitle);
        this.mTextView_Title.setText((CharSequence)this.getString(R.string.zm_picker_photos_title));
        rootView.findViewById(R.id.btnBack).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PhotoPickerFragment.this.getActivity().onBackPressed();
            }
        });
        this.mTextView_Preview = (TextView)rootView.findViewById(R.id.btnPreview);
        this.mCheckBox_Source = (CheckBox)rootView.findViewById(R.id.rbSource);
        this.mTextView_Preview.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ArrayList<String> selectedPaths = PhotoPickerFragment.this.mPhotoGridAdapter.getSelectedPhotoPaths();
                PhotoPickerFragment.this.openPagerFragment(0, selectedPaths, selectedPaths);
            }
        });
        RecyclerView recyclerView = (RecyclerView)rootView.findViewById(R.id.rv_photos);
        StaggeredGridLayoutManager layoutManager = new StaggeredGridLayoutManager(this.mColumn, 1);
        layoutManager.setGapStrategy(2);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        recyclerView.setAdapter((RecyclerView.Adapter)this.mPhotoGridAdapter);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.mBtnPhotoDirectory = (TextView)rootView.findViewById(R.id.button);
        this.mPhotoDirsPopupWindow = new ListPopupWindow((Context)this.getActivity());
        this.mPhotoDirsPopupWindow.setWidth(-1);
        this.mPhotoDirsPopupWindow.setAnchorView(rootView.findViewById(R.id.bottomBar));
        this.mPhotoDirsPopupWindow.setAdapter((ListAdapter)this.mListAdapter);
        this.mPhotoDirsPopupWindow.setModal(true);
        if (OsUtil.isAtLeastKLP()) {
            this.mPhotoDirsPopupWindow.setDropDownGravity(80);
        }
        this.mPhotoDirsPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                PhotoPickerFragment.this.mPhotoDirsPopupWindow.dismiss();
                PhotoPickerFragment.this.setCurrentPhotoDirectory(position);
                PhotoPickerFragment.this.mPhotoGridAdapter.setCurrentDirectoryIndex(position);
                PhotoPickerFragment.this.mPhotoGridAdapter.notifyDataSetChanged();
            }
        });
        this.mPhotoGridAdapter.setOnPhotoClickListener(new OnPhotoClickListener(){

            @Override
            public void onClick(View v, int position, boolean showCamera) {
                int index = showCamera ? position - 1 : position;
                PhotoPickerFragment.this.openPagerFragment(index, PhotoPickerFragment.this.mPhotoGridAdapter.getCurrentPhotoPaths(), PhotoPickerFragment.this.mPhotoGridAdapter.getSelectedPhotoPaths());
            }
        });
        this.mPhotoGridAdapter.setOnCameraClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!PermissionsUtils.checkCameraPermission(PhotoPickerFragment.this)) {
                    return;
                }
                if (!PermissionsUtils.checkWriteStoragePermission(PhotoPickerFragment.this)) {
                    return;
                }
                PhotoPickerFragment.this.openCamera();
            }
        });
        this.mBtnPhotoDirectory.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PhotoPickerFragment.this.mPhotoDirsPopupWindow.isShowing()) {
                    PhotoPickerFragment.this.mPhotoDirsPopupWindow.dismiss();
                } else if (!PhotoPickerFragment.this.getActivity().isFinishing()) {
                    PhotoPickerFragment.this.adjustHeight();
                    PhotoPickerFragment.this.mPhotoDirsPopupWindow.show();
                }
            }
        });
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (Math.abs(dy) > PhotoPickerFragment.this.SCROLL_THRESHOLD) {
                    PhotoPickerFragment.this.mGlideRequestManager.pauseRequests();
                } else {
                    PhotoPickerFragment.this.resumeRequestsIfNotDestroyed();
                }
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == 0) {
                    PhotoPickerFragment.this.resumeRequestsIfNotDestroyed();
                }
            }
        });
        return rootView;
    }

    private void setCurrentPhotoDirectory(int position) {
        FragmentActivity ac = this.getActivity();
        if (!(ac instanceof PhotoPickerActivity)) {
            return;
        }
        if (this.mPhotoDirectories == null || this.mPhotoDirectories.isEmpty()) {
            ((PhotoPickerActivity)ac).setSelectedPhotoDirectory(null);
            return;
        }
        PhotoDirectory directory = this.mPhotoDirectories.get(position);
        ((PhotoPickerActivity)ac).setSelectedPhotoDirectory(directory);
        this.updateSelectedDirectory();
    }

    private void openCamera() {
        try {
            Intent intent = this.mCaptureManager.dispatchTakePictureIntent();
            this.startActivityForResult(intent, 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ActivityNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1 && resultCode == -1) {
            if (this.mCaptureManager == null) {
                FragmentActivity activity = this.getActivity();
                this.mCaptureManager = new ImageCaptureManager((Context)activity);
            }
            this.mCaptureManager.galleryAddPic();
            if (this.mPhotoDirectories.size() > 0) {
                String path = this.mCaptureManager.getCurrentPhotoPath();
                PhotoDirectory directory = this.mPhotoDirectories.get(0);
                directory.getPhotos().add(0, new Photo(path.hashCode(), path));
                directory.setCoverPath(path);
                this.mPhotoGridAdapter.notifyDataSetChanged();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (grantResults.length > 0 && grantResults[0] == 0) {
            switch (requestCode) {
                case 1: 
                case 3: {
                    if (!PermissionsUtils.checkWriteStoragePermission(this) || !PermissionsUtils.checkCameraPermission(this)) break;
                    this.openCamera();
                }
            }
        }
    }

    public PhotoGridAdapter getPhotoGridAdapter() {
        return this.mPhotoGridAdapter;
    }

    public void updateSelectState() {
        int selectedCount = 0;
        if (this.mPhotoGridAdapter != null) {
            selectedCount = this.mPhotoGridAdapter.getSelectedItemCount();
        }
        if (this.mTextView_Preview != null) {
            this.mTextView_Preview.setEnabled(selectedCount > 0);
            this.mTextView_Preview.setText((CharSequence)this.getString(R.string.zm_picker_preview_with_count, new Object[]{selectedCount}));
        }
        if (this.mTextView_Send != null) {
            this.mTextView_Send.setEnabled(selectedCount > 0);
            this.mTextView_Send.setText((CharSequence)this.getString(R.string.zm_picker_done_with_count, new Object[]{selectedCount}));
        }
    }

    private void updateSelectedDirectory() {
        PhotoDirectory dir;
        FragmentActivity ac = this.getActivity();
        if (ac instanceof PhotoPickerActivity && (dir = ((PhotoPickerActivity)ac).getSelectedPhotoDirectory()) != null) {
            this.mBtnPhotoDirectory.setText((CharSequence)dir.getName());
        }
    }

    public void onResume() {
        super.onResume();
        this.updateSelectState();
        this.updateSelectedDirectory();
        this.mCheckBox_Source.setChecked(this.mSourceChecked);
    }

    public void onPause() {
        super.onPause();
        this.mSourceChecked = this.mCheckBox_Source.isChecked();
    }

    public void onSaveInstanceState(Bundle outState) {
        this.mCaptureManager.onSaveInstanceState(outState);
        super.onSaveInstanceState(outState);
    }

    public void onViewStateRestored(Bundle savedInstanceState) {
        this.mCaptureManager.onRestoreInstanceState(savedInstanceState);
        super.onViewStateRestored(savedInstanceState);
    }

    public ArrayList<String> getSelectedPhotoPaths() {
        return this.mPhotoGridAdapter.getSelectedPhotoPaths();
    }

    public void adjustHeight() {
        if (this.mListAdapter == null) {
            return;
        }
        int count = this.mListAdapter.getCount();
        int n = count = count < COUNT_MAX_PHOTO_DIRECTORY ? count : COUNT_MAX_PHOTO_DIRECTORY;
        if (this.mPhotoDirsPopupWindow != null) {
            this.mPhotoDirsPopupWindow.setHeight(count * this.getResources().getDimensionPixelOffset(R.dimen.zm_picker_item_directory_height));
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mPhotoDirectories == null) {
            return;
        }
        for (PhotoDirectory directory : this.mPhotoDirectories) {
            directory.getPhotoPaths().clear();
            directory.getPhotos().clear();
            directory.setPhotos(null);
        }
        this.mPhotoDirectories.clear();
        this.mPhotoDirectories = null;
    }

    private void resumeRequestsIfNotDestroyed() {
        if (!AndroidLifecycleUtils.canLoadImage((Fragment)this)) {
            return;
        }
        this.mGlideRequestManager.resumeRequests();
    }

    public void resetSelectedPhotoPaths(List<String> paths) {
        if (this.mPhotoGridAdapter != null) {
            this.mPhotoGridAdapter.setSelectedPhotoPaths(paths);
            this.mPhotoGridAdapter.resetCheckState();
        }
    }

    public void setSourceChecked(boolean checked) {
        this.mSourceChecked = checked;
    }

    private void openPagerFragment(int index, List<String> allPaths, List<String> selectedPaths) {
        PhotoPagerFragment photoPagerFragment = PhotoPagerFragment.newInstance(allPaths, index, selectedPaths, this.mMaxSelectedCount, this.mCheckBox_Source.isChecked(), true);
        ((PhotoPickerActivity)this.getActivity()).addImagePagerFragment(photoPagerFragment);
    }
}

