/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.photopicker;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import com.zipow.videobox.photopicker.PhotoPagerFragment;
import com.zipow.videobox.photopicker.PhotoPickerFragment;
import com.zipow.videobox.photopicker.entity.PhotoDirectory;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.videomeetings.R;

public class PhotoPickerActivity
extends ZMActivity {
    private PhotoPickerFragment mPhotoPickerFragment;
    private PhotoPagerFragment mPhotoPagerFragment;
    private boolean mShowGif = false;
    private int mMaxSelectCount = 9;
    private PhotoDirectory mSelectedPhotoDirectory;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.disableFinishActivityByGesture(true);
        boolean showGif = this.getIntent().getBooleanExtra("SHOW_GIF", false);
        this.mMaxSelectCount = this.getIntent().getIntExtra("MAX_COUNT", 9);
        this.setShowGif(showGif);
        this.setContentView(R.layout.zm_picker_activity_photo_picker);
        this.mPhotoPickerFragment = (PhotoPickerFragment)this.getSupportFragmentManager().findFragmentByTag("tag");
        if (this.mPhotoPickerFragment == null) {
            this.mPhotoPickerFragment = PhotoPickerFragment.newInstance(this.getIntent().getBooleanExtra("SHOW_CAMERA", false), showGif, this.getIntent().getBooleanExtra("PREVIEW_ENABLED", true), this.getIntent().getIntExtra("column", 3), this.mMaxSelectCount, this.getIntent().getStringArrayListExtra("ORIGINAL_PHOTOS"));
            this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)this.mPhotoPickerFragment, "tag").commit();
            this.getSupportFragmentManager().executePendingTransactions();
        }
    }

    public void onBackPressed() {
        if (this.mPhotoPagerFragment != null && this.mPhotoPagerFragment.isVisible()) {
            List<String> selectPaths = this.mPhotoPagerFragment.getSelectedPhotos();
            this.mPhotoPickerFragment.resetSelectedPhotoPaths(selectPaths);
            this.mPhotoPickerFragment.setSourceChecked(this.mPhotoPagerFragment.isSourceChecked());
            this.mPhotoPagerFragment.runExitAnimation(new Runnable(){

                @Override
                public void run() {
                    if (PhotoPickerActivity.this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
                        PhotoPickerActivity.this.getSupportFragmentManager().popBackStack();
                    }
                }
            });
        } else {
            super.onBackPressed();
        }
    }

    public void addImagePagerFragment(PhotoPagerFragment photoPagerFragment) {
        this.mPhotoPagerFragment = photoPagerFragment;
        this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)this.mPhotoPagerFragment).addToBackStack(null).commit();
    }

    public void completeSelect(boolean checkSource, ArrayList<String> list) {
        Intent intent = new Intent();
        intent.putStringArrayListExtra("SELECTED_PHOTOS", list);
        this.setResult(-1, intent);
        this.finish();
    }

    protected void onResume() {
        super.onResume();
    }

    public PhotoPickerActivity getActivity() {
        return this;
    }

    public boolean isShowGif() {
        return this.mShowGif;
    }

    public void setShowGif(boolean showGif) {
        this.mShowGif = showGif;
    }

    public PhotoDirectory getSelectedPhotoDirectory() {
        return this.mSelectedPhotoDirectory;
    }

    public void setSelectedPhotoDirectory(PhotoDirectory selectedPhotoDirectory) {
        this.mSelectedPhotoDirectory = selectedPhotoDirectory;
    }
}

