/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.photopicker;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.CheckBox;
import android.widget.TextView;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.view.ViewHelper;
import com.nineoldandroids.view.ViewPropertyAnimator;
import com.zipow.videobox.photopicker.OnPagerItemClickListener;
import com.zipow.videobox.photopicker.OnPhotoPickerHoriItemCallback;
import com.zipow.videobox.photopicker.PhotoHorizentalAdapter;
import com.zipow.videobox.photopicker.PhotoPagerAdapter;
import com.zipow.videobox.photopicker.PhotoPickerActivity;
import com.zipow.videobox.util.ZMGlideUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.videomeetings.R;

public class PhotoPagerFragment
extends Fragment {
    public static final String TAG = PhotoPagerFragment.class.getName();
    public static final float BOTTOM_BAR_ALPHA = 0.85f;
    private View mPanelTitleBar;
    private TextView mTextView_Send;
    private TextView mTextView_Title;
    private CheckBox mChk_Source;
    private CheckBox mChk_Select;
    private View mBottomBar;
    private View mDividerLine;
    public static final String ARG_ALL_PATH = "ARG_ALL_PATHS";
    public static final String ARG_CURRENT_ITEM = "ARG_CURRENT_ITEM";
    public static final String ARG_SELECTED_PATH = "ARG_SELECTED_PATHS";
    public static final String ARG_MAX_SELECTED_COUNT = "MAX_COUNT";
    public static final String ARG_SOURCE_CHECKED = "ARG_SOURCE_CHECKED";
    private ArrayList<String> mAllPaths = new ArrayList();
    private ArrayList<String> mSelectedPaths = new ArrayList();
    private Map<String, Integer> mAllPathsCache = new HashMap<String, Integer>();
    private Map<String, Integer> mSelectedPathsCache = new HashMap<String, Integer>();
    private ViewPager mViewPager;
    private PhotoPagerAdapter mPagerAdapter;
    private RecyclerView mHorizentalRecyclerView;
    private PhotoHorizentalAdapter mHorizentalAdapter;
    public static final long ANIM_DURATION = 200L;
    public static final String ARG_HAS_ANIM = "HAS_ANIM";
    private boolean mHasAnim = false;
    private int mOrigPageCurrentItem = 0;
    private int mMaxSelectedCount = 0;
    private boolean mSourceChecked = false;

    public static PhotoPagerFragment newInstance(List<String> allPaths, int currentItem, List<String> selectedPaths, int maxSelectedCount, boolean checkSource) {
        return PhotoPagerFragment.newInstance(allPaths, currentItem, selectedPaths, maxSelectedCount, checkSource, false);
    }

    public static PhotoPagerFragment newInstance(List<String> allPaths, int currentItem, List<String> selectedPaths, int maxSelectedCount, boolean checkSource, boolean hasAnim) {
        PhotoPagerFragment f = new PhotoPagerFragment();
        Bundle args = new Bundle();
        args.putStringArray(ARG_ALL_PATH, allPaths.toArray(new String[allPaths.size()]));
        args.putInt(ARG_CURRENT_ITEM, currentItem);
        args.putStringArray(ARG_SELECTED_PATH, selectedPaths.toArray(new String[selectedPaths.size()]));
        args.putBoolean(ARG_HAS_ANIM, hasAnim);
        args.putInt(ARG_MAX_SELECTED_COUNT, maxSelectedCount);
        args.putBoolean(ARG_SOURCE_CHECKED, checkSource);
        f.setArguments(args);
        return f;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            int i;
            String[] pathArr = bundle.getStringArray(ARG_ALL_PATH);
            if (pathArr != null) {
                this.mAllPaths.addAll(Arrays.asList(pathArr));
                for (i = 0; i < pathArr.length; ++i) {
                    this.mAllPathsCache.put(pathArr[i], i);
                }
            }
            this.mHasAnim = bundle.getBoolean(ARG_HAS_ANIM);
            this.mOrigPageCurrentItem = bundle.getInt(ARG_CURRENT_ITEM);
            this.mMaxSelectedCount = bundle.getInt(ARG_MAX_SELECTED_COUNT);
            this.mSourceChecked = bundle.getBoolean(ARG_SOURCE_CHECKED);
            pathArr = bundle.getStringArray(ARG_SELECTED_PATH);
            if (pathArr != null) {
                this.mSelectedPaths.addAll(Arrays.asList(pathArr));
                for (i = 0; i < pathArr.length; ++i) {
                    this.mSelectedPathsCache.put(pathArr[i], i);
                }
            }
        }
        if (this.mAllPaths == null || this.mAllPaths.isEmpty()) {
            ZMLog.e((String)TAG, (String)"all path is empty", (Object[])new Object[0]);
            this.getActivity().finish();
        }
        this.mPagerAdapter = new PhotoPagerAdapter(ZMGlideUtil.getGlideRequestManager(this), this.mAllPaths, new OnPagerItemClickListener(){

            @Override
            public void onItemClick(View view) {
                int visibility = 0;
                if (PhotoPagerFragment.this.mPanelTitleBar.getVisibility() == 0) {
                    visibility = 8;
                }
                PhotoPagerFragment.this.mPanelTitleBar.setVisibility(visibility);
                PhotoPagerFragment.this.mDividerLine.setVisibility(visibility);
                PhotoPagerFragment.this.mBottomBar.setVisibility(visibility);
                PhotoPagerFragment.this.updateSelectStateInHorizentalRecyclerView();
            }
        });
        this.mHorizentalAdapter = new PhotoHorizentalAdapter(ZMGlideUtil.getGlideRequestManager(this), this.mSelectedPaths, new OnPhotoPickerHoriItemCallback(){

            @Override
            public boolean canSelected(String path, int position) {
                return PhotoPagerFragment.this.mAllPathsCache.containsKey(path);
            }

            @Override
            public void onItemClick(View view, String path, int poistion) {
                if (PhotoPagerFragment.this.mAllPathsCache.containsKey(path)) {
                    int indexInAll = (Integer)PhotoPagerFragment.this.mAllPathsCache.get(path);
                    PhotoPagerFragment.this.mViewPager.setCurrentItem(indexInAll);
                    PhotoPagerFragment.this.mChk_Select.setChecked(true);
                }
            }
        });
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.zm_picker_fragment_image_pager, container, false);
        this.mPanelTitleBar = rootView.findViewById(R.id.panelTitleBar);
        this.mTextView_Send = (TextView)rootView.findViewById(R.id.btnSend);
        this.mTextView_Send.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PhotoPagerFragment.this.getActivity() instanceof PhotoPickerActivity) {
                    ((PhotoPickerActivity)PhotoPagerFragment.this.getActivity()).completeSelect(PhotoPagerFragment.this.mChk_Source.isChecked(), PhotoPagerFragment.this.mSelectedPaths);
                }
            }
        });
        rootView.findViewById(R.id.btnBack).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoPagerFragment.this.getActivity().onBackPressed();
            }
        });
        this.mTextView_Title = (TextView)rootView.findViewById(R.id.txtTitle);
        this.mTextView_Title.setText((CharSequence)"");
        this.mViewPager = (ViewPager)rootView.findViewById(R.id.vp_photos);
        this.mViewPager.setAdapter((PagerAdapter)this.mPagerAdapter);
        this.mViewPager.setCurrentItem(this.mOrigPageCurrentItem);
        this.mViewPager.setOffscreenPageLimit(5);
        if (savedInstanceState == null && this.mHasAnim) {
            ViewTreeObserver observer = this.mViewPager.getViewTreeObserver();
            observer.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    PhotoPagerFragment.this.mViewPager.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    int[] screenLocation = new int[2];
                    PhotoPagerFragment.this.mViewPager.getLocationOnScreen(screenLocation);
                    PhotoPagerFragment.this.runEnterAnimation();
                    return true;
                }
            });
        }
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                String cur = (String)PhotoPagerFragment.this.mAllPaths.get(position);
                if (PhotoPagerFragment.this.mSelectedPathsCache.containsKey(cur)) {
                    int indexInSelected = (Integer)PhotoPagerFragment.this.mSelectedPathsCache.get(cur);
                    PhotoPagerFragment.this.mHorizentalRecyclerView.scrollToPosition(indexInSelected);
                    PhotoPagerFragment.this.mHorizentalAdapter.setCurrentItem(indexInSelected);
                } else {
                    PhotoPagerFragment.this.mHorizentalAdapter.setCurrentItem(-1);
                }
                PhotoPagerFragment.this.updateSelectState(false);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mHorizentalRecyclerView = (RecyclerView)rootView.findViewById(R.id.photoHorizentalRecycler);
        this.mBottomBar = rootView.findViewById(R.id.bottomBar);
        this.mDividerLine = rootView.findViewById(R.id.line);
        this.mChk_Select = (CheckBox)rootView.findViewById(R.id.chkSelect);
        this.mChk_Source = (CheckBox)rootView.findViewById(R.id.rbSource);
        this.mChk_Source.setChecked(this.mSourceChecked);
        this.mChk_Select.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean b = PhotoPagerFragment.this.mChk_Select.isChecked();
                String cur = (String)PhotoPagerFragment.this.mAllPaths.get(PhotoPagerFragment.this.mViewPager.getCurrentItem());
                if (b) {
                    if (PhotoPagerFragment.this.mMaxSelectedCount <= 1) {
                        if (!PhotoPagerFragment.this.mSelectedPaths.contains(cur)) {
                            PhotoPagerFragment.this.mSelectedPaths.clear();
                            PhotoPagerFragment.this.mSelectedPaths.add(cur);
                            PhotoPagerFragment.this.mHorizentalAdapter.setCurrentItem(0);
                            PhotoPagerFragment.this.mSelectedPathsCache.clear();
                            PhotoPagerFragment.this.mSelectedPathsCache.put(cur, 0);
                        }
                    } else if (PhotoPagerFragment.this.mSelectedPaths.size() < PhotoPagerFragment.this.mMaxSelectedCount) {
                        PhotoPagerFragment.this.mSelectedPaths.add(cur);
                        PhotoPagerFragment.this.mHorizentalAdapter.setCurrentItem(PhotoPagerFragment.this.mSelectedPaths.size() - 1);
                        PhotoPagerFragment.this.mHorizentalRecyclerView.scrollToPosition(PhotoPagerFragment.this.mSelectedPaths.size() - 1);
                        PhotoPagerFragment.this.mSelectedPathsCache.put(cur, PhotoPagerFragment.this.mSelectedPaths.size() - 1);
                    } else {
                        PhotoPagerFragment.this.mChk_Select.setChecked(false);
                    }
                } else if (PhotoPagerFragment.this.mSelectedPathsCache.containsKey(cur)) {
                    int indexInSelected = (Integer)PhotoPagerFragment.this.mSelectedPathsCache.get(cur);
                    PhotoPagerFragment.this.mSelectedPaths.remove(cur);
                    if (!PhotoPagerFragment.this.mSelectedPaths.isEmpty()) {
                        indexInSelected = Math.min(indexInSelected, PhotoPagerFragment.this.mSelectedPaths.size() - 1);
                        PhotoPagerFragment.this.mHorizentalAdapter.setCurrentItem(indexInSelected);
                        PhotoPagerFragment.this.mHorizentalRecyclerView.scrollToPosition(indexInSelected);
                    }
                    PhotoPagerFragment.this.mSelectedPathsCache.clear();
                    for (int i = 0; i < PhotoPagerFragment.this.mSelectedPaths.size(); ++i) {
                        PhotoPagerFragment.this.mSelectedPathsCache.put(PhotoPagerFragment.this.mSelectedPaths.get(i), i);
                    }
                }
                PhotoPagerFragment.this.updateSelectStateInHorizentalRecyclerView();
                PhotoPagerFragment.this.updateSelectState(true);
            }
        });
        this.mBottomBar.setAlpha(0.85f);
        this.mHorizentalRecyclerView.setAlpha(0.85f);
        this.initBottomRecycleView();
        this.updateSelectState(true);
        return rootView;
    }

    private void initBottomRecycleView() {
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this.getActivity());
        linearLayoutManager.setOrientation(0);
        this.mHorizentalRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.mHorizentalRecyclerView.setAdapter((RecyclerView.Adapter)this.mHorizentalAdapter);
        this.updateSelectStateInHorizentalRecyclerView();
    }

    public void updateSelectStateInHorizentalRecyclerView() {
        int visibility = this.mSelectedPaths != null && !this.mSelectedPaths.isEmpty() && this.mBottomBar.getVisibility() == 0 ? 0 : 8;
        this.mHorizentalRecyclerView.setVisibility(visibility);
        this.mDividerLine.setVisibility(visibility);
        Integer selectedIndex = this.mSelectedPathsCache.get(this.mAllPaths.get(this.mViewPager.getCurrentItem()));
        if (selectedIndex != null) {
            this.mHorizentalAdapter.setCurrentItem(selectedIndex);
        } else {
            this.mHorizentalAdapter.setCurrentItem(-1);
        }
    }

    private void runEnterAnimation() {
        long duration = 200L;
        ViewHelper.setPivotX((View)this.mViewPager, (float)0.0f);
        ViewHelper.setPivotY((View)this.mViewPager, (float)0.0f);
        ViewHelper.setScaleX((View)this.mViewPager, (float)0.5f);
        ViewHelper.setScaleY((View)this.mViewPager, (float)0.5f);
        ViewHelper.setTranslationX((View)this.mViewPager, (float)(this.getResources().getDisplayMetrics().widthPixels / 4));
        ViewHelper.setTranslationY((View)this.mViewPager, (float)(this.getResources().getDisplayMetrics().heightPixels / 4));
        ViewPropertyAnimator.animate((View)this.mViewPager).setDuration(200L).scaleX(1.0f).scaleY(1.0f).translationX(0.0f).translationY(0.0f).setInterpolator((Interpolator)new DecelerateInterpolator());
        ObjectAnimator bgAnim = ObjectAnimator.ofInt((Object)this.mViewPager.getBackground(), (String)"alpha", (int[])new int[]{0, 255});
        bgAnim.setDuration(200L);
        bgAnim.start();
        ObjectAnimator colorizer = ObjectAnimator.ofFloat((Object)((Object)this), (String)"saturation", (float[])new float[]{0.0f, 1.0f});
        colorizer.setDuration(200L);
        colorizer.start();
    }

    public void runExitAnimation(final Runnable endAction) {
        if (!this.getArguments().getBoolean(ARG_HAS_ANIM, false) || !this.mHasAnim) {
            endAction.run();
            return;
        }
        long duration = 200L;
        ViewPropertyAnimator.animate((View)this.mViewPager).setDuration(200L).setInterpolator((Interpolator)new AccelerateInterpolator()).scaleX(0.5f).scaleY(0.5f).translationX((float)(this.getResources().getDisplayMetrics().widthPixels / 4)).translationY((float)(this.getResources().getDisplayMetrics().heightPixels / 4)).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                endAction.run();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        ObjectAnimator bgAnim = ObjectAnimator.ofInt((Object)this.mViewPager.getBackground(), (String)"alpha", (int[])new int[]{0});
        bgAnim.setDuration(200L);
        bgAnim.start();
        ObjectAnimator colorizer = ObjectAnimator.ofFloat((Object)((Object)this), (String)"saturation", (float[])new float[]{1.0f, 0.0f});
        colorizer.setDuration(200L);
        colorizer.start();
    }

    public void updateSelectState(boolean countChanged) {
        if (countChanged) {
            int selectedCount = 0;
            if (this.mSelectedPaths != null) {
                selectedCount = this.mSelectedPaths.size();
            }
            if (this.mTextView_Send != null) {
                this.mTextView_Send.setEnabled(selectedCount > 0);
                this.mTextView_Send.setText((CharSequence)this.getString(R.string.zm_picker_done_with_count, new Object[]{selectedCount}));
            }
        }
        if (this.mChk_Select != null) {
            boolean isChecked = this.mSelectedPathsCache.containsKey(this.mAllPaths.get(this.mViewPager.getCurrentItem()));
            this.mChk_Select.setChecked(isChecked);
            if (!isChecked) {
                this.mChk_Select.setEnabled(this.mSelectedPaths.size() < this.mMaxSelectedCount || this.mMaxSelectedCount <= 1);
            } else {
                this.mChk_Select.setEnabled(true);
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mAllPaths.clear();
        this.mAllPaths = null;
        if (this.mViewPager != null) {
            this.mViewPager.setAdapter(null);
        }
    }

    public List<String> getSelectedPhotos() {
        return this.mSelectedPaths;
    }

    public boolean isSourceChecked() {
        return this.mChk_Source.isChecked();
    }
}

