/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.photopicker;

import android.content.Context;
import android.net.Uri;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.request.RequestOptions;
import com.zipow.videobox.photopicker.OnPagerItemClickListener;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.view.ZMGifView;
import java.io.File;
import java.util.List;
import us.zoom.androidlib.util.AndroidLifecycleUtils;
import us.zoom.videomeetings.R;

public class PhotoPagerAdapter
extends PagerAdapter {
    private List<String> mAllPaths;
    private RequestManager mGlide;
    private OnPagerItemClickListener mItemClickListener;

    public PhotoPagerAdapter(RequestManager glide, List<String> mAllPaths, OnPagerItemClickListener clickListener) {
        this.mAllPaths = mAllPaths;
        this.mGlide = glide;
        this.mItemClickListener = clickListener;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        Context context = container.getContext();
        View itemView = LayoutInflater.from((Context)context).inflate(R.layout.zm_picker_picker_item_pager, container, false);
        ImageView imageView = (ImageView)itemView.findViewById(R.id.viewImage);
        ZMGifView gifView = (ZMGifView)itemView.findViewById(R.id.viewGif);
        String path = this.mAllPaths.get(position);
        Uri uri = path.startsWith("http") ? Uri.parse((String)path) : Uri.fromFile((File)new File(path));
        boolean canLoadImage = AndroidLifecycleUtils.canLoadImage((Context)context);
        boolean isGif = "image/gif".equals(ImageUtil.getImageMimeType(path));
        if (canLoadImage) {
            if (isGif) {
                if (PTApp.getInstance().getZoomFileInfoChecker().isLegalGif(path)) {
                    gifView.setVisibility(0);
                    imageView.setVisibility(8);
                    gifView.setGifResourse(path);
                } else {
                    gifView.setVisibility(8);
                    imageView.setVisibility(0);
                    imageView.setImageResource(R.drawable.zm_image_download_error);
                }
            } else {
                gifView.setVisibility(8);
                imageView.setVisibility(0);
                RequestOptions options = new RequestOptions();
                options.dontAnimate().dontTransform().override(800, 800).placeholder(R.drawable.zm_image_placeholder).error(R.drawable.zm_image_download_error);
                this.mGlide.setDefaultRequestOptions(options).load(uri).thumbnail(0.1f).into(imageView);
            }
        }
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PhotoPagerAdapter.this.mItemClickListener != null) {
                    PhotoPagerAdapter.this.mItemClickListener.onItemClick(v);
                }
            }
        });
        container.addView(itemView);
        return itemView;
    }

    public int getCount() {
        return this.mAllPaths.size();
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
        this.mGlide.clear((View)object);
    }

    public int getItemPosition(Object object) {
        return -2;
    }
}

