/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.pdf;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.pdf.PDFViewPage;
import us.zoom.videomeetings.R;

public class PDFView
extends FrameLayout {
    private static String TAG = PDFView.class.getSimpleName();
    private Context mContext;
    private PDFViewPage mPageView;
    private View mPageContainer;
    private SeekBar mSeekBar;
    private int mPageCount = 0;
    private boolean mSuccess = false;
    private int mCurrentPage = 0;
    private View mThumInfo;
    private ImageView mThumImageView;
    private TextView mPageNumView;
    private Bitmap mThumbImageBitmap;
    private Handler mHandler = new Handler();
    private PDFViewListener mListener = null;
    private Runnable mThumbImageRenderRunnable = new Runnable(){

        @Override
        public void run() {
            PDFView.this.showPageThumb();
        }
    };
    private PDFViewPage.PDFViewPageListener mPDFViewPageListener = new PDFViewPage.PDFViewPageListener(){

        @Override
        public void onPDFDisplayRefresh() {
            if (PDFView.this.mListener != null) {
                PDFView.this.mListener.onPDFViewPageChanged();
            }
        }

        @Override
        public void onRenderPageErr(int pageIndex) {
            PDFView.this.showPageErrorInfo(pageIndex);
        }

        @Override
        public void onLoaderPageErr(int pageIndex) {
            PDFView.this.showPageErrorInfo(pageIndex);
        }

        @Override
        public void onClickEvent() {
            if (PDFView.this.mListener != null) {
                PDFView.this.mListener.onPDFViewClicked();
            }
            if (!PDFView.this.needShowSeekBar()) {
                return;
            }
            if (PDFView.this.mSeekBar.getVisibility() == 0) {
                PDFView.this.mSeekBar.setVisibility(4);
            } else {
                PDFView.this.mSeekBar.setVisibility(0);
            }
        }
    };
    private ViewPager.OnPageChangeListener mPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageSelected(int page) {
            PDFView.this.mPageView.loadPage(page);
            if (PDFView.this.mListener != null) {
                PDFView.this.mListener.onPDFViewPageChanged();
            }
            if (PDFView.this.needShowSeekBar()) {
                PDFView.this.mSeekBar.setProgress(page);
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (PDFView.this.mListener != null) {
                PDFView.this.mListener.onPDFViewPageChanged();
            }
        }

        public void onPageScrollStateChanged(int state) {
        }
    };
    private SeekBar.OnSeekBarChangeListener mSeekBarListener = new SeekBar.OnSeekBarChangeListener(){

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            if (progress >= PDFView.this.mPageCount) {
                PDFView.this.mCurrentPage = PDFView.this.mPageCount;
            } else {
                PDFView.this.mCurrentPage = progress;
            }
            if (PDFView.this.mCurrentPage < 0) {
                PDFView.this.mCurrentPage = 0;
            }
            if (PDFView.this.mPageNumView.getVisibility() == 0) {
                PDFView.this.mPageNumView.setText((CharSequence)PDFView.this.mContext.getString(R.string.zm_lbl_pdf_page_number, new Object[]{PDFView.this.mCurrentPage + 1}));
            }
            PDFView.this.mHandler.removeCallbacks(PDFView.this.mThumbImageRenderRunnable);
            PDFView.this.mHandler.postDelayed(PDFView.this.mThumbImageRenderRunnable, 100L);
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
            if (PDFView.this.needShowSeekBar() && seekBar == PDFView.this.mSeekBar) {
                PDFView.this.mThumInfo.setVisibility(0);
            }
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            if (!PDFView.this.needShowSeekBar() || seekBar != PDFView.this.mSeekBar) {
                return;
            }
            PDFView.this.mHandler.removeCallbacks(PDFView.this.mThumbImageRenderRunnable);
            PDFView.this.mThumInfo.setVisibility(8);
            if (PDFView.this.mSuccess && PDFView.this.mCurrentPage >= 0 && PDFView.this.mCurrentPage < PDFView.this.mPageCount) {
                PDFView.this.mPageView.setCurrentItem(PDFView.this.mCurrentPage);
            }
        }
    };

    public PDFView(Context context) {
        super(context);
        this.initView(context);
    }

    public PDFView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public PDFView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    @SuppressLint(value={"NewApi"})
    public PDFView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mContext = context;
        View.inflate((Context)context, (int)R.layout.zm_pdf_view, (ViewGroup)this);
        this.mPageView = (PDFViewPage)this.findViewById(R.id.pdfPageView);
        this.mPageContainer = this.findViewById(R.id.pageContainer);
        this.mSeekBar = (SeekBar)this.findViewById(R.id.pdfSeekBar);
        if (!this.isInEditMode()) {
            this.mSeekBar.setOnSeekBarChangeListener(this.mSeekBarListener);
            this.mPageView.setPDFViewPageListener(this.mPDFViewPageListener);
            this.mPageView.setOnPageChangeListener(this.mPageChangeListener);
        }
        this.mThumInfo = this.findViewById(R.id.thumbInfo);
        this.mThumImageView = (ImageView)this.findViewById(R.id.thumbImage);
        this.mPageNumView = (TextView)this.findViewById(R.id.pageNum);
    }

    public void setSeekBarBottomPadding(int padding) {
        if (this.mSeekBar == null || this.mThumInfo == null) {
            return;
        }
        this.mSeekBar.setY(this.mSeekBar.getY() - (float)padding);
        this.mThumInfo.setY(this.mThumInfo.getY() - (float)padding);
    }

    public boolean setPdfFile(String filePath, String password) {
        this.mSuccess = this.mPageView.openFile(filePath, password);
        if (!this.mSuccess) {
            return false;
        }
        this.mPageCount = this.mPageView.getPageCount();
        if (this.mPageCount <= 0) {
            return false;
        }
        if (this.needShowSeekBar()) {
            this.mSeekBar.setMax(this.mPageCount - 1);
        } else {
            this.mSeekBar.setVisibility(4);
        }
        return true;
    }

    public void closeFile() {
        if (!this.mSuccess) {
            return;
        }
        this.mPageView.closeFile();
        this.mPageCount = 0;
        this.mSuccess = false;
    }

    public int getPageWidth() {
        return this.mPageView.getWidth();
    }

    public int getPageHeight() {
        return this.mPageView.getHeight();
    }

    public View getPageContent() {
        return this.mPageContainer;
    }

    public void setSeekBarVisible(int visiblity) {
        if (this.mSeekBar != null && this.needShowSeekBar()) {
            this.mSeekBar.setVisibility(visiblity);
        }
    }

    public void setListener(PDFViewListener l) {
        this.mListener = l;
    }

    private void checkThumbImage() {
        int width = this.mThumImageView.getWidth();
        int height = this.mThumImageView.getHeight();
        if (width <= 0 || height <= 0) {
            this.mThumbImageBitmap = null;
            this.mThumImageView.setImageBitmap(null);
            return;
        }
        if (this.mThumbImageBitmap != null) {
            if (this.mThumbImageBitmap.getWidth() == width && this.mThumbImageBitmap.getHeight() == height) {
                return;
            }
            this.mThumbImageBitmap.recycle();
        }
        this.mThumbImageBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mThumImageView.setImageBitmap(this.mThumbImageBitmap);
    }

    private void showPageThumb() {
        if (this.mThumImageView.getVisibility() != 0) {
            return;
        }
        this.checkThumbImage();
        if (this.mThumbImageBitmap != null) {
            this.mPageView.renderPage(this.mCurrentPage, this.mThumbImageBitmap);
            this.mThumImageView.invalidate();
        }
    }

    public boolean needShowSeekBar() {
        return this.mPageCount > 4;
    }

    private void showPageErrorInfo(int pageIndex) {
        String info = this.mContext.getResources().getString(R.string.zm_msg_pdf_page_err, new Object[]{pageIndex});
        Toast.makeText((Context)this.mContext, (CharSequence)info, (int)1).show();
    }

    public static interface PDFViewListener {
        public void onPDFViewPageChanged();

        public void onPDFViewClicked();
    }
}

