/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.pdf;

import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.zipow.videobox.pdf.PDFDisplayListener;
import com.zipow.videobox.pdf.PDFDoc;
import com.zipow.videobox.pdf.PDFManager;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.UiModeUtil;
import us.zoom.androidlib.util.ZMAsyncTask;
import us.zoom.androidlib.widget.TouchImageView;
import us.zoom.videomeetings.R;

public class PDFPageFragment
extends ZMFragment {
    private final String TAG = PDFPageFragment.class.getSimpleName();
    private static final String PDF_FILE = "pdf_file";
    private static final String PDF_PSW = "pdf_password";
    private static final String PDF_PAGE_NUM = "pdf_page_num";
    private String mFileName = null;
    private String mPassword = null;
    private int mPageNum = -1;
    private TouchImageView mImageView;
    private PDFManager mPdfMgr;
    private PDFDoc mDoc;
    private Bitmap mBitmap;
    private int mRenderWidth;
    private int mRenderHeight;
    private ProgressDialog mWaitingDialog = null;
    private ZMAsyncTask<Void, Void, Long> mAsyncRender;
    private long mPDFBitmap = 0L;
    private boolean mDisplay = false;
    private boolean mIsLoading = false;
    private boolean mViewCreated = false;
    private PDFDisplayListener mDisplayListener;
    private static ExecutorService mSingleExecutor;

    public static PDFPageFragment newInstance(String file, String password, int page) {
        PDFPageFragment fragment = new PDFPageFragment();
        Bundle args = new Bundle();
        args.putString(PDF_FILE, file);
        args.putString(PDF_PSW, password);
        args.putInt(PDF_PAGE_NUM, page);
        fragment.setArguments(args);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_pdf_page, container, false);
        this.mImageView = (TouchImageView)view.findViewById(R.id.imageview);
        this.mImageView.setOnViewPortChangedListener(new TouchImageView.OnViewPortChangedListener(){

            public void onViewPortChanged() {
                if (PDFPageFragment.this.mDisplayListener != null && PDFPageFragment.this.mImageView.getDrawable() != null) {
                    PDFPageFragment.this.mDisplayListener.onPDFDisplayRefresh();
                }
            }
        });
        Bundle arg = this.getArguments();
        if (savedInstanceState != null) {
            this.mFileName = savedInstanceState.getString(PDF_FILE);
            this.mPassword = savedInstanceState.getString(PDF_PSW);
            this.mPageNum = savedInstanceState.getInt(PDF_PAGE_NUM, -1);
        } else if (arg != null) {
            this.mFileName = arg.getString(PDF_FILE);
            this.mPassword = arg.getString(PDF_PSW);
            this.mPageNum = arg.getInt(PDF_PAGE_NUM, -1);
        }
        this.mPdfMgr = PDFManager.getInstance();
        this.mDoc = this.mPdfMgr.openDocument(this.mFileName, this.mPassword);
        this.mViewCreated = true;
        return view;
    }

    public void onResume() {
        super.onResume();
        if (this.mDisplay && this.mIsLoading) {
            this.showWaitingDialog();
        }
    }

    public void startDisplay(PDFDisplayListener displayListener) {
        if (!this.mViewCreated || this.mDisplay) {
            return;
        }
        this.mDisplay = true;
        this.mDisplayListener = displayListener;
        if (this.mPDFBitmap == 0L) {
            this.showWaitingDialog();
            this.asyncRenderPage();
        } else {
            this.displayPage();
        }
    }

    public void stopDisplay() {
        if (!this.mDisplay) {
            return;
        }
        this.mDisplay = false;
        this.mDisplayListener = null;
        this.releaseBitmap();
    }

    public boolean canScrollVertical(int dy) {
        if (this.mImageView == null || !this.mDisplay) {
            return false;
        }
        return this.mImageView.canScrollVertical(dy);
    }

    private void showWaitingDialog() {
        if (this.mWaitingDialog != null) {
            return;
        }
        String message = this.getString(R.string.zm_msg_loading);
        this.mWaitingDialog = new ProgressDialog((Context)this.getActivity());
        this.mWaitingDialog.requestWindowFeature(1);
        this.mWaitingDialog.setMessage((CharSequence)message);
        this.mWaitingDialog.setCanceledOnTouchOutside(false);
        this.mWaitingDialog.show();
    }

    private void dismissWaitingDialog() {
        if (this.mWaitingDialog == null) {
            return;
        }
        if (this.mWaitingDialog.isShowing()) {
            this.mWaitingDialog.dismiss();
        }
        this.mWaitingDialog = null;
    }

    private synchronized void asyncRenderPage() {
        if (this.mPageNum < 0) {
            return;
        }
        if (this.mIsLoading) {
            return;
        }
        this.mIsLoading = true;
        this.releaseBitmap();
        this.prepareRenderSize(this.mPageNum);
        this.checkRenderSizeAndCreateBitmap();
        this.mAsyncRender = new ZMAsyncTask<Void, Void, Long>(){

            protected Long doInBackground(Void ... params) {
                if (PDFPageFragment.this.mRenderWidth <= 0 || PDFPageFragment.this.mRenderHeight <= 0) {
                    return null;
                }
                long pdfbm = PDFPageFragment.this.renderPage(PDFPageFragment.this.mRenderWidth, PDFPageFragment.this.mRenderHeight);
                if (this.isCancelled()) {
                    return null;
                }
                return pdfbm;
            }

            protected void onPostExecute(Long pdfBm) {
                if (pdfBm == null) {
                    return;
                }
                PDFPageFragment.this.dismissWaitingDialog();
                PDFPageFragment.this.mPDFBitmap = pdfBm;
                PDFPageFragment.this.mIsLoading = false;
                PDFPageFragment.this.mAsyncRender = null;
                PDFPageFragment.this.displayPage();
            }
        };
        if (mSingleExecutor == null) {
            this.mAsyncRender.execute((Object[])new Void[0]);
        } else {
            this.mAsyncRender.executeOnExecutor((Executor)mSingleExecutor, (Object[])new Void[0]);
        }
    }

    private void displayPage() {
        if (!this.mDisplay) {
            return;
        }
        if (this.mPDFBitmap == 0L || this.mBitmap == null || this.mRenderWidth <= 0 || this.mRenderHeight <= 0) {
            return;
        }
        this.mDoc.copyBitmap(this.mPDFBitmap, this.mBitmap);
        this.mImageView.setImageBitmap(this.mBitmap);
        if (this.mDisplayListener != null) {
            this.mDisplayListener.onPDFDisplayRefresh();
        }
    }

    private void checkRenderSizeAndCreateBitmap() {
        Bitmap bitmap = null;
        boolean done = false;
        do {
            try {
                if (this.mRenderWidth > 0 && this.mRenderHeight > 0) {
                    bitmap = Bitmap.createBitmap((int)this.mRenderWidth, (int)this.mRenderHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                done = true;
            }
            catch (OutOfMemoryError e1) {
                this.mRenderWidth /= 2;
                this.mRenderHeight /= 2;
            }
        } while (!done);
        if (bitmap == null) {
            String message = this.getString(R.string.zm_msg_pdf_page_err, new Object[]{this.mPageNum});
            this.showToast(message);
            return;
        }
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
        }
        this.mBitmap = bitmap;
    }

    private void releaseBitmap() {
        if (this.mPDFBitmap != 0L && this.mDoc != null) {
            this.mDoc.releasePDFBitmap(this.mPDFBitmap);
        }
        this.mPDFBitmap = 0L;
        if (this.mImageView != null) {
            this.mImageView.setImageBitmap(null);
        }
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }

    private void prepareRenderSize(int pageIndex) {
        if (UiModeUtil.isInDesktopMode((Context)this.getContext())) {
            this.prepareRenderSizeForDestop(pageIndex);
        } else {
            this.prepareRenderSizeForNormal(pageIndex);
        }
    }

    private void prepareRenderSizeForNormal(int pageIndex) {
        int BASE_DISPLAY_DPI = 160;
        float displayWidth = UIUtil.getDisplayWidthInDip((Context)this.getActivity());
        float displayHeight = UIUtil.getDisplayHeightInDip((Context)this.getActivity());
        float maxWidth = displayWidth * 2.0f;
        float maxHeight = displayHeight * 2.0f;
        this.mRenderWidth = 0;
        this.mRenderHeight = 0;
        try {
            double pageW = this.mDoc.getPageWidth(pageIndex);
            double pageH = this.mDoc.getPageHeight(pageIndex);
            pageW = pageW * 160.0 / 72.0;
            pageH = pageH * 160.0 / 72.0;
            if (pageW > (double)maxWidth || pageW > (double)maxHeight) {
                if (pageW > 0.0 && pageH > 0.0) {
                    if (pageW * (double)maxHeight >= pageH * (double)maxWidth) {
                        this.mRenderWidth = (int)(pageW * (double)maxHeight / pageH);
                        this.mRenderHeight = (int)maxHeight;
                    } else {
                        this.mRenderWidth = (int)maxWidth;
                        this.mRenderHeight = (int)(pageH * (double)maxWidth / pageW);
                    }
                }
            } else {
                this.mRenderWidth = (int)pageW;
                this.mRenderHeight = (int)pageH;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mRenderWidth = this.mRenderWidth / 4 * 4;
        this.mRenderHeight = this.mRenderHeight / 4 * 4;
    }

    private void prepareRenderSizeForDestop(int pageIndex) {
        int displayWidth = UIUtil.getMetricWith((Context)this.getActivity());
        int displayHeight = UIUtil.getMetricHeight((Context)this.getActivity());
        this.mRenderWidth = 0;
        this.mRenderHeight = 0;
        try {
            double dpH;
            double dpW;
            double pageW = this.mDoc.getPageWidth(pageIndex);
            double pageH = this.mDoc.getPageHeight(pageIndex);
            double k = pageW / pageH;
            if ((double)displayWidth >= k * (double)displayHeight) {
                dpW = displayWidth;
                dpH = (double)displayWidth * pageH / pageW;
            } else {
                dpW = k * (double)displayHeight;
                dpH = displayHeight;
            }
            this.mRenderWidth = UIUtil.dip2px((Context)this.getActivity(), (float)((float)dpW)) / 4 * 4;
            this.mRenderHeight = UIUtil.dip2px((Context)this.getActivity(), (float)((float)dpH)) / 4 * 4;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private long renderPage(int widht, int height) {
        if (this.mDoc == null || this.mPageNum < 0) {
            return 0L;
        }
        if (!this.mDoc.openPage(this.mPageNum)) {
            return 0L;
        }
        long pdfBm = this.mDoc.renderPage(this.mPageNum, widht, height, 0);
        return pdfBm;
    }

    public void onDestroy() {
        if (this.mAsyncRender != null && !this.mAsyncRender.isCancelled() && this.mAsyncRender.getStatus() == ZMAsyncTask.Status.RUNNING) {
            this.mAsyncRender.cancel(true);
            this.mAsyncRender = null;
        }
        this.dismissWaitingDialog();
        super.onDestroy();
        this.releaseBitmap();
        if (this.mDoc != null) {
            this.mDoc.closePage(this.mPageNum);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putString(PDF_FILE, this.mFileName);
            outState.putString(PDF_PSW, this.mPassword);
            outState.putInt(PDF_PAGE_NUM, this.mPageNum);
        }
    }

    public static void startSingleExecutor() {
        if (mSingleExecutor == null) {
            mSingleExecutor = Executors.newSingleThreadExecutor();
        }
    }

    public static void shutdownSingleExecutor() {
        if (mSingleExecutor != null && !mSingleExecutor.isShutdown()) {
            mSingleExecutor.shutdown();
        }
        mSingleExecutor = null;
    }

    private void showToast(String msg) {
        Toast error = Toast.makeText((Context)this.getActivity(), (CharSequence)msg, (int)1);
        error.show();
    }
}

