/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.onedrive;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.support.annotation.NonNull;
import com.zipow.videobox.onedrive.OneDriveAppPickerResult;
import com.zipow.videobox.onedrive.OneDriveConfig;
import com.zipow.videobox.onedrive.OneDriveLinkType;
import com.zipow.videobox.util.IPicker;
import com.zipow.videobox.util.IPickerResult;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.StringUtil;

public class OneDrivePicker
implements IPicker {
    private static final String ONEDRIVE_PICKER_ACTION = "onedrive.intent.action.PICKER";
    private static final int SDK_VERSION = 2;
    private static final String ONEDRIVE_PACKAGE_NAME = "com.microsoft.skydrive";
    private static final int SDK_MIN_VERSION_CODE = 1460029606;
    private int mRequestCode;
    private boolean mIsBusiness;
    private ArrayList<String> mFilterExtensions = new ArrayList();

    @NonNull
    public static IPicker createPicker(@NonNull Context context, int requestCode, String[] extentions, boolean isBusiness) {
        return new OneDrivePicker(context, requestCode, extentions, isBusiness);
    }

    private OneDrivePicker(Context context, int requestCode, String[] extentions, boolean isBusiness) {
        this.mRequestCode = requestCode;
        this.mIsBusiness = isBusiness;
        this.setFilterExtens(extentions);
    }

    public static boolean hasPicker(Context context, boolean isBusiness) {
        int code;
        if (context == null) {
            return false;
        }
        Intent intent = OneDrivePicker.createOneDriveIntent(ONEDRIVE_PICKER_ACTION, OneDrivePicker.getClientId(isBusiness, context));
        if (!AndroidAppUtil.hasActivityForIntent((Context)context, (Intent)intent)) {
            return false;
        }
        PackageInfo info = AndroidAppUtil.getPackageInfo((Context)context, (String)ONEDRIVE_PACKAGE_NAME);
        return info != null && (code = info.versionCode) >= 1460029606;
    }

    @Override
    public IPickerResult getPickerResult(int requestCode, int resultCode, Intent data) {
        if (this.mRequestCode == requestCode && data != null) {
            return OneDriveAppPickerResult.fromBundle(data.getExtras(), this.mFilterExtensions);
        }
        return null;
    }

    @Override
    public void startPicking(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        OneDriveLinkType linkType = OneDriveLinkType.DownloadLink;
        Intent intent = OneDrivePicker.createOneDriveIntent(ONEDRIVE_PICKER_ACTION, OneDrivePicker.getClientId(this.mIsBusiness, (Context)activity));
        intent.putExtra("linkType", linkType.toString());
        activity.startActivityForResult(intent, this.mRequestCode);
    }

    @Override
    public void startPicking(ZMDialogFragment fragment) {
        if (fragment == null) {
            return;
        }
        OneDriveLinkType linkType = OneDriveLinkType.DownloadLink;
        Intent intent = OneDrivePicker.createOneDriveIntent(ONEDRIVE_PICKER_ACTION, OneDrivePicker.getClientId(this.mIsBusiness, (Context)fragment.getActivity()));
        intent.putExtra("linkType", linkType.toString());
        fragment.startActivityForResult(intent, this.mRequestCode);
    }

    @Override
    public void startPicking(ZMFragment fragment) {
        if (fragment == null) {
            return;
        }
        OneDriveLinkType linkType = OneDriveLinkType.DownloadLink;
        Intent intent = OneDrivePicker.createOneDriveIntent(ONEDRIVE_PICKER_ACTION, OneDrivePicker.getClientId(this.mIsBusiness, (Context)fragment.getActivity()));
        intent.putExtra("linkType", linkType.toString());
        fragment.startActivityForResult(intent, this.mRequestCode);
    }

    public static Intent createOneDriveIntent(String action, String appId) {
        Intent intent = new Intent();
        intent.setAction(action);
        intent.addCategory("android.intent.category.DEFAULT");
        intent.putExtra("appId", appId);
        intent.putExtra("version", 2);
        return intent;
    }

    private void setFilterExtens(String[] extentions) {
        this.mFilterExtensions.clear();
        if (extentions == null || extentions.length <= 0) {
            return;
        }
        for (String ext : extentions) {
            if (StringUtil.isEmptyOrNull((String)ext)) continue;
            this.mFilterExtensions.add(ext);
        }
    }

    private static String getClientId(boolean isBusiness, Context context) {
        return isBusiness ? OneDriveConfig.getBusinessClientID(context) : OneDriveConfig.getClientID(context);
    }
}

