/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.onedrive;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.Item;
import com.zipow.videobox.onedrive.IODFoldLoaderListener;
import com.zipow.videobox.onedrive.OneDrive;
import com.zipow.videobox.onedrive.OneDriveDefaultCallback;
import java.util.ArrayList;
import java.util.List;

public class OneDriveLoadFolderTask {
    private static final String EXPAND_OPTIONS_FOR_CHILDREN_AND_THUMBNAILS = "children(expand=thumbnails),thumbnails";
    private static final String EXPAND_OPTIONS_FOR_CHILDREN_AND_THUMBNAILS_LIMITED = "children,thumbnails";
    private OneDrive mOneDrive;
    private String mItemId;
    private IODFoldLoaderListener mIODFoldLoaderListener;
    private boolean mIsCancel;

    public OneDriveLoadFolderTask(OneDrive oneDrive, String itemId, IODFoldLoaderListener l) {
        this.mOneDrive = oneDrive;
        this.mItemId = itemId;
        this.mIODFoldLoaderListener = l;
    }

    private ICallback<Item> getItemCallback() {
        return new OneDriveDefaultCallback<Item>(){

            @Override
            public void success(Item item) {
                OneDriveLoadFolderTask.this.mOneDrive.removeLoadFolderTask(OneDriveLoadFolderTask.this);
                if (OneDriveLoadFolderTask.this.mIsCancel) {
                    return;
                }
                ArrayList<Item> entries = new ArrayList<Item>();
                if (item.children != null && !item.children.getCurrentPage().isEmpty()) {
                    List childrenItems = item.children.getCurrentPage();
                    for (Item childItem : childrenItems) {
                        childItem.setmPItemId(item.getItemId());
                        entries.add(childItem);
                    }
                }
                OneDriveLoadFolderTask.this.mIODFoldLoaderListener.onLoadFoldCompleted(item, entries);
            }

            @Override
            public void failure(ClientException error) {
                OneDriveLoadFolderTask.this.mOneDrive.removeLoadFolderTask(OneDriveLoadFolderTask.this);
                if (OneDriveLoadFolderTask.this.mIsCancel) {
                    return;
                }
                OneDriveLoadFolderTask.this.mIODFoldLoaderListener.onError(error);
            }
        };
    }

    public void cancel() {
        this.mIsCancel = true;
    }

    public boolean execute() {
        IOneDriveClient client;
        if (this.mOneDrive != null && this.mOneDrive.isAuthed() && (client = this.mOneDrive.getmClient()) != null) {
            client.getDrive().getItems(this.mItemId).buildRequest().expand(this.getExpansionOptions(client)).get(this.getItemCallback());
            return true;
        }
        return false;
    }

    private String getExpansionOptions(IOneDriveClient oneDriveClient) {
        String expansionOption;
        switch (oneDriveClient.getAuthenticator().getAccountInfo().getAccountType()) {
            case MicrosoftAccount: {
                expansionOption = EXPAND_OPTIONS_FOR_CHILDREN_AND_THUMBNAILS;
                break;
            }
            default: {
                expansionOption = EXPAND_OPTIONS_FOR_CHILDREN_AND_THUMBNAILS_LIMITED;
            }
        }
        return expansionOption;
    }
}

