/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.onedrive;

import com.onedrive.sdk.extensions.Item;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import us.zoom.androidlib.app.ZMFileListEntry;

public class OneDriveEntry
extends ZMFileListEntry {
    private static final String TAG = OneDriveEntry.class.getSimpleName();
    private Item mOwner;
    private Item mParent;
    private static final DateFormat gDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);

    public OneDriveEntry(Item obj, Item parent) {
        this.mOwner = obj;
        this.mParent = parent;
        if (this.mOwner == null) {
            return;
        }
        this.setPath(this.mOwner.getPath());
        this.setDisplayName(this.mOwner.getShowName());
        Calendar date = this.mOwner.lastModifiedDateTime;
        if (date == null) {
            date = this.mOwner.createdDateTime;
        }
        if (date != null) {
            this.setDate(date.getTime());
        }
        if (this.mOwner.folder != null) {
            this.setDir(true);
        } else {
            this.setDir(false);
            this.setBytes(this.getSize());
        }
    }

    public static Date parseDate(String date) {
        try {
            return gDateFormat.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private long getSize() {
        if (this.mOwner == null || this.mOwner.size == null) {
            return 0L;
        }
        return this.mOwner.size;
    }

    public Item getObject() {
        return this.mOwner;
    }

    public Item getParentObject() {
        return this.mParent;
    }
}

